<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Addon BNO (Bloc-notes et Objectifs) pour Ganesha
* @author	PYG <pyg_listes@exiup.com>
* @package	GaneshaClass
*/
/**
* Fournit une API pour la gestion des BNO
* @author	PYG<pyg_listes@exiup.com>
* @access	public
* @package	GaneshaClass
*/
class BNO {

	/**
	* Lit les infos saisies par le tuteur
	* @param	integer	$id_membre 
	* @param	integer	$id_groupe 
	* @param	integer	$type_outil 
	* @access	public
	*/
	function Lire($id_membre, $id_groupe, $type_outil) {
		global $TBL, $db;
		$sSQL = "SELECT contenu,date_maj FROM ".$TBL['bno']." " ;
		$sSQL.= "WHERE id_membre='".$id_membre."' AND id_groupe='".$id_groupe."' " ;
		$sSQL.= "AND type_outil='".$type_outil."'" ;
		$db->query($sSQL);
		$ret['id_membre']	= $id_membre	;
		$ret['id_groupe']	= $id_groupe	;
		$ret['type_outil']	= $type_outil	;
		if ( $db->next_record() ) {
			$ret['contenu']		= Unreplace($db->f("contenu"))		;
			$ret['date_maj']	= $db->f("date_maj")				;
			$db->free()	;
		}
		return($ret);
	}


	/**
	* Sauvegarde les infos saisies par le tuteur
	* @param	integer	$type_outil 
	* @param	integer	$id_membre 
	* @param	integer	$id_groupe 
	* @param	string	$contenu 
	* @access	public
	*/
	function Replace($type_outil, $id_membre, $id_groupe, $contenu) {
		global $TBL, $db, $trad_Menu_BNO ;	 
		// on evite les injections de Xscripting
		$nv_contenu = SecuriseHTML($contenu);  
		// Utilisation de la commande SQL REPLACE pour viter les INSERT/UPDATE (bonne ide ?)	
		$sSQL = "REPLACE INTO ".$TBL['bno']." (type_outil, id_membre, id_groupe, contenu)" ;
		$sSQL.= "VALUES ('".$type_outil."','".$id_membre."','".$id_groupe."','".$nv_contenu."');" ;
		if ($db->query($sSQL)) {
			$msg_replace = $trad_Menu_BNO['Replace_OK'];
		} else {
			$msg_replace = $trad_Menu_BNO['Replace_PB'];
		}
		return($msg_replace);
	}

	/**
	* Rcupre la liste d'utilisateurs du groupe en cours
	* @param	integer	$type_outil 
	* @param	integer	$id_membre 
	* @param	integer	$id_groupe 
	* @param	string	$contenu 
	* @access	public
	*/
	function TableUtilisateur() { 
		global $TBL, $titre_profil, $db, $groupe;
		/*
        $sSQL = "SELECT distinct m.prenom,m.nom,m.id,";
        $sSQL.= "m.date_connexion,g.name ";
        $sSQL.= "FROM ".$TBL['membres']." m, ".$TBL['list_groupe']." g ";
        $sSQL.= "where m.type=0 and g.id_groupe=m.id_groupe and g.id_groupe=".$groupe." " ;
        $sSQL.= "order by g.name,m.nom ASC";
        */

        $sSQL = "SELECT m.prenom,m.nom,m.id, m.date_connexion ";
        $sSQL.= "FROM ".$TBL['membres']." m, ".$TBL['groupe']." g ";
        $sSQL.= "WHERE m.type=0 AND m.id=g.id_membres AND g.id_groupe=".$groupe." " ;
        $sSQL.= "ORDER BY m.nom ASC";

        $db->query($sSQL)     ;
        //debug($sSQL);
        if ( $db->next_record() ) {
			MakeListeWithIdBNO($sSQL,"LUser",$titre_profil[0].$i,$db->f(0)) ;
		} else {
			MakeListeWithIdBNO($sSQL,"LUser",$titre_profil[0].$i,-1) ;
		}
		$db->free();       				
	}

} // class BNO

/**
* Instance de la classe BNO
* @var	object	BNO
*/
$ClsBno = new BNO ;

?>