<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Definition de la class pour la gestion des groupes
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @package	GaneshaClass
*/
/**
* Fournit une API pour acceder aux groupes.
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @access	public
* @package	GaneshaClass
*/
class Groupe {

	/**
	* Contient la connexion locale de la classe
	* @var	object DB_Ganesha	$_db
	* @access	private
	*/
	var $_db ;

	/**
	* Constructeur de la classe Formation. Cre une connexion locale
	* @access	public
	*/
	function Groupe() {
		$this->_db = new DB_Ganesha ;
	}

	/**
	* Retourne les groupes tutores par le tuteur $idu
	* @param	integer	$idu ID du membre
	* @return	array	retourne un tableau avec tous les id des groupes tutores par le tuteur $idu
	* @access	public
	*/
	function GetList($idu) {
	 global $TBL, $db ;
		$sSQL  = "SELECT DISTINCT id_groupe FROM ".$TBL['list_groupe']." where id_tuteur=".$idu;
		$db->query($sSQL)	;
		$index = 0			;
		while ( $db->next_record() ) {
			$tGroupe[$index++] = $db->f("id_groupe");
		}
		return($tGroupe);
	}

	/**
	* Retourne les tuteurs du groupe $idg
	* @param	integer	$idg ID du groupe
	* @return	array	Retourne un tableau avec tous les tuteurs du groupe $idg
	* @access	public
	*/
	function GetListTutor($idg) {
	 global $TBL, $db ;
		$sSQL  = "SELECT id_tuteur FROM ".$TBL['list_groupe']." where id_groupe=".$idg;
		$db->query($sSQL)	;
		$index = 0			;
		while ( $db->next_record() ) {
			$tGroupe[$index++] = $db->f("id_tuteur");
		}
		return($tGroupe);
	}

	/**
	* Retourne les membres d'un groupe et leurs id
	* @param	integer	$idg ID du groupe
	* @return	array	Retourne un tableau avec tous les membres, leurs Id et leur nombre.
	* @access	public
	*/
	function Members($idg) {
	 global $TBL, $db ;
		$sSQL = "SELECT DISTINCT m.prenom,m.nom,m.id "	;
		$sSQL.= "FROM ".$TBL['membres']." m, ".$TBL['groupe']." g "	;
		$sSQL.= "where g.id_groupe =".$idg." and m.id=g.id_membres ";
		$sSQL.= "order by nom"	;
		$db->query($sSQL)	;
		$ret['cnt'] = $db->num_rows();		
		$index = 0			;
		while( $db->next_record() ) {
			$ret[$index]['name'] 	= $db->f(0).' '.$db->f(1);
			$ret[$index]['prenom'] 	= $db->f(0);
			$ret[$index]['nom'] 	= $db->f(1);
			$ret[$index]['id']  	= $db->f(2);
			$index++ ;
		}
		return($ret);
	}

	/**
	* Retourne le nombre de membres d'un groupe 
	* @param	integer	$idg ID du groupe
	* @return	integer	Retourne le nombre de membres d'un groupe 
	* @access	public
	*/
	function NbMembers($idg) {
	 global $TBL, $db ;
		$sSQL ="SELECT id FROM ".$TBL['membres']." where id_groupe =".$idg." and type=0";
		$db->query($sSQL) ;
		return($db->num_rows());
	}

	/**
	* Retourne le nom d'un groupe 
	* @param	integer	$idg ID du groupe
	* @return	string	Retourne le nom d'un groupe 
	* @access	public
	*/
	function Name($idg) {
	 global $TBL, $db ;
		$sSQL ="SELECT name FROM ".$TBL['list_groupe']." where id_groupe=".$idg;
		$db->query($sSQL)	;
		if ( $db->num_rows() > 0 ) {
			$db->next_record()	;
			return($db->f(0))	;
		} else {
			return('*******');
		}
	}

	/**
	* Retourne le nom du repertoire du groupe
	* @param	integer	$idg ID du groupe
	* @return	string	Retourne le nom du repertoire du groupe
	* @access	public
	*/
	function Directory($idg) {
	 global $TBL, $db ;
		$sSQL ="SELECT repertoire FROM ".$TBL['list_groupe']." where id_groupe=".$idg;
		$db->query($sSQL)	;
		$db->next_record()	;
		return($db->f(0))	;
	}

	/**
	* Retourne le nom du fichier planning du groupe
	* @param	integer	$idg ID du groupe
	* @return	string	Retourne le nom du fichier planning du groupe
	* @access	public
	*/
	function Planning($idg) {
	 global $TBL, $db ;
		$sSQL ="SELECT planning FROM ".$TBL['list_groupe']." where id_groupe=".$idg;
		$db->query($sSQL)	;
		$db->next_record()	;
		return($db->f(0))	;
	}

	/**
	* Ajoute le planning pour un groupe
	* @param	integer	$idg ID du groupe
	* @param	string	$planning nom du fichier contenant le planning
	* @access	public
	*/
	function SetPlanning($idg,$planning) {
	 global $TBL, $db ;
		$sSQL ="update ".$TBL['list_groupe']." set planning='".$planning."' where id_groupe=".$idg;
		$db->query($sSQL)	;
	}

	/**
	* Supprime le planning du groupe
	* @param	integer	$idg ID du groupe
	* @return	string	Retourne un message indiquant la suppression du planning
	* @access	public
	*/
	function DeletePlanning($idg) {
	 global $ClsGroupe ;
	 global $tu_texte, $db ;
		$planning = $this->Planning($idg)	;
		$rep = $this->Directory($idg)			;
		if ( $planning != "" && file_exists(RP_GROUPES.$rep."/".$planning) ) {
			unlink(RP_GROUPES.$rep."/".$planning);
		}
		$planning = ""										;
		$ClsGroupe->SetPlanning($idg,$planning)	;
		$msg = $tu_texte['suplanning']						;
		return($msg);
	}

	/**
	* Met a jour le planning du groupe
	* @param	integer	$idg ID du groupe
	* @param	string	$fichier descrption du fichier a copier
	* @return	string	Retourne un message indiquant la mise a jour du planning
	* @access	public
	*/
	function UpdatePlanning($idg, $fichier) {
	 global $tu_texte ;
		if ( isset($fichier['fichier']['name']) && 
			 strlen($fichier['fichier']['name'])>0 && 
			 $fichier['fichier']['error']==0 
		   ) {
			if ( !OPT_UPLOAD_ACTIVE ) {
				return($tu_texte['errorupload']);
			}
			$planning = $this->Planning($idg);	
			$rep =  $this->Directory($idg)  ;
			if ( $planning != "" && file_exists (RP_GROUPES.$rep."/".$planning) ) {
				unlink(RP_GROUPES.$rep."/".$planning);
			}
			$fplanning = MakeFileName('',$fichier['fichier']['name']);
			if ( $fichier_name = copier_fichier( $fichier['fichier'],RP_GROUPES.$rep."/".$fplanning) ) {
				$this->SetPlanning($idg,$fichier_name)	;
				$msg = $tu_texte['uplanning']	;
			} else {
				$msg = $tu_texte['erroruplan'].' error=> '.$fichier['fichier']['error'];
			}
		} else {
			$msg = $tu_texte['erroruplan'].' error=> '.$fichier['fichier']['error'];
		}
		return($msg);
	}

	/**
	* Retourne l'id du forum associe au groupe
	* @param	integer	$idg ID du groupe
	* @return	integer	Retourne l'id du forum associe au groupe
	* @access	public
	*/
	function IdForum($idg){ 
	 global $TBL, $db ;
		$sSQL ="SELECT id_forum FROM ".$TBL['list_groupe']." where id_groupe=".$idg;
		$db->query($sSQL)	;
		$db->next_record()	;
		return($db->f(0))	;
	}

	/**
	* Initialise la liste des groupes d'un membre
	* @param	integer	$idu ID du groupe
	* @return	integer	Retourne le nombre de groupes du membres $idu
	* @access	public
	*/
	function InitList($idu){ 
	 global $TBL;
		$sSQL = "SELECT DISTINCT g.id_groupe, l.name FROM ".$TBL['groupe']." g,".$TBL['list_groupe']." l ";
		$sSQL.= "where g.id_membres=".$idu." and l.id_groupe=g.id_groupe";
		$this->_db->query($sSQL)		;
		return($this->_db->num_rows())	;
	}

	/**
	* Initialise la liste des groupes d'un membre
	* @return	array	Retourne le nombre de groupes du membres $idu ou False
	* @access	public
	*/
	function NextItem() { 
		if ( $this->_db->next_record() ) {
			$ret['id_groupe'] = $this->_db->f(0) ;
			$ret['name']	  = $this->_db->f(1) ;
		} else {
			$ret = false ;
		}
		return($ret);
	}

	/**
	* Lecture de tous les groupes (tutores par le tuteur $idu)
	* @param	integer	$idu ID du membre	
	* @return	array	retourne un tableau avec tous les id des groupes tutores par le tuteur $idu	
	* @access	public
	*/
	function read($idu=0) {
		global $TBL, $db ;
        $sSQL = "SELECT DISTINCT name,id_groupe,code FROM ".$TBL['list_groupe']." ";
        $sSQL.= ($idu==0?'':'WHERE id_tuteur='.$idu.' ');
        $sSQL.= "ORDER BY name ASC";
		$db->query($sSQL)	;
		$ret = array()		;
		$ret['cnt'] = $db->num_rows();
		$i = 0 ;
		while($db->next_record()) {
			$ret[$i]['name']	= $db->f(0) ;
			$ret[$i]['id']		= $db->f(1) ;
			$ret[$i]['code']	= $db->f(2) ;
			$i++ ;
		}
		return($ret);
	}

	/**
	* Lecture de tous les groupes pour l'export
	* @access	public
	*/
	function readExport() {
		global $TBL, $db ;
		$ret['mtitre'] 	= 'Exportation des socits';
		$ret['titre'] 	= array('id','nom'); 
        $sSQL = "SELECT DISTINCT name,id_groupe FROM ".$TBL['list_groupe']." ";
        $sSQL.= "ORDER BY name ASC";
        switch(FORMAT) {
        case EXPORT_XML :
			$ret['result'] = $ClsSql2Xml->sqlExec($sSQL,$ret['titre']);
			break;
		case EXPORT_XLS :
			$db->query($sSQL)   ;
			$ret['result']['cnt'] = $db->num_rows()	;
			$i = 0 ;
			while ( $db->next_record() ) {
				$j = 0 ;
				$ret['result'][$i][$j++]	= $db->f("id_groupe")	;
				$ret['result'][$i][$j++]	= $db->f("name")		;
				$i++ ;
			}
			$db->free()	;
			break;
        }
		return($ret);			
	}

	/**
	* Lecture de tous les groupes
	* @access	public
	*/
	function readGroupe($idg) {
		global $TBL, $db ;
        $sSQL = "SELECT name,planning,code FROM ".$TBL['list_groupe']." WHERE id_groupe=".$idg;
		$db->query($sSQL)	;
		$ret = array()		;
		if($db->next_record()) {
			$ret['name']	= $db->f(0) ;
			$ret['id']		= $db->f(1) ;
			$ret['code']	= $db->f(2) ;
			$db->free()	;
		}
		return($ret);
	}
	
	/**
	* Ajoute un nouveau groupe
	* @param	string	$name nom du groupe
	* @param	string	$code code du groupe
	* @param	array	$tabtut table des tuteurs
	* @param	string	$planning planning du groupe
	* @param	boolean	$create creation des repertoires sur le serveur		
	* @access	public
	*/
	function add($name,$code,$tabtut,$planning,$create) { 
		global $db, $TBL, $ClsPhorum ;
		//Id du nouveau groupe
		$sSQL = "SELECT max(id_groupe) FROM ".$TBL['list_groupe'];
		$db->query($sSQL)  ;
		$db->next_record();
		$idg = $db->f(0) + 1 ;

		// Creation du forum pour le groupe
		$idf = $ClsPhorum->CreatePhorum($idg, $name);
		
		// definition du repertoire pour le groupe		
		$repertoire = DIR_GRP.$idg ;

		if ( trim($code) == '' ) {
			$code = GRP_CODE.($idg < 10 ? '0'.$idg : $idg) ;
		}

		// Creation du groupe et affectation aux tuteurs...
		if ( is_array($tabtut) ) {
			for ($i=0;$i<count($tabtut);$i++) {
				$sSQL = "INSERT INTO ".$TBL['list_groupe']." ";
				$sSQL.= "(id_groupe,name,code,id_tuteur,id_forum,repertoire,planning) ";
				$sSQL.= "VALUES (".$idg.",'".$name."','".$code."',".$tabtut[$i].",'".$idf."','".$repertoire."','".$planning."')";
				$db->query($sSQL)   ;
			}
		}
		$sSQL = "INSERT INTO ".$TBL['list_groupe']." ";
		$sSQL.= "(id_groupe,name,code,id_tuteur,id_forum,repertoire,planning) ";
		$sSQL.= "VALUES (".$idg.",'".$name."','".$code."',0,'".$idf."','".$repertoire."','".$planning."')";
		$db->query($sSQL)   ;	
		if ( $create ) {
			CreateDirectorie( RP_GROUPES.$repertoire);
			CreateIndexFile ( RP_GROUPES.$repertoire);
			CreateDirectorie( RP_GROUPES.$repertoire."/messages");
			CreateIndexFile ( RP_GROUPES.$repertoire."/messages");			
		}
		return($idg);
	}

	/**
	* Ajoute le groupe 0
	* @access	public
	*/
	function addGroupe0() { 
		global $db, $TBL;
		$sSQL = "SELECT name FROM ".$TBL['list_groupe']." WHERE id_groupe=0 ";
		$db->query($sSQL);
		if ( $db->num_rows() == 0 ) {
			$sSQL = "INSERT INTO ".$TBL['list_groupe']." ";
			$sSQL.= "(id_groupe,name,id_tuteur,id_forum,repertoire,planning) ";
			$sSQL.= "VALUES (0,'',0,0,'','')";
			$db->query($sSQL)   ;
		}
	}
		
	/**
	* maj d'un groupe
	* @param	integer	$idg id du groupe	
	* @param	string	$name nom du groupe
	* @param	string	$code code du groupe
	* @param	array	$tabtut table des tuteurs
	* @param	string	$planning planning du groupe
	* @access	public
	*/
	function update($idg,$name,$code,$tabtut,$planning) {
	 global $TBL, $db ;
	 	$idf = $this->IdForum($idg) ;
		$sSQL ="DELETE FROM ".$TBL['list_groupe']." WHERE id_groupe=".$idg." AND id_tuteur>0";
		$db->query($sSQL)	;
		if ( trim($code) == '' ) {
			$code = GRP_CODE.($idg < 10 ? '0'.$idg : $idg) ;
		}		
		$sSQL ="UPDATE ".$TBL['list_groupe']." SET name='".$name."',code='".$code."' WHERE id_groupe=".$idg;
		$db->query($sSQL)	;		

		// definition du repertoire pour le groupe		
		$repertoire = DIR_GRP.$idg ;

		// Creation du groupe et affectation aux tuteurs...
		if ( is_array($tabtut) ) {
			for ($i=0;$i<count($tabtut);$i++) {
				$sSQL = "INSERT INTO ".$TBL['list_groupe']." ";
				$sSQL.= "(id_groupe,name,code,id_tuteur,id_forum,repertoire,planning) ";
				$sSQL.= "VALUES (".$idg.",'".$name."','".$code."',".$tabtut[$i].",'".$idf."','".$repertoire."','".$planning."')";
				$db->query($sSQL);
			}
		}
	}

	/**
	* Ajoute un nouveau membre a un groupe
	* @param	integer	$idg ID du groupe
	* @param	integer	$idu ID du membre
	* @access	public
	*/
	function addMembre($idg,$idu) { 
		global $db, $TBL, $ClsSession, $ClsFormation ;
		$ret = $ClsSession->read($idg);	
		for($i=0;$i<$ret['cnt'];$i++) {
			$ClsFormation->add($idu,$ret[$i]['id'],$idg);
		}
		$sSQL = "insert into ".$TBL['groupe']." (id_groupe,id_membres) ";
		$sSQL.= "values ('".$idg."','".$idu."')";		
		$db->query($sSQL);
		if ( $idg != 0 ) {
			$sSQL = "DELETE FROM ".$TBL['groupe']." WHERE id_groupe=0 AND id_membres=".$idu ;
			$db->query($sSQL);
		}
	}


	/**
	* Ajoute les groupes a un membre
	* @param	integer	$idm ID du membre	
	* @param	array	$tabgroupe liste des groupes du stagiaire
	* @access	public
	*/
	function addMembreGroupe($idm,$tabgroupe) { 
		if ( is_array($tabgroupe) && count($tabgroupe)>0 ) {
			for($i=0;$i<count($tabgroupe);$i++) {
				$this->addMembre($tabgroupe[$i],$idm);
			}
		} else {
			$this->addGroupe0();
			$this->addMembre(0,$idm);
		}
	}
	
	/**
	* suppression d'un membre a un groupe
	* @param	integer	$idg ID du groupe
	* @param	integer	$idu ID du membre
	* @access	public
	*/
	function delMembre($idg,$idu) { 
		global $db, $TBL, $ClsSession, $ClsFormation  ;
		$sSQL = "DELETE FROM ".$TBL['groupe']." " ;
		$sSQL.= "WHERE id_groupe=".$idg." AND id_membres=".$idu ;
		$ret = $ClsSession->read($idg)	;
		for($i=0;$i<$ret['cnt'];$i++) {
			$ClsFormation->add($idu,$ret[$i]['id'],$idg);
		}		
		$db->query($sSQL)   ;
	}
	
	/**
	* suppression d'un groupe
	* @param	integer	$idg ID du groupe
	* @access	public
	*/
	function del($idg) {
		global $ClsDocument, $ClsWebMail, $ClsGroupe, $ClsSession, $db, $TBL ;
		$sSQL ="DELETE FROM ".$TBL['list_groupe']." WHERE id_groupe=".$idg;
		$db->query($sSQL)   ;
		$sSQL ="DELETE FROM ".$TBL['groupe']." WHERE id_groupe=".$idg;
		$db->query($sSQL)   ;		
	}

	/**
	* supprime le user d'un groupe
	* @param	integer	$idm ID du membre
	* @param	integer	$idg ID du groupe
	* @access	public
	*/
	function delUserGroupe($idm,$idg) {
		global $db, $TBL, $ClsTracking, $ClsSession, $ClsFormation, $ClsLog ;
		$this->delMembre($idg,$idm);
		$ret = $ClsSession->read($idg);
		for($j=0;$j<$ret['cnt'];$j++) {
			$ClsTracking->del($idm,$ret[$j]['id'],$idg);
			$ClsFormation->del($idm,$ret[$j]['id'],$idg);
			$ClsLog->del($idm,$idg);
		}
	}

	/**
	* retourne le nombre de groupes d'un membre
	* @param	integer	$idm ID du membre
	* @access	private
	*/
	function nbGroupe($idm) {
		global $db, $TBL ;
		$sSQL = "SELECT COUNT(id_groupe) FROM ".$TBL['groupe']." " ;
		$sSQL.= "WHERE id_membres=".$idm ;
		$db->query($sSQL)   ;
		$db->next_record();
		return(is_numeric($db->f(0))?$db->f(0):0);	
	}	
	
	/**
	* changement de groupes d'un stagiaire
	* @param	integer	$idu ID du user
	* @param	array	$newgroupe list des nouveaux groupes
	* @access	public
	*/
	function updateMembreGroupe($idu,$newgroupe) {
		global $db, $TBL;
		$this->InitList($idu);
		$oldgroupe = array();
		while($ret=$this->NextItem()) {
			if ( $ret['id_groupe'] > 0 ) {
				$oldgroupe[] = $ret['id_groupe'];
			}
		}
		
		$this->addGroupe0();
		$this->delUserGroupe($idu,0);	
		
		if ( ! is_array($newgroupe) ) {
			$newgroupe = array();
		}
		
		// suppression des vieux groupes
		$ret1 = array_diff($oldgroupe,$newgroupe);
		if ( is_array($ret1) && count($ret1)>0 ) {
			$val1 = array_values($ret1) ;
			for($i=0;$i<count($val1);$i++){
				$this->delUserGroupe($idu,$val1[$i]);
			}
		}
		
		// ajout des nouveaux groupes
		$ret2 = array_diff($newgroupe,$oldgroupe);
		if ( is_array($ret2) && count($ret2)>0 ) {
			$val2 = array_values($ret2) ;
			for($i=0;$i<count($val2);$i++){
				$this->addMembre($val2[$i],$idu);
			}
		}		
		
		if ( $this->nbGroupe($idu) == 0 ) {
			$this->addGroupe0();
			$this->addMembre(0,$idu);
		}
	}

	/**
	* merge entre deux selection de stagiaires
	* @param	array	$oldgroupe list des ancien stagiaire du groupe
	* @param	array	$newgroupe list des nouveaux stagiaire du groupe
	* @access	public
	*/
	function MergeMembreGroupe($idg,$oldgroupe,$newgroupe) {
	global $ClsMembre ;
		if ( ! is_array($newgroupe) ) {
			$newgroupe = array();
		}
		if ( ! is_array($oldgroupe) ) {
			$oldgroupe = array();
		}
		// suppression des vieux groupes
		$ret1 = array_diff($oldgroupe,$newgroupe);
		if ( is_array($ret1) && count($ret1)>0 ) {
			$val1 = array_values($ret1) ;
			for($i=0;$i<count($val1);$i++){
				$this->delUserGroupe($val1[$i],$idg);
			}
		}
		
		// ajout des nouveaux groupes
		$ret2 = array_diff($newgroupe,$oldgroupe);
		if ( is_array($ret2) && count($ret2)>0 ) {
			$val2 = array_values($ret2) ;
			for($i=0;$i<count($val2);$i++){
				$this->addMembre($idg,$val2[$i]);
				if ( $ClsMembre->GetLastGroupe($val2[$i])==0) { 
					$ClsMembre->SetGroupe($val2[$i],$idg);
				}
			}
		}
	}

	/**
	* Verifie si le membre appartient au groupe
	* @param	integer	$idm ID du membre
	* @param	integer	$idg ID du groupe	
	* @access	public
	*/
	function verifMembreGroupe($idm,$idg) {
		global $db, $TBL ;
		$sSQL = "SELECT * FROM ".$TBL['groupe']." " ;
		$sSQL.= "WHERE id_groupe=".$idg." AND id_membres=".$idm ;
		$db->query($sSQL)  ;
		return($db->num_rows()>=1);	
	}	
		
	
 } // class Groupe


/**
* Instance de la classe Groupe
* @var	object	Groupe
*/
 $ClsGroupe = new Groupe ;

?>