<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Definition de la class pour la gestion des logs
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @package	GaneshaClass
*/
/**
* Fournit une API pour envoyer des emails
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @access	public
* @package	GaneshaClass
*/
class Email {

	/**
	* contient le corps du mail
	* @var	string	$_body
	* @access	private
	* @see	SetBody(), AddToBody(), AddPub(), Send()
	*/
	var $_body = ""	;
	/**
	* Contient le sujet du mail
	* @var	integer	$_subject
	* @access	private
	* @see	SetSubject(), Send()
	*/
	var $_subject	;
	/**
	* Contient le header du mail ( essentiellement le champs bcc )
	* @var	integer	$_header
	* @access	private
	* @see	SetBcc(), Send()
	*/
	var $_header	;

	/**
	* Positionne l'objet du mail
	*
	* @param	integer	$type   Defini le type de mail : emil admin, envoi du login/pwd
	* @param	integer	$val1	Permet d'ajouter du texte au sujet du mail
	* @access	public
	*/
	function SetSubject($type,$val1) {
		switch ( $type ) {
			case MAIL_LOGIN_PASSWORD :
					$this->_subject = "Login + password <Ganesha>" ;
					break ;
			case MAIL_TUTEUR :
			case MAIL_STAGIAIRE :
					$this->_subject = "<Ganesha> message perso" ;
					break ;
			case MAIL_ADMIN :
					$this->_subject = "<Ganesha> : ".$val1 ;
					break ;
			case MAIL_INSCRIPTION :
					break;
		}
	}

	/**
	* Positionne le corps du mail
	*
	* @param	integer	$type   Defini le type de mail : email admin, envoi du login/pwd
	* @param	integer	$val1	Utilise en fonction du type d'email
	* @param	integer	$val2	Utilise en fonction du type d'email
	* @param	integer	$val3	Utilise en fonction du type d'email
	* @param	integer	$val4	Utilise en fonction du type d'email
	* @access	public
	*/
	function SetBody($type,$val1,$val2,$val3,$val4) {
		global $ClsMembre ;
		$date = getdate()				;
		$date = date("j/m/Y",$date["0"]);
		switch ( $type ) {
			case MAIL_LOGIN_PASSWORD :
				$this->_body = "Email envoye par GANESHA le ".$date."\n";
				$this->_body.= " \n";
				$this->_body = "Login = ".$val1." \n"	;
				$this->_body.= "Password = ".$val2."\n"	;
				break ;
			case MAIL_TUTEUR :    // Tuteur -> Stagiaire, Groupe
			case MAIL_STAGIAIRE : // Stagiaire -> Tuteur, Groupe
				$this->_body = "Email envoye par GANESHA le ".$date."\n";
				$this->_body.= " \n";
				$this->_body.= " \n";
				$this->_body.= " De      : ".$val1."\n"	;
				$this->_body.= " Groupe  : ".$val2."\n"	;
				$this->_body.= " Message : ".$val3."\n"	;
				$this->_body.= " \n";
				$this->_body.= " \n";
				$this->_body.= " Se connecter : ".HTTP_MAIN."\n";
				$this->_body.= " \n";
				break ;
			case MAIL_ADMIN : // Tuteur -> Admin
				$this->_body = "Email envoye par GANESHA le ".$date."\n";
				$this->_body.= " \n";
				$this->_body.= " \n";
				$this->_body.= " De      : ".$val1."\n"	;
				$this->_body.= " Email   : ".$val2."\n"	;
				$this->_body.= " Message : ".$val3."\n"	;
				$this->_body.= " \n";
				$this->_body.= " \n";
				$this->_body.= " Se connecter : ".HTTP_MAIN."\n";
				$this->_body.= " \n";
				break ;
			case MAIL_INSCRIPTION :
				$this->_body = "Inscription du ".$date."\n";
				$this->_body.= " \n";
				$this->_body.= " \n";
				$ret = $ClsMembre->GetFiche($val1);
				$this->_body.= " Nom :".$ret['nom']."\n";
				$this->_body.= " Prnom :".$ret['prenom']."\n";
				$this->_body.= " E-mail :".$ret['email']."\n";
				$this->_body.= " Adresse :".$ret['adresse']."\n";
				$this->_body.= " Code postal :".$ret['cp']."\n";
				$this->_body.= " Ville :".$ret['ville']."\n";
				$this->_body.= " Login :".$ret['login']."\n";
				$this->_body.= " Mot de passe :".$ret['password']."\n";
				$this->_body.= " \n";				
				$this->_body.= " Se connecter : ".HTTP_MAIN."\n";
				$this->_body.= " \n";
				break ;
		}
	}

	/**
	* Positionne la copie cachee
	*
	* @param	string	$bcc   email envoye en copie cachee
	* @access	public
	*/
	function SetBcc($bcc) { 
		$this->_header = "bcc:".$bcc ;
	}

	/**
	* Ajoute du texte au corps du message
	*
	* @param	string	$val   Texte a ajouter au corps du message
	* @access	public
	*/
	function AddToBody($val) {
		$this->_body.= $val."\n";
	}

	/**
	* Ajoute la pub Ganesha a la fin du mail
	*
	* @access	public
	*/
	function AddPub() { 
		$this->_body.= " \n"								;
		$this->_body.= " \n"								;
		$this->_body.= " \n"								;
		$this->_body.= " \n"								;
		$this->_body.= "*******************************\n"	;
		$this->_body.= "Ganesha, 1ere plate forme \n"		;
		$this->_body.= "en Open Source et gratuite\n"		;
		$this->_body.= " \n"								;
		$this->_body.= "  http://www.anemalab.org \n"		;
		$this->_body.= " \n"								;
		$this->_body.= "*******************************\n" ;
	}

	/**
	* Envoie un email
	*
	* @param	string	$dest   Email du destinataire
	* @return	boolean true si le message est envoye, false sinon
	* @access	public
	*/
	function Send($dest) {
		if ( ! OPT_MAIL_ACTIVE ) return(false);
		$this->AddPub();
		if ( PROVIDER == ONLINE ) {
			if( !email("webmaster",$dest,$this->_subject,Unreplace($this->_body)) ) {
				return(false);
			}
		} else {
			// Hebergeur classique
			if( !@mail($dest,$this->_subject,Unreplace($this->_body),$this->_header) ) {
				return(false);
			}
		}
		return(true);
	}

}  // fin class EMAIL

/**
* Instance de la classe Email
* @var	object	Email
*/
 $ClsMail = new Email ;


?>