<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Definition de la class pour la gestion des membres
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @package	GaneshaClass
*/
/**
* Fournit une API pour acceder aux membres
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @access	public
* @package	GaneshaClass
*/
class Membre {

	/**
	* Contient la connexion locale de la classe
	* @var	object DB_Ganesha	$_db
	* @access	private
	*/
	var $_db ;

	/**
	* Constructeur. Initialise une connexion a la bdd
	* @access	private
	*/
	function Membre() {
		$this->_db = new DB_Ganesha ;
	}
	
	/**
	* verifie si le login existe deja dans la bdd et si le mot de passe n'est pas vide
	* @param	string	$pwd Mot de passe du membre
	* @param	string	$login Login du membre
	* @param	string	$idu Id du membre
	* @return	boolean	Retourne false si la verification a echouee, sinon true
	* @access	public
	*/
	function VerifPwdLogin($pwd,$login,$idu=-1) {
	 global $TBL, $db ;
		$pwd = strip_tags($pwd);
		if ( strlen(trim($pwd)) == 0 ) {
			return(false);
		}
		$user = ($idu!=-1?'AND id<>'.$idu:'');
		$sSQL="SELECT login FROM ".$TBL['membres']." WHERE login='".$login."' ".$user ;
		$db->query($sSQL);
		return($db->num_rows() == 0);
	}

	/**
	* Verifie si l'email est deja present dans la bdd
	* @param	integer	$idu id du user
	* @param	string	$email email a verifier
	* @return	boolean	True si email existe
	* @access	public
	*/
	function emailExist($idu,$email) {
	 global $TBL, $db ;
		if ( strlen(trim($email)) == 0 ) {
			return(false);
		}
		if ( ! isEmail($email) ) {
			return(false);
		}
		$sSQL = "SELECT id FROM ".$TBL['membres']." WHERE email ='".$email."' and id<>".$idu;
		$db->query($sSQL);
		return ( $db->num_rows() > 0 ) ;
	}

	/**
	* Initialise la liste de tous les tuteurs d'un groupe
	* @param	integer	$idg id du groupe
	* @access	public
	* @see		NextItem()
	*/
	function InitListTutor($idg) {
	 global $TBL ;
		$sSQL = "SELECT m.id,m.prenom,m.nom FROM ".$TBL['membres']." m,".$TBL['list_groupe']." g ";
		$sSQL.= "WHERE g.id_groupe=".$idg." and m.id=g.id_tuteur ";
		$sSQL.= "ORDER by prenom ASC,nom"	;
		$this->_db->query($sSQL)			;
	}

	/**
	* Lecture des tuteurs pour un groupe
	* @param	integer	$idg id du groupe
	* @access	public
	*/
	function readTuteur($idg) {
	 global $TBL ;
		$sSQL = "SELECT m.id,m.prenom,m.nom FROM ".$TBL['membres']." m,".$TBL['list_groupe']." g ";
		$sSQL.= "WHERE g.id_groupe=".$idg." and m.id=g.id_tuteur ";
		$sSQL.= "ORDER BY prenom ASC,nom"	;
		$this->_db->query($sSQL);
		$ret = array();
		while($this->_db->next_record()) {
			$ret[]=$this->_db->f(1).' '.$this->_db->f(2);
		}
		return($ret);
	}

	/**
	* Initialise la liste de tous les tuteurs d'un groupe
	* @param	integer	$idg id du groupe
	* @access	public
	* @see		NextItem()
	*/
	function InitListGroupe($idg) {
	 global $TBL ;
		$sSQL = "SELECT m.id, m.prenom, m.nom FROM ".$TBL['membres']." m, ".$TBL['groupe']." g ";
		$sSQL.= "WHERE m.type=".STAGIAIRE." and m.id=g.id_membres and g.id_groupe=".$idg." ";
		$sSQL.= "ORDER by m.prenom ASC, m.nom ";
		$this->_db->query($sSQL)			;
	}

	/**
	* Retourne un tableau avec les elements de la liste
	* @return	array Retourne un tableau avec les elements de la liste ou sinon false
	* @access	public
	* @see		InitListTutor(),InitListGroupe()
	*/
	function NextItem() {
		$ret = Array() ;
		if ( $this->_db->next_record() ) {
			$ret['id']		= $this->_db->f(0)	 ;
			$ret['prenom']	= $this->_db->f(1) ;
			$ret['nom']		= $this->_db->f(2)   ;
			return($ret);
		} else {
			return(false);
		}
	} 

	/**
	* retourne la valeur d'un champs de la table membre correspoondant a l'id 
	* @param	string	$field Champs a lire
	* @param	integer	$idu Id du membre
	* @return	string	Retourne la valeur du champs de la table membres correspondant a l'id 
	* @access	private
	*/
	function Request($field,$idu) {
	 global $TBL, $db ;
		$res = '' ;
		$sSQL="SELECT ".$field." FROM ".$TBL['membres']." where id=".$idu  ;
		$db->query($sSQL)	;
		$db->next_record()	;
		if ( $db->num_rows() != 0 ) {
			$res = Unreplace($db->f(0))	;
			$db->free()	;
		}
		return($res);
	}

	/**
	* Mete a jour la fiche du membre
	* @param	integer	$idu	Id du membre
	* @param	string	$nom	Nom du membre
	* @param	string	$prenom	prenom du membre
	* @param	string	$email	Email du membre
	* @param	string	$login	Login du membre
	* @param	string	$pwd	Mot du passe du membre
	* @param	string	$adresse	Adresse du membre
	* @param	string	$cp		Code postal du membre
	* @param	string	$ville	Ville du membre
	* @access	public
	*/
	function ModifierFiche ($idu,$nom,$prenom,$email,$login,$pwd,$adresse,$cp,$ville) {
	 global $TBL, $db ;
		$sSQL = "UPDATE ".$TBL['membres']." SET prenom='".$prenom."',nom='".$nom."',login='".$login."',";
		$sSQL.= "password='".$pwd."',email='".$email."',adresse='".$adresse."',cp='".$cp."',";
		$sSQL.= "ville='".$ville."' WHERE id=".$idu		;
		$db->query($sSQL)	;
	}

	/**
	* Retourne la fiche d'un membre
	* @param	integer	$idu	Id du membre
	* @return	array	Retourne un tableau avec toutes les informations d'un membre 
	* @access	public
	*/
	function GetFiche($idu) {
	 global $TBL, $db, $tu_texte ;
		$sSQL = "SELECT prenom,nom,login,password,date_creation,email,adresse,cp,ville,";
		$sSQL.= "id_societe,cv,nbconnexion,date_connexion ";
		$sSQL.= "FROM ".$TBL['membres']." where id=".$idu  ;
		$db->query($sSQL)	;
		if ( $db->num_rows() != 0 ) {
			$db->next_record() ;
			$ret['prenom']			= $db->f("prenom")	;
			$ret['nom']				= $db->f("nom")		;
			$ret['login']			= $db->f("login")	;
			$ret['password']		= $db->f("password");
			$ret['date_creation']	= date("j/m/y  H:i",$db->f("date_creation")); 
			$ret['email']			= $db->f("email")	;
			$ret['adresse']			= $db->f("adresse")	;
			$ret['cp']				= $db->f("cp")		;
			$ret['ville']			= $db->f("ville")	;
			$ret['id_societe']		= $db->f("id_societe")	;
			$ret['cv']				= $db->f("cv")			;
			$ret['nbconnexion']		= $db->f("nbconnexion")	;
			$ret['date_connexion']	= ($db->f("date_connexion")==''?$tu_texte['nocnx']:date(FORMATDATE,$db->f("date_connexion")));
		}
		return($ret);
	}

	/**
	* Retourne l'id de l'admin Ganesha
	* @return	integer	Retourne l'id de l'admin Ganesha
	* @access	public
	*/
	function GetIdRoot() {
	 global $TBL, $db ;
		$ret = "" ;
		$sSQL="SELECT id FROM ".$TBL['membres']." where type=2";
		$db->query($sSQL)	;
		$db->next_record()	;
		if ( $db->num_rows() != 0 ) {
			$ret = $db->f("id")	;
			$db->free()			;
		}
		return($ret);
	}

	/**
	* Retourne l'id de l'admin Ganesha
	* @return	integer	Retourne l'id de l'admin Ganesha
	* @access	public
	*/
	function getMelAdmin() {
		$idu = $this->GetIdRoot();
		return($this->Request("email",$idu));
	}

	/**
	* Retourne le nom de l'auteur
	* @param	integer	$idu	Id du membre
	* @return	string	Retourne le nom de l'auteur
	* @access	public
	*/
	function GetAuteurName($idu) {
	 global $TBL ;
		$ret = "" ;
		$sSQL="SELECT prenom,nom FROM ".$TBL['membres']." where id=".$idu  ;
		$this->_db->query($sSQL)		;
		$this->_db->next_record();
		if ( $this->_db->num_rows() != 0 ) {
			$ret = Unreplace($this->_db->f(0)." ".$this->_db->f(1))	;
			$this->_db->free()	;
		}else{
			$ret = '&nbsp;';
		}
		return($ret);
	}

	/**
	* Retourne la valeur du champ Nom pour le membre $idu
	* @param	integer	$idu	Id du membre
	* @return	string	Retourne le nom d'un membre
	* @access	public
	*/
	function GetNom($idu) { 
		return $this->Request("nom",$idu); 
	}

	/**
	* Retourne la valeur du champ Prenom pour le membre $idu
	* @param	integer	$idu	Id du membre
	* @return	string	Retourne le prenom d'un membre
	* @access	public
	*/
	function GetPrenom($idu) { 
		return $this->Request("prenom",$idu); 
	}

	/**
	* Retourne la valeur du champ CV pour le membre $idu
	* @param	integer	$idu	Id du membre
	* @return	string	Retourne le cv d'un membre
	* @access	public
	*/
	function GetCvLink($idu) { 
		return $this->Request("cv",$idu); 
	}

	/**
	* Retourne la valeur du champ email pour le membre $idu
	* @param	integer	$idu	Id du membre
	* @return	string	Retourne l'email d'un membre
	* @access	public
	*/
	function GetEmail($idu) { 
		return $this->Request("email",$idu); 
	}

	/**
	* Retourne la valeur du champ login pour le membre $idu
	* @param	integer	$idu	Id du membre
	* @return	string	Retourne le login d'un membre
	* @access	public
	*/
	function GetLogin($idu) { 
		return $this->Request("login",$idu);
	}

	/**
	* Retourne la valeur du champ nbconnexion pour le membre $idu
	* @param	integer	$idu	Id du membre
	* @return	string	Retourne le nombre de connexion d'un membre
	* @access	public
	*/
	function GetNbConnexion($idu) { 
		return $this->Request("nbconnexion",$idu);
	}

	/**
	* Retourne la valeur du champ date_connexion pour le membre $idu
	* @param	integer	$idu	Id du membre
	* @return	string	Retourne le nombre de connexion d'un membre
	* @access	public
	*/
	function GetDateConnexion($idu) { 
	 global $tu_texte ;
		$ret = $this->Request("date_connexion",$idu);
		if ( $ret !=  '' ) {
			$last = date("j/m/Y",$ret) ;
		} else {
			$last = "<b>".$tu_texte['nocnx']."</b>" ;
		}
		return($last);
	}

	/**
	* Retourne le nom du membre en fonction de son login
	* @param	string	$login	Login du membre
	* @return	string	Retourne le nom du membre 
	* @access	public
	*/
	function GetNameByLogin($login ) {
	 global $TBL, $db ;
		$ret = "" ;
		$sSQL="SELECT prenom,nom FROM ".$TBL['membres']." where login='".$login."'" ;
		$db->query($sSQL)	;
		$db->next_record()	;
		if ( $db->num_rows() != 0 ) {
			$ret = Unreplace($db->f(0)." ".$db->f(1));
			$db->free();
		}
		return($ret);
	}

	/**
	* Retourne la liste des tuteurs pour le profil stagiaire
	* @param	integer	$idg	Id du groupe
	* @return	string	Retourne une chaine contenant le code HTML pour l'ouverture des CV des tuteurs
	* @access	public
	*/
	function GetTuteur($idg) {
	 global $TBL, $gconnexionid, $db ;
		$sSQL ="SELECT m.prenom,m.nom,m.cv FROM ".$TBL['list_groupe']." g,".$TBL['membres']." m ";
		$sSQL.="where g.id_groupe=".$idg." and g.id_tuteur=m.id";
		$db->query($sSQL);
		$tuteur = '' ;
		if ( $db->num_rows() > 0 ) {
			while( $db->next_record() ) {
				if ( trim($db->f(2)) != '' ) {
					$tuteur.="<A class=student href=\"#\" onMouseOver=\"window.status='Affichage du CV';return true;\" onMouseOut=\"window.status='Ganesha ".VERSION."';return true;\"  onClick=\"openWindow('".HTTP_CV.$db->f(2)."?connexion=".$gconnexionid."','fenetre','scrollbars=yes,width=620,height=400')\">".CSS($db->f(0).' '.$db->f(1))."&nbsp;</A>";
				} else {
					$tuteur.=CSS($db->f(0).' '.$db->f(1));
				}
				$tuteur.='&nbsp;-&nbsp;';
			}
		} else {
			$tuteur = "(Aucun)"	;
		}
		$db->free()		;
		return($tuteur)	;
	}

	/**
	* Retourne la liste des tuteurs pour le profil tuteur
	* @param	integer	$idg	Id du groupe
	* @return	string	Retourne une chaine contenant le code HTML pour l'ouverture des CV des tuteurs
	* @access	public
	*/
	function GetListTuteur($idg) {
	 global $TBL, $gconnexionid, $db ;
		$sSQL ="SELECT m.prenom,m.nom,m.cv FROM ".$TBL['list_groupe']." g,".$TBL['membres']." m ";
		$sSQL.="where g.id_groupe=".$idg." and g.id_tuteur=m.id";
		$db->query($sSQL);
		$tuteur = '' ;
		if ( $db->num_rows() > 0 ) {
			while( $db->next_record() ) {
				if ( trim($db->f(2)) != '' ) {
					$tuteur.="<A class=student href=\"#\" onMouseOver=\"window.status='Affichage du CV';return true;\" onMouseOut=\"window.status='Ganesha ".VERSION."';return true;\"  onClick=\"openWindow('".HTTP_CV.$db->f(2)."?connexion=".$gconnexionid."','fenetre','scrollbars=yes,width=620,height=400')\">".CSS($db->f(0)." ".$db->f(1))."&nbsp;</A><br>&nbsp;";										
				} else {
					$tuteur.=CSS($db->f(0)." ".$db->f(1)).'<br>';					
				}
			}
		} else {
			$tuteur = "(Aucun)";
		}
		$db->free()		;
		return($tuteur)	;
	}

	/**
	* Retourne la liste des stagiaires
	* @return	tableau des stagiaires
	* @access	public
	*/
	function GetListStagiaire() {
	 global $TBL, $db ;
		$sSQL ="SELECT id,prenom,nom FROM ".$TBL['membres']." WHERE type=".STAGIAIRE." ORDER BY prenom, nom" ;
		$db->query($sSQL);
		$ret['cnt'] = $db->num_rows();
		$index = 0			;
		while( $db->next_record() ) {
			$ret[$index]['prenom'] 	= $db->f('prenom');
			$ret[$index]['nom'] 	= $db->f('nom');
			$ret[$index]['name'] 	= $db->f('prenom').' '.$db->f('nom');
			$ret[$index]['id']  	= $db->f('id');
			$index++ ;
		}
		$db->free()		;
		return($ret)	;
	}

	/**
	* Retourne la liste des emails des tuteurs d'un groupe
	* @param	integer	$idg	Id du groupe
	* @return	string	Retourne une chaine contenant les Emails des tuteurs
	* @access	public
	*/
	function GetEmailTuteur($idg) {
	 global $TBL, $db ;
		$sSQL ="SELECT m.email from ".$TBL['list_groupe']." g,".$TBL['membres']." m ";
		$sSQL.="where  m.id=g.id_tuteur and g.id_groupe=".$idg;
		$db->query($sSQL);
		if ( $db->num_rows() > 0 ) {
			while( $db->next_record() ) {
				if (strlen($db->f(0)) > 0 ) {
					$tuteur.=$db->f(0)." ; " ;
				}
			}
		} else {
			$tuteur = "(Aucun)";
		}
		$db->free()		;
		return($tuteur)	;
	}

	/**
	* Retourne la liste des emails des membres d'un groupe
	* @param	integer	$idg	Id du groupe
	* @return	string	Retourne une chaine contenant les Emails de tous les membres du groupe
	* @access	public
	*/
	function GetEmailGroupe($idg) {
	 global $TBL, $db ;
		$sSQL ="SELECT DISTINCT m.email FROM ".$TBL['membres']." m,".$TBL['list_groupe']." g ";
		$sSQL.="where m.id_groupe=".$idg." OR (g.id_groupe=".$idg." and m.id=g.id_tuteur)";
		$db->query($sSQL);
		if ( $db->num_rows($res) > 0 ) {
			while( $db->next_record() ) {
				if (strlen($db->f(0)) > 0 ) {
					$ret.=$db->f(0)." ; " ;
				}
			}
		} else {
			$ret = "" ;
		}
		$db->free()	;
		return($ret);
	}

	/**
	* Retourne le nom d'un groupe et son id
	* @param	integer	$idu	Id du membre
	* @return	array	Retourne un tableau avec le nom du groupe et son Id
	* @access	public
	*/
	function GetGroupe($idu) {
	 global $TBL, $db ;
		$sSQL ="SELECT g.name,g.id_groupe FROM ".$TBL['list_groupe']." g,".$TBL['membres']." m ";
		$sSQL.="where m.id=".$idu." and g.id_groupe=m.id_groupe";
		$db->query($sSQL);
		if ( $db->num_rows() > 0 ) {
			$db->next_record()			;
			$ret['groupe']	= $db->f(0)	;
			$ret['idgroupe']= $db->f(1)	;
		} else {
			$ret['groupe']	= "(AUCUN)"	;
			$ret['idgroupe']= -1		;
		}
		$db->free()	;
		return($ret);
	}

	/**
	* Retourne le dernier groupe utilise par id
	* @param	integer	$idu	Id du membre
	* @return	array	Retourne un tableau avec le nom du groupe et son Id
	* @access	public
	*/
	function GetLastGroupe($idu) {
	 global $TBL, $db ;
		$sSQL ="SELECT id_groupe FROM ".$TBL['membres']." WHERE id=".$idu ;
		$db->query($sSQL);
		$rt = 0 ;
		if ( $db->num_rows() > 0 ) {
			$ret = $db->f('id_groupe') ;
		} 
		$db->free()	;
		return($ret);
	}	
	
	/**
	* Retourne le type d'un membre
	* @param	integer	$idu	Id du membre
	* @return	integer	Retourne le type d'un membre
	* @access	public
	*/
	function GetTypeMembre($idu) {
	 global $TBL, $db ;
		$sSQL="SELECT type FROM ".$TBL['membres']." where id=".$idu;
		$db->query($sSQL);
		if ( $db->num_rows() > 0 ) {
			$db->next_record()	;
			$type = $db->f(0)	;
		} else {
			$type = -1;
		}
		$db->free()	 ;
		return($type);
	}

	/**
	* Retourne l'id du forum du groupe du membre $idu
	* @param	integer	$idu	Id du membre
	* @return	integer	Retourne l'id du forum du groupe du membre $idu
	* @access	public
	*/
	function GetForumId($idu) {
	 global $TBL, $db ;
		$sSQL ="SELECT DISTINCT l.id_forum FROM ".$TBL['membres']." m, ".$TBL['list_groupe']." l ";
		$sSQL.="where m.id=".$idu." and m.id_groupe=l.id_groupe";
		$db->query($sSQL)	;
		$db->next_record()	;
		$fid  = $db->f(0)	;
		$db->free()			;
		return($fid)		;
	}

	/**
	* Retourne le login et le pwd d'un membre en fonction de son email
	* @param	string	$email	Email du membre
	* @return	array	Retourne un tableau avec le login et le mot de passe d'un membre
	* @access	public
	*/
	function GetLoginPassword($email) {
	 global $TBL, $db ;
		$sSQL ="SELECT login,password FROM ".$TBL['membres']." m where email='".Replace($email)."'";
		$db->query($sSQL);
		if ( $db->num_rows() <> 1 ) {
			return(0);
		}
		$db->next_record() ;
		$ret['login']	= $db->f("login")	;
		$ret['pwd']		= $db->f("password");
		$db->free()	;
		return($ret);
	}

	/**
	* Retourne le nombre de connexion d'un groupe
	* @param	integer	$idg	Id de groupe
	* @return	integer	Retourne le nombre de connexion des membres d'un groupe
	* @access	public
	*/
	function GetNbConnexionGroupe($idg) {
	 global $TBL, $db ;
		$sSQL ="SELECT nbconnexion FROM ".$TBL['membres']." where id_groupe=".$idg." and type=0";
		$db->query($sSQL);
		$nb = "(aucune)" ;
		if ( $db->num_rows() > 0 ) {
			while( $db->next_record() ) {
				$nb = $nb + $db->f("nbconnexion") ;
			}
		} 
		$db->free() ;
		return($nb)	;
	}

	/**
	* Met a jour le groupe courant pour le membre $idu
	* @param	integer	$idu	Id du membre
	* @param	integer	$idg	Id du groupe
	* @access	public
	*/
	function SetGroupe($idu,$idg) {
		global $TBL, $db ;
		$sSQL = "UPDATE ".$TBL['membres']." SET id_groupe=".$idg." WHERE id=".$idu ;
		$db->query($sSQL);
		return(true);
	}
	
	/**
	* Ajoute une nouvelle societe.
	* @param	string	$desc	description de la societe
	* @param	string	$adresse	adresse de la soc.
	* @param	string	$adressef	adresse de facturation de la soc.
	* @access	public
	*/
	function addCompany($desc,$adresse,$adressef) {
		global $TBL, $db ;
		$sSQL = "INSERT INTO ".$TBL['list_societe']." "	;
		$sSQL.= "(description,adresse,adresse_presentiel,adresse_facturation) "	;
		$sSQL.= "VALUES ('".$desc."','".$adresse."','','".$adressef."')"		;
		$db->query($sSQL)   ;
	}

	/**
	* Supprime une societe.
	* @param	integer	$idc	id de la soc.
	* @access	public
	*/
	function delCompany($idc) {
		global $TBL, $db ;
		$sSQL = "DELETE FROM ".$TBL['list_societe']." WHERE id_societe=".$idc	;
		$db->query($sSQL)   ;
		$sSQL = "UPDATE ".$TBL['membres']." SET id_societe=0 WHERE id_societe=".$idc	;
		$db->query($sSQL)   ;
	}

	
	/**
	* lecture de toutes les connexions des stagiaires
	* @param	integer	$idg	id du groupe
	* @return	array	Toutes les connexions
	* @access	public
	*/
	function readCnx($idg) {
		global $TBL, $db ;
        $sSQL = "SELECT m.prenom, m.nom, m.date_connexion,m.id " ;
        $sSQL.= "FROM ".$TBL['membres']." m,".$TBL['groupe']." g " ;
        $sSQL.= "where g.id_membres=m.id AND g.id_groupe=".$idg." AND m.type=0 " ;
        $sSQL.= "order by m.date_connexion DESC, m.nom ASC";
		$db->query($sSQL)   ;
		$ret['cnt'] = $db->num_rows() ;
		$i=0 ;
        while ( $db->next_record() ) {
			$ret[$i]['name']= $db->f(0).' '.$db->f(1);
			$ret[$i]['cnx']	= $db->f(2)	;
			$ret[$i]['id']	= $db->f(3)	;
			$i++ ;
		}
		$db->free()	;
		return($ret);
	}
		
	/**
	* lecture de toutes les societes
	* @param	integer	$idc	id de la societe. '' -> toutes les societes			
	* @access	public
	*/
	function readCompany($idc='') {
		global $TBL, $db ;
		if ( $idc == '' ) {
	        $sSQL = "SELECT description,id_societe,adresse,adresse_facturation ";
	        $sSQL.= "FROM ".$TBL['list_societe']." where id_societe>0 ";
	        $sSQL.= "order by description ASC";
			$db->query($sSQL)   ;
			$ret['cnt'] = $db->num_rows()	;
			$i = 0 ;
			while ( $db->next_record() ) {
				$ret[$i]['name']	= $db->f("description")	;
				$ret[$i]['id']		= $db->f("id_societe")	;
				$ret[$i]['adresse']	= $db->f("adresse")		;
				$ret[$i]['adresse_facturation']	= $db->f("adresse_facturation")		;
				$i++ ;
			}
		} else {
	        $sSQL = "SELECT description,id_societe,adresse,adresse_facturation ";
	        $sSQL.= "FROM ".$TBL['list_societe']." where id_societe=".$idc;
			$db->query($sSQL)   ;
			if ( $db->next_record() ) {
				$ret['name']	= $db->f("description")	;
				$ret['id']		= $db->f("id_societe")	;
				$ret['adresse']	= $db->f("adresse")		;
				$ret['adresse_facturation']	= $db->f("adresse_facturation")		;
			}
		}
		$db->free()	;
		return($ret);
	}

	/**
	* lecture de toutes les societes
	* @param	integer	$idc	id de la societe. '' -> toutes les societes			
	* @access	public
	*/
	function readCompanyExport() {
		global $TBL, $db, $ClsSql2Xml ;
		$ret['mtitre'] 	= 'Exportation des socits';
		$ret['titre'] 	= array('id','nom','adresse','adresse_facturation'); 
        $sSQL = "SELECT description,id_societe,adresse,adresse_facturation ";
        $sSQL.= "FROM ".$TBL['list_societe']." where id_societe>0 ";
        $sSQL.= "order by description ASC";
        switch(FORMAT) {
        case EXPORT_XML :
			$ret['result'] = $ClsSql2Xml->sqlExec($sSQL,$ret['titre']);
			break;
		case EXPORT_XLS :	
			$db->query($sSQL)   ;
			$ret['result']['cnt'] = $db->num_rows()	;
			$i = 0 ;
			while ( $db->next_record() ) {
				$j = 0 ;
				$ret['result'][$i][$j++]	= $db->f("id_societe")	;
				$ret['result'][$i][$j++]	= $db->f("description")	;
				$ret['result'][$i][$j++]	= $db->f("adresse")		;
				$ret['result'][$i][$j++]	= $db->f("adresse_facturation")	;
				$i++ ;
			}
			$db->free()	;
			break;
        }
		return($ret);
	}

	/**
	* MAJ une nouvelle societe.
	* @param	integer	$idc	id de la societe		
	* @param	string	$desc	description de la societe
	* @param	string	$adresse	adresse de la soc.
	* @param	string	$adressef	adresse de facturation de la soc.
	* @access	public
	*/
	function updateCompany($idc,$desc,$adresse,$adressef) {
		global $TBL, $db ;
		$sSQL = "UPDATE ".$TBL['list_societe']." set description='".$desc."',";
		$sSQL.= "adresse='".$adresse."',adresse_presentiel='',adresse_facturation='".$adressef."' ";
		$sSQL.= "WHERE id_societe=".$idc;
		$db->query($sSQL)   ;
	}

	/**
	* Ajoute un nouveau membre
	* @param	string	$prenom	description de la societe
	* @param	string	$nom	adresse de la soc.
	* @param	string	$login	adresse de facturation de la soc.
	* @param	string	$pwd	adresse de facturation de la soc.
	* @param	string	$email	adresse de facturation de la soc.
	* @param	integer	$ids	adresse de facturation de la soc.
	* @param	string	$cv	adresse de facturation de la soc.
	* @param	integer	$type	adresse de facturation de la soc.
	* @param	integer	$idg	id du groupe
	* @access	public
	*/
	function add($prenom,$nom,$login,$pwd,$email,$ids,$cv,$type,$idg) {
		global $TBL, $db ;
		$date	= getdate()	; 
		$date	= $date["0"];
		$sSQL = "INSERT INTO ".$TBL['membres']." ";
		$sSQL.= "(prenom,nom,login,password,email,date_creation,id_societe,cv,type,id_groupe) ";
		$sSQL.= "VALUES ('".$prenom."','".$nom."','".$login."','".$pwd."','".$email."',";
		$sSQL.= "'".$date."',".$ids.",'".$cv."',".$type.",".$idg.")";
		$db->query($sSQL)   ;
		
		$sSQL = "SELECT id FROM  ".$TBL['membres']." "			;
		$sSQL.= "WHERE prenom='".$prenom."' AND nom='".$nom."' ";
		$sSQL.= "AND login='".$login."' AND password='".$pwd."'";
		$sSQL.= "AND date_creation='".$date."' "				;
		$db->query($sSQL) 	;
		$db->next_record()	;
		$ret = $db->f(0) 	;
		$db->free()		;
		return($ret)	;
	}

	/**
	* Retourne la liste des tuteurs 
	* @return	array	liste des tous 
	* @access	public
	*/
	function listTuteur() {
	 global $TBL, $db, $tu_texte ;
        $sSQL = "SELECT prenom,nom,id,login,password,cv,date_creation,date_connexion,nbconnexion ";
        $sSQL.= "FROM ".$TBL['membres']." WHERE type=".TUTEUR." AND id>1 ORDER BY nom ASC, prenom ASC";
        $db->query($sSQL);
		$ret['cnt'] = 0 ;
        $ret['cnt'] = $db->num_rows();
		$i = 0 ;
		while ( $db->next_record() ) {
			$ret[$i]['name']	= $db->f("nom").' '.$db->f("prenom");
			$ret[$i]['id']		= $db->f("id")		;
			$ret[$i]['cv']		= $db->f("cv")		;
			$ret[$i]['login']	= $db->f("login")	;
			$ret[$i]['password']= $db->f("password");
			$ret[$i]['cnx']		= ($db->f("date_connexion")==''?$tu_texte['nocnx']:date(FORMATDATE,$db->f("date_connexion")));
			$ret[$i]['nbcnx']	= $db->f("nbconnexion")		;
			$i++ ;
		}
		$db->free()	;
		return($ret);
	}

	/**
	* Mete a jour la fiche du membre
	* @param	integer	$idu	Id du membre
	* @param	string	$nom	Nom du membre
	* @param	string	$prenom	prenom du membre
	* @param	string	$email	Email du membre
	* @param	string	$login	Login du membre
	* @param	string	$pwd	Mot du passe du membre
	* @param	string	$cv		cv du membre
	* @param	integer	$idsociete	id de la societe
	* @param	integer	$groupe	id du groupe courant	
	* @access	public
	*/
	function update ($idu,$nom,$prenom,$email,$login,$pwd,$cv,$idsociete,$groupe=-1) {
	 global $TBL, $db ;
	 	$grp  = ($groupe==-1?'':'id_groupe='.$groupe.',');
		$sSQL = "UPDATE ".$TBL['membres']." SET prenom='".$prenom."',nom='".$nom."',login='".$login."',";
		$sSQL.= "password='".$pwd."',email='".$email."',".$grp ;
		$sSQL.= "ville='',cv='".$cv."',id_societe=".$idsociete." ";
		$sSQL.= "WHERE id=".$idu		;
		$db->query($sSQL)	;
	}

	/**
	* suppression d'un membre
	* @param	integer	$idm ID du membre
	* @param	integer	$type type du membre
	* @access	public
	*/
	function del($idm,$type) {
		global $db, $TBL ;
		$sSQL ="DELETE FROM ".$TBL['membres']." WHERE id=".$idm;
		$db->query($sSQL)   ;
		if ( $type == TUTEUR ) {
			$sSQL ="DELETE FROM ".$TBL['list_groupe']." WHERE id_tuteur=".$idm;
			$db->query($sSQL)   ;
		}
		$sSQL ="DELETE FROM ".$TBL['stat_cnx']." WHERE id_membres=".$idm;
		$db->query($sSQL)   ;
		$sSQL ="DELETE FROM ".$TBL['formation']." WHERE user_id=".$idm;
		$db->query($sSQL)   ;
		$sSQL ="DELETE FROM ".$TBL['tracking']." WHERE user_id=".$idm;
		$db->query($sSQL)   ;
		$sSQL ="DELETE FROM ".$TBL['groupe']." WHERE id_membres=".$idm;
		$db->query($sSQL)   ;
	}

	/**
	* Lecture des users avec un filtre
	* @param	string	$filtre valeur du filtre
	* @access	public
	*/
	function filtrer($filtre,$stagiaire=true) {
		global $db, $TBL, $tu_texte ;
		$type = ($stagiaire==true?STAGIAIRE:TUTEUR);
		if ( $filtre == 'all' ) {
	        $sSQL = "SELECT prenom,nom,id,login,password,date_creation,date_connexion,nbconnexion ";
    	    $sSQL.= "FROM ".$TBL['membres']." WHERE type=".$type." ORDER BY prenom";
		} else {
	        $sSQL = "SELECT prenom,nom,id,login,password,date_creation,date_connexion,nbconnexion ";
    	    $sSQL.= "FROM ".$TBL['membres']." WHERE type=".$type." AND nom LIKE '".$filtre."%' ";
		}
        $db->query($sSQL);
		$ret['cnt'] = 0 ;
        $ret['cnt'] = $db->num_rows();
		$i = 0 ;
		while ( $db->next_record() ) {
			$ret[$i]['name']	= $db->f("nom").' '.$db->f("prenom");
			$ret[$i]['id']		= $db->f("id")		;
			$ret[$i]['login']	= $db->f("login")	;
			$ret[$i]['password']= $db->f("password");
			$ret[$i]['cnx']		= $db->f("date_connexion");
			$ret[$i]['cnx']		= ($db->f("date_connexion")==''?$tu_texte['nocnx']:date(FORMATDATE,$db->f("date_connexion")));			
			$ret[$i]['nbcnx']	= $db->f("nbconnexion")	;
			$i++ ;
		}
		$db->free()	;
		return($ret);
	}

	/**
	* Retourne un nouveau mot de passe
	* @return	string	Retourne la valeur du mot de passe
	* @access	public
	*/
	function CreatePwd() {
		srand(time())							;
		$taille = 8								;
		$value = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"	;
		$value.= "1234567890"					;
		$value.= "abcdefghijklmnopqrstuvwxyz"	;
		for ( $i=0; $i<$taille; $i++ ) {
			$id .= substr($value,(rand()%(strlen($value))),1);
		}
		return $id ;
	}

	/**
	* Ajoute un nouveau membre
	* @param	string	$prenom	description de la societe
	* @param	string	$nom	adresse de la soc.
	* @param	string	$email	adresse de facturation de la soc.
	* @param	string	$adresse de facturation de la soc.
	* @param	string	$cp	code postal.	
	* @param	string	$ville	ville
	* @param	integer	$type	type du membre
	* @param	string	$code	code d el'inscription	
	* @access	public
	*/
	function inscription($prenom,$nom,$email,$adresse,$cp,$ville,$type,$code) {
		global $TBL, $db, $ClsInscription, $ClsGroupe, $ClsMail ;
		$ret = $ClsInscription->readInsciption($code) ;

		$login 	= str_replace(' ','_',$nom);
		$pwd 	= $this->CreatePwd();		
		if ( ! $this->VerifPwdLogin($pwd,$login) || $this->emailExist(-1,$email) ) {
			return(false);
		}
		
		// Envoyer un email avec login/password.
		$ClsMail->SetSubject(MAIL_LOGIN_PASSWORD,"")	;
		$ClsMail->SetBody(MAIL_LOGIN_PASSWORD,$login,$pwd,"","");
		if ( ! $ClsMail->Send($email) ) {
			return(false);
		}
		
		$groupes = $ret['id_groupe'] ;
		$id_groupe = (count($groupes)>0?$groupes[0]:0);

		$date	= getdate()	; 
		$date	= $date["0"];
		$sSQL = "INSERT INTO ".$TBL['membres']." ";
		$sSQL.= "(id_societe,prenom,nom,login,password,email,date_creation,adresse,cp,ville,type,id_groupe) ";
		$sSQL.= "VALUES (-1,'".$prenom."','".$nom."','".$login."','".$pwd."','".$email."',";
		$sSQL.= "'".$date."','".$adresse."','".$cp."','".$ville."','".$type."','".$id_groupe."')";
		$db->query($sSQL)   ;

		$sSQL = "SELECT id FROM  ".$TBL['membres']." "				;
		$sSQL.= "WHERE prenom='".$prenom."' AND nom='".$nom."'  "	;
		$sSQL.= "AND login='".$login."' AND password='".$pwd."' "	;
		$sSQL.= "AND date_creation='".$date."' "				 	;
		$db->query($sSQL) 	;
		$db->next_record()	;
		$idu = $db->f(0) 	;
		$db->free()			;
		$ClsGroupe->addMembreGroupe($idu,$groupes);
		$ClsInscription->incr($code) ;
		return(true) ;
	}


} // class Membre

	/**
	* Instance de la classe Membre
	* @var	object	Membre
	*/
	$ClsMembre = new Membre ;

?>