<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Definition de la class pour la gestion des News
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @package	GaneshaClass
*/
/**
* Fournit une API pour la gestion des News
* @author	Georges Caldeira <gcaldeira@anemalab.org>
* @access	public
* @package	GaneshaClass
*/

class GaneshaNews {

	/**
	* Cre une nouvelle news pour le groupe $idg
	* @param	string	$titre titre de la news
	* @param	string	$texte texte de la news
	* @param	integer	$idg ID du groupe
	* @param	integer	$idu ID du membre
	* @access	public
	*/
	function add($titre,$texte,$idg,$idu) {
	 global $TBL, $db ;
		$date = FormatDate()	;
		$sSQL="INSERT INTO ".$TBL['news']." (id,titre,msg,date,id_groupe,id_user,status)" ;
		$date = getdate()	;
		$date = $date["0"]	;
		$sSQL .=" VALUES ('','".$titre."','".$texte."','".$date."','".$idg."','".$idu."','1')" ;
		$db->query($sSQL)	;
	}

	/**
	* Csupprime la news pour le groupe $idg
	* @param	integer	$idg ID du groupe
	* @access	public
	*/
	function del($idg) {
	 global $TBL, $db ;
		$date = FormatDate()	;
		$sSQL="DELETE FROM ".$TBL['news']." WHERE id_groupe=".$idg ;
		$db->query($sSQL)	;
	}
		
	/**
	* Met a jour la news pour le groupe $idg
	* @param	string	$titre titre de la news
	* @param	string	$texte texte de la news
	* @param	integer	$idg ID du groupe
	* @param	integer	$idu ID du membre
	* @access	public
	*/
	function update($titre,$texte,$idg,$idu) {
	 global $TBL, $db ;
		$date = getdate()	;
		$date = $date["0"]	;
		$sSQL = "UPDATE ".$TBL['news']." SET titre='".$titre."',msg='".$texte."',date='".$date."',id_user=".$idu ;
		$sSQL.= " where id_groupe=".$idg ;
		$db->query($sSQL)	;
	}

	/**
	* Retourne la news d'un groupe
	* @param	integer	$idg Id du groupe
	* @return	array	Retourne la news du groupe
	* @access	public
	*/
	function read($idg) { 
	 global $TBL, $db, $groupe, $ClsMembre ;
	 global $st_texte ;
		$ret = Array()	;
		$add = false	;
		$sSQL="SELECT id,titre,msg,date,id_user FROM ".$TBL['news']." where id_groupe=".$idg ;
		$db->query($sSQL) ;
		if ( $db->num_rows() == 0 ) {
			$sSQL="SELECT id,titre,msg,date,id_user FROM ".$TBL['news']." where id=1";
			$db->query($sSQL) ;
			$add = true	;
		} 
		$db->next_record() ;
		$ret['id'] = $db->f("id") ;
		$ret['titre'] = $db->f("titre") ;
		$ret['text']  = $db->f("msg") ;
		$ret['date']  = $db->f("date") ;
		$ret['id_user'] = $db->f("id_user") ;
		$id_root = $ClsMembre->GetIdRoot();
		if ( $add ) $this->add($ret['titre'],$ret['text'],$groupe,$id_root);
		return $ret;
	}

} // class GaneshaLog

/**
* Instance de la classe GaneshaNews
* @var	object	GaneshaNews
*/
$ClsNews = new GaneshaNews ;

?>