<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Addon BNO (Bloc-notes et Objectifs) pour Ganesha
*
* @author		PYG <pyg_listes@exiup.com>
* @package		GaneshaInc
*/


	/**
	* Formatte et affiche les liens pour le BNO en fonction du membre connecte.
	* @param	integer	$idgroupe 
	* @access	public
	*/
	function AfficheLienBNO($idgroupe) {
	global $ext, $trad_Menu_BNO, $gconnexionid, $gusertype, $guserid ;

		switch ($gusertype) {
			case STAGIAIRE:   			// ---------> lien "Objectifs" ct stagiaire
				$type_outil = 2; 	// outil = Objectifs
				$url = HTTP_BNO."bno_voir".$ext."?type_outil=".$type_outil."&groupe=".$idgroupe ;
				$url.= "&id_modif=".$guserid."&connexion=".$gconnexionid ;
				$texte = $trad_Menu_BNO['objectif'];
				$texte_lien = $trad_Menu_BNO['Objectifs'] ;
				$href = "javascript:openWindow('".$url."','Objectifs','width=500,height=500,resizable=yes,scrollbars=yes');";
				UL();
				LI($texte.'<a class="student" href="'.$href.'">'.$texte_lien.'</a>');
				_UL();
				break;

			case TUTEUR :	
				SubTitle($trad_Menu_BNO['gestionbno'])	;				
				// ---------> lien "Bloc-notes" ct tuteur
				$type_outil = 1; 	// outil = Bloc-notes
				$url	= HTTP_BNO."index".$ext."?type_outil=".$type_outil."&groupe=".$idgroupe ;
				$url   .= "&id_modif=".$guserid."&connexion=".$gconnexionid."&menu=1";
				$href	= "javascript:openWindow('".$url."','Objectifs','width=500,height=500,resizable=yes,scrollbars=yes');";
				$status = Status($trad_Menu_BNO['BN']);
				UL();
				LI('<a class="student" href="'.$href.'" '.$status.'>'.$trad_Menu_BNO['BN'].'</a>');
	
				// ---------> lien "Objectifs" ct tuteur !!!
				$type_outil = 2; 	// outil = Objectifs
				$url = HTTP_BNO."index".$ext."?type_outil=".$type_outil."&groupe=".$idgroupe ;
				$url.= "&id_modif=".$guserid."&connexion=".$gconnexionid."&menu=1";
				$href = "javascript:openWindow('".$url."','Objectifs','width=500,height=500,resizable=yes,scrollbars=yes');";
				$status = Status($trad_Menu_BNO['Objectifs']);
				LI('<a class="student" href="'.$href.'" '.$status.'>'.$trad_Menu_BNO['Objectifs'].'</a>');
				_UL();
				break;
		}
	}

	/**
	* Affiche le <textarea> 
	* @access	public
	*/
	function AfficheTa () {
	global $id_modif, $groupe, $type_outil, $color1a, $trad_Menu_BNO, $ClsBno;
		BR();
		put("<tr height=30 bgcolor=".$color1a.">");
		put("  <td>");
		BR();
		put("<textarea name=\"Ta\" cols=\"80\" rows=\"10\">");
		// on lit le contenu correspondant
		$enregistrement = $ClsBno->Lire($id_modif, $groupe, $type_outil);	
		// on affiche le contenu dans le <textarea
		put($enregistrement['contenu']);
		put("</textarea>");
		BR();
		put("<div align=\"center\"><INPUT type=submit value=".$trad_Menu_BNO['modifier']."></div>");
		put("  </td></tr>");
		HTMLAreaConfig("Ta","1");
		BR();
	}

	/**
	* Cre un <select>  partir de la requete de la fonction TableUtilisateur
	* @param	string	$sSQL 
	* @param	string	$name 
	* @param	string	$titre 
	* @param	integer	$id 
	* @access	public
	*/
	function MakeListeWithIdBNO($sSQL,$name,$titre,$id) {
	global $color1a ;
		$rqt = mysql_query($sSQL)   ;
        put("<tr height=30 bgcolor=".$color1a.">");
        put("  <td>&nbsp;".$titre."");
        BeginOptionBNO($name);		
        while($row = mysql_fetch_array($rqt)) {
            $select = false ;
			if ($GLOBALS['id_modif']) {										
				if ($GLOBALS['id_modif']==$row[2]) { 
					$select = true ; 
				}
			}
            AddOptionBNO($row[1]." ".$row[0],"&id_modif=".$row[2],$select) ;
        }
        EndOptionBNO();		// fin du select
        put("  </td>\n</tr>\n");
	}
	  
	/**
	* Dbute le select
	* @param	string	$name 
	* @access	public
	*/
	function BeginOptionBNO($name) {
	global $HTTP_SERVER_VARS, $trad_Menu_BNO;
		$params = "type_outil=".$GLOBALS['type_outil']."&menu=".$GLOBALS['menu'] ;
		$params.= "&connexion=".$GLOBALS['connexion']."&groupe=".$GLOBALS['groupe'];
		$url2   = $HTTP_SERVER_VARS['SCRIPT_URI']."?".$params;
		$value  = "&id_modif=aucun" ;
		put_debug(" Debut OPTION ".$name);
		put('<SELECT name="'.$name.'" size=1 onchange="window.location.href=this.options[this.selectedIndex].value">');
		put('<OPTION value="'.$url2.$value.'">'.$trad_Menu_BNO['choisissez'].'</OPTION>');
	}

 	/**
	* termine le select
	* @param	string	$name 
	* @access	public
	*/
	function EndOptionBNO() {
		put("</SELECT>");
		put_debug(" Fin OPTION ");
	}

 	/**
	* Ajoute une option
	* @param	string	$text 
	* @param	string	$value 
	* @param	boolean	$selected 
	* @access	public
	*/	 
	function AddOptionBNO($text,$value,$selected) {
	global $HTTP, $HTTP_SERVER_VARS;
		$params = "type_outil=".$GLOBALS['type_outil']."&menu=".$GLOBALS['menu'] ;
		$params.= "&connexion=".$GLOBALS['connexion']."&groupe=".$GLOBALS['groupe'];
		$url2   = $HTTP_SERVER_VARS['SCRIPT_URI']."?".$params;
		$text = Unreplace($text) ;
		if ( $selected ) {
			put('<OPTION value="'.$url2.$value.'" selected>'.$text.'</OPTION>');
		} else {
			put('<OPTION value="'.$url2.$value.'">'.$text.'</OPTION>');
		}
	}


 	/**
	* Debute le formulaire
	* @param	string	$titre 
	* @param	string	$action 
	* @access	public
	*/	
	function BeginFormulaireBNO($titre,$action) {
	global $color2 ;
		put('
	<CENTER>
	<table width="90%" bgColor="'.$color2.'" border="0" cellPadding="1" >
	<tr>
	<td>
	<FORM action="'.$action.'" method="post">
	<tr height=30>
	 <td colspan="2" class="title2" bgColor="'.$color2.'" align=center>'.$titre.'</td>
	</tr>');

}

 	/**
	* fermeture du formulaire et ajout des champs cachs
	* @access	public
	*/	
	function EndFormulaireBNO() {
    global $color2 ;
		put('
	<tr height="35" bgColor="'.$color2.'">
	 <td align="left" bgColor="'.$color2.'">
	 
	 <input type="hidden" name="menu" value="'.$GLOBALS['menu'].'">
	 <input type="hidden" name="groupe" value="'.$GLOBALS['groupe'].'">
	 <input type="hidden" name="type_outil" value="'.$GLOBALS['type_outil'].'">
	 <input type="hidden" name="id_modif" value="'.$GLOBALS['id_modif'].'">
	 <input type="hidden" name="identite" value=""> 
	 </td>
	 <td></td>
	</tr>
	</FORM>
	</td>
	</tr>
	</table>');
	}

 	/**
	* on affiche les entetes de la page HTML 
	* @access	public
	*/	
	function InitPageHtmlNoCacheBNO() {
	global $BodyColor, $color1, $color2, $charset ;
		put_copyright();
		put('<HTML>
		<HEAD>
		<TITLE>Ganesha</TITLE>
		<META http-equiv="Pragma" content="no-cache">
		<META http-equiv="Cache-Control" content="no-cache">
		<META http-equiv="Expires" content="0">
		<META http-equiv="Content-Type" content="text/html; charset='.$charset.'">');
		stylesheet();
		put('
		<STYLE TYPE="text/css">
		<!--
		BODY { SCROLLBAR-FACE-COLOR: '.$color1.'; SCROLLBAR-HIGHLIGHT-COLOR: #ffffff; SCROLLBAR-SHADOW-COLOR: silver; SCROLLBAR-3DLIGHT-COLOR: silver; SCROLLBAR-ARROW-COLOR: #ffffff; SCROLLBAR-TRACK-COLOR: white; SCROLLBAR-DARKSHADOW-COLOR: '.$color2.'  }
		// -->
		</style>');
		includeJavaScript();
		AjouteHtmlArea(HTTP_HTMLAREA);	// Initialisation du plugin htmlarea
		put('</HEAD>
		<BODY bgColor="'.$BodyColor.'" TOPMARGIN="0" MARGINHEIGHT="0" LEFTMARGIN="0" MARGINWIDTH="0" '.$option.'>');
	}
	
 	/**
	* Affiche les infos aprs le post (ct tuteur)
	* @param	string	$msg_replace 
	* @access	public
	*/	
	function AfficheInfo($msg_replace) {
	global $HTTP_POST_VARS, $color2, $color1;
		$contenu = $HTTP_POST_VARS['Ta'];
		$identite = $HTTP_POST_VARS['identite'];

		$nv_contenu = SecuriseHTML($contenu);
		$nv_contenu = stripslashes($nv_contenu);
		BR(2);
		put('<div align="center">'.$msg_replace.'</div>');
		BR(3);
		put('
		<table width="80%" border="1" align="center" cellpadding="0" cellspacing="0" bordercolor="#000000">
		<tr>
			<td bgcolor="'.$color2.'" class="title2">&nbsp;'.$identite.'</td>
		  </tr>
		  <tr>
			<td bgcolor="'.$color1.'">'.$nv_contenu.'</td>
		</tr>
		</table>');
	}


 	/**
	* Affiche les infos cot stagiaire
	* @param	array	$table 
	* @access	public
	*/	
	function VoirBNO($val) {
		global $HTTP_GET_VARS, $color2, $color1, $trad_Menu_BNO;
		$id_membre = $val['id_membre'];
		$contenu   = $val['contenu']	;
		$type_outil = $val['type_outil']	;
		$date_maj   = $val['date_maj']	;
		$annee = substr($date_maj, 0,4);
		$mois  = substr($date_maj, 4,2);
		$jour  = substr($date_maj, 6,2);
		
		switch ($HTTP_GET_VARS['type_outil']) {
		case 1 : $nom_outil = ($id_membre==0?$trad_Menu_BNO['BN_Gl']:$trad_Menu_BNO['BN']) ;break;
		case 2 : $nom_outil = ($id_membre==0?$trad_Menu_BNO['O_Gl']:$trad_Menu_BNO['Objectifs']) ; break;
		}

		$nv_contenu = SecuriseHTML($contenu)	;
		$nv_contenu = stripslashes($nv_contenu)	;

		BR();
		SubTitle($nom_outil)	;
		BeginBorder("80%",$color2);
		put('<table width="100%" border="0" align="center" cellpadding="0" cellspacing="1" bordercolor="#000000">
			<tr>
				<td bgcolor="'.$color1.'" class="title2"> &nbsp;'.$nom_outil.'&nbsp;&nbsp;('.$jour.'-'.$mois.'-'.$annee.')</td>
			  </tr>
			  <tr>
				<td bgcolor="'.$color1.'">'.$nv_contenu.'</td>
			</tr>
			</table>');
		CloseBorder();
	}


 	/**
	* Lien "retour" apres le post
	* @access	public
	*/	
	function AfficheRetour() {
	global $st_titre;
		BR();
		put('<div align="center">');
		put('<a href="javascript:history.back();">'.$st_titre['retour'].'</a>');
		put('</div>');
	}

 	/**
	* Configuration du plugin htmlarea
	* @access	public
	*/	
	function HTMLAreaConfig($nom_ta, $num_config="0") {
		put('<script language="JavaScript1.2" defer>');
		switch ($num_config) {
		case "0" :	// config par defaut
			put("var config = new Object(); // create new config object");
			break;

		case "1" :	// config personalise n1
			put('var config = new Object(); // create new config object');
			put('config.width  = "90%"  ;');
			put('config.height = "200px";');
			put('config.bodyStyle = \'background-color: white; font-family: "Verdana"; font-size: x-small;\'');
			put('config.debug = 0;');
			// on affiche les boutons choisis
			put("
				config.toolbar = [
			  ['fontname'],
			  ['fontsize'],
			  //['fontstyle'],
			  ['linebreak'],
			  ['bold','italic','underline','separator'],
			  //['strikethrough','subscript','superscript','separator'],
			  ['justifyleft','justifycenter','justifyright','separator'],
			  //['OrderedList'],
			  ['UnOrderedList','Outdent','Indent','separator'],
			  ['forecolor','backcolor','separator'],
			  //['custom1','custom2','custom3','separator'],
			  ['HorizontalRule'],
			  ['Createlink'],
			  //['InsertImage'],
			  ['htmlmode','separator'],
			  //['about','help']
			  ['popupeditor']
			]; ");
			break;
		}
		put("editor_generate('".$nom_ta."',config);");
		put('	</script>');
	}

 	/**
	* Javascript indispensable au plugin htmlarea
	* @param	string	$Chemin 
	* @access	public
	*/	

	function AjouteHtmlArea($Chemin) {
		$js = $Chemin."editor.js" ;
		put('
		<script language="Javascript1.2">
		var _editor_url = "'.$Chemin.'" ;
		var win_ie_ver = parseFloat(navigator.appVersion.split("MSIE")[1]);
		if (navigator.userAgent.indexOf(\'Mac\')        >= 0) { win_ie_ver = 0; }
		if (navigator.userAgent.indexOf(\'Windows CE\') >= 0) { win_ie_ver = 0; }
		if (navigator.userAgent.indexOf(\'Opera\')      >= 0) { win_ie_ver = 0; }
		if (win_ie_ver >= 5.5) {
			document.write(\'<scr\'+\'ipt language="Javascript1.2" src="'.$js.'" ></scr\'+\'ipt>\');  
		} else { 
			document.write(\'<scr\'+\'ipt>function editor_generate() { return false; }</scr\'+\'ipt>\'); 
		}
		</script>');
	}

 	/**
	* afin d'eviter les balises php et javascript (a completer)
	* @param	string	$contenu 
	* @access	public
	*/	
	function SecuriseHTML($contenu) {
		$contenu = str_replace("<?", "< ?", $contenu);
		$contenu = str_replace("?>", "? >", $contenu);
		$contenu = str_replace("<SCRIPT", "< SCRIPT", $contenu);
		$contenu = str_replace("/SCRIPT", "< / SCRIPT", $contenu);
		$contenu = str_replace("?", "< ?", $contenu);
		$contenu = str_replace("?>", "? >", $contenu);
		$contenu = str_replace("<script", "< script", $contenu);
		$contenu = str_replace("/script", "< / script", $contenu);
		$contenu = addslashes($contenu);
		$nv_contenu = $contenu;
		return($nv_contenu);
	}

function AddMenuBNO($index,$width,$titre,$url){
 global $color2, $connexion, $menu, $color1, $color2, $groupe, $type_outil ;
	if ( $menu == 0 ) { $menu = 1 ; }
	$bgcolor = 	($index == $menu ? $color1: $color2 )	;
	$class   =  ($index == $menu ? "HEADER2": "HEADER1");
	$over = 'onMouseOver="window.status=\''.Replace($st_menu['quit']).'\';return true;"'; 
	$out  = 'onMouseOut="window.status=\'Ganesha '.VERSION.'\';return true;"';
	$url  = ($url==""?"":$url.'?type_outil='.$type_outil.'&menu='.$index.'&connexion='.$connexion.'&groupe='.$groupe) ;
	if ( $titre == "" ) {
		put('<TD width="'.$width.'"  bgColor="'.$bgcolor.'">&nbsp;</TD>');
	} else {
		$link = '<a href="'.$url.'" target="_top" class="'.$class.'" '.$over.' '.$out.'>'.$titre.'</a>';
		put('<TD width="'.$width.'"  bgColor="'.$bgcolor.'">'.$link.'</TD>');
	}
}


function HeaderBNOTuteur() {
 global $connexion, $color1, $color2, $ext, $HTTP;
 global $trad_Menu_BNO, $ext, $groupe, $type_outil;
	BeginHeader();
	AddMenuBNO(0,"33%","","");
	if ($type_outil==1) { // Bloc-Notes
		AddMenuBNO(1,"33%",$trad_Menu_BNO['BN_Stag'],HTTP_BNO.'index'.$ext )	;
		AddMenuBNO(2,"33%",$trad_Menu_BNO['BN_Gl'],HTTP_BNO.'index'.$ext)	;
	} else if ($type_outil==2) { // Objectifs
		AddMenuBNO(1,"33%",$trad_Menu_BNO['O_Stag'],HTTP_BNO.'index'.$ext )	;
		AddMenuBNO(2,"33%",$trad_Menu_BNO['O_Gl'],HTTP_BNO.'index'.$ext)	;
	}
	CloseHeader();
}	
?>