<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Liste de fonctions et de commandes utilises par Ganesha
*
* @author		Georges Caldeira <gcaldeira@anemalab.org>
* @package		GaneshaInc
*/

	/*
	* traitement special pour oleane : Merci a PYG et a mathieu
	* Voir les posts :
	* http://www.anemalab.org/phorum/read.php?f=2&i=4171&t=4171
	* http://www.anemalab.org/phorum/read.php?f=2&i=4367&t=4366
	*/
	//ini_alter("error_reporting","2039")	;
	//ini_alter("display_errors",true)		;


	/*
	* Permet d'afficher/masquer tous les warnings
	*/
	if ( DEVELOPPEMENT ) {
		error_reporting (E_ALL);
	} else {
		error_reporting (E_ALL ^ E_NOTICE ^ E_WARNING);
	}

	/**
	* Supprime les \ sur les fichiers
	*/
	set_magic_quotes_runtime(0);

	
	/**
	* Supprime les \ sur POST/GET/COOKIES/FILES
	*/
	if (!get_magic_quotes_gpc()) {
		foreach($HTTP_GET_VARS    as $k=>$v) $HTTP_GET_VARS["$k"]	= addslashes($v) ;
		foreach($HTTP_POST_VARS	  as $k=>$v) $HTTP_POST_VARS["$k"]	= addslashes($v) ;
		foreach($HTTP_POST_FILES  as $k=>$v) $HTTP_POST_FILES["$k"]	= addslashes($v) ;
		foreach($HTTP_COOKIE_VARS as $k=>$v) $HTTP_COOKIE_VARS["$k"]= addslashes($v) ;
	}

	// Modification PyG sur le forum....
	// http://anemalab.org/phorum/read.php?f=2&i=3764&t=3748
	// Passage de toutes les variables en globale
	if($HTTP_GET_VARS) { foreach($HTTP_GET_VARS as $Key=>$Value) {$$Key = $Value;}}
	if($HTTP_POST_VARS){foreach($HTTP_POST_VARS as $Key=>$Value) {$$Key = $Value;}}
	if($HTTP_SERVER_VARS){foreach($HTTP_SERVER_VARS as $Key=>$Value){$$Key = $Value;}}
	if($HTTP_ENV_VARS){foreach($HTTP_ENV_VARS as $Key=>$Value){$$Key = $Value;}}


	/** 
	* Retourne une date en utilisant le format formatDate
	* @param	integer	$date	date a traiter
	* @access	public
	*/
	function ReplaceDate($date)	{ 
		if ($date == '') {
			return('');
		}
		return(date(FORMATDATE,$date));
	}

	/** 
	* Retourne une chaine avec les quotes doubles 
	* en fonction de la config du serveur
	* @param	string	$txt	chaine a traiter
	* @access	public
	* @see		Unreplace()
	*/
	function Replace($txt) {
		$mytxt = trim($txt);
//		$mytxt = (get_magic_quotes_gpc()==0?addslashes($mytxt):$mytxt);
		return $mytxt ;
	}

	/**
	* retourne une chaine sans les quotes doubles 
	* en fonction de la config du serveur
	* @param	string	$txt	chaine a traiter
	* @access	public
	* @see		Replace()
	*/
	function Unreplace($txt) {
		$mytxt = trim($txt);
//		$mytxt = (get_magic_quotes_gpc()==1?stripslashes($mytxt):$mytxt);
//		$mytxt = stripslashes($mytxt);
		return $mytxt ;
	}

	/**
	* retourne une chaine avec les valeurs HTML
	* @param	string	$txt	chaine a traiter
	* @access	public
	* @see		_CSS()
	*/
	function CSS($txt) {
		$mytxt = trim($txt);
		$mytxt = htmlentities($mytxt);
		return $mytxt ;
	}
		
	/**
	* Affiche une chaine avec un retour chariot
	* @param	string	$txt	chaine a afficher
	* @access	public
	*/
	function put($txt ){
		print $txt."\n";
	}

	/**
	* Affiche le (c) de Ganesha a l'ecran
	* @access	public
	* @see		put_copyright(), put()
	*/
	function put_copyright_GANESHA() {
		put('<p class="small">&copy; 2000-2003 An&eacute;ma Formation</p>');
	}

	/**
	* verifie que la valeur passee est bien un email
	* @param	string	$email Email a tester
	* @access	public
	*/
	function isEmail($email){ 
		$ret	= false	;
		$name	= ""	;
		$domain	= ""	;
		@list($name, $domain) = @explode("@", $email) ;
		if( !strstr($email, " ") && @strstr($domain, ".") ){
			$ret = true;
		}
		return($ret);
	}

	/**
	* retourne une chaine avec un format 00h 00m 00s
	* @param	string	$val	valeur a afficher
	* @access	public
	*/
	function FormatTime($val) {

		$hours = intval(intval($val) / 3600); 
		$res = $hours; 
		$res.= ":"; 

		$minutes = ((intval($val) / 60) % 60); 
		if ($minutes < 10) { 
			$res.=  "0"; 
		} 
		$res.= $minutes; 
		$res.=":"; 
		
		$seconds = (intval($val) % 60); 
		if ($seconds < 10) { 
			$res.= "0"; 
		} 
		$res.= $seconds;
		return($res);
		/*
		if ( $val > 3600 ) {
			$heure	= number_format(($val / 3600),0,",","") ;
			$reste = $val % 3600 ;
			if ( $reste > 60 ) {
				$minute	= number_format( ($reste / 60),0,",","") ;
				$seconde= $reste % 60 ;
			} else {
				$minute	= 0 ;
				$seconde = $reste ;
			}
		} else {
			if ( $val > 60 ) {
				$minute	= number_format( ($val / 60),0,",","") ;
				$seconde= $val % 60 ;
			} else {
				$minute	= 0 ;
				$seconde = $val ;
			}
		}
		
		$res = ( $heure>0?$heure."h ":"");
		$res.= ( $minute>0?$minute."min ":"");
		$res.= ( $seconde>0?$seconde."s ":"");
		return($res);
		*/
	}
	
	/**
	* Coupe un texte en fonction de $nb_car
	* @param	string	$txt	texte a couper
	* @param	integer	$nb_car	nombre de caracteres
	* @access	public
	*/
	function CouperTexte($txt,$nb_car) {
		$ret = $txt ;
		if ( strlen($txt) > $nb_car && $nb_car >0 ) {
				$ret = substr($txt, 0, $nb_car)." ..."	;
		}
		return($ret);
	}
?>