<?PHP
/* vim: set expandtab tabstop=4 shiftwidth=4: */
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Free Web Based Training System                           |
// +----------------------------------------------------------------------------+
// | <G a n e s h a> - Plate-forme de tlformation gratuite et en open source  |
// +----------------------------------------------------------------------------|
// | Copyright (C) 2001-2003  Anma Formation  <http://www.anema.fr/>           |
// +----------------------------------------------------------------------------+
// |           Developer : Georges CALDEIRA <gcaldeira@anemalab.org>            |
// +----------------------------------------------------------------------------+
// |              Infos on project <http://anemalab.org/>                       |
// +----------------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify       |
// | it under the terms of the GNU General Public License as published by       |
// | the Free Software Foundation; either version 2 of the License, or          |
// | (at your option) any later version.                                        |
// |                                                                            |
// | This program is distributed in the hope that it will be useful,            |
// | but WITHOUT ANY WARRANTY; without even the implied warranty of             |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              |
// | GNU General Public License for more details.                               |
// |                                                                            |
// | You should have received a copy of the GNU General Public License          |
// | along with this program; if not, write to the Free Software                |
// | Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA   |
// +----------------------------------------------------------------------------+

/**
* Gestion des tuteurs
*
* @author		Georges Caldeira <gcaldeira@anemalab.org>
* @package		GaneshaInc
*/

	/**
	* Affiche une synthese des formations
	* @access	public
	*/
	function acc_evalannexes() {
	 global $gconnexionid, $color1, $ClsMembre, $ClsEvalanx;
	 global $tu_titre, $tu_table ;
	 
 		SubTitleImage($tu_titre['evalanx'],MENU_IMG_EVALX);
		InitTableau(5);
		DebutLigne(false);
		TitreTableau($tu_table['evaltitre'],25,$color1);
		TitreTableau($tu_table['nbrapport'],25,$color1);
		TitreTableau($tu_table['pourcent'],25,$color1);
		TitreTableau($tu_table['ltuteur'],25,$color1);
		FinLigne();
	
		$tEval = $ClsEvalanx->getListEval();
		$cnt = count($tEval) ;
		for ( $i=0; $i<$cnt; $i++) {			
			$ideval = $tEval[$i]["id"];
			
			// liste des tuteurs ayant fait un rapport pour l'valuation en cours
			$idtut = $ClsEvalanx->getTabIdTuteur($ideval);
			$lgidtut = count($idtut);
			$linktut = '' ;
			for ($j=0; $j<$lgidtut; $j++) {
				$prenom = $ClsMembre->GetPrenom($idtut[$j]);
				$nom = $ClsMembre->GetNom($idtut[$j]);
				$cv = $ClsMembre->GetCvLink($idtut[$j]);
				if ( trim($cv) != '' ) {
					$status = Status($tu_table['tuteur']);
					$linktut.= "<a class=student href=\"\" ".$status."  onClick=\"openWindow('".HTTP_CV.$cv."?connexion=".$gconnexionid."','cv','scrollbars=yes,width=620,height=400')\">".$prenom." ".$nom."</a>";
				} else {
					$linktut.= $prenom." ".$nom ;					
				}
				if ($j<$lgidtut-1) $linktut.= ", ";
			}
			
			$moyenne = $ClsEvalanx->getMoyenne($ideval);
			
			$color = GetColor($i+1) ;
			DebutLigne(false,$color);
			ColTableau($tEval[$i]["nom"],$color);
			ColTableau($ClsEvalanx->getNbRap($ideval),$color);
			ColTableau($moyenne.'%',$color);
			ColTableau($linktut,$color);
			FinLigne();
		}
		FermeTableau();
	}
	
	/**
	* Affiche une synthese des formations
	* @access	public
	*/
	function acc_tdb() {
	 global $gconnexionid, $guserid, $color1, $color2, $ClsGroupe, $ClsMembre, $ext  ;
	 global $tu_titre, $tu_table ;
 		SubTitleImage($tu_titre['gformation'],MENU_IMG_TDB);
		InitTableau(5);
		DebutLigne(false);
		TitreTableau($tu_table['ngroupe'],25,$color1);
		TitreTableau($tu_table['nstagiaire'],25,$color1);
		TitreTableau($tu_table['nbrecnx'],25,$color1);
		TitreTableau($tu_table['ltuteur'],25,$color1);
		FinLigne();
		
		$tGroupe = $ClsGroupe->read($guserid) ;
		for ( $i=0; $i<$tGroupe['cnt']; $i++) {
			$color = GetColor($i+1) ;
			DebutLigne(false,$color);
			$url   = HTTP_COMMUN.'p_groupe'.$ext.'?groupe='.$tGroupe[$i]['id'].'&connexion='.$gconnexionid ;
			$click  = 'onClick="openWindow(\''.$url.'\',\'fenetre\',\'scrollbars=yes,width=620,height=400\')" ';
			$status = Status ("Dtails du groupe") ;
			$link  = '<a class="student" href="#" '.$click.$status.'>'.CSS($tGroupe[$i]['name']).'</a>';
			ColTableau($link,$color);
			ColTableau($ClsGroupe->NbMembers($tGroupe[$i]['id']),$color);
			ColTableau($ClsMembre->GetNbConnexionGroupe($tGroupe[$i]['id']),$color);
			ColTableau($ClsMembre->GetListTuteur($tGroupe[$i]['id']),$color);
			FinLigne();
		}
		FermeTableau();
	}

	/**
	* Affiche une synthese des formations
	* @access	public
	*/
	function acc_webmail() {
	 global $gconnexionid, $guserid, $color1, $color2, $ClsGroupe, $ClsWebMail ; 
	 global $tu_titre, $tu_table ;

 		SubTitleImage($tu_titre['gmessagerie'],MENU_IMG_MESS);
		InitTableau(5);
		DebutLigne(false);
		TitreTableau($tu_table['grpname'],25,$color1);
		TitreTableau($tu_table['nbmesse'],25,$color1);
		TitreTableau($tu_table['nbmessr'],25,$color1);
		TitreTableau($tu_table['nbmessnl'],25,$color1);
		FinLigne();
		  
		$tGroupe = $ClsGroupe->read($guserid) ;
		for ( $i=0; $i<$tGroupe['cnt']; $i++ ) {
			$color = GetColor($i+1) ;
			DebutLigne(false,$color);
			ColTableau(CSS($tGroupe[$i]['name']),$color);
			ColTableau($ClsWebMail->NbSend($guserid,$tGroupe[$i]['id']),$color);
			ColTableau($ClsWebMail->NbRec($guserid,$tGroupe[$i]['id']),$color);
			ColTableau($ClsWebMail->NbRecNotRead($guserid,$tGroupe[$i]['id']),$color);
			FinLigne();
		}
		FermeTableau();
	}

	/**
	* Affiche une synthese des forums
	* @access	public
	*/
	function acc_forum() {
	 global $gconnexionid, $guserid, $color1, $color2, $ClsGroupe, $ext ; 
	 global $tu_titre, $tu_table, $tu_texte ;
 		SubTitleImage($tu_titre['gforum'],MENU_IMG_FORUM);
		InitTableau(5);
		DebutLigne(false);
		TitreTableau($tu_table['grpname'],25,$color1);
		TitreTableau($tu_table['nbmess'],15,$color1);
		TitreTableau($tu_table['derniermess'],25,$color1);
		TitreTableau($tu_table['adminforum'],35,$color1);
		FinLigne();

		$tGroupe = $ClsGroupe->read($guserid);
		for ( $i=0; $i<$tGroupe['cnt']; $i++) {
			$IdPhorum = $ClsGroupe->IdForum($tGroupe[$i]['id']) ;
			$nb   = NbPost($IdPhorum)	;
			$last = LastPost($IdPhorum)	;
			$nb   = ($nb==0?$tu_texte['nomess']:$nb);
			$last = ($last!=''?date_format_fr($last):'&nbsp;');
			$url  = HTTP_FORUM.'admin/index'.$ext.'?connexion='.$gconnexionid.'&page=easyadmin&num='.$IdPhorum ;
			$status = Status($tu_table["adminforum"]);
			$action = " onClick=\"openWindow('".$url."','phorum','scrollbars=yes,width=750,height=590')\" ";
			$lurl ='<a href="#" class="student" '.$action.' '.$status.'>'.$tu_table['adminforum'].'</a>'; 
			$color = GetColor($i+1) ;
			DebutLigne(false,$color);
			ColTableau(CSS($tGroupe[$i]['name']),$color);
			ColTableau($nb,$color);
			ColTableau($last,$color);
			ColTableau($lurl,$color);
			FinLigne();
		}
		FermeTableau();
	}

	/**
	* Affiche un tableau de synthese des documents 
	* pour tous les groupes d'un tuteur
	* @access	public
	*/
	function acc_document() {
	 global $guserid, $gusertype, $HTTP, $color1, $color2, $ClsGroupe, $ClsDocument ; 
	 global $tu_table, $tu_titre, $tu_texte ;
 		SubTitleImage($tu_titre['gdoc'],MENU_IMG_DOC);
		InitTableau(5);
		DebutLigne(false);
		TitreTableau($tu_table['ngroupe'],25,$color1);
		TitreTableau($tu_table['nbfiles'],25,$color1);
		TitreTableau($tu_table['nbfilepost'],25,$color1);
		TitreTableau($tu_table['planning'],25,$color1);
		FinLigne();

		$tGroupe = $ClsGroupe->read($guserid);
		for ( $i=0; $i<$tGroupe['cnt']; $i++ ) {
			$color = GetColor($i+1) ;
			DebutLigne(false,$color);
			ColTableau(CSS($tGroupe[$i]['name']),$color);
			ColTableau($ClsDocument->Nb($tGroupe[$i]['id']),$color);
			ColTableau($ClsDocument->NbPost($guserid,$tGroupe[$i]['id']),$color);
			$planning = $ClsGroupe->Planning($tGroupe[$i]['id'])  ;
			if ( $planning != '' ) {
				$rep = $ClsGroupe->Directory($tGroupe[$i]['id']) ;
				$planning = HTTP_GROUPE.$rep."/".$planning ;
				$status	= Status('planning');
				$lp = '<a class="student" target="_blank" href="'.$planning.'" '.$status.'>'.$tu_texte['vplanning'].' </a>';
				ColTableau($lp,$color);
			} else {
				ColTableau($tu_texte['noplanning'],$color);
			}
			FinLigne();
		}
		FermeTableau();
	}

	/**
	* Affiche la page tableau de bord du profil tuteur
	* @access	public
	*/
	function page_tdb_tuteur() {
	 global $color2, $gconnexionid, $ClsSession, $ClsGroupe;
	 global $ext, $groupe, $guserid ;
	 global $tu_menu, $tu_titre ;
		Title( $tu_menu['tdb']." [ ".CSS($ClsGroupe->Name($groupe))." ]");

/*		
		// synthese des groupes...
		$url  = HTTP_COMMUN."p_evaltut".$ext."?connexion=".$gconnexionid	;
		$click  = 'onClick="openWindow(\''.$url.'\',\'fsynthese\',\'scrollbars=yes,width=600,height=590\')" ';
		//$status = Status('Synthese');
		$link = '<a class="student" href="#" '.$click.$status.'>Evaluation du tuteur</a>'; 
		put("&nbsp;&nbsp;".IMG_RIGHT."&nbsp;&nbsp;".$link);
		BR(2);
*/

		// synthese des groupes...
		$url  = HTTP_COMMUN."p_synthese".$ext."?connexion=".$gconnexionid."&groupe=".$groupe	;
		$click  = 'onClick="openWindow(\''.$url.'\',\'fsynthese\',\'scrollbars=yes,width=600,height=590\')" ';
		$status = Status('Synthese');
		$link = '<a class="student" href="#" '.$click.$status.'>Synthse du groupe</a>'; 
		put("&nbsp;&nbsp;".IMG_RIGHT."&nbsp;&nbsp;".$link);
		BR(2);

		SubTitle($tu_titre['sformation'])	;
		BeginBorder("90%",$color2);
		put('<table width="100%" border="0" cellspacing="0" cellpadding="5" bgcolor="#FFFFFF">');
		put('<tr>')	;
		put(' <td>')	;
		UL()			;
		$ret = $ClsSession->read($groupe);
		for ( $i=0; $i<$ret['cnt']; $i++) {
			$titre = ($ret[$i]['name']);
			$url   = HTTP_STAGIAIRE."f_module".$ext."?connexion=".$gconnexionid."&module=".$ret[$i]['id'] ;
			$url  .= "&groupe=".$groupe ;
			$click = "onClick=\"openWindow('".$url."','fenetre','scrollbars=yes,width=750,height=500');\"";
			LI();
			put('<a class="student" href="#" '.$click.Status("Module").'>'.Unreplace($titre).'</a>');
			_LI();
		}
		_UL();
		put(' </td></tr>')	;
		put('</table>')	;
		CloseBorder()		;
		BR()				;

		put('<table width="100%" border="0" cellspacing="0" cellpadding="5" bgcolor="#FFFFFF">');
		put('<tr valign="top">')	;
		put(' <td width="40%">')	;
		// debut modif Pyg [addon BNO] : ajoute le lien vers le bloc-notes tuteur
		$load_news = 0 ;
		if ( OPT_BNO_ACTIVE ) {
			AfficheLienBNO($groupe); 
		} elseif ( OPT_NEWS_ACTIVE ) {
			News($groupe)	;
			$load_news = 1 ;
		} else {
			put('&nbsp;');
		}
		// fin  modif pyg [addon BNO] 
		put('</td><td width="60%">');
		if ( OPT_NEWS_ACTIVE && $load_news==0 ) {
			News($groupe)	;
		} else {
			put('&nbsp;');
		}
		put('</td>');
		put('</tr></table>');
		BR()	;
		DisplayGroupe($groupe,'feng');
	}

	/**
	* Affiche la menu de gauche du profil tuteur
	* @access	public
	*/
	function menu_tuteur() {
	 global $color2, $color1, $color2a,$connexion, $menu, $guserid ;
	 global $ClsGroupe, $ext, $groupe, $cmd ; 
	 global $tu_titre ;
		if ( $cmd=='' ) { $cmd=0 ; }
		//"onmouseover=\"setPointer(this, '".$color2a."')\" onmouseout=\"setPointer(this, '".$color2."')\"";
		$action = "";
		put('<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center" bgcolor="'.$color2.'">');

		put ('     <tr><td valign="middle" width="5%" bgcolor="'.$color2.'">&nbsp;</td>');
		put ('      	<td align="left" valign="middle" width="95%" bgcolor="'.$color2.'" >&nbsp;</td>');
		put ('     </tr>')	;
		
		if ( OPT_SKIN_ACTIVE ) {
			put ('     <tr><td valign="middle" height="40" width="5%" bgcolor="'.$color2.'">&nbsp;</td>');
			put ('     <td align="left" valign="middle" height="40" width="95%" bgcolor="'.$color2.'" >');
			ViewSkin()		;
			put ('     </td></tr>')	;
		}
		
		if ( OPT_AUTORIZ_TUTOR_ADMIN ) {
			$href = HTTP_ADMIN."accueil".$ext."?connexion=".$connexion."&action=liste";
			put ('     <tr><td align="middle" valign="middle" width="5%" bgcolor="'.$color2.'">'.IMG_RIGHT.'</td>');
			put ('     <td align="left" valign="middle" width="95%" bgcolor="'.$color2.'" >');
			put ('     <a class="HEADER1" target="FrmMain" href="'.$href.'">Admin Ganesha</a>');
			put ('     </td></tr>')	;
		}

		if ( OPT_FICHE_ACTIVE ) {
			put ('     <tr '.$action.'><td align="middle" valign="middle" width="5%" bgcolor="'.$color2.'">'.IMG_RIGHT.'</td>');
			$url  = HTTP_COMMUN.'p_fiche'.$ext.'?connexion='.$connexion ;
			$click  = 'onClick="openWindow(\''.$url.'\',\'ftuteur\',\'scrollbars=yes,width=500,height=590\')" ';
			$status = Status($tu_titre["modifiche"]);
			$link = '<a class="HEADER1" href="#" '.$click.$status.'> '.$tu_titre["modifiche"].'</a>'; 
			put ('     <td align="left" valign="middle" width="95%" bgcolor="'.$color2.'">'.$link.'</td></tr>');
		}
		put ('     <tr><td valign="middle" width="5%" bgcolor="'.$color2.'">&nbsp;</td>');
		put ('      	<td align="left" valign="middle" width="95%" bgcolor="'.$color2.'" >&nbsp;</td>');
		put ('     </tr>')	;


/**
* modifications Eric Villard <evillard@nef.fr> 12/02/03
* ajout d'un menu d'accs aux valuations annexes uniquement
* au niveau du menu tableau de bord
*/		if ($menu == MENU_TDB && OPT_EVALANX_ACTIVE ) {
			// menu valuation slectionn et dpli
			if ( $groupe == 0 && isset($GLOBALS["evalanx"]) && !isset($GLOBALS["evx_menu"])) {
				$image = '<img align="middle" alt="[Evaluations]" border="0" src="'.HTTP_IMAGES.'evalanx.gif">';
				put ('     <tr><td height="25" width="5%" bgcolor="'.$color1.'">'.$image.'</td>');

				$href   = 'href="'.HTTP_TUTEUR.'index'.$ext.'?connexion='.$connexion.'&groupe=0&evalanx=1&menu='.$menu.'"';
				$status = Status($tu_titre["evalanx"]);
				$link = '<a class="HEADER2" target="FrmMain" '.$href.$status.'>'.$tu_titre["evalanx"].'</a>';
				put ('     <td height="25" width="95%" bgcolor="'.$color1.'">'.$link.'</td></tr>');
				menu_evalannexes();
			
			// menu valuation non slectionn mais dpli
			} elseif ( $groupe == 0 && !isset($GLOBALS["evalanx"]) && isset($GLOBALS["evx_menu"])) {
				$image = '<img align="middle" border="0" src="'.HTTP_IMAGES.'evalanx.gif">';
				put ('     <tr '.$action.'><td height="25" bgcolor="'.$color2.'">'.$image.'</td>');
	
				$href   = 'href="'.HTTP_TUTEUR.'index'.$ext.'?connexion='.$connexion.'&groupe=0&evalanx=1&menu='.$menu.'" ' ;
				$status = Status($tu_titre["evalanx"]);
				$link = '<a class="HEADER1" target="FrmMain" '.$href.$status.'>'.$tu_titre["evalanx"].'</a>';
				put ('     <td height="25" bgcolor="'.$color2.'">'.$link.'</td></tr>');
				menu_evalannexes();
			
			// menu valuation non slectionn et non dpli
			} else {
				$image = '<img align="middle" border="0" src="'.HTTP_IMAGES.'evalanx.gif">';
				put ('     <tr '.$action.'><td height="40" bgcolor="'.$color2.'">'.$image.'</td>');
	
				$href   = 'href="'.HTTP_TUTEUR.'index'.$ext.'?connexion='.$connexion.'&groupe=0&evalanx=1&menu='.$menu.'" ' ;
				$status = Status($tu_titre["evalanx"]);
				$link = '<a class="HEADER1" target="FrmMain" '.$href.$status.'>'.$tu_titre["evalanx"].'</a>';
				put ('     <td height="40" bgcolor="'.$color2.'">'.$link.'</td></tr>');
			}
		}
		// menu accueil
		if ( $groupe == 0 && !isset($GLOBALS["evalanx"]) && !isset($GLOBALS["evx_menu"])) {
			$image = '<img align="middle" alt="[Accueil]" border="0" src="'.HTTP_IMAGES.'home.gif">';
			put ('     <tr><td height="40" width="5%" bgcolor="'.$color1.'">'.$image.'</td>');

			$href   = 'href="'.HTTP_TUTEUR.'index'.$ext.'?connexion='.$connexion.'&groupe=0&menu='.$menu.'"';
			$status = Status($tu_titre["accueil"]);
			$link = '<a class="HEADER2" target="FrmMain" '.$href.$status.'>'.$tu_titre["accueil"].'</a>';
			put ('     <td height="40" width="95%" bgcolor="'.$color1.'">'.$link.'</td></tr>');
		} else {
			$image = '<img align="middle" border="0" src="'.HTTP_IMAGES.'home.gif">';
			put ('     <tr '.$action.'><td height="40" bgcolor="'.$color2.'">'.$image.'</td>');

			$href   = 'href="'.HTTP_TUTEUR.'index'.$ext.'?connexion='.$connexion.'&groupe=0&menu='.$menu.'" ' ;
			$status = Status($tu_titre["accueil"]);
			$link = '<a class="HEADER1" target="FrmMain" '.$href.$status.'>'.$tu_titre["accueil"].'</a>';
			put ('     <td height="40" bgcolor="'.$color2.'">'.$link.'</td></tr>');
		}
/**
* fin modifications Eric Villard
*/

		$tGroupe = $ClsGroupe->read($guserid);
		for ( $i=0; $i<$tGroupe['cnt']; $i++ ) {
			$name = $tGroupe[$i]['name'] ;
			if ( $groupe == $tGroupe[$i]['id'] ) {
				$image = '<img align="middle" border="0" src="'.HTTP_IMAGES.'groupe.gif">';
				put ('     <tr><td height="40" width="5%" bgcolor="'.$color1.'" >'.$image.'</td>');

				$href   = '';//'href="#" ' ;
				$status = Status($name);
				$link = '<a class="HEADER2" target="FrmMain" '.$href.$status.'>'.CSS(Replace($name)).'</a>';
				put ('     <td height="40" bgcolor="'.$color1.'">'.$link.'</td></tr>');

			} else {
				$image = '<img align="middle" border="0" src="'.HTTP_IMAGES.'groupe.gif">';
				put ('     <tr '.$action.'><td width="5%"bgcolor="'.$color2.'">'.$image.'</td>');

				$href = 'href="'.HTTP_TUTEUR.'index'.$ext.'?connexion='.$connexion.'&groupe='.$tGroupe[$i]['id'] ;
				$href.= '&menu='.$menu.'&cmd='.$cmd.'" ' ;
				$status = Status($name);
				$link = '<a class="HEADER1" target="FrmMain" '.$href.$status.'>'.CSS(Replace($name)).'</a>';
				put ('     <td height="40" bgcolor="'.$color2.'">'.$link.'</td></tr>');
			}
		}
		put ('     <tr><td height="20" width="5%" bgcolor="'.$color2.'" >&nbsp;</td>');
		put ('     <td height="20" bgcolor="'.$color2.'">&nbsp;</td></tr>');
		print ('</table>')	;		
	}

	/**
	* Affiche la page accueil principale du menu tuteur
	* @access	public
	*/
	function page_accueil() { 
	global $BodyColor, $ext, $menu, $color1 ;
	global $tu_titre ;
/**
* modifications Eric Villard <evillard@nef.fr> 12/02/03
* dfinition du titre de la page d'accueil en fonction
* Accueil tableau de bord / Accueil valuations annexes
*/
		(isset($GLOBALS["evalanx"])) ? $titre = $tu_titre['accueileval']: $titre = $tu_titre['paccueil'];
		
		InitPageHtml();
		print('<table width="100%" border="0" cellspacing="0" cellpadding="0">');
		print('<tr><td width="16%" valign="top">');
		menu_tuteur();
		print('</td>');
		print('<td width="84%" valign="top">');
		Title($titre);
//		print('<center>');
		switch($menu) {
			// orientation vers accueil tuteur ou vers accueil valuations annexes
			case MENU_TDB : (isset($GLOBALS["evalanx"])) ? acc_evalannexes(): acc_tdb(); break;				
/**
* fin modifications Eric Villard
*/ 
			case MENU_WM : acc_webmail(); break;
			case MENU_FORUM : acc_forum();   break;
			case MENU_DOC : acc_document();break;
		}
//		put('</center>');
		put('</td></tr></table>');
	}


	/**
	* Affiche la page principale du menu tuteur en fonction de la varianme $menu
	* @access	public
	*/
	function page_tuteur() { 
	 global $connexion, $ext, $menu, $ClsGroupe, $groupe, $gusertype ;
	 global $gfilecss, $deleteplanning;
		if ( $menu != MENU_FORUM ) {
			InitPageHtml();
			put('<table width="100%" border="0" cellspacing="0" cellpadding="0">');
			put('<tr><td width="16%" valign="top">');
			menu_tuteur();
			put('</td>');
			put('<td width="84%" valign="top">');
		}
		
		switch($menu) {
/**
* modifications Eric Villard <evillard@nef.fr> 12/02/03
* orientation vers accueil tuteur ou vers accueil valuations annexes
*/
		case MENU_TDB : 
			(isset($GLOBALS["evx_menu"])) ? page_evalannexes(): page_tdb_tuteur(); break;		
/**
* fin modifications Eric Villard
*/ 
		case MENU_WM : 
			page_WebMail();		
			break;
		case MENU_FORUM : 
			$num  = $ClsGroupe->IdForum($groupe) ;
			$urlm = HTTP_TUTEUR.'p_menu'.$ext.'?groupe='.$groupe.'&connexion='.$connexion.'&menu='.$menu ;
			$urlf = HTTP_FORUM.'list'.$ext.'?f='.$num.'&connexion='.$connexion ;
			put('<html>');
			put('<head>');
			put('<title>Tuteur</title>');
			put('<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />');
			put('<link rel="stylesheet" href="'.HTTP_SKIN.$gfilecss.'" />');
			put('</head>');
			put('<frameset cols="150,*" scrolling="AUTO" frameborder="NO" border="0" framespacing="0">');
			put('  <frame name="FrmMenu" scrolling="NO" src="'.$urlm.'" marginwidth="0" marginheight="0">');
			put('  <frame name="FrmMain" scrolling="AUTO" src="'.$urlf.'" marginheight="0">'); 
			put('</frameset>');
			put('<noframes>');
			put('<body>');
			put('Dsol, votre navigateur n\'accepte pas les frames');
			put('</body>');
			put('</noframes>');
			put('</html>');
			break;
		case MENU_DOC : 
			page_document();		
			break;
		}
		print ('</td></tr></table>');
	}

?>