/* 

   Geeks Artificial Neural Network (G.A.N.N) - Sockets And Neural Map Creator
   
   Copyright GNU/GPL 2005-2006 George Delaportas (qtgeo)
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/



#if defined __GANN__
#define __GSNMC__

//Geeks Sockets And Neural Map Creator (Function)
void GSNMC()

{

    //Variables
    int i,j,k;			//Counters
    int *APT;			//All Pins Types
    APT=new int[MAX_PIN*2];
    float v,n,m;                //Float Values
    FILE *FileToOpen;		//A File Pointer
    
    //Get User Values To Create The I/O GSockets
    printf("# Geeks Sockets And Neural Map Creator #\n");
    printf("New I/O GSockets Have To Be Created\n");
    printf("Please Make Your Choices To Set Up The New GSockets\n\n");
    
    printf("# Input GSocket #\n");
    
    InSocket.SetST(0);
    
    printf("Please Specify Input GPins Number\n");
    printf("(Min:1,Max:%i)\n",MAX_PIN);
    printf("Choice:");
    
    scanf("%i",&i);
    
    printf("\n");
    
    InSocket.SetPins(i);
    
    printf("Now Please Specify Type And State Of Every GPin\n");
    printf("(Types Binary:0,Real:1)\n");
    printf("(States Off:0,On:1)\n\n");
    
    for (j=0;j<i;j++)
    
    {
    
        printf("GPin %i\n",j+1);
        printf("Choice (Type):");
        
        scanf("%i",&k);
        
        printf("\n");
        
        InSocket.SetPT(j,k);
        
        printf("GPin %i\n",j+1);
        printf("Choice (State):");
        
        scanf("%i",&k);
        
        printf("\n");
        
        InSocket.SetPS(j,k);
    
    }
    
    printf("Now Please Assign Values To The GPins\n");
    printf("(Examples:1 Or 5,20.6)\n\n");
    
    for (j=0;j<i;j++)
    
    {
    
        m=0.0;
        
        printf("GPin %i\n",j+1);
        
        if (InSocket.GetPT(j)==0)
        
        {
        
            printf("Choice [Binary]:");
            
            scanf("%f",&n);
            
            InSocket.SetPV(j,n,0.0);
        
        }
        
        else
        
        {
        
            printf("Choice (Min,Max) [Real]:");
            
            scanf("%f,%f",&n,&m);
            
            InSocket.SetPV(j,n,m);
        
        }
        
        printf("\n");
    
    }
    
    printf("# Output GSocket #\n");
    
    OutSocket.SetST(1);
    
    printf("Please Specify Output GPins Number\n");
    printf("(Min:1,Max:%i)\n",MAX_PIN);
    printf("Choice:");
    
    scanf("%i",&i);
    
    printf("\n");
    
    OutSocket.SetPins(i);
    
    printf("Now Please Specify Type And State Of Every GPin\n");
    printf("(Types Binary:0,Real:1)\n");
    printf("(States Off:0,On:1)\n\n");
    
    for (j=0;j<i;j++)
    
    {
    
        printf("GPin %i\n",j+1);
        printf("Choice (Type):");
        
        scanf("%i",&k);
        
        printf("\n");
        
        OutSocket.SetPT(j,k);
        
        printf("GPin %i\n",j+1);
        printf("Choice (State):");
        
        scanf("%i",&k);
        
        printf("\n");
        
        OutSocket.SetPS(j,k);
    
    }
    
    printf("Now Please Assign Values To The GPins\n");
    printf("(Examples:1 Or 5,20.6)\n\n");
    
    for (j=0;j<i;j++)
    
    {
    
        m=0.0;
        
        printf("GPin %i\n",j+1);
        
        if (OutSocket.GetPT(j)==0)
        
        {
        
            printf("Choice [Binary]:");
            
            scanf("%f",&n);
            
            OutSocket.SetPV(j,n,0.0);
        
        }
        
        else
        
        {
        
            printf("Choice (Min,Max) [Real]:");
            
            scanf("%f,%f",&n,&m);
            
            OutSocket.SetPV(j,n,m);
        
        }
        
        printf("\n");
    
    }
    
    //Get User Opinion To Optimize The GMap Simulation Type
    printf("Please Choose The Simulation Type Of Your A.N.N\n");
    printf("(Critical:0,Normal:1)\n");
    printf("Choice:");
    
    scanf("%i",&j);
    
    printf("\n");
    
    //Check GMSType
    if (j<0 OR j>1)
        GExit(1,"Error:Wrong Simulation Type Specified!\n");
    
    //Get GSockets I/O
    Inputs=InSocket.GetPins();
    Outputs=OutSocket.GetPins();
    
    //Automatically Check GSockets Data Types To Set The Simulation Type
    for (i=0;i<Inputs;i++)
        APT[i]=InSocket.GetPT(i);
    
    for (i=Inputs;i<Inputs+Outputs;i++)
        APT[i]=OutSocket.GetPT(i-Inputs);
    
    for (i=0;i<Inputs+Outputs-1;i++)
    
    {
    
        if (APT[i+1]==APT[i])
            GMSType=APT[i];
        
        else if (APT[i+1]!=APT[i])
        
        {
        
            GMSType=2;
            break;
        
        }
    
    }
    
    //Fixate GMSType
    if (j==0)
        GMSType=1;
    
    //Automatically Check I/O Number-Types-Values-Range To Set ECT
    if (Inputs==Outputs)
    
    {
    
        for (i=0;i<Inputs;i++)
        
        {
        
            if (InSocket.GetPT(i)==OutSocket.GetPT(i))
            
            {
            
                if (InSocket.GetPV(i,0)==OutSocket.GetPV(i,0))
                
                {
                
                    if (InSocket.GetPV(i,1)==OutSocket.GetPV(i,1))
                    
                    {
                    
                        ECT=0;
                    
                    }
                
                }
                
                else
                
                {
                
                    ECT=1;
                    break;
                
                }
            
            }
            
            else
            
            {
            
                ECT=1;
                break;
            
            }
        
        }
    
    }
    
    else
    
    {
    
        ECT=1;
    
    }
    
    //Get User Values To Create The Neural Map
    printf("# Geeks Neural Map #\n");
    printf("Now The GMap Is Ready To Be Created\n");
    printf("Please Specify GMap Connections Type\n");
    printf("(Automatic:0,Manual:1)\n");
    printf("Choice:");
    
    scanf("%i",&GMCType);
    
    //Check GMap Connections Type
    if (GMCType<0 OR GMCType>1)
        GExit(1,"Error:Wrong GMap Connections Type!\n");
    
    printf("\n");                                               
    
    printf("Please Specify An Estimation Of GNeurons\n");
    printf("(GNeurons Must Be Equal Or More Than The Outputs)\n");
    printf("(Min:1,Max:%i)\n",MAX_GN);
    printf("Choice:");
    
    scanf("%i",&GNNum);
    
    //Check For Problematic GNNum
    if (GNNum>MAX_GN)
        GExit(1,"Error:Too Many GNeurons!\n");
    
    //Check For Problematic GMap
    if (GNNum<Outputs)
        GExit(1,"Error:GNeurons Are Less Than The Outputs!\n");
    
    printf("\n");
    
    //Fixate GNNum
    GNNum=GNNum+Inputs+Outputs;
    
    //Initialize GIOD
    FileToOpen=fopen("GIOD","w");
    
    //Set Starting Header
    fprintf(FileToOpen,"%i\n%i\n",Inputs,Outputs);
    
    //Save I/O GSockets Distribution
    for (i=0;i<Inputs;i++)
    
    {
    
        j=InSocket.GetST();
        
        fprintf(FileToOpen,"%i\n",j);
        
        j=InSocket.GetPT(i);
        
        fprintf(FileToOpen,"%i\n",j);
        
        j=InSocket.GetPS(i);
        
        fprintf(FileToOpen,"%i\n",j);
        
        v=InSocket.GetPV(i,0);
        
        fprintf(FileToOpen,"%f\n",v);
        
        v=InSocket.GetPV(i,1);
        
        fprintf(FileToOpen,"%f\n",v);
    
    }
    
    for (i=0;i<Outputs;i++)
    
    {
    
        j=OutSocket.GetST();
        
        fprintf(FileToOpen,"%i\n",j);    
        
        j=OutSocket.GetPT(i);
        
        fprintf(FileToOpen,"%i\n",j);
        
        j=OutSocket.GetPS(i);
        
        fprintf(FileToOpen,"%i\n",j);
        
        v=OutSocket.GetPV(i,0);
        
        fprintf(FileToOpen,"%f\n",v);
        
        v=OutSocket.GetPV(i,1);
        
        fprintf(FileToOpen,"%f\n",v);
    
    }
    
    //Close GIOD
    fclose(FileToOpen);
    
    //Set Simulations Number
    printf("Please Specify How Many Times The G.A.N.N Will Be Simulated\n");
    printf("(Simulations Must Be Positive - Equal Or Bigger Than 1)\n");
    printf("Choice:");
    
    scanf("%i",&SimNum);
    
    if (SimNum<1)
        GExit(1,"Error:Simulations Must Be A Positive Number!\n");
    
    printf("\n");
    
    //Set Threshold
    printf("Please Specify Learning Mode Threshold\n");
    printf("(Threshold Must Be A Positive Value Between 1-100%%)\n");
    printf("Choice:");
    
    scanf("%f",&LearnTH);
    
    if (LearnTH<1.0 OR LearnTH>100.0)
        GExit(1,"Error:Threshold Value Must Be Between 1-100%!\n");
    
    printf("\n");
    
    //Initialize GMap
    FileToOpen=fopen("GMap","w");
    
    //Set Starting Header
    fprintf(FileToOpen,"%i\n%i\n%i\n%i\n%i\n%i\n%f\n",\
    SimNum,ECT,GMSType,GMCType,Inputs,Outputs,LearnTH);
    
    //GMap Creation And Optimization
    j=GNNum/(Inputs+Outputs);	//Layers
    k=GNNum-(Inputs+Outputs);	//Free GNeurons (Not Used For I/O)
    
    printf("Creating And Optimizing GMap...\n");
    
    //Reset GNNum
    GNNum=0;
    
    //Keep Fixated Layers
    Layers=j;
    
    //Check Maximum Layers
    if (Layers>MAX_LAYERS)
        GExit(1,"Error:Too Many Layers Allocated For GMap!\n");
    
    //Fixate Free GNeurons
    if (k==0)
        k++;
    
    //Store Layers
    fprintf(FileToOpen,"%i\n",Layers);
    
    //Rectangle (Orthogonal)
    if (Inputs==Outputs)
    
    {
    
        for (i=0;i<Layers;i++)
        
        {
        
            if (i==Layers-1)
            
            {
            
                fprintf(FileToOpen,"%i\n",Outputs);
                
                GNNum+=Outputs;
            
            }
            
            else
            
            {
            
                fprintf(FileToOpen,"%i\n",k);
                
                GNNum+=k;
            
            }
        
        }
    
    }
    
    //Delta (Triangle)
    else if (Inputs>Outputs)
    
    {
    
        for (i=0;i<Layers;i++)
        
        {
        
            if (i==Layers-1)
            
            {
            
                fprintf(FileToOpen,"%i\n",Outputs);
                
                GNNum+=Outputs;
            
            }
            
            else
            
            {
            
                fprintf(FileToOpen,"%i\n",(k/j)+1);
                
                GNNum+=(k/j)+1;
            
            }
            
            j++;
        
        }
    
    }
    
    //AnaDelta (UpSide Down Triangle)
    else if (Inputs<Outputs)
    
    {
    
        for (i=0;i<Layers;i++)
        
        {
        
            if (i==Layers-1)
            
            {
            
                fprintf(FileToOpen,"%i\n",Outputs);
                
                GNNum+=Outputs;
            
            }
            
            else
            
            {
            
                fprintf(FileToOpen,"%i\n",(k/j)+1);
                
                GNNum+=(k/j)+1;
            
            }
            
            k++;
        
        }
    
    }
    
    //Write Optimized GNNum
    fprintf(FileToOpen,"%i\n",GNNum);
    
    //Close GMap
    fclose(FileToOpen);
    
    printf("\n[Optimized GMap Has %i GNeuron(s)]\n\n",GNNum);
    
    //Clean Up
    delete []APT;

}

#endif

/* ------------------------------------------------------------------------ */
