/* 
   
   Geeks Artificial Neural Network (G.A.N.N) - I/O Socket
   
   Copyright GNU/GPL 2006 George Delaportas (qtgeo)
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/



//Geeks Socket (Class - Model)
class GSocket

{

    private:
    
    //Private Variables
    int SockType;		//Socket Type
    int SockPins;		//Socket Pins
    
    
    
    //Structure Of A Geeks Pin
    struct GPin
    
    {
    
        int Type;
        
        int State;
        
        float Value;
        
        float Range;
    
    };
    
    
    
    //Load Pins Matrix
    GPin Pins[MAX_PIN];		//New Pins
    
    
    
    public:
    
    //Set Socket Type (I/O)
    void SetST(int SType)
    
    {
    
        //Check Socket Type (0:Input,1:Output)
        if (SType<0 || SType>1)
        
        {
        
            printf("Error: Wrong Socket Type Specified!\n");
            
            exit(1);
        
        }
        
        SockType=SType;
    
    }
    
    
    
    //Set Pins Number
    void SetPins(int Num)
    
    {
    
        //Check Socket Pins (Not Less Than 1 Or Not More Than MAX_PIN)
        if (Num<1 || Num>MAX_PIN)
        
        {
        
            printf("Error: Wrong Number Of Pins Specifed!\n");
            
            exit(1);
        
        }
        
        SockPins=Num;
    
    }
    
    
    
    //Set Pin Type
    void SetPT(int Pin,int PinType)
    
    {
    
        //Check Socket Pins
        if (Pin<0 || Pin>SockPins)
        
        {
        
            printf("Error: Wrong Pin Specified!\n");
            
            exit(1);
        
        }
        
        //Socket Pin Type (0:Binary,1:Real)
        if (PinType<0 || PinType>1)
        
        {
        
            printf("Error: Wrong Pin Type Specified!\n");
            
            exit(1);
        
        }
        
        Pins[Pin].Type=PinType;
    
    }
    
    
    
    //Set Pin State
    void SetPS(int Pin,int PinState)
    
    {
    
        //Check Socket Pins
        if (Pin<0 || Pin>SockPins)
        
        {
        
            printf("Error: Wrong Pin Specified!\n");
            
            exit(1);
        
        }
        
        //Socket Pin State (0:Off,1:On)
        if (PinState<0 || PinState>1)
        
        {
        
            printf("Error: Wrong Pin State Specified!\n");
            
            exit(1);
        
        }
        
        Pins[Pin].State=PinState;
    
    }
    
    
    
    //Set Pin Value
    void SetPV(int Pin,float Val)
    
    {
    
        //Check Socket Pins And Values
        if (Pin<0 || Pin>SockPins)
        
        {
        
            printf("Error: Wrong Pin Specified!\n");
            
            exit(1);
        
        }
        
        if (Pins[Pin].Type==0 && Val!=0.0 && Val!=1.0)
        
        {
        
            printf("Error: Value Mismatch!\n");
            
            exit(1);
        
        }
        
        //Check Pin Type To Set Right Values
        if (Pins[Pin].Type==0)
        
        {
        
            Pins[Pin].Value=Val;
            
            Pins[Pin].Range=0.0;
        
        }
        
        else
        
        {
        
            Pins[Pin].Value=Val;
            
            Pins[Pin].Range=0.0;
        
        }
    
    }
    
    
    
    //Set Pin Value With Range [Overloaded]
    void SetPV(int Pin,float Val1,float Val2)
    
    {
    
        //Check Socket Pins And Values
        if (Pin<0 || Pin>SockPins)
        
        {
        
            printf("Error: Wrong Pin Specified!\n");
            
            exit(1);
        
        }
        
        if (Val2<=Val1)
        
        {
        
            printf("Error: Wrong Range Specified!\n");
            
            exit(1);
        
        }
        
        if (Pins[Pin].Type==0 && Val2>0.0)
        
        {
        
            printf("Error: Binary Numbers Have No Range!\n");
            
            exit(1);
        
        }
        
        Pins[Pin].Value=Val1;
        
        Pins[Pin].Range=fabsf(Val2-Val1);
    
    }
    
    
    
    //Get Socket Type (I/O)
    int GetST()
    
    {
    
        return SockType;
    
    }
    
    
    
    //Get Pins Number
    int GetPins()
    
    {
    
        return SockPins;
    
    }
    
    
    
    //Get Pin Type
    int GetPT(int Pin)
    
    {
    
        if (Pin<0 || Pin>SockPins)
        
        {
        
            printf("Error: Wrong Pin Specified!\n");
            
            exit(1);
        
        }
        
        return Pins[Pin].Type;
    
    }
    
    
    
    //Get Pin State
    int GetPS(int Pin)
    
    {
    
        if (Pin<0 || Pin>SockPins)
        
        {
        
            printf("Error: Wrong Pin Specified!\n");
            
            exit(1);
        
        }
        
        return Pins[Pin].State;
    
    }
    
    
    
    //Get Pin Value Or Pin Value With Range
    float GetPV(int Pin,int Choice)
    
    {
    
        if (Pin<0 || Pin>SockPins)
        
        {
        
            printf("Error: Wrong Pin Specified!\n");
            
            exit(1);
        
        }
        
        if (Choice==0)
            return Pins[Pin].Value;
        
        else if (Choice==1)
            return Pins[Pin].Range;
        
        else
        
        {
        
            printf("Error: Wrong Choice Specified!\n");
            
            exit(1);
        
        }
    
    }

};

/* ------------------------------------------------------------------------ */
