/* 
   
   Geeks Artificial Neural Network (G.A.N.N) - Neural Map Simulator
   
   Copyright GNU/GPL 2005-2006 George Delaportas (qtgeo)
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/



//Geeks Neural Map Simulator (0:Learn,1:Run)
void GNMS(int SimFunc)

{

    //Variables
    register int i,j;		//Fast Counters
    int n,k,p;			//Simple Counters
    int GNC;			//GNeurons Counter
    int NLH;			//Next Layer Head
    int NLE;			//Next Layer End
    int GNFT;			//GNeuron Function Type
    int Tracer;			//A Tracer
    int Offset;			//Geeks Hash Table Offset
    float NewData[MAX_PIN];	//New Data From Inputs GSocket
    float AccErr;		//Acceptable Error (%)
    float GErr;			//G.A.N.N Error (%)
    float Tmp;			//Temp Values
    
    //Check For Wrong Simulation Mode
    if (SimFunc<0 OR SimFunc>2)
    
    {
    
        printf("Error: Wrong Simulation Mode Specified!\n");
        
        exit(1);
    
    }
    
    //Learn
    if (SimFunc==0)
    
    {
    
        //Create A New G.A.N.N In Memory (G.A.N.N Matrix)
        GNeuron *GANN;
        GANN=new GNeuron[MAX_GN];
        
        //Get I/O From GSockets Loaded In Memory
        Inputs=InSocket.GetPins();
        Outputs=OutSocket.GetPins();
        
        //Get Acceptable Error
        AccErr=100.0-LearnTH;
        
        //Fill NData With Inputs GSocket Data (Only For Uniform Checks)
        for (i=0;i<Inputs;i++)
            NewData[i]=InSocket.GetPV(i,0);
        
        //Check GMap Simulation Type So As To Set GNeurons Function Type
        if (GMSType==0)
            GNFT=0;
        else
            GNFT=2;
        
        //Print Inputs GSocket
        printf("----- Inputs GSocket -----\n");   
        
        for (i=0;i<Inputs;i++)
        
        {
        
            printf("GPin:%i\n",i+1);
            printf("Minimum Value:%.1f\n",InSocket.GetPV(i,0));
            
            if (InSocket.GetPV(i,1)==0.0)
                printf("Maximum Value:N/A\n");
            else
                printf("Maximum Value:%.1f\n",InSocket.GetPV(i,1));
        
        }
        
        printf("--------------------------\n\n");
        
        //Start Simulation
        printf("Learning...\n\n");
        
        //Simulations Loop
        for (n=0;n<SimNum;n++)
        
        {
        
            //Escape Caption
            ReRoute:;
            
            //Randomize
            GRand();
            
            //Reset Tracer
            Tracer=0;
            
            //Reset GNC
            GNC=-1;
            
            //Reset NLH
            NLH=0;
            
            //Reset NLE
            NLE=0;
            
            //Start Routing Through The Layers
            for (i=0;i<Layers;i++)
            
            {
            
                //Get GNeurons Of Current Layer
                k=GMap[i];
                
                //Check GMap Connections Type (0:Auto,1:Manual)
                if (GMCType==0)
                
                {
                
                    //Enable All GNeurons In This Layer
                    for (j=NLE;j<(k+NLE);j++)
                    
                    {
                    
                        //GNeurons Counter
                        GNC++;
                        
                        //Get Data From InSocket (First Layer)
                        if (i==0)
                        
                        {
                        
                            for (p=0;p<Inputs;p++)
                            
                            {
                            
                                //Get Data Or Data Range
                                if (InSocket.GetPV(p,1)==0.0)
                                    Tmp=InSocket.GetPV(p,0);
                                else
                                    Tmp=GGenData(InSocket.GetPV(p,0),\
                                    InSocket.GetPV(p,1));
                                
                                //Give Data To This GNeuron
                                GANN[GNC].InData(p,Tmp);
                            
                            }
                        
                        }
                        
                        //Get Data From Previous Layer
                        else
                        
                        {
                        
                            for (p=NLH;p<(NLH+NLE);p++)
                            
                            {
                            
                                //Give Data To This GNeuron
                                GANN[GNC].InData(p-NLH,GANN[p].OutData());
                            
                            }
                        
                        }
                        
                        //Enable This GNeuron
                        GANN[GNC].Enable(GNFT);
                        
                        printf("GNeuron %i Enabled!\n\n",GNC+1);
                    
                    }
                    
                    //Next Layer Head
                    NLH+=NLE;
                    
                    //Next Layer End
                    NLE=k;
                
                }
                
                else
                
                {
                
                    //User Defined Connections
                    
                
                }
            
            }
            
            //Reset j
            j=0;
            
            //Fill GData
            for (i=NLH;i<(NLH+NLE);i++)
            
            {
            
                if (OutSocket.GetPV(j,1)!=0.0)
                
                {
                
                    GMinData[j]=GANN[i].OutData()*OutSocket.GetPV(j,0);
                    GMaxData[j]=GANN[i].OutData()*OutSocket.GetPV(j,1);
                
                }
                
                else
                
                {
                
                    GMinData[j]=GANN[i].OutData()*OutSocket.GetPV(j,0);
                    GMaxData[j]=0.0;
                
                }
                
                j++;
            
            }
            
            //Gather Error Statistics (ECT - 0:Uniform,1:Non-Uniform)
            GErr=GErrStat(NewData,GMinData,GMaxData,ECT);
            
            //Check Error Statistics
            if (GErr<=AccErr)
            
            {
            
                //Save This G.A.N.N To GKDB
                GSaveData(GANN);
                
                //Print Outputs GSocket
                printf("----- Outputs GSocket -----\n");
                
                for (i=0;i<Outputs;i++)
                
                {
                
                    printf("GPin:%i\n",i+1);
                    printf("Min Value:%.1f\n",GMinData[i]);
                    
                    if (GMaxData[i]==0.0)
                        printf("Maximum Value:N/A\n");
                    else
                        printf("Max Value:%.1f\n",GMaxData[i]);
                
                }
                
                printf("---------------------------\n\n");
                
                printf("Learning Successfully Completed!\n");
            
            }
            
            else
            
            {
            
                //Reset j
                j=0;
                
                //Error Correction
                for (i=0;i<Outputs;i++)
                
                {
                
                    for (j=0;j<GNNum;j++)
                    
                    {
                    
                        Tmp=OutSocket.GetPV(i,1);
                        
                        if (OutSocket.GetPV(i,1)!=0.0 AND\
                        (GANN[j].OutData()*Tmp)>OutSocket.GetPV(i,1))
                            GErrC(GANN,j,GErr,AUTO);
                        
                        Tmp=OutSocket.GetPV(i,0);
                        
                        if (OutSocket.GetPV(i,1)==0.0 AND\
                        (GANN[j].OutData()*Tmp)>OutSocket.GetPV(i,0))
                            GErrC(GANN,j,GErr,AUTO);
                        
                        if ((GANN[j].OutData()*Tmp)<OutSocket.GetPV(i,0))
                            GErrC(GANN,j,GErr,AUTO);
                    
                    }
                
                }
                
                goto ReRoute;
            
            }
        
        }
        
        //Unload G.A.N.N From Memory
        delete []GANN;
    
    }
    
    //Run
    else
    
    {
    
        //Reset Offset
        Offset=-1;
        
        //Run GRMC (User Interaction - Get User Values Number)
        n=GRMC();
        
        //Create A New G.A.N.N In Memory (G.A.N.N Matrix)
        GNeuron *GANN;
        GANN=new GNeuron[MAX_GN];
        
        //Start Simulation
        printf("Running...\n\n");
        
        //Escape Caption
        ReRun:;
        
        //Increase Offset
        if (Offset<n-1)
            Offset++;
        
        //Read GKDB And Load It To G.A.N.N
	GReadData(GANN,Offset);
	
	//Check User Values Number
	if (n>Inputs)
	
	{
	
	    printf("Error: User Values Number Are More Than Inputs!\n");
	    
	    exit(1);
	
	}
	
	//Check GMap Simulation Type So As To Set GNeurons Function Type
	if (GMSType==0)
	    GNFT=0;
	else
	    GNFT=2;
	
        //Reset Tracer
        Tracer=0;
        
        //Reset GNC
        GNC=-1;
        
        //Reset NLH
        NLH=0;
        
        //Reset NLE
        NLE=0;
        
        //Start Routing Through The Layers
        for (i=0;i<Layers;i++)
        
        {
        
            //Get GNeurons Of Current Layer
            k=GMap[i];
            
            //Check GMap Connections Type (0:Auto,1:Manual)
            if (GMCType==0)
            
            {
            
                //Enable All GNeurons
                for (j=NLE;j<(k+NLE);j++)
                
                {
                
                    //GNeurons Counter
                    GNC++;
                    
                    //Give Data To GNeurons Of The First Layer
                    if (i==0)
                    
                    {
                    
                        for (p=0;p<Inputs;p++)
                            GANN[GNC].InData(p-NLH,UserVal[Offset]);
                    
                    }
                    
                    else
                    
                    {
                    
                        //Give Data To GNeurons Of The Rest Layers
                        for (p=NLH;p<(NLH+NLE);p++)
                            GANN[GNC].InData(p-NLH,GANN[p].OutData());
                    
                    }
                    
                    //Run This GNeuron
                    GANN[GNC].Run(GNFT);
                
                }
                
                //Next Layer Head
                NLH+=NLE;
                
                //Next Layer End
                NLE=k;
            
            }
            
            else
            
            {
            
                //User Defined Connections
                
            
            }
        
        }
        
        //Get G.A.N.N Values
        for (i=NLH;i<(NLH+NLE);i++)
        
        {
        
            if (GANN[i].OutData()*GMinData[i-NLH]==GMinData[i-NLH]\
            OR GMaxData[i-NLH]!=0.0\
            AND GANN[i].OutData()*GMaxData[i-NLH]<=GMaxData[i-NLH])
            
            {
            
                if (RunTH<LearnTH)
                
                {
                
                    printf("\n* Output GPin%i *\n",Offset+1);
                    printf("Found Value With Little Acurracy!\n\n");
                
                }
                
                else
                
                {
                
                    printf("\n* Output GPin%i *\n",Offset+1);
                    printf("Value Found!\n\n");
                
                }
                
                if (Offset==n-1)
                    break;
                else
                    goto ReRun;
            
            }
            
            else if (Offset==n-1)
            
            {
            
                printf("Nothing Found...Finished!\n");
                
                break;
            
            }
            
            printf("Nothing Found...System Will Rerun!\n\n");
            
            goto ReRun;
        
        }
        
        //Unload G.A.N.N From Memory
        delete []GANN;
    
    }
    
    //Clean Up
    system("touch GIOD GMap");
    system("rm GIOD GMap");

}

/* ------------------------------------------------------------------------ */
