// -*- C++ -*-

/* 
 * Gnome Crystal
 * atom.h 
 *
 * Copyright (C) 2000-2002
 *
 * Developed by Jean Brfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCRYSTAL_ATOM_H
#define GCRYSTAL_ATOM_H

#include <list>
#include <gnome-xml/parser.h>
#include <gnome-xml/parserInternals.h>
#include <gnome-xml/xmlmemory.h>

class gcAtom  
{
public:
	gcAtom();
	virtual ~gcAtom();

public :
	gcAtom(int Z, double x, double y, double z, double r, float red, float green, float blue, float alpha);
	gcAtom(gcAtom& caAtom);
	gcAtom& operator=(gcAtom&);
	void Move(double x, double y, double z);

	void Draw();
	void SetPosition(double x, double y, double z);
	void GetPosition(double *x, double *y, double *z);
	void SetColor(float red, float green, float blue, float alpha);
	void GetColor(double *red, double *green, double *blue, double *alpha);
	void SetSize(double r);
	double GetSize();
	bool operator==(gcAtom&);
	void Cleave() {m_nCleave++;}
	double ScalProd(int h, int k, int l);
	void NetToCartesian(double a, double b, double c, double alpha, double beta, double gamma);
	double Distance(double x, double y, double z, bool bFixed);
	double x() {return m_dx;}
	double y() {return m_dy;}
	double z() {return m_dz;}
	double r() {return m_dr;}
	unsigned char Z() {return m_Z;}
	char* Symbol() {return m_Symbol;}
	bool IsCleaved() {return m_nCleave != 0;}
	xmlNodePtr Save(xmlDocPtr xml);
	bool Load(xmlNodePtr node, unsigned version);
	
private :
	float m_fBlue, m_fRed, m_fGreen, m_fAlpha;
	unsigned char m_Z;
	char m_Symbol[4];
	double m_dx, m_dy, m_dz, m_dr;
	int m_nCleave; //0 if not cleaved
};

typedef std::list<gcAtom*> gcAtomList;

#endif // GCRYSTAL_ATOM_H
