// -*- C++ -*-

/* 
 * Gnome Crystal
 * cleavage.h 
 *
 * Copyright (C) 2001-2002
 *
 * Developed by Jean Brfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCRYSTAL_CLEAVAGE_H
#define GCRYSTAL_CLEAVAGE_H

#include <gnome-xml/parser.h>
#include <list>

class gcCleavage
{
public:
	gcCleavage();
	gcCleavage(gcCleavage& ccClivage) ;
	virtual ~gcCleavage();

	int& Planes() {return m_nPlanes ;}
	int &h() {return m_nh ;}
	int &k() {return m_nk ;}
	int &l() {return m_nl ;}
	gcCleavage& operator=(gcCleavage&) ;
	bool operator==(gcCleavage&) ;
	xmlNodePtr Save(xmlDocPtr xml);
	bool Load(xmlNodePtr node);
	
private :
	int m_nh, m_nk, m_nl, m_nPlanes ;
};

typedef std::list<gcCleavage*> gcCleavageList;

#endif //GCRYSTAL_CLEAVAGE_H
