// -*- C++ -*-

/* 
 * Gnome Crystal
 * main.cc 
 *
 * Copyright (C) 2000-2002
 *
 * Developed by Jean Brfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "config.h"
#include <gnome.h>
#include <glade/glade.h>
#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <list>
#include "element.h"
#include "application.h"
#include "document.h"
#include "view.h"
#include "globals.h"

#ifdef USING_BONOBO
#  include <liboaf/liboaf.h>
#  include "gcrystal-bonobo.h"
#endif

extern GtkWidget *vbox1;

gcDocument* pDoc;
std::list<gcDocument*> Docs;
gcView* pView;
GtkWidget * mainwindow, *vbox1 ;
static GtkMenu *windowsmenu;

gcDocument* GetNewDocument()
{
	gcDocument* pDoc = new gcDocument();
	Docs.push_back(pDoc);
	return pDoc;
}

void RemoveDocument(gcDocument* pDoc)
{
	Docs.remove(pDoc);
	delete pDoc;
	if (IsEmbedded() && Docs.empty()) gtk_main_quit();
}


static void session_die(GnomeClient *client, gpointer data)
{
   gtk_main_quit();
}

static gint session_save(GnomeClient *client, gint phase, GnomeSaveStyle save_style, gint is_shutdown, GnomeInteractStyle interact_style, gint is_fast, gpointer client_data)
{
	gchar **argv;
	gint argc;
	if (IsEmbedded())
	{
		argv = (gchar**) g_malloc0(sizeof(gchar*) * 3);
		argc = 2;
		argv[0] = (gchar*) client_data;
		argv[1] = "--bonobo-server";
		gnome_client_set_clone_command(client, argc, argv);
		gnome_client_set_restart_command(client, argc, argv);
	}
}

 void loaddata()
{
	GladeXML *elts ;
	elts = glade_xml_new(PREFIX"/share/gcrystal/glade/mendeleiev.glade", "mendeleiev");
	if (!elts) return;
	char buf[16];
	GtkButton* btn;
	GtkLabel* label;
	gcElement* elt;
	gchar* tmp;
	for (int i = 0; i < 118;)
	{
		i++;
		snprintf(buf, sizeof(buf), "elt%d", i);
		btn = (GtkButton*)(glade_xml_get_widget(elts, buf));
		if (btn)
		{
			label = GTK_LABEL(GTK_BIN(btn)->child);
			gtk_label_get(label, &tmp);
			elt = new gcElement((unsigned char)i, tmp);
			Elt[i] = elt;
			EltsMap[tmp] = i;
		}
	}
	GtkWidget* widget = glade_xml_get_widget(elts, "mendeleiev");
	gtk_widget_destroy(widget);
}

//static char* opt_filename = NULL;
static bool bonobo_server_flag = false;
struct poptOption options[] =
{
#ifdef USING_BONOBO
    {"bonobo-server", '\0', POPT_ARG_NONE, &bonobo_server_flag, 0, N_("Allow Gnome Crystal to act as a Bonobo server."), NULL},
#endif
//    {"file", 'f', POPT_ARG_STRING, &opt_filename, 0, N_("Load data from FILENAME"), N_("FILENAME")},
	{NULL, '\0', 0, NULL, 0, NULL, NULL}
};

bool IsEmbedded() {return bonobo_server_flag;}

main(int argc, char *argv[])
{
	poptContext pctx;

	bindtextdomain(PACKAGE, PREFIX"/share/locale");
	textdomain(PACKAGE);

#ifdef USING_BONOBO
	gnomelib_register_popt_table (oaf_popt_options, "oaf");

	BonoboGenericFactory *factory;
	CORBA_Environment ev;
	CORBA_ORB orb;
#endif

	gnome_init_with_popt_table("gcrystal", VERSION, argc, argv, options, 0, &pctx);
#ifdef USING_BONOBO
	if (bonobo_server_flag)
	{
		CORBA_exception_init(&ev);
	}
#endif
	GnomeClient* client = gnome_master_client();
	gtk_signal_connect(GTK_OBJECT(client), "save_yourself", GTK_SIGNAL_FUNC(session_save), argv[0]);
	gtk_signal_connect(GTK_OBJECT(client), "die", GTK_SIGNAL_FUNC(session_die), NULL);
	
//Configuration loading
	TabPos = gnome_config_get_int("gcrystal/General/tab_pos=0");
	gnome_config_push_prefix("gcrystal/Printing/");
	PrintResolution = gnome_config_get_int("resolution=300");
	PrintWidth= gnome_config_get_int("width=300");
	PrintHeight = gnome_config_get_int("height=300");
	gnome_config_pop_prefix();
	gnome_config_push_prefix("gcrystal/Views/");
	FoV = gnome_config_get_int("fov=10");
	Psi = gnome_config_get_float("psi=70.0");
	Theta = gnome_config_get_float("theta=10.0");
	Phi = gnome_config_get_float("phi=-90.0");
	Red = gnome_config_get_float("red=1.0");
	Green = gnome_config_get_float("green=1.0");
	Blue = gnome_config_get_float("blue=1.0");
	gnome_config_pop_prefix();

	glade_gnome_init() ;
	loaddata();
	if (bonobo_server_flag)
	{
#ifdef USING_BONOBO
 	       orb = oaf_init(argc, argv);
		if (!bonobo_init(orb, CORBA_OBJECT_NIL, CORBA_OBJECT_NIL))
			g_error(_("Could not initialize Bonobo"));
		factory = bonobo_generic_factory_new("OAFIID:gnome_crystal_factory:bb346fef-4b56-4b33-982a-bfe13438e3a7", embeddable_factory, NULL);
		bonobo_running_context_auto_exit_unref(BONOBO_OBJECT(factory));
		bonobo_main();
		CORBA_exception_free(&ev);
#endif
	}
	else
	{
		gcApplication* gcApp = new gcApplication();
		Apps.push_back(gcApp);
		gcApp->OnFileNew();
		gcApp->SetOpening();
	
		const char ** args = poptGetArgs(pctx);
		if (args)
		{
			char* directory = getcwd(NULL, 0);
			bool bres = false;
			for (int i = 0; args[i] != NULL; i++)
			{	
				struct stat buf;
				chdir(directory);
				gint err = stat(args[i], &buf);
				gchar* filename;
				if (args[i][0] == '/')
				{
					if (err) filename = g_strdup_printf("%s%s", args[i], ".gcrystal");
					else filename = g_strdup(args[i]);
				}
				else
				{
					if (err) filename = g_strdup_printf("%s%c%s%s", directory, '/', args[i], ".gcrystal");
					else filename = g_strdup_printf("%s%c%s", directory, '/', args[i]);
				}
				if (bres)
				{
					gcApp->OnFileNew();
					gcApp->SetOpening();
				}
				bres = gcApp->LoadFile(filename);
				g_free(filename);
			}
			free(directory);
		}

//		if (xml) glade_xml_signal_autoconnect (xml);
	
		gtk_main();
	
	}
//Destruction of data
	for (int i = 1; i < 119; i++)
		if (Elt[i]) delete Elt[i];
	Elt.clear();
	EltsMap.clear();
		
	return 0 ;
}
