// -*- C++ -*-

/* 
 * Gnome Crystal
 * print.cc 
 *
 * Copyright (C) 2001-2002
 *
 * Developed by Jean Brfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "print.h"
#include <glade/glade.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <gtkgl/gtkglarea.h>

guint PrintWidth = 300, PrintHeight = 300, PrintResolution = 300;

static int attrlist[] = {
    GDK_GL_RGBA,
    GDK_GL_BUFFER_SIZE,1,
    GDK_GL_RED_SIZE,1,
    GDK_GL_GREEN_SIZE,1,
    GDK_GL_BLUE_SIZE,1,
    GDK_GL_DEPTH_SIZE,1,
    GDK_GL_DOUBLEBUFFER,
    GDK_GL_NONE
  };
 
gint on_init(GtkWidget *widget, gcPrintWindow *data) 
{
	data->OnInit();
	return TRUE;
}

gint on_reshape(GtkWidget *widget, GdkEventConfigure *event, gcPrintWindow *data) 
{
	data->OnSize();
	return TRUE;
}

gint on_draw(GtkWidget *widget, GdkEventExpose *event, gcPrintWindow *data) 
{
	/* Draw only last expose. */
	if (event->count > 0) return TRUE;
	data->OnDraw();
	return TRUE;
}

 gcPrintWindow::gcPrintWindow()
{
	m_bReady = false;
	
	m_box = GTK_WINDOW(gtk_window_new(GTK_WINDOW_POPUP));
	gtk_window_set_default_size(m_box, PrintWidth, PrintHeight);
	m_widget = GTK_WIDGET(gtk_gl_area_new(attrlist));
// Events for widget must be set before X Window is created
	gtk_widget_set_events(m_widget,
			GDK_EXPOSURE_MASK);

// Connect signal handlers
// Do initialization when widget has been realized.
	gtk_signal_connect(GTK_OBJECT(m_widget), "realize",
		     GTK_SIGNAL_FUNC(on_init), this);
// When window is resized viewport needs to be resized also.
	gtk_signal_connect(GTK_OBJECT(m_widget), "configure_event",
		     GTK_SIGNAL_FUNC(on_reshape), this);
// Redraw image when exposed. 
	gtk_signal_connect(GTK_OBJECT(m_widget), "expose_event",
		     GTK_SIGNAL_FUNC(on_draw), this);
/* put glarea into window and show it all */
	gtk_container_add(GTK_CONTAINER(m_box), m_widget);
	gtk_widget_show(m_widget);
	gtk_widget_show_all(GTK_WIDGET(m_box));
}

gcPrintWindow::~gcPrintWindow()
{
	gtk_widget_destroy(GTK_WIDGET(m_box));
}

void gcPrintWindow::OnInit()
{
	if (gtk_gl_area_make_current(GTK_GL_AREA(m_widget)))
	{
	    	glEnable(GL_LIGHTING);
		glEnable(GL_LIGHT0);
		glEnable(GL_DEPTH_TEST);
		glEnable(GL_CULL_FACE);
		glEnable(GL_COLOR_MATERIAL);
		float shiny = 25.0, spec[4] = {1.0, 1.0, 1.0, 1.0};
		glMaterialfv(GL_FRONT_AND_BACK, GL_SHININESS, &shiny);
		glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, spec);
   }
}

void gcPrintWindow::OnSize()
{
	if (gtk_gl_area_make_current(GTK_GL_AREA(m_widget)))
	{
		glViewport(0, 0, PrintWidth - 1, PrintHeight - 1);
	}
}

void gcPrintWindow::OnDraw()
{
	m_bReady = true;
}
