// -*- C++ -*-

/* 
 * Gnome Crystal
 * document.h 
 *
 * Copyright (C) 2000-2002
 *
 * Developed by Jean Brfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCRYSTAL_DOCUMENT_H
#define GCRYSTAL_DOCUMENT_H

#include <gnome.h>
#include <gnome-xml/parser.h>
#include "atom.h"
#include "bond.h"
#include "cleavage.h"
#ifdef USING_BONOBO
#  include <bonobo.h>
#endif

enum gcLattices {cubic=0,
				 body_centered_cubic,
				 face_centered_cubic,
				 hexagonal,
				 tetragonal,
				 body_centered_tetragonal,
				 orthorhombic,
				 base_centered_orthorhombic,
				 body_centered_orthorhombic,
				 face_centered_orthorhombic,
				 rhombohedral,
				 monoclinic,
				 base_centered_monoclinic,
				 triclinic};

class gcView;
class gcDialog;

class gcDocument
{
	//Constructor and destructor
public:
	gcDocument();
/*	gcDocument(bool create_view);*/
	~gcDocument();
	
	//Interface
public:
	void Define(unsigned nPage = 0);
	gcAtomList* GetAtomList() {return &AtomDef;}
	gcBondList* GetBondList() {return &BondDef;}
	gcCleavageList* GetCleavageList() {return &Cleavages;}
	void Update();
	void UpdateAllViews();
	void Draw();
	void SetWidget(GtkWidget* widget){m_widget = widget;}
	gdouble GetMaxDist() {return m_dDist;}
	void GetSize(gdouble* xmin, gdouble* xmax, gdouble* ymin, gdouble* ymax, gdouble* zmin, gdouble* zmax);
	void SetSize(gdouble xmin, gdouble xmax, gdouble ymin, gdouble ymax, gdouble zmin, gdouble zmax);
	void GetCell(gcLattices *lattice, gdouble *a, gdouble *b, gdouble *c, gdouble *alpha, gdouble *beta, gdouble *gamma);
	void SetCell(gcLattices lattice, gdouble a, gdouble b, gdouble c, gdouble alpha, gdouble beta, gdouble gamma);
	const gchar* GetFileName() {return m_filename;}
	void SetFileName(const gchar* filename);
	gchar* GetTitle() {return m_title;}
	void SetTitle(const gchar* title);
	void Save();
	bool Load(const gchar* filename);
	void ParseXMLTree(xmlDocPtr xml);
	xmlDocPtr BuildXMLTree();
	void OnNewDocument();
	void OnExportVRML(const gchar* FileName, gcView* pView);
	gcView* GetView();
	gcView* GetNewView();
	bool IsEmpty() {return m_bEmpty;}
	bool IsDirty() {return m_bDirty;}
	void SetDirty();
	void AddView(gcView* pView);
	bool RemoveView(gcView* pView);
	bool VerifySaved();
#ifdef USING_BONOBO
	void SetBonoboStream(BonoboPersistStream* ps) {m_ps = ps;}
#endif
	void NotifyDialog(gcDialog* dialog);
	void RemoveDialog(gcDialog* dialog);
	bool GetFixedSize() {return m_bFixedSize;}
	void SetFixedSize(bool FixedSize) {m_bFixedSize = FixedSize;}
	
private:
	void Duplicate(gcAtom& Atom);
	void Duplicate(gcBond& Bond);
	void Init();
	void Reinit();
	void Error(int num);
	
	//Implementation
private:
	gchar *m_filename, *m_title;
	gcLattices m_lattice;
	gdouble m_a, m_b, m_c, m_alpha, m_beta, m_gamma;
	gdouble m_xmin, m_ymin, m_zmin, m_xmax, m_ymax, m_zmax;
	gdouble m_dDist; //maximum distance between an object and the center
	gboolean m_bFixedSize;  //true if cleavages must not change positions in the view
							//if false, view is optimized
	bool m_bEmpty, m_bDirty, m_bClosing;
	gcAtomList AtomDef, Atoms;
	gcBondList BondDef, Bonds;
	gcCleavageList Cleavages;
	GtkWidget* m_widget;
	std::list <gcView *> m_Views;
	std::list <gcDialog *> m_Dialogs;
#ifdef USING_BONOBO
	BonoboPersistStream* m_ps;
#endif
};

#endif //GCRYSTAL_DOCUMENT_H
