// -*- C++ -*-

/* 
 * Gnome Crystal
 * view-settings.cc
 *
 * Copyright (C) 2001-2002
 *
 * Developed by Jean Brfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "view-settings.h"
#include "document.h"
#include <gnome.h>
#include <glade/glade.h>

gcViewSettingsDlg::gcViewSettingsDlg(gcView* pView): gcDialog(PREFIX"/share/gcrystal/glade/view-settings.glade", "view_settings", "view.html")
{
	m_pView = pView;
	m_pView->NotifyDialog(this);
	FoV = GTK_SPIN_BUTTON(glade_xml_get_widget(xml, "fov"));
	Psi = (GtkEntry*) glade_xml_get_widget(xml, "psi");
	Theta = (GtkEntry*) glade_xml_get_widget(xml, "theta");
	Phi = (GtkEntry*) glade_xml_get_widget(xml, "phi");
	Background = (GnomeColorPicker*) glade_xml_get_widget(xml, "color");
	double x0, x1, x2, x3;
	m_pView->GetBackgroundColor(&x0, &x1, &x2, &x3);
	gnome_color_picker_set_d(Background, x0, x1, x2, x3);
	m_pView->GetRotation(&x0, &x1, &x2);
	char m_buf[32];
	snprintf(m_buf, sizeof(m_buf) - 1, "%g", x0);
	gtk_entry_set_text(Psi, m_buf);
	snprintf(m_buf, sizeof(m_buf) - 1, "%g", x1);
	gtk_entry_set_text(Theta, m_buf);
	snprintf(m_buf, sizeof(m_buf) - 1, "%g", x2);
	gtk_entry_set_text(Phi, m_buf);
	gtk_spin_button_set_value(FoV, (int)(m_pView->GetFoV()));
	
	gtk_widget_show_all(GTK_WIDGET(dialog));
}

gcViewSettingsDlg::~gcViewSettingsDlg()
{
	m_pView->RemoveDialog(this);
}

bool gcViewSettingsDlg::Apply()
{
	double x0, x1, x2, x3;
	if (!GetNumber(Psi, &x0, gccMinEqMax, -180, 180)) return false;
	if (!GetNumber(Theta, &x1, gccMinEqMaxEq, 0, 180)) return false;
	if (!GetNumber(Phi, &x2, gccMinEqMax, -180, 180)) return false;
	m_pView->SetRotation(x0, x1, x2);
	m_pView->GetFoV() = gtk_spin_button_get_value_as_float(FoV);
	gnome_color_picker_get_d(Background, &x0, &x1, &x2, &x3);
	m_pView->SetBackgroundColor(x0, x1, x2, x3);
	m_pView->Update();
	m_pView->GetDocument()->SetDirty();
	return true;	
}
