// -*- C++ -*-

/* 
 * Gnome Crystal
 * view.h 
 *
 * Copyright (C) 2000-2002
 *
 * Developed by Jean Brfort <jean.brefort@ac-dijon.fr>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GCRYSTAL_VIEW_H
#define GCRYSTAL_VIEW_H

#include <gnome.h>
#include <gnome-xml/parser.h>
#include <libgnomeprint/gnome-print.h>
#include <list>
#include "config.h"
#include "matrix.h"
#include "dialog.h"

class gcDocument;
class gcApplication;

class gcView
{
public:
	gcView(gcDocument *pDoc);
	gcView(gcView *pView);
	~gcView();
	
	void SetDocument(gcDocument *pDoc);
	gcDocument* GetDocument() {return m_pDoc;}
	void Init(GtkWidget *widget);
	void Reshape(GtkWidget *widget);
	void Draw(GtkWidget *widget);
	void Update();
	void Update(GtkWidget *widget);
	bool OnPressed(GtkWidget *widget, GdkEventButton *event);
	void OnMotion(GtkWidget *widget, GdkEventMotion *event);
	void OnDestroyed(GtkWidget *widget);
	void SetBackgroundColor(float red, float green, float blue, float alpha);
	void GetBackgroundColor(double *red, double *green, double *blue, double *alpha);
	gdouble& GetFoV() {return m_fAngle;}
	gdouble& GetPos() {return m_fRadius;}
	void GetRotation(double *psi, double *theta, double *phi);
	void SetRotation(double psi, double theta, double phi);
	xmlNodePtr Save(xmlDocPtr xml);
	bool Load(xmlNodePtr node);
#ifdef HAVE_PNG
	void ExportPNG(const gchar* filename);
#endif
#ifdef HAVE_LIBJPEG
	void ExportJPG(const gchar* filename);
#endif
	void Print(GnomePrintContext *pc, gdouble width, gdouble height);
	void PrintEmbedded(GnomePrintContext *pc, gdouble width, gdouble height);
	GtkWidget* CreateNewWidget();
	void SetLabel(GtkLabel* Label) {m_pLabel = Label;}
	void SetMenu(GtkMenuItem* item);
	GtkLabel* GetLabel() {return m_pLabel;}
	GtkLabel* GetMenuLabel() {return m_pMenuLabel;}
	void NotifyDialog(gcDialog* dialog);
	void RemoveDialog(gcDialog* dialog);
	void Lock() {m_bLocked = true;}
	void Unlock() {m_bLocked = false;}
	bool IsLocked() {return m_bLocked;}
	gcApplication* GetApp() {return m_pApp;}
	void SetApp(gcApplication* pApp) {m_pApp = pApp;}
	
private:
	void Rotate(gdouble x, gdouble y);

	gcDocument* m_pDoc;
	gcApplication* m_pApp;
	gdouble m_fAngle, m_fRadius;
	GtkWidget* m_pWidget;
	GtkLabel *m_pLabel, *m_pMenuLabel;
	GtkMenuItem* m_pMenu;
	std::list<GtkWidget*> m_Widgets;
	bool m_bInit, m_bLocked;
	gdouble m_lastx, m_lasty;
	gdouble m_psi, m_theta, m_phi;
	gdouble m_height, m_width, m_near, m_far;
	gcMatrix m_Euler;
	unsigned m_nGLList;
	//background color
	float m_fBlue, m_fRed, m_fGreen, m_fAlpha;
	std::list <gcDialog *> m_Dialogs;
};

#endif //GCRYSTAL_VIEW_H
