<?
// GiftWeb: PHP/PostgreSQL online Gift Registry System 
// Matthew T. Jachimstal
// Copyright (C) 2000-2003  Matthew T. Jachimstal
//
// email: matthew@jachimstal.com
//
// Snail mail: Matthew Jachimstal
//             460 Washington Blvd.
//             Hoffman Estates, IL 60194
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//

require "./main.inc";
// passed $s=session#, $u=target user id
require "./util.php";

$s = $_GET["s"];
$u = $_GET["u"];
$uid = validatesession($s);

$conn = ADONewConnection($dbtype);
$conn->Connect($dbhost, $dbuser, $dbpass, $dbname);


cleanup_items();

$step = 0;

if ( isset($_POST["submit1"]) )		// adding items not on list
{
	$step = 1;
}

if ( isset($_POST["purch"]) )		// marking items purchased
{
	$step = 2;
}

if ( isset($_POST["unpurch"]) )		// marking items unpurchased
{
	$step = 3;
}

if ($step == 1)		// add purchased items not on the wishlist
{
	$sql = "SELECT count(*) AS count, max(item_num) FROM items";
	$result = $conn->Execute($sql);
	$rows = $result->fields["count"];
	$max_item = $result->fields["max"];

	if ($rows == 0)
	{
		$max_item = 1;
	}
	else
	{
		$max_item++;
	}

	$rows = 0;		// set for error checking later

	for ($i=1; $i <= 10; $i++)
	{
		$desc = "idesc$i";
		$item = chop ($_POST[$desc]);

		if ( $item != "" )
		{
			$sql = "INSERT INTO items (uid,description,url, ";
			$sql .= "purchased, added, item_num)";
			$sql .= "VALUES ('$u', '$item', '', ";
			$sql .= "'$uid', 't', '$max_item')";
			$result = $conn->Execute($sql);
			$rows += $result->RecordCount();
			$max_item++;
		}
	}

	if ($rows != 0)
	{
		$res1 = "<h2>An error occured adding an item. Please try again.<br>";
		$res1 .= "If the problem persists, please contact the site ";
		$res1 .= "administrator.</h2>\n";
	}
	else
	{
		$res1 = "<h2>Item(s) added.</h2>\n";
	}


	$step = 0;
}

// steps 2 and 3 do error checking as follows:
// the itemlist[] array potentially contains purchased and unpurchased
// items. Each step (purch/unpurch) filters the UPDATE or DELETE
// SQL statement by the current purchased value. 
//
// If it's marking items as purchased by the current user, it only UPDATEs 
// those items whose purchased field is -1. This prevents them from trying
// to remark items they've already purchased, although that would have
// no net effect. It's just the easiest way to error check this condition.
// It also prevents them from somehow hijacking items that were already
// marked purchased by a third user. This could possibly happen from someone
// writing their own page whose form action POSTs to this php page. 
// This is also a concurrency issue. If two people load the page and one 
// submits a purchase and the second doesn't refresh before submitting 
// the same purchase. The second user will not be able to update, because
// it will only update WHERE purchased=-1. They will reload the page after
// submission, and see that the item's already been marked by someone
// else. Potential cause for UTS and ID-10-T errors.
//
// When unpurchasing, the current value of purchased must be the user's
// uid. If it is -1, they're trying to unpurchased an item that hasn't been
// marked purchased. If it's another uid, they somehow got an invalid
// form that presented them with items they hadn't purchased. This is the
// the last error check to prevent that. Again, that could conceivably
// be caused by a malicious form POSTing to this script.

if ( $step == 2 )	// marking items as purchased
{
	$itemlist = $_POST["itemlist"];
	$cnt = count ($itemlist);

	$marked = 0;

	for ( $i=0; $i<$cnt; $i++ )
	{
		// update the purchased field to this user's $uid only if
		// item is not purchased 

		$sql = "UPDATE items SET purchased='$uid'";
		$sql .= " WHERE item_num='$itemlist[$i]' and purchased='-1'";

		$result = $conn->Execute($sql);

		/*
		 * FIX
		 * check for error conditions (are any possible?)
		 * keep count of how many are marked
                 *  can use if($result) and $conn->ErrorMessage(), but to
                 *  what effect here
		 */
	}

	$step = 0;
}

if ( $step == 3 )	// marking items as unpurchased
{
	$itemlist = $_POST["itemlist"];

	$cnt = count($itemlist);
	$unmarked = 0;
	$removed = 0;

	for ( $i=0; $i<$cnt; $i++ )
	{
		// unmarking has two conditions: item added by requestor
		// and item added by purchaser. 
		// In both cases we set the purchaser to -1.
		// Then, we look for any rows with purchaser=-1 and added=t
		// Those are unpurchased items that were added by the purchaser
		// and need to be deleted.
		// Also, we need to make that purchaser=uid, so we don't hijack
		// anyone else's purchases.

		$sql = "UPDATE items SET purchased='-1'";
		$sql .= " WHERE item_num='$itemlist[$i]' and purchased='$uid'";

		$result = $conn->Execute($sql);

		/*
		 * FIX
		 * check for error condition (are any possible?)
		 * count how many are unmarked
		 */
	}

	$sql = "DELETE FROM items WHERE purchased='-1' and added='t'";

	$result = $conn->Execute($sql);

	/*
	 * FIX
	 * count how many were deleted
	 */

	$step = 0;
}



if ($step == 0)		// display list/purch/unpurch/add to list
{
	$sql = "SELECT last_name, first_name FROM users WHERE uid='$u'";
	$result = $conn->Execute($sql);
	$name = chop($result->fields["last_name"]);
	$name .= ", " . chop($result->fields["first_name"]);
	$fname = chop($result->fields["first_name"]);

	startpage("$fname's Wish list", 0);

	?>
	<script language="JavaScript" type="text/javascript">
	<!-- 
	function CheckAll() 
	{
		for (var i = 0; i < document.itemList.elements.length; i++) 
		{
			if(document.itemList.elements[i].type == 'checkbox')
			{
				document.itemList.elements[i].checked = true;
			}
		}
	}

	function ViewNote(session, inum)
	{
		window.open("viewnote.php?s="+session+"&i="+inum, 
				"ViewNotes", "width=600, height=300");
	}

	//-->
	</script>
	<?

	if ( isset($res1))
	{
		echo $res1;
	}

	echo "<h2>$fname's wish list:</h2>";
	?>

	<form name="itemList" method="post" 
		action="viewlist.php?s=<?echo $s?>&u=<?echo $u?>">
	<table cellspacing=0 cellpadding=1 border=1>
	<?

	// first, all the items purchased by the current user

	$sql = "SELECT * FROM items WHERE uid='$u' ";
	$sql .= "and purchased='$uid' ORDER BY description";
	$result = $conn->Execute($sql);
	$rows = $result->RecordCount();

	echo "<tr><th width=45%>Description</th>";
	echo "<th width=35%>Store/Web Address</th>";
	echo "<th width=5%>Avg Price</th>";
	echo "<th width=10%>Notes</th>";
	echo "<th width=5%>Select</th></tr>\n";

	$ipurch_hdr = 0;
	$opurch_hdr = 0;
	$upurch_hdr = 0;

	$result->MoveFirst();
	$i=0;
        while (!$result->EOF) 
	{
		if ($ipurch_hdr == 0)
		{
			echo "<tr><td colspan=4 align=center>";
			echo "Items purchased by current user</td></tr>";
			$ipurch_hdr = 1;
		}

		$desc = $result->fields["description"];
		$url = chop($result->fields["url"]);
		$image = chop($result->fields["image"]);
		$price = chop($result->fields["price"]);
		$purchased = $result->fields["purchased"];
		$added = $result->fields["added"];
		$item_num = $result->fields["item_num"];

		if ($pad_images && !$image)
		{
			$image = "./60-60-blank.gif";
		}

		if ($price) 
		  {
		    $price = "\$$price";
		  }

		if ( substr($url, 0, 7) == "http://" )
		{
			$www = substr($url, 7);
			$parts = explode("/", $url);
			$url = "<a href=\"$url\" target=\"_new\">$parts[2]</a>";
		}

		if ($image)
		{
			echo "<tr><td><img src=\"$image\" width=60 height=60 align=middle>&nbsp;$desc</td>";
		}
		else
		{
			echo "<tr><td>$desc</td>";
		}

		echo "<td>$url&nbsp;</td>";
		echo "<td align=right>$price</td>";

		$sql = "SELECT * FROM notes WHERE item_num='$item_num'";
		$result2 = $conn->Execute($sql);

		if (!$result2->EOF)

		{
			$note_text = "<a href=\"javascript:ViewNote($s, $item_num)\">";
			$note_text .= "View Notes</a>";
		}
		else
		{
			$note_text = "&nbsp;";
		}

		if ( $added == 't' )
		{
			$note_text = "Item Added<br>by current user";
		}

		$sel_text = "I Purchased<br>";

		$sel_text .= "<input type=checkbox name=\"itemlist[]\" ";
		$sel_text .= "value=\"$item_num\">";

		?>

			<td align=center>
			<?echo $note_text?>
			<td align=center><?echo $sel_text?></td>
			</tr>
			<?
	$result->MoveNext();
	$i++;
	}

	// Now, all items purchased by other users, or by nobody. Done by selecting
	// items not purchased by current user, and ordered by the purchased field
	// in DESCending order. That way purchased items show up first, and
	// unpurchased ones (purchased=-1) show up last with unpurchased
	// items in Alphabetical order.

	$sql = "SELECT * FROM items WHERE uid='$u' ";
	$sql .= "and purchased !='$uid' ORDER BY purchased desc, description";
	$result = $conn->Execute($sql);
	
	$result->MoveFirst();
	$i=0;
        while (!$result->EOF) 
	{
		$desc = $result->fields["description"];
		$url = chop($result->fields["url"]);
		$image = chop($result->fields["image"]);
		$price = chop($result->fields["price"]);
		$purchased = $result->fields["purchased"];
		$added = $result->fields["added"];
		$item_num = $result->fields["item_num"];

		if ($pad_images && !$image)
		{
			$image = "./60-60-blank.gif";
		}

		if ($opurch_hdr === 0)
		{
			echo "<tr><td colspan=4 align=center>";
			echo "Items purchased by other users</td></tr>";
			$opurch_hdr = 1;
		}

		if ($purchased == -1 && $upurch_hdr === 0)
		{
			echo "<tr><td colspan=4 align=center>";
			echo "Items not purchased by any users</td></tr>";
			$upurch_hdr = 1;
		}

		if ($price) 
		  {
		    $price = "\$$price";
		  }

		if ( substr($url, 0, 7) == "http://" )
		{
			$www = substr($url, 7);
			$parts = explode("/", $url);
			$url = "<a href=\"$url\" target=\"_new\">$parts[2]</a>";
		}

		if ($image)
		{
			echo "<tr><td><img src=\"$image\" width=60 height=60 align=middle>&nbsp;$desc</td>";
		}
		else
		{
			echo "<tr><td>$desc</td>";
		}
		echo "<td>$url&nbsp;</td>";
		echo "<td align=right>$price</td>";

		$sql = "SELECT * FROM notes WHERE item_num='$item_num'";
		$result2 = $conn->Execute($sql);

		if (!$result2->EOF)
		{
			$note_text = "<a href=\"javascript:ViewNote($s, $item_num)\">";
			$note_text .= "View Notes</a>";
		}
		else
		{
			$note_text = "&nbsp;";
		}

		if ( $added == 't' )
		{
			$note_text = "Item Added<br>by another user";
		}

		$sel_text = "&nbsp;";

		if ($purchased == -1)
		{
			$sel_text = "<input type=checkbox name=\"itemlist[]\" ";
			$sel_text .= "value=\"$item_num\">";
		}
		else
		{
			$sel_text = "Purchased by another user";
		}

		?>

			<td align=center>
			<?echo $note_text?>
			<td align=center><?echo $sel_text?></td>
			</tr>
			<?
	$result->MoveNext();
	$i++;
	}
	?>
		</table>
		<br>

		<input type=submit name="purch" value="Purchase Selected Items">
		<input type=submit name="unpurch" value="Un-purchase Selected Items">
		<input type=reset name=reset value="Unselect all items">
		<input type="button" value="Select all items"
			onClick=CheckAll()>
		</form>

		<?

		// add a section where users can add items they've purchased
		// that aren't on the list

		?>
		<p>
		<hr width=70% size=5
		<?
		echo "<h4><ul><li>If you've purchased items not on $fname's list, ";
   		echo "please add them below.</li>\n";
	   	echo "<li>They will be displayed to other users to see that ";
	   	echo "they've been purchased.</li>\n";
	   	echo "<li>$fname will not see these items and will not be ";
	   	echo "able to delete them.</li></ul></h4>";
		?>
		<form method="post" action="viewlist.php?s=<?echo $s?>&u=<?echo $u?>">
		<table cellspacing=0 cellpadding=2>
		<tr><td></td><td align=center>Description</td></tr>
		<tr><td>1</td><td><input type="text" name="idesc1" size=50></td></tr>
		<tr><td>2</td><td><input type="text" name="idesc2" size=50></td></tr>
		<tr><td>3</td><td><input type="text" name="idesc3" size=50></td></tr>
		<tr><td>4</td><td><input type="text" name="idesc4" size=50></td></tr>
		<tr><td>5</td><td><input type="text" name="idesc5" size=50></td></tr>
		<tr><td></td><td align=center><input type="submit" name="submit1" 
		value="Add item(s)">
		<input type="reset" name="reset" value="Clear"></tr></tr>
		</table>
		</form>
		<?

}

endpage(0);
?>
