/* A Bison parser, made by GNU Bison 2.7.  */

/* Bison implementation for Yacc-like parsers in C
   
      Copyright (C) 1984, 1989-1990, 2000-2012 Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.7"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* Copy the first part of user declarations.  */
/* Line 371 of yacc.c  */
#line 21 "creature.y"

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <netinet/in.h>

#include "st.h"
#include "opts.h"
#include "creature.h"
#include "mcheck.h"




/*
 * defined_t is used to indicate whether all fields have been defined
 */

typedef struct {
    unsigned	move: 1,
		special: 1,
		treasure: 1,
		spell: 1,
		breath: 1,
		resist: 1,
		defense: 1,
		mexp: 1,
		sleep: 1,
		aaf: 1,
		ac: 1,
		speed: 1,
		cchar: 1,
		hd: 1,
		damage: 1,
		level: 1;
} defined_t;



/*
 * template_t contains creature definition & flags
 */

typedef struct 
{
  int idx;
  creature_type	val;
  defined_t def;
} template_t;




/*
 * symInit_t is used to initialize symbol tables with integer values
 */

typedef struct 
{
  char *name;
  int32u val;
} symInit_t;



static symInit_t 
defenseInit[] = 
{
    { "dragon", 0 },
    { "animal", 1 },
    { "evil", 2 },
    { "undead", 3 },
    { "frost", 4 },
    { "fire", 5 },
    { "poison", 6 },
    { "acid", 7 },
    { "light", 8 },
    { "stone", 9 },
    { "bit_9", 10 },
    { "bit_10", 11 },
    { "no_sleep", 12 },
    { "infra", 13 },
    { "max_hp", 14 },
    { "bit_15", 15 },
    { NULL, 0 }
};

static symInit_t 
moveInit[] = 
{
    { "attack_only", 0 },
    { "move_normal", 1 },
    { "magic_only", 2 },
    { "random_20", 3 },
    { "random_40", 4 },
    { "random_75", 5 },
    { NULL, 0 }
};

static symInit_t 
specialInit[] = 
{
    { "invisible", 16 },
    { "open_door", 17 },
    { "phase", 18 },
    { "eats_other", 19 },
    { "picks_up", 20 },
    { "multiply", 21 },
    { "win_creature", 31 },
    { NULL, 0 }
};

static symInit_t 
treasureInit[] = 
{
    { "carry_small_obj", 23 },
    { "carry_obj", 24 },
    { "carry_gold", 25 },
    { "has_random_60", 26 },
    { "has_random_90", 27 },
    { "has_1d2_obj", 28 },
    { "has_2d2_obj", 29 },
    { "has_4d2_obj", 30 },
    { NULL, 0 }
};

static symInit_t 
spellInit[] = 
{
    { "tel_short", 4 },
    { "tel_long", 5 },
    { "tel_to", 6 },
    { "lght_wnd", 7 },
    { "ser_wnd", 8 },
    { "hold_per", 9 },
    { "blind", 10 },
    { "confuse", 11 },
    { "fear", 12 },
    { "summon_mon", 13 },
    { "summon_und", 14 },
    { "slow_per", 15 },
    { "drain_mana", 16 },
    { "bit_17", 17 },
    { "bit_18", 18 },
    { NULL, 0 }
};

static symInit_t 
breathInit[] = 
{
    { "light", 19 },
    { "gas", 20 },
    { "acid", 21 },
    { "frost", 22 },
    { "fire", 23 },
    { NULL, 0 }
};

static symInit_t 
attackTypeInit[] = 
{
    { "normal_damage", 1 },
    { "lose_str", 2 },
    { "confusion", 3 },
    { "cause_fear", 4 },
    { "fire_damage", 5 },
    { "acid_damage", 6 },
    { "cold_damage", 7 },
    { "lightning_damage", 8 },
    { "corrosion", 9 },
    { "cause_blindness", 10 },
    { "cause_paralysis", 11 },
    { "steal_money", 12 },
    { "steal_obj", 13 },
    { "poison", 14 },
    { "lose_dex", 15 },
    { "lose_con", 16 },
    { "lose_int", 17 },
    { "lose_wis", 18 },
    { "lose_exp", 19 },
    { "aggravation", 20 },
    { "disenchant", 21 },
    { "eat_food", 22 },
    { "eat_light", 23 },
    { "eat_charges", 24 },
    { "blank", 99 },
    { NULL, 0 }
};

static symInit_t 
attackDescInit[] = 
{
    { "hits", 1 },
    { "bites", 2 },
    { "claws", 3 },
    { "stings", 4 },
    { "touches", 5 },
    { "kicks", 6 },
    { "gazes", 7 },
    { "breathes", 8 },
    { "spits", 9 },
    { "wails", 10 },
    { "embraces", 11 },
    { "crawls_on", 12 },
    { "releases_spores", 13 },
    { "begs_for_money", 14 },
    { "slimes", 15 },
    { "crushes", 16 },
    { "tramples", 17 },
    { "drools_on", 18 },
    { "insults", 19 },
    { "is_repelled", 99 },
    { NULL, 0 }
};





/*
 * Maximum token length = maximum string constant length
 * Also, trim the stack to an "acceptable" size.
 */

#define	MAX_TOK_LEN	64		/* maximum acceptable token length  */
#define	YYSTACKSIZE	128

#define GEN_TYPE_TMPL	256		/* type of a template for st	    */

/*
 * Globals used by the tokenizer (lexical analyzer)
 */

#define INPUT_BUF_SIZE 256
static char	inputBuf[INPUT_BUF_SIZE] = { 0 };
					/* input line buffer		    */
static char	*inputBufp = inputBuf;	/* position in input line buffer    */
static int	lineNo = 0;		/* number of current line	    */
static FILE	*input_F;
static char	tokStr[MAX_TOK_LEN];	/* text of current token	    */
static	int	tokType;		/* type of current token	    */

static template_t blankTemplate;	/* blank template for init-ing     */
static template_t tmpTemplate;		/* working template for current     */
					/* class or creature		    */

#define MAX_ATTACK 250
static m_attack_type attackList[MAX_ATTACK];
static m_attack_type sorted_attackList[MAX_ATTACK];
static int attackCt = 1;
static int creatureAttacks = 0;
static int maxCreatureLevel = 0;

/*
 * Global symbol tables
 */

static st_Table_Pt keywordT_P;		/* parser's keywords		    */
static st_Table_Pt defenseT_P;		/* defense flags		    */
static st_Table_Pt moveT_P;		/* movement flags		    */
static st_Table_Pt specialT_P;		/* special flags		    */
static st_Table_Pt treasureT_P;		/* treasure flags		    */
static st_Table_Pt spellT_P;		/* spell flags			    */
static st_Table_Pt breathT_P;		/* breath flags			    */
static st_Table_Pt attackTypeT_P;	/* attack type flags		    */
static st_Table_Pt attackDescT_P;	/* attack desc flags		    */
static st_Table_Pt classT_P;		/* class templates		    */
static st_Table_Pt creatureT_P;		/* creature definitions		    */

/*
 * Function declarations
 */

extern void AddDefense ();
extern void NegDefense ();
extern void AddMove ();
extern void NegMove ();
extern void AddTreasure ();
extern void NegTreasure ();
extern void AddSpecial ();
extern void NegSpecial ();
extern void AddSpell ();
extern void NegSpell ();
extern void AddBreath ();
extern void AddFreq ();
extern void NegBreath ();
extern void AddResist ();
extern void NegResist ();
extern void AddAttack ();
extern void AddUnusedAttack ();
extern void WriteCreature ();
extern void PutClassTemplate ();
extern template_t GetClassTemplate ();
extern int MergeClassTemplate (char *s, template_t *t1);
extern void PutCreature ();
extern int FindAttackCount (int8u *);


/* Line 371 of yacc.c  */
#line 370 "creature.c"

# ifndef YY_NULL
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULL nullptr
#  else
#   define YY_NULL 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     CLASS = 258,
     CREATURE = 259,
     UNUSED = 260,
     NAMED = 261,
     HD = 262,
     MOVE = 263,
     SPELL = 264,
     BREATH = 265,
     DEFENSE = 266,
     XP = 267,
     CCHAR = 268,
     SLEEP = 269,
     RADIUS = 270,
     SPEED = 271,
     ATTACK = 272,
     FOR = 273,
     AC = 274,
     LEVEL = 275,
     TREASURE = 276,
     SPECIAL = 277,
     OF = 278,
     IN = 279,
     NOTHING = 280,
     DESCRIPTION = 281,
     RESIST = 282,
     IDENTIFIER = 283,
     FLOAT_LIT = 284,
     INT_LIT = 285,
     STRING_LIT = 286,
     BOOL_LIT = 287
   };
#endif
/* Tokens.  */
#define CLASS 258
#define CREATURE 259
#define UNUSED 260
#define NAMED 261
#define HD 262
#define MOVE 263
#define SPELL 264
#define BREATH 265
#define DEFENSE 266
#define XP 267
#define CCHAR 268
#define SLEEP 269
#define RADIUS 270
#define SPEED 271
#define ATTACK 272
#define FOR 273
#define AC 274
#define LEVEL 275
#define TREASURE 276
#define SPECIAL 277
#define OF 278
#define IN 279
#define NOTHING 280
#define DESCRIPTION 281
#define RESIST 282
#define IDENTIFIER 283
#define FLOAT_LIT 284
#define INT_LIT 285
#define STRING_LIT 286
#define BOOL_LIT 287



#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{
/* Line 387 of yacc.c  */
#line 332 "creature.y"

	int ival;
	double dval;
	char sval[MAX_TOK_LEN];
	

/* Line 387 of yacc.c  */
#line 481 "creature.c"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif

extern YYSTYPE yylval;

#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* Copy the second part of user declarations.  */
/* Line 390 of yacc.c  */
#line 346 "creature.y"

static symInit_t 
keywordInit[] = 
{
    { "class", CLASS },
    { "creature", CREATURE },
    { "unused", UNUSED},
    { "named", NAMED },
    { "hd", HD },
    { "move", MOVE },
    { "spell", SPELL },
    { "breath", BREATH },
    { "defense", DEFENSE },
    { "exp", XP },
    { "letter", CCHAR },
    { "sleep", SLEEP },
    { "radius", RADIUS },
    { "speed", SPEED },
    { "attack", ATTACK },
    { "for", FOR },
    { "ac", AC },
    { "level", LEVEL },
    { "treasure", TREASURE },
    { "special", SPECIAL },
    { "of", OF },
    { "in", IN },
    { "none", NOTHING },
    { "description", DESCRIPTION},
    { "resist", RESIST},
    { NULL, 0 }
};

/* Line 390 of yacc.c  */
#line 542 "creature.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(N) (N)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (YYID (0))
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  16
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   172

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  42
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  44
/* YYNRULES -- Number of rules.  */
#define YYNRULES  99
/* YYNRULES -- Number of states.  */
#define YYNSTATES  207

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   287

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,    34,     2,     2,     2,     2,
       2,     2,     2,     2,    38,     2,     2,    40,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    37,    33,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    35,    39,    36,    41,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     7,    11,    15,    18,    19,    22,    25,
      27,    30,    31,    38,    43,    47,    48,    50,    51,    55,
      56,    63,    67,    68,    72,    76,    77,    81,    87,    91,
      95,    99,   103,   107,   111,   115,   119,   123,   130,   134,
     141,   145,   149,   153,   157,   161,   163,   165,   168,   176,
     178,   182,   183,   186,   194,   196,   200,   201,   204,   206,
     209,   211,   215,   216,   219,   220,   222,   225,   227,   231,
     232,   235,   237,   240,   242,   246,   247,   250,   252,   255,
     257,   261,   262,   265,   267,   270,   272,   276,   277,   280,
     282,   285,   287,   291,   292,   295,   297,   300,   302,   306
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int8 yyrhs[] =
{
      43,     0,    -1,    48,    33,    43,    -1,    53,    33,    43,
      -1,    49,    33,    43,    -1,    44,    43,    -1,    -1,    34,
      45,    -1,    46,    47,    -1,    28,    -1,    46,    47,    -1,
      -1,     3,    28,    50,    35,    56,    36,    -1,     5,    35,
      54,    36,    -1,    37,    51,    52,    -1,    -1,    28,    -1,
      -1,    38,    51,    52,    -1,    -1,     4,    31,    50,    35,
      56,    36,    -1,    55,    33,    54,    -1,    -1,    17,    37,
      59,    -1,    57,    33,    56,    -1,    -1,    20,    37,    30,
      -1,     7,    37,    30,    39,    30,    -1,    12,    37,    30,
      -1,    13,    37,    31,    -1,    19,    37,    30,    -1,    14,
      37,    30,    -1,    15,    37,    30,    -1,    16,    37,    30,
      -1,    17,    37,    62,    -1,     8,    37,    65,    -1,     9,
      37,    68,    -1,     9,    30,    40,    30,    37,    68,    -1,
      10,    37,    74,    -1,    10,    30,    40,    30,    37,    74,
      -1,    27,    37,    71,    -1,    11,    37,    77,    -1,    21,
      37,    80,    -1,    22,    37,    83,    -1,    26,    37,    58,
      -1,    31,    -1,    25,    -1,    60,    61,    -1,    28,    18,
      30,    39,    30,    23,    28,    -1,    25,    -1,    38,    60,
      61,    -1,    -1,    63,    64,    -1,    28,    18,    30,    39,
      30,    23,    28,    -1,    25,    -1,    38,    63,    64,    -1,
      -1,    66,    67,    -1,    28,    -1,    41,    28,    -1,    25,
      -1,    38,    66,    67,    -1,    -1,    69,    70,    -1,    -1,
      28,    -1,    41,    28,    -1,    25,    -1,    38,    69,    70,
      -1,    -1,    72,    73,    -1,    28,    -1,    41,    28,    -1,
      25,    -1,    38,    72,    73,    -1,    -1,    75,    76,    -1,
      28,    -1,    41,    28,    -1,    25,    -1,    38,    75,    76,
      -1,    -1,    78,    79,    -1,    28,    -1,    41,    28,    -1,
      25,    -1,    38,    78,    79,    -1,    -1,    81,    82,    -1,
      28,    -1,    41,    28,    -1,    25,    -1,    38,    81,    82,
      -1,    -1,    84,    85,    -1,    28,    -1,    41,    28,    -1,
      25,    -1,    38,    84,    85,    -1,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   402,   402,   403,   404,   405,   406,   409,   413,   416,
     420,   421,   424,   428,   431,   433,   437,   442,   447,   448,
     451,   462,   463,   466,   469,   470,   473,   476,   480,   483,
     486,   489,   492,   495,   498,   499,   500,   501,   507,   508,
     514,   515,   516,   517,   518,   521,   522,   525,   528,   530,
     533,   534,   537,   540,   542,   553,   554,   557,   560,   561,
     562,   565,   566,   569,   570,   573,   574,   575,   578,   579,
     582,   585,   586,   587,   590,   591,   594,   597,   598,   599,
     602,   603,   606,   609,   610,   611,   614,   615,   618,   621,
     622,   623,   626,   627,   630,   633,   634,   635,   638,   639
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "CLASS", "CREATURE", "UNUSED", "NAMED",
  "HD", "MOVE", "SPELL", "BREATH", "DEFENSE", "XP", "CCHAR", "SLEEP",
  "RADIUS", "SPEED", "ATTACK", "FOR", "AC", "LEVEL", "TREASURE", "SPECIAL",
  "OF", "IN", "NOTHING", "DESCRIPTION", "RESIST", "IDENTIFIER",
  "FLOAT_LIT", "INT_LIT", "STRING_LIT", "BOOL_LIT", "';'", "'#'", "'{'",
  "'}'", "':'", "','", "'|'", "'/'", "'~'", "$accept", "creatures",
  "comment_def", "comments", "comment", "more_comments", "class_def",
  "unused_def", "parent_classes", "parent_class", "more_classes",
  "creature_def", "unusedfeatures", "unusedfeature", "features", "feature",
  "description", "unusedattacks", "unusedattack", "more_unusedattacks",
  "attacks", "attack", "more_attacks", "moves", "move", "more_moves",
  "spells", "spell", "more_spells", "resists", "resist", "more_resists",
  "breaths", "breath", "more_breaths", "defenses", "defense",
  "more_defenses", "carries", "carry", "more_carries", "specials",
  "special", "more_specials", YY_NULL
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,    59,    35,   123,   125,    58,    44,   124,
      47,   126
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    42,    43,    43,    43,    43,    43,    44,    45,    46,
      47,    47,    48,    49,    50,    50,    51,    51,    52,    52,
      53,    54,    54,    55,    56,    56,    57,    57,    57,    57,
      57,    57,    57,    57,    57,    57,    57,    57,    57,    57,
      57,    57,    57,    57,    57,    58,    58,    59,    60,    60,
      61,    61,    62,    63,    63,    64,    64,    65,    66,    66,
      66,    67,    67,    68,    68,    69,    69,    69,    70,    70,
      71,    72,    72,    72,    73,    73,    74,    75,    75,    75,
      76,    76,    77,    78,    78,    78,    79,    79,    80,    81,
      81,    81,    82,    82,    83,    84,    84,    84,    85,    85
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     3,     3,     3,     2,     0,     2,     2,     1,
       2,     0,     6,     4,     3,     0,     1,     0,     3,     0,
       6,     3,     0,     3,     3,     0,     3,     5,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     6,     3,     6,
       3,     3,     3,     3,     3,     1,     1,     2,     7,     1,
       3,     0,     2,     7,     1,     3,     0,     2,     1,     2,
       1,     3,     0,     2,     0,     1,     2,     1,     3,     0,
       2,     1,     2,     1,     3,     0,     2,     1,     2,     1,
       3,     0,     2,     1,     2,     1,     3,     0,     2,     1,
       2,     1,     3,     0,     2,     1,     2,     1,     3,     0
};

/* YYDEFACT[STATE-NAME] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       6,     0,     0,     0,     0,     0,     6,     0,     0,     0,
      15,    15,    22,     9,     7,    11,     1,     5,     6,     6,
       6,    17,     0,     0,     0,     0,     0,    11,     8,     2,
       4,     3,    16,    19,    25,    25,     0,    13,    22,    10,
      17,    14,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    49,     0,    23,    51,    21,    19,     0,     0,
       0,    64,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    12,    25,    20,
       0,     0,    47,    18,     0,    60,    58,     0,    35,    62,
       0,    67,    65,     0,    36,    69,     0,    79,    77,     0,
      38,    81,    85,    83,     0,    41,    87,    28,    29,    31,
      32,    33,    54,     0,    34,    56,    30,    26,    91,    89,
       0,    42,    93,    97,    95,     0,    43,    99,    46,    45,
      44,    73,    71,     0,    40,    75,    24,     0,    51,     0,
      59,     0,    57,     0,    66,     0,    63,     0,    78,     0,
      76,    84,     0,    82,     0,     0,    52,    90,     0,    88,
      96,     0,    94,    72,     0,    70,     0,    50,    27,    62,
      64,    69,     0,    81,    87,     0,    56,    93,    99,    75,
       0,    61,    37,    68,    39,    80,    86,     0,    55,    92,
      98,    74,     0,     0,    48,     0,    53
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     5,     6,    14,    27,    28,     7,     8,    22,    33,
      41,     9,    25,    26,    59,    60,   140,    64,    65,    92,
     124,   125,   166,    98,    99,   152,   104,   105,   156,   144,
     145,   175,   110,   111,   160,   115,   116,   163,   131,   132,
     169,   136,   137,   172
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -74
static const yytype_int8 yypact[] =
{
      -2,    -8,   -10,    15,    31,    62,    -2,    30,    32,    33,
      34,    34,    47,   -74,   -74,    31,   -74,   -74,    -2,    -2,
      -2,    39,    35,    37,    36,    40,    41,    31,   -74,   -74,
     -74,   -74,   -74,    42,    -3,    -3,    12,   -74,    47,   -74,
      39,   -74,    44,    45,   -15,     9,    46,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    43,
      64,    63,   -74,    60,   -74,    65,   -74,    42,    68,     0,
      28,     1,    61,     2,     6,    70,    71,    74,    75,    76,
      27,    77,    78,     8,    10,    29,    20,   -74,    -3,   -74,
      79,    12,   -74,   -74,    72,   -74,   -74,    82,   -74,    80,
      83,   -74,   -74,    84,   -74,    81,    85,   -74,   -74,    86,
     -74,    87,   -74,   -74,    88,   -74,    89,   -74,   -74,   -74,
     -74,   -74,   -74,    66,   -74,    90,   -74,   -74,   -74,   -74,
      92,   -74,    91,   -74,   -74,    93,   -74,    94,   -74,   -74,
     -74,   -74,   -74,    95,   -74,    96,   -74,    97,    65,   100,
     -74,     0,   -74,    98,   -74,     1,   -74,   101,   -74,     2,
     -74,   -74,     6,   -74,   103,    27,   -74,   -74,     8,   -74,
     -74,    10,   -74,   -74,    20,   -74,   107,   -74,   -74,    80,
       1,    81,     2,    87,    89,   102,    90,    91,    94,    96,
      99,   -74,   -74,   -74,   -74,   -74,   -74,   109,   -74,   -74,
     -74,   -74,   112,   108,   -74,   114,   -74
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -74,    38,   -74,   -74,    73,   116,   -74,   -74,   106,   104,
     105,   -74,   110,   -74,   -35,   -74,   -74,   -74,   -22,   -73,
     -74,   -41,   -60,   -74,    -6,   -33,   -31,    -5,   -34,   -74,
     -23,   -37,   -29,    -4,   -27,   -74,    -1,   -30,   -74,   -11,
     -28,   -74,   -13,   -26
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const yytype_uint8 yytable[] =
{
      61,     1,     2,     3,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    70,    53,    54,    55,    56,
      10,    11,    71,    57,    58,    95,   101,   107,    96,   102,
     108,   112,     4,   128,   113,   133,   129,    62,   134,    72,
      63,    97,   103,   109,    17,   141,    73,   114,   142,   130,
      12,   135,   122,   146,   138,   123,    29,    30,    31,    13,
     139,   143,    16,    18,    24,    19,    20,    32,   100,   148,
      34,    21,    35,    36,    38,   177,    37,    15,    90,    87,
      40,    68,    69,    74,   164,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    88,    94,    89,
     117,   106,   118,    91,   119,   120,   121,   126,   127,   147,
     150,   149,   154,   153,   158,   157,   161,    23,   151,   155,
     167,   170,   202,   173,   186,   159,   198,   162,   165,   168,
     178,   205,   171,   185,   174,   180,   176,   190,   182,   203,
     204,   197,   206,    39,    67,   179,   191,   193,    66,   192,
     181,   189,   201,   194,   196,   183,   195,   187,   188,   199,
       0,   184,   200,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    93
};

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-74)))

#define yytable_value_is_error(Yytable_value) \
  YYID (0)

static const yytype_int16 yycheck[] =
{
      35,     3,     4,     5,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    30,    19,    20,    21,    22,
      28,    31,    37,    26,    27,    25,    25,    25,    28,    28,
      28,    25,    34,    25,    28,    25,    28,    25,    28,    30,
      28,    41,    41,    41,     6,    25,    37,    41,    28,    41,
      35,    41,    25,    88,    25,    28,    18,    19,    20,    28,
      31,    41,     0,    33,    17,    33,    33,    28,    40,    91,
      35,    37,    35,    37,    33,   148,    36,     4,    18,    36,
      38,    37,    37,    37,    18,    37,    37,    37,    37,    37,
      37,    37,    37,    37,    37,    37,    37,    33,    30,    36,
      30,    40,    31,    38,    30,    30,    30,    30,    30,    30,
      28,    39,    28,    30,    28,    30,    28,    11,    38,    38,
      28,    28,    23,    28,   165,    38,   186,    38,    38,    38,
      30,    23,    38,    30,    38,    37,    39,    30,    37,    30,
      28,    39,    28,    27,    40,   151,   179,   181,    38,   180,
     155,   174,   189,   182,   184,   159,   183,   168,   171,   187,
      -1,   162,   188,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    67
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     3,     4,     5,    34,    43,    44,    48,    49,    53,
      28,    31,    35,    28,    45,    46,     0,    43,    33,    33,
      33,    37,    50,    50,    17,    54,    55,    46,    47,    43,
      43,    43,    28,    51,    35,    35,    37,    36,    33,    47,
      38,    52,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    19,    20,    21,    22,    26,    27,    56,
      57,    56,    25,    28,    59,    60,    54,    51,    37,    37,
      30,    37,    30,    37,    37,    37,    37,    37,    37,    37,
      37,    37,    37,    37,    37,    37,    37,    36,    33,    36,
      18,    38,    61,    52,    30,    25,    28,    41,    65,    66,
      40,    25,    28,    41,    68,    69,    40,    25,    28,    41,
      74,    75,    25,    28,    41,    77,    78,    30,    31,    30,
      30,    30,    25,    28,    62,    63,    30,    30,    25,    28,
      41,    80,    81,    25,    28,    41,    83,    84,    25,    31,
      58,    25,    28,    41,    71,    72,    56,    30,    60,    39,
      28,    38,    67,    30,    28,    38,    70,    30,    28,    38,
      76,    28,    38,    79,    18,    38,    64,    28,    38,    82,
      28,    38,    85,    28,    38,    73,    39,    61,    30,    66,
      37,    69,    37,    75,    78,    30,    63,    81,    84,    72,
      30,    67,    68,    70,    74,    76,    79,    39,    64,    82,
      85,    73,    23,    30,    28,    23,    28
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  However,
   YYFAIL appears to be in use.  Nevertheless, it is formally deprecated
   in Bison 2.4.2's NEWS entry, where a plan to phase it out is
   discussed.  */

#define YYFAIL		goto yyerrlab
#if defined YYFAIL
  /* This is here to suppress warnings from the GCC cpp's
     -Wunused-macros.  Normally we don't worry about that warning, but
     some users do, and we want to make it easy for users to remove
     YYFAIL uses, which will produce warnings from Bison 2.5.  */
#endif

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                  \
do                                                              \
  if (yychar == YYEMPTY)                                        \
    {                                                           \
      yychar = (Token);                                         \
      yylval = (Value);                                         \
      YYPOPSTACK (yylen);                                       \
      yystate = *yyssp;                                         \
      goto yybackup;                                            \
    }                                                           \
  else                                                          \
    {                                                           \
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))

/* Error token number */
#define YYTERROR	1
#define YYERRCODE	256


/* This macro is provided for backward compatibility. */
#ifndef YY_LOCATION_PRINT
# define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */
#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  FILE *yyo = yyoutput;
  YYUSE (yyo);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
        break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
#else
static void
yy_stack_print (yybottom, yytop)
    yytype_int16 *yybottom;
    yytype_int16 *yytop;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule)
#else
static void
yy_reduce_print (yyvsp, yyrule)
    YYSTYPE *yyvsp;
    int yyrule;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (YY_NULL, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULL;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - Assume YYFAIL is not used.  It's too flawed to consider.  See
       <http://lists.gnu.org/archive/html/bison-patches/2009-12/msg00024.html>
       for details.  YYERROR is fine as it does not invoke this
       function.
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYSIZE_T yysize1 = yysize + yytnamerr (YY_NULL, yytname[yyx]);
                  if (! (yysize <= yysize1
                         && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                    return 2;
                  yysize = yysize1;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    YYSIZE_T yysize1 = yysize + yystrlen (yyformat);
    if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
      return 2;
    yysize = yysize1;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  YYUSE (yyvaluep);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
        break;
    }
}




/* The lookahead symbol.  */
int yychar;


#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval YY_INITIAL_VALUE(yyval_default);

/* Number of syntax errors so far.  */
int yynerrs;


/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       `yyss': related to states.
       `yyvs': related to semantic values.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss_alloc, yyss);
	YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 7:
/* Line 1792 of yacc.c  */
#line 410 "creature.y"
    {/*don't do anything*/;}
    break;

  case 9:
/* Line 1792 of yacc.c  */
#line 417 "creature.y"
    {/* don't do anything with it*/;}
    break;

  case 12:
/* Line 1792 of yacc.c  */
#line 425 "creature.y"
    { PutClassTemplate((yyvsp[(2) - (6)].sval), &tmpTemplate); }
    break;

  case 15:
/* Line 1792 of yacc.c  */
#line 433 "creature.y"
    { tmpTemplate = blankTemplate;
			  creatureAttacks = 0; }
    break;

  case 16:
/* Line 1792 of yacc.c  */
#line 438 "creature.y"
    { MergeClassTemplate ((yyvsp[(1) - (1)].sval), &tmpTemplate);
				  creatureAttacks = 
				    FindAttackCount (tmpTemplate.val.damage); }
    break;

  case 17:
/* Line 1792 of yacc.c  */
#line 442 "creature.y"
    { tmpTemplate = blankTemplate;
				  creatureAttacks = 0; }
    break;

  case 20:
/* Line 1792 of yacc.c  */
#line 453 "creature.y"
    { tmpTemplate.val.name =
				    (char *) malloc(strlen((yyvsp[(2) - (6)].sval)) + 1);
				  strcpy(tmpTemplate.val.name, (yyvsp[(2) - (6)].sval));
				  PutCreature((yyvsp[(2) - (6)].sval), &tmpTemplate,
					      arguments.mc.consistency_check);
				  tmpTemplate = blankTemplate;
				}
    break;

  case 26:
/* Line 1792 of yacc.c  */
#line 474 "creature.y"
    { tmpTemplate.val.level = (yyvsp[(3) - (3)].ival);
				  tmpTemplate.def.level = TRUE; }
    break;

  case 27:
/* Line 1792 of yacc.c  */
#line 477 "creature.y"
    { tmpTemplate.val.hd[0] = (yyvsp[(3) - (5)].ival);
				  tmpTemplate.val.hd[1] = (yyvsp[(5) - (5)].ival);
				  tmpTemplate.def.hd = TRUE; }
    break;

  case 28:
/* Line 1792 of yacc.c  */
#line 481 "creature.y"
    { tmpTemplate.val.mexp = (yyvsp[(3) - (3)].ival);
				  tmpTemplate.def.mexp = TRUE; }
    break;

  case 29:
/* Line 1792 of yacc.c  */
#line 484 "creature.y"
    { tmpTemplate.val.cchar = (yyvsp[(3) - (3)].sval)[0];
				  tmpTemplate.def.cchar = TRUE; }
    break;

  case 30:
/* Line 1792 of yacc.c  */
#line 487 "creature.y"
    { tmpTemplate.val.ac = (yyvsp[(3) - (3)].ival);
				  tmpTemplate.def.ac = TRUE; }
    break;

  case 31:
/* Line 1792 of yacc.c  */
#line 490 "creature.y"
    { tmpTemplate.val.sleep = (yyvsp[(3) - (3)].ival);
				  tmpTemplate.def.sleep = TRUE; }
    break;

  case 32:
/* Line 1792 of yacc.c  */
#line 493 "creature.y"
    { tmpTemplate.val.aaf = (yyvsp[(3) - (3)].ival);
				  tmpTemplate.def.aaf = TRUE; }
    break;

  case 33:
/* Line 1792 of yacc.c  */
#line 496 "creature.y"
    { tmpTemplate.val.speed = (yyvsp[(3) - (3)].ival) + 10;
				  tmpTemplate.def.speed = TRUE; }
    break;

  case 37:
/* Line 1792 of yacc.c  */
#line 502 "creature.y"
    { 
                                  int i = (yyvsp[(3) - (6)].ival);
                                  int j = (yyvsp[(5) - (6)].ival);
				  AddFreq (i, j, "spell");
				}
    break;

  case 39:
/* Line 1792 of yacc.c  */
#line 509 "creature.y"
    { 
                                  int i = (yyvsp[(3) - (6)].ival);
                                  int j = (yyvsp[(5) - (6)].ival);
				  AddFreq (i, j, "breath");
				}
    break;

  case 48:
/* Line 1792 of yacc.c  */
#line 529 "creature.y"
    { AddUnusedAttack((yyvsp[(1) - (7)].sval), (yyvsp[(3) - (7)].ival), (yyvsp[(5) - (7)].ival), (yyvsp[(7) - (7)].sval)); }
    break;

  case 53:
/* Line 1792 of yacc.c  */
#line 541 "creature.y"
    { AddAttack((yyvsp[(1) - (7)].sval), (yyvsp[(3) - (7)].ival), (yyvsp[(5) - (7)].ival), (yyvsp[(7) - (7)].sval)); }
    break;

  case 54:
/* Line 1792 of yacc.c  */
#line 543 "creature.y"
    {
				  tmpTemplate.val.damage[0] = 0;
				  tmpTemplate.val.damage[1] = 0;
				  tmpTemplate.val.damage[2] = 0;
				  tmpTemplate.val.damage[3] = 0;
				  creatureAttacks = 0;
				  tmpTemplate.def.damage = TRUE; 
				}
    break;

  case 58:
/* Line 1792 of yacc.c  */
#line 560 "creature.y"
    { AddMove((yyvsp[(1) - (1)].sval)); }
    break;

  case 59:
/* Line 1792 of yacc.c  */
#line 561 "creature.y"
    { NegMove((yyvsp[(2) - (2)].sval)); }
    break;

  case 65:
/* Line 1792 of yacc.c  */
#line 573 "creature.y"
    { AddSpell((yyvsp[(1) - (1)].sval)); }
    break;

  case 66:
/* Line 1792 of yacc.c  */
#line 574 "creature.y"
    { NegSpell((yyvsp[(2) - (2)].sval)); }
    break;

  case 71:
/* Line 1792 of yacc.c  */
#line 585 "creature.y"
    { AddResist((yyvsp[(1) - (1)].sval)); }
    break;

  case 72:
/* Line 1792 of yacc.c  */
#line 586 "creature.y"
    { NegResist((yyvsp[(2) - (2)].sval)); }
    break;

  case 77:
/* Line 1792 of yacc.c  */
#line 597 "creature.y"
    { AddBreath((yyvsp[(1) - (1)].sval)); }
    break;

  case 78:
/* Line 1792 of yacc.c  */
#line 598 "creature.y"
    { NegBreath((yyvsp[(2) - (2)].sval)); }
    break;

  case 83:
/* Line 1792 of yacc.c  */
#line 609 "creature.y"
    { AddDefense((yyvsp[(1) - (1)].sval)); }
    break;

  case 84:
/* Line 1792 of yacc.c  */
#line 610 "creature.y"
    { NegDefense((yyvsp[(2) - (2)].sval)); }
    break;

  case 85:
/* Line 1792 of yacc.c  */
#line 611 "creature.y"
    { tmpTemplate.def.defense = TRUE; }
    break;

  case 89:
/* Line 1792 of yacc.c  */
#line 621 "creature.y"
    { AddTreasure((yyvsp[(1) - (1)].sval)); }
    break;

  case 90:
/* Line 1792 of yacc.c  */
#line 622 "creature.y"
    { NegTreasure((yyvsp[(2) - (2)].sval)); }
    break;

  case 91:
/* Line 1792 of yacc.c  */
#line 623 "creature.y"
    { tmpTemplate.def.treasure = TRUE; }
    break;

  case 95:
/* Line 1792 of yacc.c  */
#line 633 "creature.y"
    { AddSpecial((yyvsp[(1) - (1)].sval)); }
    break;

  case 96:
/* Line 1792 of yacc.c  */
#line 634 "creature.y"
    { NegSpecial((yyvsp[(2) - (2)].sval)); }
    break;


/* Line 1792 of yacc.c  */
#line 2155 "creature.c"
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}


/* Line 2055 of yacc.c  */
#line 643 "creature.y"




/*
 * MyFGetC--
 *	fgetc with support for comments
 *
 *	# is the comment character.  comment lasts till end of line.
 * Spews out an extra char of whitespace at EOF since something seems to
 * need it.  I'll figure this out eventually...
 */
static int 
MyFGetC (FILE *input_F)
{
  while (!*inputBufp || (*inputBufp == '#')) 
    {
      fgets (inputBuf, INPUT_BUF_SIZE, input_F);
      if (feof (input_F))
	return EOF;
      lineNo++;
      inputBufp = inputBuf;
    }
  return *inputBufp++;
}



/*
 * Advance--
 *	Advance to the next token in the input stream and set tokStr,
 * tokType.
 *
 *	On error, tokType is set to a negative value.
 */
static void 
Advance (FILE *input_F)
{
  register char *tok = tokStr;	/* accumulating token string		    */
  register int len = 0;		/* length of current token		    */
  static int c = 32;		/* current character; ' ' is harmless init  */


  /*
   * Skip whitespace in the stream
   */
  while ((c != EOF) && isspace (c))
    c = MyFGetC (input_F);

  /*
   * At end of file?
   */
  if (c == EOF) 
    {
      tokType = EOF;
      strcpy (tokStr, "[EOF]");
      return;
    }

  /*
   * Recognize a number [+|-][dddd][.][dddd][{e|E}[+|-]dddd]
   */
  if (isdigit (c) || (c == '.') || (c == '+') || (c == '-')) 
    {
      register int decPt = FALSE,   /* seen a decimal point yet?	*/
	       hasExp = FALSE;	    /* has an exponent?			*/

      if ((c == '-') || (c == '+')) 
	{
	  *tok++ = c;
	  c = MyFGetC (input_F);
	}

      while ((len < MAX_TOK_LEN - 1) && (isdigit (c) || (c == '.'))) 
	{
	  if (c == '.') 
	    {
	      if (decPt)
		break;
	      else
		decPt = TRUE;
	    }

	  *tok++ = c;
	  c = MyFGetC (input_F);
	  len++;
	}

      if ((c == 'e') || (c == 'E')) 
	{
	  hasExp = TRUE;
	  *tok++ = c;
	  c = MyFGetC (input_F);
	  len++;

	  if ((c == '-') || (c == '+')) 
	    {
	      *tok++ = c;
	      c = MyFGetC (input_F);
	      len++;
	    }

	  while ((len < MAX_TOK_LEN - 1) && isdigit (c)) 
	    {
	      *tok++ = c;
	      c = MyFGetC (input_F);
	      len++;
	    }
	}

      *tok = 0;

      if (decPt || hasExp) 
	{
	  tokType = FLOAT_LIT;
	  yylval.dval = atof (tokStr);
	} 
      else 
	{
	  tokType = INT_LIT;
	  yylval.ival = atoi (tokStr);
	}

      return;

    }

  /*
   * Recognize a quoted string
   */
  if (c == '\"') 
    {

      c = MyFGetC (input_F);

      while ((len < MAX_TOK_LEN - 1) &&
	     (c != EOF) && (c != '\n') && (c != '\"')) 
	{
	  *tok++ = c;
	  c = MyFGetC (input_F);
	}

      *tok = 0;

      c = MyFGetC (input_F);

      tokType = STRING_LIT;
      strncpy (yylval.sval, tokStr, MAX_TOK_LEN - 1);
      yylval.sval[MAX_TOK_LEN - 1] = 0;

      return;

    }

  /*
   * Recognize an identifier and try to match it with a keyword.
   * Identifiers begin with a letter and continue in letters and/or
   * digits.  Convert it to lowercase.
   */
  if (isalpha (c) || (c == '_') || (c == '$')) {

    if (isupper (c))
      c = tolower (c);
    *tok++ = c;
    c = MyFGetC (input_F);
    len++;

    while ((len < MAX_TOK_LEN - 1) && (isalpha (c) || isdigit (c) ||
				       (c == '_') || (c == '$'))) 
      {
	if (isupper (c))
	  c = tolower (c);
	*tok++ = c;
	c = MyFGetC (input_F);
	len++;
      }

    *tok = 0;

    /*
     * We've got the identifier; see if it matches any keywords.
     */

      {
	generic_t gval;
	int type;
	if (St_GetSym (keywordT_P, tokStr, &type, &gval) == ST_SYM_FOUND) 
	  {
	    tokType = gval.i;
	    strncpy (yylval.sval, tokStr, MAX_TOK_LEN - 1);
	    yylval.sval[MAX_TOK_LEN - 1] = 0;
	  } 
	else if (!strcmp (tokStr, "true")) 
	  {
	    tokType = BOOL_LIT;
	    yylval.ival = 1;
	  } 
	else if (!strcmp (tokStr, "false")) 
	  {
	    tokType = BOOL_LIT;
	    yylval.ival = 0;
	  } 
	else 
	  {
	    tokType = IDENTIFIER;
	    strncpy (yylval.sval, tokStr, MAX_TOK_LEN - 1);
	    yylval.sval[MAX_TOK_LEN - 1] = 0;
	  }
      }

    return;

  }

  /*
   * Recognize punctuation
   */

  tokType = c;
  *tok++ = c;
  *tok = 0;
  c = MyFGetC (input_F);
  return;
}

void 
ErrMsg (char *s)
{
  int i;

  fprintf (stderr, "Error: %s at line %d\n", s, lineNo);
  fprintf (stderr, "%s", inputBuf);
  for (i = 0; i < inputBufp - inputBuf; i++) 
    {
      fputc ((inputBuf[i] == '\t' ? '\t' : ' '), stderr);
    }
  fprintf (stderr, "^ before here\n\n");
  return;
}

int 
yyerror (char *s)
{
  ErrMsg (s);
  return 0;
}


int 
yylex ()
{
  Advance (input_F);
  return tokType;
}

void 
AddSpell (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (spellT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown spell '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      if (tmpTemplate.def.resist)
	{
	  sprintf (s1, "Setting spell '%s' when a resist is already set causes the resist to turn into breath which probably isn't want you want.", s);
	  ErrMsg (s1);
	}
      else
	{
	  tmpTemplate.val.spells |= (1 << gval.i);
	  tmpTemplate.def.spell = TRUE;
	}
    }
  return;
}


void 
NegSpell (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (spellT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown spell '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      tmpTemplate.val.spells &= ~(1 << gval.i);
      tmpTemplate.def.spell = TRUE;
    }
  return;
}

unsigned int
lookup_flag (char *kind, char *f)
{
  char *flags;
  generic_t gval;
  int retval = 0;
  char *s;
  int type;
  char s1[256];
  static st_Table_Pt table;
  int negate = 0;

  if (strcmp (kind, "defense") == 0)
    table = defenseT_P;
  else if (strcmp (kind, "move") == 0)
    table = moveT_P;
  else if (strcmp (kind, "special") == 0)
    table = specialT_P;
  else if (strcmp (kind, "treasure") == 0)
    table = treasureT_P;
  else if (strcmp (kind, "spell") == 0)
    table = spellT_P;
  else if (strcmp (kind, "breath") == 0)
    table = breathT_P;
  else if (strcmp (kind, "resist") == 0)
    table = breathT_P;
  else if (strcmp (kind, "attacktype") == 0)
    table = attackTypeT_P;
  else if (strcmp (kind, "attackdesc") == 0)
    table = attackDescT_P;
  else
    return -1;

  flags = strdup (f);
  for (s = strtok (flags, ", "); s != NULL; s = strtok (NULL, ", "))
    {
      negate = 0;
      if (s[0] == '~')
	{
	  negate = 1;
	  s++;
	}
      if (St_GetSym (table, s, &type, &gval) != ST_SYM_FOUND) 
	{
	  sprintf (s1, "unknown %s '%s' (in internal code)", kind, s);
	  ErrMsg (s1);
	} 
      else
	{
	  if (negate)
	    retval &= ~(1 << gval.i);
	  else
	    retval |= (1 << gval.i);
	}
    }
  free (flags);
  return retval;
}

void 
AddResist (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (breathT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown resist '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      if ((tmpTemplate.def.breath) && 
	  ((tmpTemplate.val.spells & (1 << gval.i))) == 0)
	{
	  sprintf (s1, "4. Setting resist '%s' when non-identical breath already set causes %s-breath to be enabled which probably isn't want you want.", s, s);
	  ErrMsg (s1);
	}
      else if ((tmpTemplate.def.spell) && (tmpTemplate.def.breath == 0))
	{
	  sprintf (s1, "5. Setting resist '%s' when a spell frequency is already set causes %s-breath to be enabled which probably isn't want you want.", s, s);
	  ErrMsg (s1);
	}
      else
	{
	  tmpTemplate.val.spells |= (1 << gval.i);
	  tmpTemplate.def.resist = TRUE;
	}
    }
  return;
}


void 
NegResist (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (breathT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown resist '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      tmpTemplate.val.spells &= ~(1 << gval.i);
      tmpTemplate.def.resist = TRUE;
    }
  return;
}

void 
AddBreath (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (breathT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown breath '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      if ((tmpTemplate.def.resist) && 
	  ((tmpTemplate.val.spells & (1 << gval.i)) == 0))
	{
	  sprintf (s1, "6. Setting breath '%s' when non-identical resist was already set causes the resist to become a breath which probably isn't want you want.", s);
	  ErrMsg (s1);
	}
      else
	{
	  tmpTemplate.val.spells |= (1 << gval.i);
	  tmpTemplate.def.breath = TRUE;
	}
    }
  return;
}


void 
NegBreath (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (breathT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown breath '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      tmpTemplate.val.spells &= ~(1 << gval.i);
      tmpTemplate.def.breath = TRUE;
    }
  return;
}


void 
AddSpecial (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (specialT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown special '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      tmpTemplate.val.cmove |= (1 << gval.i);
      tmpTemplate.def.special = TRUE;
    }
  return;
}


void 
NegSpecial (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (specialT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown special '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      tmpTemplate.val.cmove &= ~(1 << gval.i);
      tmpTemplate.def.special = TRUE;
    }
  return;
}

void AddMove(char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (moveT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown move '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      tmpTemplate.val.cmove |= (1 << gval.i);
      tmpTemplate.def.move = TRUE;
    }
  return;
}


void 
NegMove (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (moveT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown move '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      tmpTemplate.val.cmove &= ~(1 << gval.i);
      tmpTemplate.def.move = TRUE;
    }
  return;
}

void 
AddTreasure (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (treasureT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown treasure '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      tmpTemplate.val.cmove |= (1 << gval.i);
      tmpTemplate.def.treasure = TRUE;
    }
  return;
}


void 
NegTreasure (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (treasureT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown treasure '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      tmpTemplate.val.cmove &= ~(1 << gval.i);
      tmpTemplate.def.treasure = TRUE;
    }
  return;
}


void 
AddDefense (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (defenseT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown defense '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      tmpTemplate.val.cdefense |= (1 << gval.i);
      tmpTemplate.def.defense = TRUE;
    }
  return;
}


void 
NegDefense (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (defenseT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown defense '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      tmpTemplate.val.cdefense &= ~(1 << gval.i);
      tmpTemplate.def.defense = TRUE;
    }
  return;
}


int 
PutAttack (m_attack_type attack)
{
  register int i;

  for (i = 0; i < attackCt; i++) 
    {
      if ((attack.attack_type == attackList[i].attack_type) &&
	  (attack.attack_desc == attackList[i].attack_desc) &&
	  (attack.attack_dice == attackList[i].attack_dice) &&
	  (attack.attack_sides == attackList[i].attack_sides)) 
	{
	  return i;
	}
    }

  if (attackCt == MAX_ATTACK) 
    {
      fprintf (stderr, "fatal error: too many different attacks.\n");
      fprintf (stderr, "increase MAX_ATTACK.\n");
      exit (1);
    }

  attackList[attackCt].attack_type = attack.attack_type;
  attackList[attackCt].attack_desc = attack.attack_desc;
  attackList[attackCt].attack_dice = attack.attack_dice;
  attackList[attackCt].attack_sides = attack.attack_sides;

  attackCt++;
  return attackCt - 1;
}

void 
AddUnusedAttack (char *s1, int dice, int sides, char *s2)
{
  generic_t gval;
  int type, aDesc;
  m_attack_type attack;
  char s[256];

  if (St_GetSym (attackDescT_P, s1, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s, "unknown attack description '%s'", s1);
      ErrMsg (s);
      return;
    } 
  else 
    {
      aDesc = gval.i;
    }

  if (St_GetSym (attackTypeT_P, s2, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s, "unknown attack type '%s'", s2);
      ErrMsg (s);
    } 
  else 
    {
      attack.attack_type = gval.i;
      attack.attack_dice = dice;
      attack.attack_desc = aDesc;
      attack.attack_sides = sides;

      PutAttack (attack);
    }
  return;
}

void 
AddAttack (char *s1, int dice, int sides, char *s2)
{
  generic_t gval;
  int type, aDesc;
  m_attack_type attack;
  char s[256];

  if (St_GetSym (attackDescT_P, s1, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s, "unknown attack description '%s'", s1);
      ErrMsg (s);
      return;
    } 
  else 
    {
      aDesc = gval.i;
    }

  if (St_GetSym (attackTypeT_P, s2, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s, "unknown attack type '%s'", s2);
      ErrMsg (s);
    } 
  else 
    {
      if (creatureAttacks > 3) 
	{
	  sprintf (s, "creature limited to 4 attacks");
	  ErrMsg (s);
	  return;
	}
      attack.attack_type = gval.i;
      attack.attack_dice = dice;
      attack.attack_desc = aDesc;
      attack.attack_sides = sides;

      tmpTemplate.val.damage[creatureAttacks++] = PutAttack (attack);
      tmpTemplate.def.damage = TRUE;
    }
  return;
}

int
FindAttackCount (int8u *damage)
{
  int max = 4;
  int i;
  for (i = 0; i < max; i++)
    {
      if (damage[i] == 0)
	return i;
    }
  return max;
}

void
AddFreq (int i, int chance, char *kind)
{
  char s1[256];
  if (((tmpTemplate.def.breath) || (tmpTemplate.def.spell)) &&
      (tmpTemplate.val.spells & CS_FREQ) && 
      ((tmpTemplate.val.spells & CS_FREQ) != chance))
    {
      sprintf (s1, "Setting new %s frequency causes previous spells or breaths to happen at this new rate which probably isn't want you want.", kind);
      ErrMsg (s1);
    }
  else if (i != 1 || (chance < 0 || chance > 15))
    {
      sprintf (s1, "%s frequency must be between 1/1 and 1/15.", kind);
      ErrMsg (s1);
    }
  else
    {
      tmpTemplate.val.spells &= ~(CS_FREQ);
      tmpTemplate.val.spells |= chance;
      tmpTemplate.def.spell = TRUE; 
    }
  return;
}

st_Table_Pt 
InitTable (char *name, symInit_t *init)
{
  int i;
  st_Table_Pt table_P;
  generic_t gval;

  table_P = St_NewTable (name, 20);
  for (i = 0; init[i].name; i++) 
    {
      gval.i = init[i].val;
      St_DefSym (table_P, init[i].name, GEN_TYPE_INT, gval);
    }

  return table_P;
}


void 
InitTables ()
{
  keywordT_P = InitTable ("keyword", keywordInit);
  defenseT_P = InitTable ("defense", defenseInit);
  spellT_P = InitTable ("spell", spellInit);
  moveT_P = InitTable ("move", moveInit);
  specialT_P = InitTable ("special", specialInit);
  breathT_P = InitTable ("breath", breathInit);
  treasureT_P = InitTable ("treasure", treasureInit);
  attackTypeT_P = InitTable ("attackType", attackTypeInit);
  attackDescT_P = InitTable ("attackDesc", attackDescInit);

  classT_P = St_NewTable ("class", 40);
  creatureT_P = St_NewTable ("creature", 200);

  return;
}

void 
WriteCreature (template_t *tmpl_P)
{
  char s[256];
  strcpy (s, "\"");
  strcat (s, tmpl_P->val.name);
  strcat (s, "\"");
  fprintf (arguments.mc.outfile, "{%-28s, 0x%08XL,0x%08XL,0x%04X,%5d,%3d,\n",
	   s, (unsigned int) tmpl_P->val.cmove, 
	   (unsigned int) tmpl_P->val.spells, tmpl_P->val.cdefense, 
	   tmpl_P->val.mexp, tmpl_P->val.sleep);
  fprintf (arguments.mc.outfile, 
	   " %2d, %3d, %2d, '%c', {%3d,%2d}, {%3d,%3d,%3d,%3d}, %3d},\n",
	   tmpl_P->val.aaf, tmpl_P->val.ac, tmpl_P->val.speed,
	   tmpl_P->val.cchar,
	   tmpl_P->val.hd[0], tmpl_P->val.hd[1],
	   tmpl_P->val.damage[0], tmpl_P->val.damage[1],
	   tmpl_P->val.damage[2], tmpl_P->val.damage[3],
	   tmpl_P->val.level);
  return;
}

void 
WriteCreaturesHdr ()
{
  fprintf (arguments.mc.outfile, "\n\
/* Following are creature arrays and variables			*/\n\
	/* Creatures must be defined here                               */\n\
	/*      See types.h under creature_type for a complete list\n\
	   of all variables for creatures.       Some of the less obvious\n\
	   are explained below.\n\
\n\
	   Hit points:  #1, #2: where #2 is the range of each roll and\n\
	   #1 is the number of added up rolls to make.\n\
	   Example: a creature with 5 eight-sided hit die\n\
	   is given {5,8}.\n\
\n\
	   Attack types:\n\
	   1    Normal attack\n\
	   2    Poison Strength\n\
	   3    Confusion attack\n\
	   4    Fear attack\n\
	   5    Fire attack\n\
	   6    Acid attack\n\
	   7    Cold attack\n\
	   8    Lightning attack\n\
	   9    Corrosion attack\n\
	   10   Blindness attack\n\
	   11   Paralysis attack\n\
	   12   Steal Money\n\
	   13   Steal Object\n\
	   14   Poison\n\
	   15   Lose dexterity\n\
	   16   Lose constitution\n\
	   17   Lose intelligence\n\
	   18   Lose wisdom\n\
	   19   Lose experience\n\
	   20   Aggravation\n\
	   21   Disenchants\n\
	   22   Eats food\n\
	   23   Eats light\n\
	   24   Eats charges\n\
	   99   Blank\n\
\n\
	   Attack descriptions:\n\
	   1    hits you.\n\
	   2    bites you.\n\
	   3    claws you.\n\
	   4    stings you.\n\
	   5    touches you.\n\
	   6    kicks you.\n\
	   7    gazes at you.\n\
	   8    breathes on you.\n\
	   9    spits on you.\n\
	   10   makes a horrible wail.\n\
	   11   embraces you.\n\
	   12   crawls on you.\n\
	   13   releases a cloud of spores.\n\
	   14   begs you for money.\n\
	   15   You've been slimed.\n\
	   16   crushes you.\n\
	   17   tramples you.\n\
	   18   drools on you.\n\
	   19   insults you.\n\
	   99   is repelled.\n\
\n\
	   Example:  For a creature which bites for 1d6, then stings for\n\
	   2d4 and loss of dex you would use:\n\
	   {1,2,1,6},{15,4,2,4}\n\
\n\
	   CMOVE flags:\n\
	   Movement.    00000001        Move only to attack\n\
	   .    00000002        Move, attack normal\n\
	   .    00000008        20% random movement\n\
	   .    00000010        40% random movement\n\
	   .    00000020        75% random movement\n\
	   Special +    00010000        Invisible movement\n\
	   +    00020000        Move through door\n\
	   +    00040000        Move through wall\n\
	   +    00080000        Move through creatures\n\
	   +    00100000        Picks up objects\n\
	   +    00200000        Multiply monster\n\
	   Carries =    01000000        Carries objects.\n\
	   =    02000000        Carries gold.\n\
	   =    04000000        Has 60% of time.\n\
	   =    08000000        Has 90% of time.\n\
	   =    10000000        1d2 objects/gold.\n\
	   =    20000000        2d2 objects/gold.\n\
	   =    40000000        4d2 objects/gold.\n\
	   Special ~    80000000        Win-the-Game creature.\n\
\n\
	   SPELL Flags:\n\
	   Frequency    000001    1     These add up to x.  Then\n\
	   (1 in x).    000002    2     if RANDINT(X) = 1 the\n\
	   .    000004    4     creature casts a spell.\n\
	   .    000008    8\n\
	   Spells       =       000010  Teleport short (blink)\n\
	   =    000020  Teleport long\n\
	   =    000040  Teleport player to monster\n\
	   =    000080  Cause light wound\n\
	   =    000100  Cause serious wound\n\
	   =    000200  Hold person (Paralysis)\n\
	   =    000400  Cause blindness\n\
	   =    000800  Cause confusion\n\
	   =    001000  Cause fear\n\
	   =    002000  Summon monster\n\
	   =    004000  Summon undead\n\
	   =    008000  Slow Person\n\
	   =    010000  Drain Mana\n\
	   =    020000  Not Used\n\
	   =    040000  Not Used\n\
	   Breath/      +       080000  Breathe/Resist Lightning\n\
	   Resist       +       100000  Breathe/Resist Gas\n\
	   +    200000  Breathe/Resist Acid\n\
	   +    400000  Breathe/Resist Frost\n\
	   +    800000  Breathe/Resist Fire\n\
\n\
	   CDEFENSE flags:\n\
	   0001 Hurt by Slay Dragon.\n\
	   0002 Hurt by Slay Animal.\n\
	   0004 Hurt by Slay Evil.\n\
	   0008 Hurt by Slay Undead.\n\
	   0010 Hurt by Frost.\n\
	   0020 Hurt by Fire.\n\
	   0040 Hurt by Poison.\n\
	   0080 Hurt by Acid.\n\
	   0100 Hurt by Light-Wand.\n\
	   0200 Hurt by Stone-to-Mud.\n\
	   0400 Not used.\n\
	   0800 Not used.\n\
	   1000 Cannot be charmed or slept.\n\
	   2000 Can be seen with infra-vision.\n\
	   4000 Max Hit points.\n\
	   8000 Not used.\n\
\n\
\n\
	   Sleep (sleep)        :       A measure in turns of how fast creature\n\
	   will notice player (on the average).\n\
	   Area of affect (aaf) :       Max range that creature is able to \"notice\"\n\
	   the player.\n\
	 */\n\n");
}

void 
WriteCreatures ()
{
  char **s_A, **sp;
  int level, type;
  generic_t gval;
  int i;

  fprintf(arguments.mc.outfile, "#include \"constant.h\"\n");
  fprintf(arguments.mc.outfile, "#include \"types.h\"\n\n");
  WriteCreaturesHdr();
  s_A = St_SListTable (creatureT_P);

  fprintf (arguments.mc.outfile, "creature_type c_list[MAX_CREATURES] = {\n");
  for (i = 0; i < St_TableSize (creatureT_P); i++)
    {
      for (sp = s_A; *sp; sp++) 
	{
	  if (St_GetSym (creatureT_P, *sp, &type, &gval) != ST_SYM_FOUND) 
	    {
	      fprintf (stderr, "internal err. in WriteCreatures\n");
	      exit (1);
	    }
	  if ((*(template_t *) gval.v).idx == i) 
	    {
	      WriteCreature ((template_t *) gval.v);
	    }
	}
    }

  fprintf (arguments.mc.outfile, "};\n\n");

  St_SListTable (NULL);
  return;
}

void 
PutClassTemplate (char *s, template_t *tmpl_P)
{
  generic_t gval;
  char s1[256];

  gval.v = malloc (sizeof(template_t));
  *(template_t *) gval.v = *tmpl_P;

  if (St_DefSym (classT_P, s, GEN_TYPE_TMPL, gval) == ST_SYM_FOUND) 
    {
      sprintf (s1, "attempt to redefine class '%s'", s);
      ErrMsg (s1);
      free (gval.v);
      return;
    }
  return;
}


int
MergeClassTemplate (char *s, template_t *t1)
{
  template_t t2;
  t2 = GetClassTemplate (s);
  if (t2.def.move == TRUE)
    {
      t1->val.cmove |= (t2.val.cmove & CM_ALL_MV_FLAGS);
      t1->def.move = TRUE;
    }
  if (t2.def.special == TRUE)
    {
      t1->val.cmove |= (t2.val.cmove & CM_SPECIAL & CM_WIN);
      t1->def.special = TRUE;
    }
  if (t2.def.treasure == TRUE)
    {
      t1->val.cmove |= (t2.val.cmove & CM_TREASURE);
      t1->def.treasure = TRUE;
    }
  if (t2.def.spell == TRUE)
    {
      t1->val.spells = (t2.val.spells & CS_SPELLS & CS_FREQ);
      t1->def.spell = TRUE;
    }
  if (t2.def.breath == TRUE)
    {
      t1->val.spells |= (t2.val.spells & CS_BREATHE & CS_FREQ);
      t1->def.breath = TRUE;
    }
  if (t2.def.resist == TRUE)
    {
      t1->val.spells |= (t2.val.spells & CS_BREATHE);
      t1->def.resist = TRUE;
    }
  if (t2.def.defense == TRUE)
    {
      t1->val.cdefense |= t2.val.cdefense;
      t1->def.defense = TRUE;
    }
  if (t2.def.mexp == TRUE)
    {
      t1->val.mexp = t2.val.mexp;
      t1->def.mexp = TRUE;
    }
  if (t2.def.sleep == TRUE)
    {
      t1->val.sleep = t2.val.sleep;
      t1->def.sleep = TRUE;
    }
  if (t2.def.aaf == TRUE)
    {
      t1->val.aaf = t2.val.aaf;
      t1->def.aaf = TRUE;
    }
  if (t2.def.ac == TRUE)
    {
      t1->val.ac = t2.val.ac;
      t1->def.ac = TRUE;
    }
  if (t2.def.speed == TRUE)
    {
      t1->val.speed = t2.val.speed;
      t1->def.speed = TRUE;
    }
  if (t2.def.cchar == TRUE)
    {
      t1->val.cchar = t2.val.cchar;
      t1->def.cchar = TRUE;
    }
  if (t2.def.hd == TRUE)
    {
      t1->val.hd[0] = t2.val.hd[0];
      t1->val.hd[1] = t2.val.hd[1];
      t1->def.hd = TRUE;
    }
  if (t2.def.damage == TRUE)
    {
      int i, j;
      int t2attackcount;
      int found = 0;
      t2attackcount = FindAttackCount (t2.val.damage);
      for (i = 0; i < t2attackcount; i++)
	{
	  /* do i have this one already? */
	  for (j = 0; j < creatureAttacks; j++)
	    {
	      if (t1->val.damage[j] == t2.val.damage[i])
		{
		  found = 1;
		  break;
		}
	    }
	  /* no?  great. now add it to our attack list */
	  if (!found)
	    {
	      //add it, and increment.
	      if (creatureAttacks > 3) 
		{
		  ErrMsg ("creature limited to 4 attacks");
		  return -1;
		}
	      else
		{
		  creatureAttacks++;
		  t1->val.damage[creatureAttacks -1] = t2.val.damage[i];
		}
	      found = 0;
	    }
	}
      if (t2attackcount == 0)
	{
	  t1->val.damage[0] = 0;
	  creatureAttacks = 0;
	}
      t1->def.damage = TRUE;
    }
  if (t2.def.level == TRUE)
    {
      t1->val.level = t2.val.level;
      t1->def.level = TRUE;
    }

  return 0;
}

template_t 
GetClassTemplate (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (classT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "class '%s' undefined\n", s);
      ErrMsg (s1);
      return blankTemplate;
    } 
  else 
    {
      return *(template_t *) gval.v;
    }
  return blankTemplate;
}


void 
NotDefined(char *name, char *s)
{
  fprintf (arguments.mc.outfile, 
	   "Warning: %s not defined for \"%s\", line %d\n",
	   s, name, lineNo);
  return;
}


void 
PutCreature (char *s, template_t *tmpl_P, int consistency_check)
{
  static int idx;
  generic_t gval;
  char s1[256];

  gval.v = malloc (sizeof(template_t));
  *(template_t *) gval.v = *tmpl_P;

  if (!tmpl_P->def.move)
    NotDefined (tmpl_P->val.name, "MOVE");
  if (!tmpl_P->def.treasure)
    NotDefined (tmpl_P->val.name, "TREASURE");
  if (!tmpl_P->def.defense)
    NotDefined (tmpl_P->val.name, "DEFENSE");
  if (!tmpl_P->def.mexp)
    NotDefined (tmpl_P->val.name, "XP");
  if (!tmpl_P->def.sleep)
    NotDefined (tmpl_P->val.name, "SLEEP");
  if (!tmpl_P->def.aaf)
    NotDefined (tmpl_P->val.name, "RADIUS");
  if (!tmpl_P->def.ac)
    NotDefined (tmpl_P->val.name, "AC");
  if (!tmpl_P->def.speed)
    NotDefined (tmpl_P->val.name, "SPEED");
  if (!tmpl_P->def.cchar)
    NotDefined (tmpl_P->val.name, "CCHAR");
  if (!tmpl_P->def.hd)
    NotDefined (tmpl_P->val.name, "HD");
  if (!tmpl_P->def.damage)
    NotDefined (tmpl_P->val.name, "ATTACK");
  if (!tmpl_P->def.level)
    NotDefined (tmpl_P->val.name, "LEVEL");

  if (consistency_check)
    ConsistencyCheckCreature (&tmpl_P->val);

  (*(template_t *) gval.v).idx = idx;

  if (St_DefSym (creatureT_P, s, GEN_TYPE_TMPL, gval) == ST_SYM_FOUND) 
    {
      sprintf (s1, "attempt to redefine creature '%s'\n", s);
      ErrMsg (s1);
      free (gval.v);
      return;
    }

  if (tmpl_P->val.level > maxCreatureLevel)
    maxCreatureLevel = tmpl_P->val.level;

  idx++;
  return;
}

int 
compare_attacks(const void *lhs_attack, const void *rhs_attack)
{
  const int *lhs = lhs_attack;
  const int *rhs = rhs_attack;
  return ntohl(*lhs) - ntohl(*rhs);
}

void
SortAttacks ()
{
  int i = 0;
  int j = 0;
  for (i = 0; i < attackCt; i++) 
    sorted_attackList[i] = attackList[i];
  qsort (sorted_attackList, attackCt, sizeof (m_attack_type), compare_attacks);
int v = memcmp(attackList, sorted_attackList, attackCt * sizeof(m_attack_type));
  //now find the diffs.
  int diffs[MAX_ATTACK];
  memset (diffs, 0, sizeof (diffs));
  for (i = 0; i < attackCt; i++) 
    {
      m_attack_type attack = attackList[i];
      for (j = 0; j < attackCt; j++)
        {
          if (attack.attack_type == sorted_attackList[j].attack_type &&
              attack.attack_desc == sorted_attackList[j].attack_desc &&
              attack.attack_dice == sorted_attackList[j].attack_dice &&
              attack.attack_sides == sorted_attackList[j].attack_sides)
            {
              diffs[i] = j;
              break;
            }
        }
    }
  //now we change each of the creatures in order to point to their new attacks.
  char **s_A, **sp;
  int type;
  generic_t gval;

  s_A = St_SListTable (creatureT_P);

  for (i = 0; i < St_TableSize (creatureT_P); i++)
    {
      for (sp = s_A; *sp; sp++) 
	{
	  if (St_GetSym (creatureT_P, *sp, &type, &gval) != ST_SYM_FOUND) 
	    {
	      fprintf (stderr, "internal err. in WriteCreatures\n");
	      exit (1);
	    }
	  if ((*(template_t *) gval.v).idx == i) 
	    {
              creature_type *c = (creature_type*) &(*(template_t*)gval.v).val;
              for (j = 0; j < 4; j++)
                {
                  if (c->damage[j] == 0)
                    break;
                  c->damage[j] = diffs[c->damage[j]];
                }
	    }
	}
    }

  St_SListTable (NULL);
  for (i = 0; i < attackCt; i++) 
    attackList[i] = sorted_attackList[i];
}

void 
WriteAttacks ()
{
  int i;
  int record_count = 0;

  fprintf (arguments.mc.outfile, 
	   "struct m_attack_type monster_attacks[N_MONS_ATTS] = {\n");

  for (i = 0; i < attackCt; i++) 
    {

      if ((i % 4) == 0)
	{
	  if (i != 0)
	    fprintf (arguments.mc.outfile, "\n");
	  if ((record_count % 5) == 0)
	    fprintf (arguments.mc.outfile, "/*%3d */", i);
	  else
	    {
	      if (i > attackCt - 4)
		fprintf (arguments.mc.outfile, "/*%3d */", i);
	      else
		fprintf (arguments.mc.outfile, "        ");
	    }
	  record_count++;
	}

      fprintf (arguments.mc.outfile, "{%2d,%2d,%2d,%2d}", 
	       attackList[i].attack_type, attackList[i].attack_desc,
	       attackList[i].attack_dice, attackList[i].attack_sides);

      if (!(i == attackCt - 1))
	fprintf (arguments.mc.outfile, ",\t");

    };

  fprintf (arguments.mc.outfile, "\n};\n");
  return;
}

void 
WriteConstants ()
{
  fprintf (arguments.mc.outfile,
	   "\n#define MAX_CREATURES\t%d\n", St_TableSize (creatureT_P));
  fprintf (arguments.mc.outfile,
	   "#define N_MONS_ATTS\t%d\n\n", attackCt);
  return;
}

void WriteGenerationNotice()
{
  fprintf (arguments.mc.outfile,
	   "/* The following was generated by the %s monster compiler \n"
           "   (%s-mc %s) on %s. \n", 
           PACKAGE_NAME, GAME_NAME, VERSION, __DATE__);
  fprintf (arguments.mc.outfile,"\n\
   Copyright (c) 1989-94 James E. Wilson, Robert A. Koeneke\n\
   This program is free software; you can redistribute it and/or modify\n\
   it under the terms of the GNU General Public License as published by\n\
   the Free Software Foundation; either version 3 of the License, or\n\
   (at your option) any later version.\n\
   \n\
   This program is distributed in the hope that it will be useful,\n\
   but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
   GNU Library General Public License for more details.\n\
   \n\
   You should have received a copy of the GNU General Public License\n\
   along with this program; if not, write to the Free Software\n\
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n");
  fprintf (arguments.mc.outfile,
	   "*/\n\n");
  return;
}

int
mc_main (char *inputFilename)
{
  InitTables ();

  if (strcmp (inputFilename, "-") == 0)
    input_F = stdin;
  else
    {
      input_F = fopen (inputFilename, "r");
      if (!input_F) 
	{
	  fprintf (stderr, "Error: couldn't open file.\n");
	  return -1;
	}
    }

  if (yyparse ()) 
    {
      fprintf (stderr, "Errors prevent continuation.\n");
      return -2;
    }

  WriteGenerationNotice();
  if (arguments.mc.only_generate_constants)
    WriteConstants ();
  else
    {
      SortAttacks();
      WriteCreatures ();
      WriteAttacks ();
    }

  return 0;
}
