/* A Bison parser, made by GNU Bison 2.7.  */

/* Bison implementation for Yacc-like parsers in C
   
      Copyright (C) 1984, 1989-1990, 2000-2012 Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.7"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* Copy the first part of user declarations.  */
/* Line 371 of yacc.c  */
#line 21 "race-class.y"

#include "config.h"
#include <stdlib.h>
#include "argz.h"
#include "xvasprintf.h"
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <netinet/in.h>
#include <dirent.h>

#include "st.h"
#include "opts.h"
#include "race-class.h"
#include "rccheck.h"
#include "object_constant.h"




/*
 * defined_t is used to indicate whether all fields have been defined
 */

typedef struct {
    unsigned	age: 1,
		infra_vision: 1,
		male_height: 1,
		male_weight: 1,
		female_height: 1,
		female_weight: 1,
		hit_points: 1,
		disarming: 1,
		search_chance: 1,
		stealth_factor: 1,
		frequency_of_search: 1,
		base_to_hit: 1,
		base_to_hit_with_bows: 1,
		saving_throw: 1,
		strength_modifier: 1,
		intelligence_modifier: 1,
		wisdom_modifier: 1,
		dexterity_modifier: 1,
		constitution_modifier: 1,
		charisma_modifier: 1,
		experience_factor: 1,
		classes: 1,
		store_price_adjust_by_race: 1,
		shopkeep: 1,
		backgrounds: 1;
} race_defined_t;

typedef struct {
    unsigned    hit_points: 1,
		disarming: 1,
		search_chance: 1,
		stealth_factor: 1,
		frequency_of_search: 1,
		base_to_hit: 1,
		base_to_hit_with_bows: 1,
		saving_throw: 1,
		strength_modifier: 1,
		intelligence_modifier: 1,
		wisdom_modifier: 1,
		dexterity_modifier: 1,
		constitution_modifier: 1,
		charisma_modifier: 1,
		experience_factor: 1,
                adjust_base_to_hit: 1,
                adjust_base_to_hit_with_bows: 1,
                adjust_use_device: 1,
                adjust_disarming: 1,
                adjust_saving_throw: 1,
                titles: 1,
                spells: 1,
                prayers: 1;
} class_defined_t;

typedef struct {
    unsigned    store: 1,
                haggle_per: 1,
                inflate: 1,
                max_insults: 1,
                max_cost: 1;
} shopkeep_defined_t;

typedef struct {
    unsigned    roll: 1,
                social_class_bonus: 1;
} fragment_defined_t;

typedef struct {
    unsigned    adjust_base_to_hit: 1,
                adjust_base_to_hit_with_bows: 1,
                adjust_use_device: 1,
                adjust_disarming: 1,
                adjust_saving_throw: 1;
} adjust_per_one_third_level_defined_t;

typedef struct {
    unsigned    roll: 1,
                social_class_bonus: 1;
} background_defined_t;

typedef struct {
    unsigned    level: 1,
                mana: 1,
                fail: 1,
                exp: 1;
} spell_defined_t;

typedef struct
{
  char *race;
  int price;
} race_price_t;

typedef struct
{
  race_type r;
  race_price_t *price_adjust;
  int num_price_adjust;
  char *classes_argz;
  size_t classes_len;
  owner_type *shopkeeps;
  int num_shopkeeps;
  background_type *backgrounds;
  int num_backgrounds;
} race_t;

typedef struct
{
  int idx;
  race_t val;
  race_defined_t def;
  int line_no_for_classes;
  int line_no_for_price_adjust;
} race_template_t;


typedef struct
{
  int idx;
  spell_type s;
  int line_no;
} spell_t;

typedef struct
{
  class_type c;
  char *titles_argz;
  size_t titles_len;
  int adjust_per_one_third_level[MAX_LEV_ADJ];
  spell_t *spells;
  int num_spells;
  spell_t *prayers;
  int num_prayers;
} class_t;

typedef struct
{
  int idx;
  class_t val;
  class_defined_t def;
} class_template_t;

typedef struct
{
  owner_type val;
  shopkeep_defined_t def;
  int line_no;
} shopkeep_template_t;

typedef struct
{
  background_type val;
  background_defined_t def;
  int line_no;
} background_template_t;

typedef struct
{
  background_type val;
  fragment_defined_t def;
} fragment_template_t;

typedef struct
{
  spell_t val;
  spell_defined_t def;
} spell_template_t;

/*
 * symInit_t is used to initialize symbol tables with integer values
 */

typedef struct 
{
  char *name;
  int32u val;
} symInit_t;



/*
 * Maximum token length = maximum string constant length
 * Also, trim the stack to an "acceptable" size.
 */

#define	MAX_TOK_LEN	64		/* maximum acceptable token length  */
#define	YYSTACKSIZE	128

#define GEN_TYPE_TMPL	256		/* type of a template for st	    */

/*
 * Globals used by the tokenizer (lexical analyzer)
 */

#define INPUT_BUF_SIZE 256
static char	inputBuf[INPUT_BUF_SIZE] = { 0 };
					/* input line buffer		    */
static char	*inputBufp = inputBuf;	/* position in input line buffer    */
static int	lineNo = 0;		/* number of current line	    */
static FILE	*input_F;
static char	tokStr[MAX_TOK_LEN];	/* text of current token	    */
static	int	tokType;		/* type of current token	    */

static race_template_t blankRace;	/* blank race for init-ing     */
static race_template_t tmpRace;		/* working race for current race   */

static class_template_t blankClass;	/* blank class for init-ing     */
static class_template_t tmpClass;	/* working class for current class */

static shopkeep_template_t blankShopkeep;
static shopkeep_template_t tmpShopkeep;
static fragment_template_t blankFragment;
static fragment_template_t tmpFragment;

int num_shopkeeps;
int *experience_levels;
int num_experience_levels;
background_template_t tmpBackground;
background_template_t blankBackground;
spell_template_t tmpSpell;
spell_template_t blankSpell;
spell_template_t tmpPrayer;
spell_template_t blankPrayer;

/*
 * Global symbol tables
 */

static st_Table_Pt keywordT_P;		/* parser's keywords		    */
static st_Table_Pt spellsT_P;		/* spells that go in books	    */
static st_Table_Pt prayersT_P;		/* prayers that go in books	    */
static st_Table_Pt raceT_P;		/* race definitions		    */
static st_Table_Pt classT_P;		/* class definitions */

static symInit_t
spellsInit[] = 
{
    { "magic_missile", 0},
    { "detect_monsters", 1},
    { "phase_door", 2},
    { "light_area", 3},
    { "cure_light_wounds", 4},
    { "find_hidden_traps_and_doors", 5},
    { "stinking_cloud", 6},
    { "confusion", 7},
    { "lightning_bolt", 8},
    { "trap_and_door_destruction", 9},
    { "sleep_i", 10},
    { "cure_poison", 11},
    { "teleport_self", 12},
    { "remove_curse", 13},
    { "frost_bolt", 14},
    { "turn_stone_to_mud", 15},
    { "create_food", 16},
    { "recharge_item_i", 17},
    { "sleep_ii", 18},
    { "polymorph_other", 19},
    { "identify", 20},
    { "sleep_iii", 21},
    { "fire_bolt", 22},
    { "slow_monster", 23},
    { "frost_ball", 24},
    { "recharge_item_ii", 25},
    { "teleport_other", 26},
    { "haste_self", 27},
    { "fire_ball", 28},
    { "word_of_destruction", 29},
    { "genocide", 30},
    { NULL, 0 },
};

static symInit_t
prayersInit[] = 
{
    { "detect_evil", 0},
    { "cure_light_wounds", 1},
    { "bless", 2},
    { "remove_fear", 3},
    { "call_light", 4},
    { "find_traps", 5},
    { "detect_doors_and_stairs", 6},
    { "slow_poison", 7},
    { "blind_creature", 8},
    { "portal", 9},
    { "cure_medium_wounds", 10},
    { "chant", 11},
    { "sanctuary", 12},
    { "create_food", 13},
    { "remove_curse", 14},
    { "resist_heat_and_cold", 15},
    { "neutralize_poison", 16},
    { "orb_of_draining", 17},
    { "cure_serious_wounds", 18},
    { "sense_invisible", 19},
    { "protection_from_evil", 20},
    { "earthquake", 21},
    { "sense_surroundings", 22},
    { "cure_critical_wounds", 23},
    { "turn_undead", 24},
    { "pray_prayer", 25},
    { "dispel_undead", 26},
    { "heal", 27},
    { "dispel_evil", 28},
    { "glyph_of_warding", 29},
    { "holy_word", 30},
    { NULL, 0 },
};
/*
 * Function declarations
 */

void PutRace (char *s, race_template_t *tmpl_P, int consistency_check);
void PutShopkeep(shopkeep_template_t *tmpl_P, int consistency_check);
void PutBackground(background_template_t *tmpl_P, int consistency_check);
void PutSpell (char *s, spell_template_t *tmpl_P, int consistency_check);
void PutPrayer (char *s, spell_template_t *tmpl_P, int consistency_check);
void CheckBackground (int chart, int next);
void PutClass (char *s, class_template_t *tmpl_P, int consistency_check);

int yyerror (char *s);


/* Line 371 of yacc.c  */
#line 416 "race-class.c"

# ifndef YY_NULL
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULL nullptr
#  else
#   define YY_NULL 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     RACE = 258,
     CLASS = 259,
     EXPERIENCE_LEVELS = 260,
     AGE = 261,
     MALE_HEIGHT = 262,
     MALE_WEIGHT = 263,
     FEMALE_HEIGHT = 264,
     FEMALE_WEIGHT = 265,
     INFRA_VISION = 266,
     ATTRIBUTES = 267,
     HIT_POINTS = 268,
     DISARMING = 269,
     SEARCH_CHANCE = 270,
     STEALTH_FACTOR = 271,
     FREQUENCY_OF_SEARCH = 272,
     BASE_TO_HIT = 273,
     BASE_TO_HIT_WITH_BOWS = 274,
     SAVING_THROW = 275,
     STRENGTH_MODIFIER = 276,
     INTELLIGENCE_MODIFIER = 277,
     WISDOM_MODIFIER = 278,
     DEXTERITY_MODIFIER = 279,
     CONSTITUTION_MODIFIER = 280,
     CHARISMA_MODIFIER = 281,
     EXPERIENCE_FACTOR = 282,
     CLASSES = 283,
     STORE_PRICE_ADJUST_BY_RACE = 284,
     SHOPKEEP = 285,
     STORE = 286,
     HAGGLE_PER = 287,
     INFLATE = 288,
     MAX_INSULTS = 289,
     MAX_COST = 290,
     BACKGROUNDS = 291,
     BACKGROUND = 292,
     FRAGMENT = 293,
     ROLL = 294,
     SOCIAL_CLASS_BONUS = 295,
     ADJUST_PER_ONE_THIRD_LEVEL = 296,
     TITLES = 297,
     SPELLS = 298,
     SPELL = 299,
     LEVEL = 300,
     MANA = 301,
     FAIL = 302,
     EXP = 303,
     PRAYERS = 304,
     PRAYER = 305,
     ADJUST_BASE_TO_HIT = 306,
     ADJUST_BASE_TO_HIT_WITH_BOWS = 307,
     ADJUST_USE_DEVICE = 308,
     ADJUST_DISARMING = 309,
     ADJUST_SAVING_THROW = 310,
     IDENTIFIER = 311,
     FLOAT_LIT = 312,
     INT_LIT = 313,
     STRING_LIT = 314,
     BOOL_LIT = 315
   };
#endif
/* Tokens.  */
#define RACE 258
#define CLASS 259
#define EXPERIENCE_LEVELS 260
#define AGE 261
#define MALE_HEIGHT 262
#define MALE_WEIGHT 263
#define FEMALE_HEIGHT 264
#define FEMALE_WEIGHT 265
#define INFRA_VISION 266
#define ATTRIBUTES 267
#define HIT_POINTS 268
#define DISARMING 269
#define SEARCH_CHANCE 270
#define STEALTH_FACTOR 271
#define FREQUENCY_OF_SEARCH 272
#define BASE_TO_HIT 273
#define BASE_TO_HIT_WITH_BOWS 274
#define SAVING_THROW 275
#define STRENGTH_MODIFIER 276
#define INTELLIGENCE_MODIFIER 277
#define WISDOM_MODIFIER 278
#define DEXTERITY_MODIFIER 279
#define CONSTITUTION_MODIFIER 280
#define CHARISMA_MODIFIER 281
#define EXPERIENCE_FACTOR 282
#define CLASSES 283
#define STORE_PRICE_ADJUST_BY_RACE 284
#define SHOPKEEP 285
#define STORE 286
#define HAGGLE_PER 287
#define INFLATE 288
#define MAX_INSULTS 289
#define MAX_COST 290
#define BACKGROUNDS 291
#define BACKGROUND 292
#define FRAGMENT 293
#define ROLL 294
#define SOCIAL_CLASS_BONUS 295
#define ADJUST_PER_ONE_THIRD_LEVEL 296
#define TITLES 297
#define SPELLS 298
#define SPELL 299
#define LEVEL 300
#define MANA 301
#define FAIL 302
#define EXP 303
#define PRAYERS 304
#define PRAYER 305
#define ADJUST_BASE_TO_HIT 306
#define ADJUST_BASE_TO_HIT_WITH_BOWS 307
#define ADJUST_USE_DEVICE 308
#define ADJUST_DISARMING 309
#define ADJUST_SAVING_THROW 310
#define IDENTIFIER 311
#define FLOAT_LIT 312
#define INT_LIT 313
#define STRING_LIT 314
#define BOOL_LIT 315



#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{
/* Line 387 of yacc.c  */
#line 378 "race-class.y"

	int ival;
	double dval;
	char sval[MAX_TOK_LEN];
	

/* Line 387 of yacc.c  */
#line 583 "race-class.c"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif

extern YYSTYPE yylval;

#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* Copy the second part of user declarations.  */
/* Line 390 of yacc.c  */
#line 400 "race-class.y"

static symInit_t 
keywordInit[] = 
{
    { "race", RACE},
    { "class", CLASS},
    { "experience_levels", EXPERIENCE_LEVELS},
    { "age", AGE},
    { "male_height", MALE_HEIGHT},
    { "male_weight", MALE_WEIGHT},
    { "female_height", FEMALE_HEIGHT},
    { "female_weight", FEMALE_WEIGHT},
    { "infra_vision", INFRA_VISION},
    { "attributes", ATTRIBUTES},
    { "hit_points", HIT_POINTS},
    { "disarming", DISARMING},
    { "search_chance", SEARCH_CHANCE},
    { "stealth_factor", STEALTH_FACTOR},
    { "frequency_of_search", FREQUENCY_OF_SEARCH},
    { "base_to_hit", BASE_TO_HIT},
    { "base_to_hit_with_bows", BASE_TO_HIT_WITH_BOWS},
    { "saving_throw", SAVING_THROW},
    { "strength_modifier", STRENGTH_MODIFIER},
    { "intelligence_modifier", INTELLIGENCE_MODIFIER},
    { "wisdom_modifier", WISDOM_MODIFIER},
    { "dexterity_modifier", DEXTERITY_MODIFIER},
    { "constitution_modifier", CONSTITUTION_MODIFIER},
    { "charisma_modifier", CHARISMA_MODIFIER},
    { "experience_factor", EXPERIENCE_FACTOR},
    { "classes", CLASSES},
    { "store_price_adjust_by_race", STORE_PRICE_ADJUST_BY_RACE},
    { "shopkeep", SHOPKEEP},
    { "store", STORE},
    { "haggle_per", HAGGLE_PER},
    { "inflate", INFLATE},
    { "max_insults", MAX_INSULTS},
    { "max_cost", MAX_COST},
    { "backgrounds", BACKGROUNDS},
    { "background", BACKGROUND},
    { "fragment", FRAGMENT},
    { "roll", ROLL},
    { "social_class_bonus", SOCIAL_CLASS_BONUS},
    { "adjust_per_one_third_level", ADJUST_PER_ONE_THIRD_LEVEL},
    { "titles", TITLES},
    { "spells", SPELLS},
    { "spell", SPELL},
    { "level", LEVEL},
    { "mana", MANA},
    { "fail", FAIL},
    { "exp", EXP},
    { "prayers", PRAYERS},
    { "prayer", PRAYER},
    { "adjust_base_to_hit", ADJUST_BASE_TO_HIT},
    { "adjust_base_to_hit_with_bows", ADJUST_BASE_TO_HIT_WITH_BOWS},
    { "adjust_use_device", ADJUST_USE_DEVICE},
    { "adjust_disarming", ADJUST_DISARMING},
    { "adjust_saving_throw", ADJUST_SAVING_THROW},
    { NULL, 0 }
};

/* Line 390 of yacc.c  */
#line 672 "race-class.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(N) (N)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (YYID (0))
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  16
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   318

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  68
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  60
/* YYNRULES -- Number of rules.  */
#define YYNRULES  137
/* YYNRULES -- Number of states.  */
#define YYNSTATES  378

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   315

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,    62,     2,     2,     2,     2,
       2,     2,     2,     2,    67,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    65,    61,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    63,    66,    64,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     7,    11,    15,    18,    19,    22,    25,
      27,    30,    31,    37,    43,    47,    51,    55,    59,    63,
      64,    70,    74,    80,    86,    92,    98,   102,   106,   110,
     114,   118,   122,   126,   130,   134,   138,   142,   146,   150,
     154,   158,   163,   166,   168,   172,   173,   178,   182,   186,
     190,   191,   199,   203,   207,   208,   212,   216,   222,   226,
     230,   235,   238,   245,   249,   250,   253,   259,   263,   264,
     268,   272,   276,   280,   281,   285,   289,   293,   297,   301,
     302,   306,   310,   314,   318,   322,   326,   330,   334,   338,
     342,   346,   350,   354,   358,   362,   367,   371,   375,   376,
     380,   384,   388,   392,   396,   401,   404,   406,   410,   411,
     416,   419,   423,   424,   430,   434,   438,   439,   443,   447,
     451,   455,   460,   463,   467,   468,   474,   478,   482,   483,
     487,   491,   495,   499,   504,   507,   509,   513
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int8 yyrhs[] =
{
      69,     0,    -1,    74,    61,    69,    -1,    75,    61,    69,
      -1,   124,    61,    69,    -1,    70,    69,    -1,    -1,    62,
      71,    -1,    72,    73,    -1,    56,    -1,    72,    73,    -1,
      -1,     3,    59,    63,    76,    64,    -1,     4,    59,    63,
     100,    64,    -1,    77,    61,    76,    -1,    78,    61,    76,
      -1,    82,    61,    76,    -1,    86,    61,    76,    -1,    90,
      61,    76,    -1,    -1,     6,    65,    58,    66,    58,    -1,
      11,    65,    58,    -1,     7,    65,    58,    66,    58,    -1,
       8,    65,    58,    66,    58,    -1,     9,    65,    58,    66,
      58,    -1,    10,    65,    58,    66,    58,    -1,    13,    65,
      58,    -1,    14,    65,    58,    -1,    15,    65,    58,    -1,
      16,    65,    58,    -1,    17,    65,    58,    -1,    18,    65,
      58,    -1,    19,    65,    58,    -1,    20,    65,    58,    -1,
      21,    65,    58,    -1,    22,    65,    58,    -1,    23,    65,
      58,    -1,    24,    65,    58,    -1,    25,    65,    58,    -1,
      26,    65,    58,    -1,    27,    65,    58,    -1,    28,    63,
      79,    64,    -1,    80,    81,    -1,    59,    -1,    67,    80,
      81,    -1,    -1,    29,    63,    83,    64,    -1,    84,    61,
      85,    -1,    59,    65,    58,    -1,    84,    61,    85,    -1,
      -1,    30,    59,    59,    59,    63,    87,    64,    -1,    89,
      61,    88,    -1,    89,    61,    88,    -1,    -1,    31,    65,
      59,    -1,    32,    65,    58,    -1,    33,    65,    58,    66,
      58,    -1,    34,    65,    58,    -1,    35,    65,    58,    -1,
      36,    63,    91,    64,    -1,    92,    93,    -1,    37,    58,
      58,    63,    94,    64,    -1,    67,    92,    93,    -1,    -1,
      95,    96,    -1,    38,    59,    63,    97,    64,    -1,    67,
      95,    96,    -1,    -1,    98,    61,    99,    -1,    39,    65,
      58,    -1,    40,    65,    58,    -1,    98,    61,    99,    -1,
      -1,   101,    61,   100,    -1,   102,    61,   100,    -1,   106,
      61,   100,    -1,   110,    61,   100,    -1,   117,    61,   100,
      -1,    -1,    13,    65,    58,    -1,    14,    65,    58,    -1,
      15,    65,    58,    -1,    16,    65,    58,    -1,    17,    65,
      58,    -1,    18,    65,    58,    -1,    19,    65,    58,    -1,
      20,    65,    58,    -1,    21,    65,    58,    -1,    22,    65,
      58,    -1,    23,    65,    58,    -1,    24,    65,    58,    -1,
      25,    65,    58,    -1,    26,    65,    58,    -1,    27,    65,
      58,    -1,    41,    63,   103,    64,    -1,   105,    61,   104,
      -1,   105,    61,   104,    -1,    -1,    51,    65,    58,    -1,
      52,    65,    58,    -1,    53,    65,    58,    -1,    54,    65,
      58,    -1,    55,    65,    58,    -1,    42,    63,   107,    64,
      -1,   108,   109,    -1,    59,    -1,    67,   108,   109,    -1,
      -1,    43,    63,   111,    64,    -1,   113,   112,    -1,    67,
     113,   112,    -1,    -1,    44,    56,    63,   114,    64,    -1,
     116,    61,   115,    -1,   116,    61,   115,    -1,    -1,    45,
      65,    58,    -1,    46,    65,    58,    -1,    47,    65,    58,
      -1,    48,    65,    58,    -1,    49,    63,   118,    64,    -1,
     120,   119,    -1,    67,   120,   119,    -1,    -1,    50,    56,
      63,   121,    64,    -1,   123,    61,   122,    -1,   123,    61,
     122,    -1,    -1,    45,    65,    58,    -1,    46,    65,    58,
      -1,    47,    65,    58,    -1,    48,    65,    58,    -1,     5,
      63,   125,    64,    -1,   126,   127,    -1,    58,    -1,    67,
     126,   127,    -1,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,   484,   484,   485,   486,   487,   488,   491,   495,   498,
     502,   503,   506,   517,   528,   529,   530,   531,   532,   533,
     536,   540,   543,   547,   551,   555,   559,   562,   565,   568,
     571,   574,   577,   580,   583,   586,   589,   592,   595,   598,
     601,   606,   612,   615,   620,   621,   624,   629,   632,   666,
     667,   670,   687,   690,   691,   694,   705,   708,   713,   716,
     721,   725,   728,   742,   743,   746,   749,   757,   758,   761,
     764,   770,   775,   776,   779,   780,   781,   782,   783,   784,
     787,   790,   793,   796,   799,   802,   805,   808,   811,   814,
     817,   820,   823,   826,   829,   834,   837,   840,   841,   844,
     848,   852,   856,   860,   866,   870,   873,   897,   898,   901,
     904,   907,   908,   911,   917,   920,   921,   924,   927,   930,
     933,   938,   941,   944,   945,   948,   954,   957,   958,   961,
     964,   967,   970,   975,   978,   981,  1002,  1003
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "RACE", "CLASS", "EXPERIENCE_LEVELS",
  "AGE", "MALE_HEIGHT", "MALE_WEIGHT", "FEMALE_HEIGHT", "FEMALE_WEIGHT",
  "INFRA_VISION", "ATTRIBUTES", "HIT_POINTS", "DISARMING", "SEARCH_CHANCE",
  "STEALTH_FACTOR", "FREQUENCY_OF_SEARCH", "BASE_TO_HIT",
  "BASE_TO_HIT_WITH_BOWS", "SAVING_THROW", "STRENGTH_MODIFIER",
  "INTELLIGENCE_MODIFIER", "WISDOM_MODIFIER", "DEXTERITY_MODIFIER",
  "CONSTITUTION_MODIFIER", "CHARISMA_MODIFIER", "EXPERIENCE_FACTOR",
  "CLASSES", "STORE_PRICE_ADJUST_BY_RACE", "SHOPKEEP", "STORE",
  "HAGGLE_PER", "INFLATE", "MAX_INSULTS", "MAX_COST", "BACKGROUNDS",
  "BACKGROUND", "FRAGMENT", "ROLL", "SOCIAL_CLASS_BONUS",
  "ADJUST_PER_ONE_THIRD_LEVEL", "TITLES", "SPELLS", "SPELL", "LEVEL",
  "MANA", "FAIL", "EXP", "PRAYERS", "PRAYER", "ADJUST_BASE_TO_HIT",
  "ADJUST_BASE_TO_HIT_WITH_BOWS", "ADJUST_USE_DEVICE", "ADJUST_DISARMING",
  "ADJUST_SAVING_THROW", "IDENTIFIER", "FLOAT_LIT", "INT_LIT",
  "STRING_LIT", "BOOL_LIT", "';'", "'#'", "'{'", "'}'", "':'", "'|'",
  "','", "$accept", "race_and_class", "comment_def", "comments", "comment",
  "more_comments", "race_def", "class_def", "race_attributes",
  "race_attribute", "classes_def", "ok_classes", "ok_class",
  "more_ok_classes", "price_race_adj", "race_prices", "race_price",
  "more_race_prices", "shopkeep_def", "shopkeep_attrs", "more_shop_attrs",
  "shopkeep_attr", "backgrounds_def", "backgrounds", "background",
  "more_backgrounds", "fragments", "fragment", "more_fragments",
  "frag_attrs", "frag_attr", "more_frag_attrs", "class_attributes",
  "class_attribute", "adjust_per_lev", "adj_attrs", "more_adj_attrs",
  "adj_attr", "titles_def", "titles", "title", "more_titles", "spells_def",
  "spells", "more_spells", "spell", "spell_attrs", "more_spell_attrs",
  "spell_attr", "prayers_def", "prayers", "more_prayers", "prayer",
  "prayer_attrs", "more_prayer_attrs", "prayer_attr", "exp_levels_def",
  "exp_levels", "exp_level", "more_exp_levels", YY_NULL
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,    59,    35,   123,   125,    58,   124,    44
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    68,    69,    69,    69,    69,    69,    70,    71,    72,
      73,    73,    74,    75,    76,    76,    76,    76,    76,    76,
      77,    77,    77,    77,    77,    77,    77,    77,    77,    77,
      77,    77,    77,    77,    77,    77,    77,    77,    77,    77,
      77,    78,    79,    80,    81,    81,    82,    83,    84,    85,
      85,    86,    87,    88,    88,    89,    89,    89,    89,    89,
      90,    91,    92,    93,    93,    94,    95,    96,    96,    97,
      98,    98,    99,    99,   100,   100,   100,   100,   100,   100,
     101,   101,   101,   101,   101,   101,   101,   101,   101,   101,
     101,   101,   101,   101,   101,   102,   103,   104,   104,   105,
     105,   105,   105,   105,   106,   107,   108,   109,   109,   110,
     111,   112,   112,   113,   114,   115,   115,   116,   116,   116,
     116,   117,   118,   119,   119,   120,   121,   122,   122,   123,
     123,   123,   123,   124,   125,   126,   127,   127
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     3,     3,     3,     2,     0,     2,     2,     1,
       2,     0,     5,     5,     3,     3,     3,     3,     3,     0,
       5,     3,     5,     5,     5,     5,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     4,     2,     1,     3,     0,     4,     3,     3,     3,
       0,     7,     3,     3,     0,     3,     3,     5,     3,     3,
       4,     2,     6,     3,     0,     2,     5,     3,     0,     3,
       3,     3,     3,     0,     3,     3,     3,     3,     3,     0,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     4,     3,     3,     0,     3,
       3,     3,     3,     3,     4,     2,     1,     3,     0,     4,
       2,     3,     0,     5,     3,     3,     0,     3,     3,     3,
       3,     4,     2,     3,     0,     5,     3,     3,     0,     3,
       3,     3,     3,     4,     2,     1,     3,     0
};

/* YYDEFACT[STATE-NAME] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       6,     0,     0,     0,     0,     0,     6,     0,     0,     0,
       0,     0,     0,     9,     7,    11,     1,     5,     6,     6,
       6,    19,    79,   135,     0,   137,    11,     8,     2,     3,
       4,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   133,     0,   134,
      10,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    12,    19,    19,    19,
      19,    19,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    13,    79,    79,    79,    79,    79,   137,     0,     0,
       0,     0,     0,    21,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    43,
       0,    45,     0,     0,     0,     0,     0,     0,    64,    14,
      15,    16,    17,    18,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,     0,
       0,     0,     0,     0,     0,     0,   106,     0,   108,     0,
       0,   112,     0,     0,   124,    74,    75,    76,    77,    78,
     136,     0,     0,     0,     0,     0,    41,     0,    42,     0,
      46,    50,     0,     0,    60,     0,    61,     0,     0,     0,
       0,     0,    95,    98,   104,     0,   105,     0,   109,     0,
     110,     0,   121,     0,   122,    20,    22,    23,    24,    25,
      45,    48,     0,    47,     0,     0,    64,    99,   100,   101,
     102,   103,    96,     0,   108,     0,   112,     0,   124,    44,
      50,     0,     0,     0,     0,     0,     0,     0,     0,    63,
      98,   107,     0,     0,     0,     0,     0,     0,   111,     0,
       0,     0,     0,     0,     0,   123,    49,     0,     0,     0,
       0,     0,    51,    54,     0,     0,    68,    97,     0,     0,
       0,     0,   113,   116,     0,     0,     0,     0,   125,   128,
      55,    56,     0,    58,    59,    52,     0,     0,    62,     0,
      65,   117,   118,   119,   120,   114,     0,   129,   130,   131,
     132,   126,     0,     0,    54,     0,    68,   116,   128,    57,
      53,     0,     0,     0,     0,    67,   115,   127,     0,     0,
      66,    73,    70,    71,     0,    69,    73,    72
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     5,     6,    14,    26,    27,     7,     8,    56,    57,
      58,   170,   171,   228,    59,   173,   262,   263,    60,   286,
     335,   336,    61,   177,   178,   236,   315,   316,   340,   363,
     374,   375,    81,    82,    83,   204,   272,   273,    84,   207,
     208,   246,    85,   210,   250,   211,   296,   345,   346,    86,
     213,   254,   214,   303,   351,   352,     9,    24,    25,    89
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -174
static const yytype_int16 yypact[] =
{
      -3,   -29,   -22,   -25,    -6,    51,    -3,    -9,    27,    28,
      29,    30,    32,  -174,  -174,    -6,  -174,  -174,    -3,    -3,
      -3,    47,   -10,  -174,    31,    24,    -6,  -174,  -174,  -174,
    -174,    33,    34,    35,    36,    37,    38,    40,    41,    42,
      43,    44,    45,    46,    48,    49,    50,    52,    53,    54,
      55,    56,    59,    60,    57,    61,    62,    64,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    87,    88,    89,
      90,    91,    93,    95,    96,    97,    98,  -174,    32,  -174,
    -174,   102,   103,   104,   105,   106,   107,   108,   109,   110,
     111,   112,   113,   114,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   124,   125,    94,  -174,    47,    47,    47,
      47,    47,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   -28,   142,   156,
     152,  -174,   -10,   -10,   -10,   -10,   -10,    24,   143,   144,
     145,   146,   147,  -174,  -174,  -174,  -174,  -174,  -174,  -174,
    -174,  -174,  -174,  -174,  -174,  -174,  -174,  -174,  -174,  -174,
     150,    65,   151,   153,   154,   148,   160,   155,   157,  -174,
    -174,  -174,  -174,  -174,  -174,  -174,  -174,  -174,  -174,  -174,
    -174,  -174,  -174,  -174,  -174,  -174,  -174,  -174,  -174,   158,
     161,   162,   163,   164,   166,   159,  -174,   167,   165,   149,
     169,   168,   178,   172,   170,  -174,  -174,  -174,  -174,  -174,
    -174,   180,   181,   182,   183,   184,  -174,   123,  -174,   185,
    -174,   124,   186,   187,  -174,    94,  -174,   188,   189,   190,
     192,   193,  -174,   -28,  -174,   142,  -174,   191,  -174,   156,
    -174,   194,  -174,   152,  -174,  -174,  -174,  -174,  -174,  -174,
      65,  -174,   195,  -174,     9,   196,   157,  -174,  -174,  -174,
    -174,  -174,  -174,   197,   165,   -27,   168,    39,   170,  -174,
     124,   179,   198,   199,   200,   201,   203,   207,    58,  -174,
     -28,  -174,   204,   205,   206,   208,   210,   211,  -174,   212,
     213,   214,   215,   217,   221,  -174,  -174,   202,   218,   225,
     226,   227,  -174,     9,   216,   222,   220,  -174,   230,   231,
     232,   233,  -174,   -27,   234,   235,   236,   237,  -174,    39,
    -174,  -174,   238,  -174,  -174,  -174,   239,   240,  -174,    58,
    -174,  -174,  -174,  -174,  -174,  -174,   241,  -174,  -174,  -174,
    -174,  -174,   244,   243,     9,   -11,   220,   -27,    39,  -174,
    -174,   242,   245,   247,   248,  -174,  -174,  -174,   250,   254,
    -174,   -11,  -174,  -174,   252,  -174,   -11,  -174
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -174,    16,  -174,  -174,   100,    86,  -174,  -174,   -72,  -174,
    -174,  -174,  -133,  -163,  -174,  -174,    20,  -146,  -174,  -174,
    -173,   -61,  -174,  -174,   -31,   -60,  -174,  -131,  -135,  -174,
    -130,  -154,   -64,  -174,  -174,  -174,   -38,   177,  -174,  -174,
       8,   -19,  -174,  -174,   -16,    13,  -174,   -59,    21,  -174,
    -174,    19,    63,  -174,   -52,    22,  -174,  -174,   229,   171
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const yytype_uint16 yytable[] =
{
       1,     2,     3,    62,    63,    64,    65,    66,    67,    68,
      69,    70,    71,    72,    73,    74,    75,    76,   292,   293,
     294,   295,    17,   199,   200,   201,   202,   203,   361,   362,
      10,    77,    78,    79,    28,    29,    30,    11,    12,    80,
     281,   282,   283,   284,   285,   179,   180,   181,   182,   183,
      13,    16,    18,    31,    32,    33,    34,    35,    36,     4,
      37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    48,    49,    50,    51,    52,    53,    54,   215,   216,
     217,   218,   219,    55,   299,   300,   301,   302,    19,    20,
      23,    88,    21,    22,   260,    87,   314,   279,    91,    92,
      93,    94,    95,    96,    15,    97,    98,    99,   100,   101,
     102,   103,    90,   104,   105,   106,   114,   107,   108,   109,
     110,   111,   112,   113,   115,   117,   116,   118,   119,   120,
     121,   176,   227,   174,   306,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,   136,
     137,   138,   139,   140,   142,   141,   143,   144,   145,   146,
     148,   149,   150,   151,   152,   153,   154,   155,   156,   157,
     158,   159,   160,   161,   162,   163,   164,   165,   166,   167,
     168,   360,   169,   172,   175,   184,   185,   186,   187,   188,
     189,   190,   191,   192,   193,   194,   195,   196,   197,   198,
     209,   206,   212,   287,   266,   247,   289,   232,   356,   221,
     222,   223,   224,   225,   226,   231,   229,   230,   233,   234,
     243,   365,   377,   237,   235,   364,   238,   239,   240,   241,
     242,   244,   245,   248,   251,   249,   252,   253,   255,   256,
     257,   258,   259,   261,   307,   265,   267,   268,   269,   264,
     270,   271,   317,   274,   275,   291,   280,   277,   290,   288,
     298,   330,   276,   308,   309,   310,   311,   312,   313,   318,
     319,   320,   323,   321,   322,   337,   331,   324,   325,   326,
     327,   328,   329,   332,   333,   334,   338,   339,   341,   342,
     343,   344,   347,   348,   349,   350,   297,   305,   366,   304,
     354,   359,   357,   355,   353,   358,   367,   368,   372,   371,
     369,   370,   373,   376,   205,     0,   278,   147,   220
};

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-174)))

#define yytable_value_is_error(Yytable_value) \
  YYID (0)

static const yytype_int16 yycheck[] =
{
       3,     4,     5,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    45,    46,
      47,    48,     6,    51,    52,    53,    54,    55,    39,    40,
      59,    41,    42,    43,    18,    19,    20,    59,    63,    49,
      31,    32,    33,    34,    35,   117,   118,   119,   120,   121,
      56,     0,    61,     6,     7,     8,     9,    10,    11,    62,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,   142,   143,
     144,   145,   146,    36,    45,    46,    47,    48,    61,    61,
      58,    67,    63,    63,   227,    64,    38,   260,    65,    65,
      65,    65,    65,    65,     4,    65,    65,    65,    65,    65,
      65,    65,    26,    65,    65,    65,    59,    65,    65,    65,
      65,    65,    63,    63,    63,    61,    64,    61,    61,    61,
      61,    37,    67,   113,   280,    65,    65,    65,    65,    65,
      65,    65,    65,    65,    65,    65,    65,    65,    65,    65,
      63,    63,    63,    63,    61,    64,    61,    61,    61,    61,
      58,    58,    58,    58,    58,    58,    58,    58,    58,    58,
      58,    58,    58,    58,    58,    58,    58,    58,    58,    58,
      58,   354,    59,    59,    59,    58,    58,    58,    58,    58,
      58,    58,    58,    58,    58,    58,    58,    58,    58,    58,
      44,    59,    50,   264,   235,    56,   266,    59,   339,    66,
      66,    66,    66,    66,    64,    61,    65,    64,    58,    64,
      61,   356,   376,    65,    67,   355,    65,    65,    65,    65,
      64,    64,    67,    64,    56,    67,    64,    67,    58,    58,
      58,    58,    58,    58,    65,    58,    58,    58,    58,    63,
      58,    58,   290,   245,    63,   274,    61,    63,    61,    63,
     276,    59,   249,    65,    65,    65,    65,    64,    61,    65,
      65,    65,    61,    65,    64,    59,    58,    65,    65,    65,
      65,    64,    61,    58,    58,    58,    64,    67,    58,    58,
      58,    58,    58,    58,    58,    58,   275,   278,   357,   277,
      61,    58,    61,    63,    66,    61,   358,    65,    58,    61,
      65,    64,    58,    61,   137,    -1,   253,    88,   147
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     3,     4,     5,    62,    69,    70,    74,    75,   124,
      59,    59,    63,    56,    71,    72,     0,    69,    61,    61,
      61,    63,    63,    58,   125,   126,    72,    73,    69,    69,
      69,     6,     7,     8,     9,    10,    11,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    36,    76,    77,    78,    82,
      86,    90,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    41,    42,    43,
      49,   100,   101,   102,   106,   110,   117,    64,    67,   127,
      73,    65,    65,    65,    65,    65,    65,    65,    65,    65,
      65,    65,    65,    65,    65,    65,    65,    65,    65,    65,
      65,    65,    63,    63,    59,    63,    64,    61,    61,    61,
      61,    61,    65,    65,    65,    65,    65,    65,    65,    65,
      65,    65,    65,    65,    65,    65,    65,    63,    63,    63,
      63,    64,    61,    61,    61,    61,    61,   126,    58,    58,
      58,    58,    58,    58,    58,    58,    58,    58,    58,    58,
      58,    58,    58,    58,    58,    58,    58,    58,    58,    59,
      79,    80,    59,    83,    84,    59,    37,    91,    92,    76,
      76,    76,    76,    76,    58,    58,    58,    58,    58,    58,
      58,    58,    58,    58,    58,    58,    58,    58,    58,    51,
      52,    53,    54,    55,   103,   105,    59,   107,   108,    44,
     111,   113,    50,   118,   120,   100,   100,   100,   100,   100,
     127,    66,    66,    66,    66,    66,    64,    67,    81,    65,
      64,    61,    59,    58,    64,    67,    93,    65,    65,    65,
      65,    65,    64,    61,    64,    67,   109,    56,    64,    67,
     112,    56,    64,    67,   119,    58,    58,    58,    58,    58,
      80,    58,    84,    85,    63,    58,    92,    58,    58,    58,
      58,    58,   104,   105,   108,    63,   113,    63,   120,    81,
      61,    31,    32,    33,    34,    35,    87,    89,    63,    93,
      61,   109,    45,    46,    47,    48,   114,   116,   112,    45,
      46,    47,    48,   121,   123,   119,    85,    65,    65,    65,
      65,    65,    64,    61,    38,    94,    95,   104,    65,    65,
      65,    65,    64,    61,    65,    65,    65,    65,    64,    61,
      59,    58,    58,    58,    58,    88,    89,    59,    64,    67,
      96,    58,    58,    58,    58,   115,   116,    58,    58,    58,
      58,   122,   123,    66,    61,    63,    95,    61,    61,    58,
      88,    39,    40,    97,    98,    96,   115,   122,    65,    65,
      64,    61,    58,    58,    98,    99,    61,    99
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  However,
   YYFAIL appears to be in use.  Nevertheless, it is formally deprecated
   in Bison 2.4.2's NEWS entry, where a plan to phase it out is
   discussed.  */

#define YYFAIL		goto yyerrlab
#if defined YYFAIL
  /* This is here to suppress warnings from the GCC cpp's
     -Wunused-macros.  Normally we don't worry about that warning, but
     some users do, and we want to make it easy for users to remove
     YYFAIL uses, which will produce warnings from Bison 2.5.  */
#endif

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                  \
do                                                              \
  if (yychar == YYEMPTY)                                        \
    {                                                           \
      yychar = (Token);                                         \
      yylval = (Value);                                         \
      YYPOPSTACK (yylen);                                       \
      yystate = *yyssp;                                         \
      goto yybackup;                                            \
    }                                                           \
  else                                                          \
    {                                                           \
      yyerror (YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))

/* Error token number */
#define YYTERROR	1
#define YYERRCODE	256


/* This macro is provided for backward compatibility. */
#ifndef YY_LOCATION_PRINT
# define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */
#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  FILE *yyo = yyoutput;
  YYUSE (yyo);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
        break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  yy_symbol_value_print (yyoutput, yytype, yyvaluep);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *yybottom, yytype_int16 *yytop)
#else
static void
yy_stack_print (yybottom, yytop)
    yytype_int16 *yybottom;
    yytype_int16 *yytop;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, int yyrule)
#else
static void
yy_reduce_print (yyvsp, yyrule)
    YYSTYPE *yyvsp;
    int yyrule;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       		       );
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, Rule); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return 1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return 2 if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYSIZE_T *yymsg_alloc, char **yymsg,
                yytype_int16 *yyssp, int yytoken)
{
  YYSIZE_T yysize0 = yytnamerr (YY_NULL, yytname[yytoken]);
  YYSIZE_T yysize = yysize0;
  enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULL;
  /* Arguments of yyformat. */
  char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
  /* Number of reported tokens (one for the "unexpected", one per
     "expected"). */
  int yycount = 0;

  /* There are many possibilities here to consider:
     - Assume YYFAIL is not used.  It's too flawed to consider.  See
       <http://lists.gnu.org/archive/html/bison-patches/2009-12/msg00024.html>
       for details.  YYERROR is fine as it does not invoke this
       function.
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yytoken != YYEMPTY)
    {
      int yyn = yypact[*yyssp];
      yyarg[yycount++] = yytname[yytoken];
      if (!yypact_value_is_default (yyn))
        {
          /* Start YYX at -YYN if negative to avoid negative indexes in
             YYCHECK.  In other words, skip the first -YYN actions for
             this state because they are default actions.  */
          int yyxbegin = yyn < 0 ? -yyn : 0;
          /* Stay within bounds of both yycheck and yytname.  */
          int yychecklim = YYLAST - yyn + 1;
          int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
          int yyx;

          for (yyx = yyxbegin; yyx < yyxend; ++yyx)
            if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR
                && !yytable_value_is_error (yytable[yyx + yyn]))
              {
                if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                  {
                    yycount = 1;
                    yysize = yysize0;
                    break;
                  }
                yyarg[yycount++] = yytname[yyx];
                {
                  YYSIZE_T yysize1 = yysize + yytnamerr (YY_NULL, yytname[yyx]);
                  if (! (yysize <= yysize1
                         && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
                    return 2;
                  yysize = yysize1;
                }
              }
        }
    }

  switch (yycount)
    {
# define YYCASE_(N, S)                      \
      case N:                               \
        yyformat = S;                       \
      break
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
# undef YYCASE_
    }

  {
    YYSIZE_T yysize1 = yysize + yystrlen (yyformat);
    if (! (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM))
      return 2;
    yysize = yysize1;
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return 1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yyarg[yyi++]);
          yyformat += 2;
        }
      else
        {
          yyp++;
          yyformat++;
        }
  }
  return 0;
}
#endif /* YYERROR_VERBOSE */

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  YYUSE (yyvaluep);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
        break;
    }
}




/* The lookahead symbol.  */
int yychar;


#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval YY_INITIAL_VALUE(yyval_default);

/* Number of syntax errors so far.  */
int yynerrs;


/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
    int yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       `yyss': related to states.
       `yyvs': related to semantic values.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* The state stack.  */
    yytype_int16 yyssa[YYINITDEPTH];
    yytype_int16 *yyss;
    yytype_int16 *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    YYSIZE_T yystacksize;

  int yyn;
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yystacksize = YYINITDEPTH;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss_alloc, yyss);
	YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token.  */
  yychar = YYEMPTY;

  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 7:
/* Line 1792 of yacc.c  */
#line 492 "race-class.y"
    {/*don't do anything*/;}
    break;

  case 9:
/* Line 1792 of yacc.c  */
#line 499 "race-class.y"
    {/* don't do anything with it*/;}
    break;

  case 12:
/* Line 1792 of yacc.c  */
#line 507 "race-class.y"
    { tmpRace.val.r.trace =
				    (char *) malloc(strlen((yyvsp[(2) - (5)].sval)) + 1);
				  strcpy(tmpRace.val.r.trace, (yyvsp[(2) - (5)].sval));
                                  tmpRace.idx = St_TableSize(raceT_P);
				  PutRace((yyvsp[(2) - (5)].sval), &tmpRace,
					      arguments.rcc.consistency_check);
				  tmpRace = blankRace;
				}
    break;

  case 13:
/* Line 1792 of yacc.c  */
#line 518 "race-class.y"
    { tmpClass.val.c.title =
				    (char *) malloc(strlen((yyvsp[(2) - (5)].sval)) + 1);
				  strcpy(tmpClass.val.c.title, (yyvsp[(2) - (5)].sval));
                                  tmpClass.idx = St_TableSize(classT_P);
				  PutClass((yyvsp[(2) - (5)].sval), &tmpClass,
					      arguments.rcc.consistency_check);
				  tmpClass = blankClass;
				}
    break;

  case 20:
/* Line 1792 of yacc.c  */
#line 537 "race-class.y"
    { tmpRace.val.r.b_age = (yyvsp[(3) - (5)].ival);
                                  tmpRace.val.r.m_age = (yyvsp[(5) - (5)].ival);
				  tmpRace.def.age = TRUE; }
    break;

  case 21:
/* Line 1792 of yacc.c  */
#line 541 "race-class.y"
    { tmpRace.val.r.infra = (yyvsp[(3) - (3)].ival);
				  tmpRace.def.infra_vision = TRUE; }
    break;

  case 22:
/* Line 1792 of yacc.c  */
#line 544 "race-class.y"
    { tmpRace.val.r.m_b_ht = (yyvsp[(3) - (5)].ival);
				  tmpRace.val.r.m_m_ht = (yyvsp[(5) - (5)].ival);
				  tmpRace.def.male_height = TRUE; }
    break;

  case 23:
/* Line 1792 of yacc.c  */
#line 548 "race-class.y"
    { tmpRace.val.r.m_b_wt = (yyvsp[(3) - (5)].ival);
				  tmpRace.val.r.m_m_wt = (yyvsp[(5) - (5)].ival);
				  tmpRace.def.male_weight = TRUE; }
    break;

  case 24:
/* Line 1792 of yacc.c  */
#line 552 "race-class.y"
    { tmpRace.val.r.f_b_ht = (yyvsp[(3) - (5)].ival);
				  tmpRace.val.r.f_m_ht = (yyvsp[(5) - (5)].ival);
				  tmpRace.def.female_height = TRUE; }
    break;

  case 25:
/* Line 1792 of yacc.c  */
#line 556 "race-class.y"
    { tmpRace.val.r.f_b_wt = (yyvsp[(3) - (5)].ival);
				  tmpRace.val.r.f_m_wt = (yyvsp[(5) - (5)].ival);
				  tmpRace.def.female_weight = TRUE; }
    break;

  case 26:
/* Line 1792 of yacc.c  */
#line 560 "race-class.y"
    { tmpRace.val.r.bhitdie = (yyvsp[(3) - (3)].ival);
				  tmpRace.def.hit_points = TRUE; }
    break;

  case 27:
/* Line 1792 of yacc.c  */
#line 563 "race-class.y"
    { tmpRace.val.r.b_dis = (yyvsp[(3) - (3)].ival);
				  tmpRace.def.disarming = TRUE; }
    break;

  case 28:
/* Line 1792 of yacc.c  */
#line 566 "race-class.y"
    { tmpRace.val.r.srh = (yyvsp[(3) - (3)].ival);
				  tmpRace.def.search_chance = TRUE; }
    break;

  case 29:
/* Line 1792 of yacc.c  */
#line 569 "race-class.y"
    { tmpRace.val.r.stl = (yyvsp[(3) - (3)].ival);
				  tmpRace.def.stealth_factor = TRUE; }
    break;

  case 30:
/* Line 1792 of yacc.c  */
#line 572 "race-class.y"
    { tmpRace.val.r.fos = (yyvsp[(3) - (3)].ival);
				  tmpRace.def.frequency_of_search = TRUE; }
    break;

  case 31:
/* Line 1792 of yacc.c  */
#line 575 "race-class.y"
    { tmpRace.val.r.bth = (yyvsp[(3) - (3)].ival);
				  tmpRace.def.base_to_hit = TRUE; }
    break;

  case 32:
/* Line 1792 of yacc.c  */
#line 578 "race-class.y"
    { tmpRace.val.r.bthb = (yyvsp[(3) - (3)].ival);
				  tmpRace.def.base_to_hit_with_bows = TRUE; }
    break;

  case 33:
/* Line 1792 of yacc.c  */
#line 581 "race-class.y"
    { tmpRace.val.r.bsav = (yyvsp[(3) - (3)].ival);
				  tmpRace.def.saving_throw = TRUE; }
    break;

  case 34:
/* Line 1792 of yacc.c  */
#line 584 "race-class.y"
    { tmpRace.val.r.str_adj = (yyvsp[(3) - (3)].ival);
				  tmpRace.def.strength_modifier = TRUE; }
    break;

  case 35:
/* Line 1792 of yacc.c  */
#line 587 "race-class.y"
    { tmpRace.val.r.int_adj = (yyvsp[(3) - (3)].ival);
				  tmpRace.def.intelligence_modifier = TRUE; }
    break;

  case 36:
/* Line 1792 of yacc.c  */
#line 590 "race-class.y"
    { tmpRace.val.r.wis_adj = (yyvsp[(3) - (3)].ival);
				  tmpRace.def.wisdom_modifier = TRUE; }
    break;

  case 37:
/* Line 1792 of yacc.c  */
#line 593 "race-class.y"
    { tmpRace.val.r.dex_adj = (yyvsp[(3) - (3)].ival);
				  tmpRace.def.dexterity_modifier = TRUE; }
    break;

  case 38:
/* Line 1792 of yacc.c  */
#line 596 "race-class.y"
    { tmpRace.val.r.con_adj = (yyvsp[(3) - (3)].ival);
				  tmpRace.def.constitution_modifier = TRUE; }
    break;

  case 39:
/* Line 1792 of yacc.c  */
#line 599 "race-class.y"
    { tmpRace.val.r.chr_adj = (yyvsp[(3) - (3)].ival);
				  tmpRace.def.charisma_modifier = TRUE; }
    break;

  case 40:
/* Line 1792 of yacc.c  */
#line 602 "race-class.y"
    { tmpRace.val.r.b_exp = (yyvsp[(3) - (3)].ival);
				  tmpRace.def.experience_factor = TRUE; }
    break;

  case 41:
/* Line 1792 of yacc.c  */
#line 607 "race-class.y"
    { /*PutAllowedClassesForRace();*/ 
                                  tmpRace.def.classes = TRUE; 
                                  tmpRace.line_no_for_classes = lineNo;}
    break;

  case 43:
/* Line 1792 of yacc.c  */
#line 616 "race-class.y"
    { argz_add(&tmpRace.val.classes_argz,
                                           &tmpRace.val.classes_len, (yyvsp[(1) - (1)].sval));}
    break;

  case 46:
/* Line 1792 of yacc.c  */
#line 625 "race-class.y"
    {tmpRace.def.store_price_adjust_by_race = TRUE;
                                 tmpRace.line_no_for_price_adjust = lineNo; }
    break;

  case 48:
/* Line 1792 of yacc.c  */
#line 633 "race-class.y"
    {if (arguments.rcc.consistency_check)
                                   {
                                     int i = 0;
                                     for (; i<tmpRace.val.num_price_adjust; i++)
                                       {
                                         race_price_t val =
                                           tmpRace.val.price_adjust[i];
                                         if (strcmp (val.race, (yyvsp[(1) - (3)].sval)) == 0)
                                           {
                                             char *msg = 
                                               xasprintf ("duplicate race `%s'",
                                                           val.race);
                                             yyerror (msg);
                                           }
                                       }
                                       if ((yyvsp[(3) - (3)].ival) == 0)
                                         {
                                           char *msg = "price must be greater "
                                                       "than zero";
                                           yyerror (msg);
                                         }
                                   }
                                 tmpRace.val.num_price_adjust++;
                                 int num = tmpRace.val.num_price_adjust;
                                 tmpRace.val.price_adjust = 
                                   realloc (tmpRace.val.price_adjust,
                                            num * sizeof (race_price_t));
                                 race_price_t val;
                                 val.race = strdup((yyvsp[(1) - (3)].sval)); //FIXME leak
                                 val.price = (yyvsp[(3) - (3)].ival);
                                 tmpRace.val.price_adjust[num-1] = val;}
    break;

  case 51:
/* Line 1792 of yacc.c  */
#line 671 "race-class.y"
    { 
                                  tmpRace.def.shopkeep = TRUE;
                                  char *r = xasprintf ("(%s)", (yyvsp[(3) - (7)].sval));
                                  tmpShopkeep.val.owner_name = 
                                    xasprintf ("%-22s %-12s %s", 
                                      (yyvsp[(2) - (7)].sval), r, (yyvsp[(4) - (7)].sval));
                                  tmpShopkeep.line_no = lineNo;
                                  tmpShopkeep.val.owner_race = 
                                    St_TableSize(raceT_P);
				  PutShopkeep(&tmpShopkeep,
					      arguments.rcc.consistency_check);
				  tmpShopkeep = blankShopkeep;
                                  num_shopkeeps++;
				}
    break;

  case 55:
/* Line 1792 of yacc.c  */
#line 695 "race-class.y"
    {
                                 if (arguments.rcc.consistency_check)
                                   {
                                     if (strlen ((yyvsp[(3) - (3)].sval)) > 1 || 
                                         strlen ((yyvsp[(3) - (3)].sval)) == 0 ||
                                         (yyvsp[(3) - (3)].sval)[0] - '1' > MAX_STORES)
                                       yyerror ("invalid store");
                                   }
                                 tmpShopkeep.def.store = TRUE;
                                 tmpShopkeep.val.pstore = (yyvsp[(3) - (3)].sval)[0] - '1';}
    break;

  case 56:
/* Line 1792 of yacc.c  */
#line 706 "race-class.y"
    {tmpShopkeep.def.haggle_per = TRUE;
                                 tmpShopkeep.val.haggle_per = (yyvsp[(3) - (3)].ival);}
    break;

  case 57:
/* Line 1792 of yacc.c  */
#line 709 "race-class.y"
    {tmpShopkeep.def.inflate = TRUE;
                                 tmpShopkeep.val.min_inflate = (yyvsp[(3) - (5)].ival);
                                 tmpShopkeep.val.max_inflate = 
                                   tmpShopkeep.val.min_inflate + (yyvsp[(5) - (5)].ival);}
    break;

  case 58:
/* Line 1792 of yacc.c  */
#line 714 "race-class.y"
    {tmpShopkeep.def.max_insults = TRUE;
                                 tmpShopkeep.val.insult_max = (yyvsp[(3) - (3)].ival);}
    break;

  case 59:
/* Line 1792 of yacc.c  */
#line 717 "race-class.y"
    {tmpShopkeep.def.max_cost = TRUE;
                                 tmpShopkeep.val.max_cost = (yyvsp[(3) - (3)].ival);}
    break;

  case 60:
/* Line 1792 of yacc.c  */
#line 722 "race-class.y"
    {tmpRace.def.backgrounds = TRUE;}
    break;

  case 62:
/* Line 1792 of yacc.c  */
#line 729 "race-class.y"
    {int i;
                                 for (i=0; i<tmpRace.val.num_backgrounds; i++)
                                   if (!tmpRace.val.backgrounds[i].chart)
                                     {
                                       tmpRace.val.backgrounds[i].chart = 
                                         (yyvsp[(2) - (6)].ival);
                                       tmpRace.val.backgrounds[i].next = 
                                         (yyvsp[(3) - (6)].ival);
                                     }
                                 if (arguments.rcc.consistency_check)
                                   CheckBackground((yyvsp[(2) - (6)].ival), (yyvsp[(3) - (6)].ival)); }
    break;

  case 66:
/* Line 1792 of yacc.c  */
#line 750 "race-class.y"
    {tmpBackground.val.info = strdup((yyvsp[(2) - (5)].sval));
                                 //FIXME leak
                                 PutBackground(&tmpBackground,
                                               arguments.rcc.consistency_check);
                                 tmpBackground = blankBackground;}
    break;

  case 70:
/* Line 1792 of yacc.c  */
#line 765 "race-class.y"
    {if (arguments.rcc.consistency_check &&
                                     (yyvsp[(3) - (3)].ival) > 100)
                                   yyerror("roll exceeds 100");
                                 tmpBackground.def.roll = TRUE;
                                 tmpBackground.val.roll = (yyvsp[(3) - (3)].ival);}
    break;

  case 71:
/* Line 1792 of yacc.c  */
#line 771 "race-class.y"
    {tmpBackground.def.social_class_bonus = TRUE;
                                 tmpBackground.val.bonus = (yyvsp[(3) - (3)].ival);}
    break;

  case 80:
/* Line 1792 of yacc.c  */
#line 788 "race-class.y"
    { tmpClass.val.c.adj_hd = (yyvsp[(3) - (3)].ival);
				  tmpClass.def.hit_points = TRUE; }
    break;

  case 81:
/* Line 1792 of yacc.c  */
#line 791 "race-class.y"
    { tmpClass.val.c.mdis = (yyvsp[(3) - (3)].ival);
				  tmpClass.def.disarming = TRUE; }
    break;

  case 82:
/* Line 1792 of yacc.c  */
#line 794 "race-class.y"
    { tmpClass.val.c.msrh = (yyvsp[(3) - (3)].ival);
				  tmpClass.def.search_chance = TRUE; }
    break;

  case 83:
/* Line 1792 of yacc.c  */
#line 797 "race-class.y"
    { tmpClass.val.c.mstl = (yyvsp[(3) - (3)].ival);
				  tmpClass.def.stealth_factor = TRUE; }
    break;

  case 84:
/* Line 1792 of yacc.c  */
#line 800 "race-class.y"
    { tmpClass.val.c.mfos = (yyvsp[(3) - (3)].ival);
				  tmpClass.def.frequency_of_search = TRUE; }
    break;

  case 85:
/* Line 1792 of yacc.c  */
#line 803 "race-class.y"
    { tmpClass.val.c.mbth = (yyvsp[(3) - (3)].ival);
				  tmpClass.def.base_to_hit = TRUE; }
    break;

  case 86:
/* Line 1792 of yacc.c  */
#line 806 "race-class.y"
    { tmpClass.val.c.mbthb = (yyvsp[(3) - (3)].ival);
				  tmpClass.def.base_to_hit_with_bows = TRUE; }
    break;

  case 87:
/* Line 1792 of yacc.c  */
#line 809 "race-class.y"
    { tmpClass.val.c.msav = (yyvsp[(3) - (3)].ival);
				  tmpClass.def.saving_throw = TRUE; }
    break;

  case 88:
/* Line 1792 of yacc.c  */
#line 812 "race-class.y"
    { tmpClass.val.c.madj_str = (yyvsp[(3) - (3)].ival);
				  tmpClass.def.strength_modifier = TRUE; }
    break;

  case 89:
/* Line 1792 of yacc.c  */
#line 815 "race-class.y"
    { tmpClass.val.c.madj_int = (yyvsp[(3) - (3)].ival);
				  tmpClass.def.intelligence_modifier = TRUE; }
    break;

  case 90:
/* Line 1792 of yacc.c  */
#line 818 "race-class.y"
    { tmpClass.val.c.madj_wis = (yyvsp[(3) - (3)].ival);
				  tmpClass.def.wisdom_modifier = TRUE; }
    break;

  case 91:
/* Line 1792 of yacc.c  */
#line 821 "race-class.y"
    { tmpClass.val.c.madj_dex = (yyvsp[(3) - (3)].ival);
				  tmpClass.def.dexterity_modifier = TRUE; }
    break;

  case 92:
/* Line 1792 of yacc.c  */
#line 824 "race-class.y"
    { tmpClass.val.c.madj_con = (yyvsp[(3) - (3)].ival);
				  tmpClass.def.constitution_modifier = TRUE; }
    break;

  case 93:
/* Line 1792 of yacc.c  */
#line 827 "race-class.y"
    { tmpClass.val.c.madj_chr = (yyvsp[(3) - (3)].ival);
				  tmpClass.def.charisma_modifier = TRUE; }
    break;

  case 94:
/* Line 1792 of yacc.c  */
#line 830 "race-class.y"
    { tmpClass.val.c.m_exp = (yyvsp[(3) - (3)].ival);
				  tmpClass.def.experience_factor = TRUE; }
    break;

  case 99:
/* Line 1792 of yacc.c  */
#line 845 "race-class.y"
    {tmpClass.val.adjust_per_one_third_level[0] =
                                 (yyvsp[(3) - (3)].ival);
                                 tmpClass.def.adjust_base_to_hit = TRUE;}
    break;

  case 100:
/* Line 1792 of yacc.c  */
#line 849 "race-class.y"
    {tmpClass.val.adjust_per_one_third_level[1] =
                                 (yyvsp[(3) - (3)].ival);
                                 tmpClass.def.adjust_base_to_hit_with_bows = TRUE;}
    break;

  case 101:
/* Line 1792 of yacc.c  */
#line 853 "race-class.y"
    {tmpClass.val.adjust_per_one_third_level[2] =
                                 (yyvsp[(3) - (3)].ival);
                                 tmpClass.def.adjust_use_device = TRUE;}
    break;

  case 102:
/* Line 1792 of yacc.c  */
#line 857 "race-class.y"
    {tmpClass.val.adjust_per_one_third_level[3] =
                                 (yyvsp[(3) - (3)].ival);
                                 tmpClass.def.adjust_disarming = TRUE;}
    break;

  case 103:
/* Line 1792 of yacc.c  */
#line 861 "race-class.y"
    {tmpClass.val.adjust_per_one_third_level[4] =
                                 (yyvsp[(3) - (3)].ival);
                                 tmpClass.def.adjust_saving_throw = TRUE;}
    break;

  case 104:
/* Line 1792 of yacc.c  */
#line 867 "race-class.y"
    { /*PutTitles();*/ }
    break;

  case 106:
/* Line 1792 of yacc.c  */
#line 874 "race-class.y"
    { 
                                 if (arguments.rcc.consistency_check)
                                   {
                                     const char *t = NULL;
                                     char *argz = tmpClass.val.titles_argz;
                                     size_t len = tmpClass.val.titles_len;
                                     while ((t = argz_next (argz, len, t)))
                                       {
                                         if (strcmp (t, (yyvsp[(1) - (1)].sval)) == 0)
                                           {
                                             char *msg = 
                                               xasprintf ("duplicate title %s",
                                                          (yyvsp[(1) - (1)].sval));
                                             yyerror (msg);
                                           }
                                       }
                                   }

                                 argz_add (&tmpClass.val.titles_argz,
                                           &tmpClass.val.titles_len, 
                                           (yyvsp[(1) - (1)].sval)); }
    break;

  case 113:
/* Line 1792 of yacc.c  */
#line 912 "race-class.y"
    {PutSpell((yyvsp[(2) - (5)].sval), &tmpSpell,
                                          arguments.rcc.consistency_check);
                                 tmpSpell = blankSpell;}
    break;

  case 117:
/* Line 1792 of yacc.c  */
#line 925 "race-class.y"
    {tmpSpell.val.s.slevel = (yyvsp[(3) - (3)].ival);
                                 tmpSpell.def.level = TRUE;}
    break;

  case 118:
/* Line 1792 of yacc.c  */
#line 928 "race-class.y"
    {tmpSpell.val.s.smana = (yyvsp[(3) - (3)].ival);
                                 tmpSpell.def.mana = TRUE;}
    break;

  case 119:
/* Line 1792 of yacc.c  */
#line 931 "race-class.y"
    {tmpSpell.val.s.sfail = (yyvsp[(3) - (3)].ival);
                                 tmpSpell.def.fail = TRUE;}
    break;

  case 120:
/* Line 1792 of yacc.c  */
#line 934 "race-class.y"
    {tmpSpell.val.s.sexp = (yyvsp[(3) - (3)].ival);
                                 tmpSpell.def.exp = TRUE;}
    break;

  case 125:
/* Line 1792 of yacc.c  */
#line 949 "race-class.y"
    {PutPrayer((yyvsp[(2) - (5)].sval), &tmpPrayer,
                                           arguments.rcc.consistency_check);
                                 tmpPrayer = blankPrayer;}
    break;

  case 129:
/* Line 1792 of yacc.c  */
#line 962 "race-class.y"
    {tmpPrayer.val.s.slevel = (yyvsp[(3) - (3)].ival);
                                 tmpPrayer.def.level = TRUE;}
    break;

  case 130:
/* Line 1792 of yacc.c  */
#line 965 "race-class.y"
    {tmpPrayer.val.s.smana = (yyvsp[(3) - (3)].ival);
                                 tmpPrayer.def.mana = TRUE;}
    break;

  case 131:
/* Line 1792 of yacc.c  */
#line 968 "race-class.y"
    {tmpPrayer.val.s.sfail = (yyvsp[(3) - (3)].ival);
                                 tmpPrayer.def.fail = TRUE;}
    break;

  case 132:
/* Line 1792 of yacc.c  */
#line 971 "race-class.y"
    {tmpPrayer.val.s.sexp = (yyvsp[(3) - (3)].ival);
                                 tmpPrayer.def.exp = TRUE;}
    break;

  case 135:
/* Line 1792 of yacc.c  */
#line 982 "race-class.y"
    { 
                                  int lvl = num_experience_levels;
                                  if (lvl > 0 &&
                                      experience_levels[lvl-1] > (yyvsp[(1) - (1)].ival) &&
                                      arguments.rcc.consistency_check)
                                    yyerror (xasprintf("%s %d is too small",
                                                       "experience level",
                                                       (yyvsp[(1) - (1)].ival)));
                                  else
                                    {
                                      num_experience_levels++;
                                      lvl++;
                                      experience_levels =
                                        realloc (experience_levels, lvl * 
                                                   sizeof (int));
                                      experience_levels[lvl-1] = (yyvsp[(1) - (1)].ival);
                                    }
                                }
    break;


/* Line 1792 of yacc.c  */
#line 2805 "race-class.c"
      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYEMPTY : YYTRANSLATE (yychar);

  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (YY_("syntax error"));
#else
# define YYSYNTAX_ERROR yysyntax_error (&yymsg_alloc, &yymsg, \
                                        yyssp, yytoken)
      {
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = YYSYNTAX_ERROR;
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == 1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = (char *) YYSTACK_ALLOC (yymsg_alloc);
            if (!yymsg)
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = 2;
              }
            else
              {
                yysyntax_error_status = YYSYNTAX_ERROR;
                yymsgp = yymsg;
              }
          }
        yyerror (yymsgp);
        if (yysyntax_error_status == 2)
          goto yyexhaustedlab;
      }
# undef YYSYNTAX_ERROR
#endif
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#if !defined yyoverflow || YYERROR_VERBOSE
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}


/* Line 2055 of yacc.c  */
#line 1006 "race-class.y"




/*
 * MyFGetC--
 *	fgetc with support for comments
 *
 *	# is the comment character.  comment lasts till end of line.
 * Spews out an extra char of whitespace at EOF since something seems to
 * need it.  I'll figure this out eventually...
 */
static int 
MyFGetC (FILE *input_F)
{
  while (!*inputBufp || (*inputBufp == '#')) 
    {
      fgets (inputBuf, INPUT_BUF_SIZE, input_F);
      if (feof (input_F))
	return EOF;
      lineNo++;
      inputBufp = inputBuf;
    }
  return *inputBufp++;
}



/*
 * Advance--
 *	Advance to the next token in the input stream and set tokStr,
 * tokType.
 *
 *	On error, tokType is set to a negative value.
 */
static void 
Advance (FILE *input_F)
{
  register char *tok = tokStr;	/* accumulating token string		    */
  register int len = 0;		/* length of current token		    */
  static int c = 32;		/* current character; ' ' is harmless init  */


  /*
   * Skip whitespace in the stream
   */
  while ((c != EOF) && isspace (c))
    c = MyFGetC (input_F);

  /*
   * At end of file?
   */
  if (c == EOF) 
    {
      tokType = EOF;
      strcpy (tokStr, "[EOF]");
      return;
    }

  /*
   * Recognize a number [+|-][dddd][.][dddd][{e|E}[+|-]dddd]
   */
  if (isdigit (c) || (c == '.') || (c == '+') || (c == '-')) 
    {
      register int decPt = FALSE,   /* seen a decimal point yet?	*/
	       hasExp = FALSE;	    /* has an exponent?			*/

      if ((c == '-') || (c == '+')) 
	{
	  *tok++ = c;
	  c = MyFGetC (input_F);
	}

      while ((len < MAX_TOK_LEN - 1) && (isdigit (c) || (c == '.'))) 
	{
	  if (c == '.') 
	    {
	      if (decPt)
		break;
	      else
		decPt = TRUE;
	    }

	  *tok++ = c;
	  c = MyFGetC (input_F);
	  len++;
	}

      if ((c == 'e') || (c == 'E')) 
	{
	  hasExp = TRUE;
	  *tok++ = c;
	  c = MyFGetC (input_F);
	  len++;

	  if ((c == '-') || (c == '+')) 
	    {
	      *tok++ = c;
	      c = MyFGetC (input_F);
	      len++;
	    }

	  while ((len < MAX_TOK_LEN - 1) && isdigit (c)) 
	    {
	      *tok++ = c;
	      c = MyFGetC (input_F);
	      len++;
	    }
	}

      *tok = 0;

      if (decPt || hasExp) 
	{
	  tokType = FLOAT_LIT;
	  yylval.dval = atof (tokStr);
	} 
      else 
	{
	  tokType = INT_LIT;
	  yylval.ival = atoi (tokStr);
	}

      return;

    }

  /*
   * Recognize a quoted string
   */
  if (c == '\"') 
    {

      c = MyFGetC (input_F);

      while ((len < MAX_TOK_LEN - 1) &&
	     (c != EOF) && (c != '\n') && (c != '\"')) 
	{
	  *tok++ = c;
	  c = MyFGetC (input_F);
	}

      *tok = 0;

      c = MyFGetC (input_F);

      tokType = STRING_LIT;
      strncpy (yylval.sval, tokStr, MAX_TOK_LEN - 1);
      yylval.sval[MAX_TOK_LEN - 1] = 0;

      return;

    }

  /*
   * Recognize an identifier and try to match it with a keyword.
   * Identifiers begin with a letter and continue in letters and/or
   * digits.  Convert it to lowercase.
   */
  if (isalpha (c) || (c == '_') || (c == '$')) {

    if (isupper (c))
      c = tolower (c);
    *tok++ = c;
    c = MyFGetC (input_F);
    len++;

    while ((len < MAX_TOK_LEN - 1) && (isalpha (c) || isdigit (c) ||
				       (c == '_') || (c == '$'))) 
      {
	if (isupper (c))
	  c = tolower (c);
	*tok++ = c;
	c = MyFGetC (input_F);
	len++;
      }

    *tok = 0;

    /*
     * We've got the identifier; see if it matches any keywords.
     */

      {
	generic_t gval;
	int type;
	if (St_GetSym (keywordT_P, tokStr, &type, &gval) == ST_SYM_FOUND) 
	  {
	    tokType = gval.i;
	    strncpy (yylval.sval, tokStr, MAX_TOK_LEN - 1);
	    yylval.sval[MAX_TOK_LEN - 1] = 0;
	  } 
	else if (!strcmp (tokStr, "true")) 
	  {
	    tokType = BOOL_LIT;
	    yylval.ival = 1;
	  } 
	else if (!strcmp (tokStr, "false")) 
	  {
	    tokType = BOOL_LIT;
	    yylval.ival = 0;
	  } 
	else 
	  {
	    tokType = IDENTIFIER;
	    strncpy (yylval.sval, tokStr, MAX_TOK_LEN - 1);
	    yylval.sval[MAX_TOK_LEN - 1] = 0;
	  }
      }

    return;

  }

  /*
   * Recognize punctuation
   */

  tokType = c;
  *tok++ = c;
  *tok = 0;
  c = MyFGetC (input_F);
  return;
}

void 
ErrMsgLineNo (char *s, int line_no)
{
  if (line_no >= 0)
    fprintf (stderr, "Error: %s at line %d\n", s, line_no);
  else
    fprintf (stderr, "Error: %s\n", s);
}

void 
ErrMsg (char *s)
{
  int i;

  fprintf (stderr, "Error: %s at line %d\n", s, lineNo);
  fprintf (stderr, "%s", inputBuf);
  for (i = 0; i < inputBufp - inputBuf; i++) 
    {
      fputc ((inputBuf[i] == '\t' ? '\t' : ' '), stderr);
    }
  fprintf (stderr, "^ before here\n\n");
  return;
}

int 
yyerror (char *s)
{
  ErrMsg (s);
  return 0;
}


int 
yylex ()
{
  Advance (input_F);
  return tokType;
}

st_Table_Pt 
InitTable (char *name, symInit_t *init)
{
  int i;
  st_Table_Pt table_P;
  generic_t gval;

  table_P = St_NewTable (name, 20);
  for (i = 0; init[i].name; i++) 
    {
      gval.i = init[i].val;
      St_DefSym (table_P, init[i].name, GEN_TYPE_INT, gval);
    }

  return table_P;
}

void 
InitTables ()
{
  keywordT_P = InitTable ("keyword", keywordInit);
  spellsT_P = InitTable ("spells", spellsInit);
  prayersT_P = InitTable ("prayers", prayersInit);

  raceT_P = St_NewTable ("race", 200);
  classT_P = St_NewTable ("class", 40);

  return;
}

void 
NotDefined(char *name, char *s)
{
  fprintf (stderr, 
	   "Warning: %s not defined for \"%s\", line %d\n",
	   s, name, lineNo);
  return;
}

void 
PutRace (char *s, race_template_t *tmpl_P, int consistency_check)
{
  generic_t gval;

  gval.v = malloc (sizeof(race_template_t));
  *(race_template_t *) gval.v = *tmpl_P;

  if (!tmpl_P->def.age)
    NotDefined (tmpl_P->val.r.trace, "AGE");
  if (!tmpl_P->def.infra_vision)
    NotDefined (tmpl_P->val.r.trace, "INFRA_VISION");
  if (!tmpl_P->def.male_height)
    NotDefined (tmpl_P->val.r.trace, "MALE_HEIGHT");
  if (!tmpl_P->def.male_weight)
    NotDefined (tmpl_P->val.r.trace, "MALE_WEIGHT");
  if (!tmpl_P->def.female_height)
    NotDefined (tmpl_P->val.r.trace, "FEMALE_HEIGHT");
  if (!tmpl_P->def.female_weight)
    NotDefined (tmpl_P->val.r.trace, "FEMALE_WEIGHT");
  if (!tmpl_P->def.hit_points)
    NotDefined (tmpl_P->val.r.trace, "HIT_POINTS");
  if (!tmpl_P->def.disarming)
    NotDefined (tmpl_P->val.r.trace, "DISARMING");
  if (!tmpl_P->def.search_chance)
    NotDefined (tmpl_P->val.r.trace, "SEARCH_CHANCE");
  if (!tmpl_P->def.stealth_factor)
    NotDefined (tmpl_P->val.r.trace, "STEALTH_FACTOR");
  if (!tmpl_P->def.frequency_of_search)
    NotDefined (tmpl_P->val.r.trace, "FREQUENCY_OF_SEARCH");
  if (!tmpl_P->def.base_to_hit)
    NotDefined (tmpl_P->val.r.trace, "BASE_TO_HIT");
  if (!tmpl_P->def.base_to_hit_with_bows)
    NotDefined (tmpl_P->val.r.trace, "BASE_TO_HIT_WITH_BOWS");
  if (!tmpl_P->def.saving_throw)
    NotDefined (tmpl_P->val.r.trace, "SAVING_THROW");
  if (!tmpl_P->def.strength_modifier)
    NotDefined (tmpl_P->val.r.trace, "STRENGTH_MODIFIER");
  if (!tmpl_P->def.intelligence_modifier)
    NotDefined (tmpl_P->val.r.trace, "INTELLIGENCE_MODIFIER");
  if (!tmpl_P->def.wisdom_modifier)
    NotDefined (tmpl_P->val.r.trace, "WISDOM_MODIFIER");
  if (!tmpl_P->def.dexterity_modifier)
    NotDefined (tmpl_P->val.r.trace, "DEXTERITY_MODIFIER");
  if (!tmpl_P->def.constitution_modifier)
    NotDefined (tmpl_P->val.r.trace, "CONSTITUTION_MODIFIER");
  if (!tmpl_P->def.charisma_modifier)
    NotDefined (tmpl_P->val.r.trace, "CHARISMA_MODIFIER");
  if (!tmpl_P->def.experience_factor)
    NotDefined (tmpl_P->val.r.trace, "EXPERIENCE_FACTOR");
  if (!tmpl_P->def.classes)
    NotDefined (tmpl_P->val.r.trace, "CLASSES");
  if (!tmpl_P->def.store_price_adjust_by_race)
    NotDefined (tmpl_P->val.r.trace, "STORE_PRICE_ADJUST_BY_RACE");
  if (!tmpl_P->def.shopkeep)
    ;//NotDefined (tmpl_P->val.r.trace, ""); it's okay if we don't have one.
  if (!tmpl_P->def.backgrounds)
    NotDefined (tmpl_P->val.r.trace, "BACKGROUNDS");

  if (consistency_check)
    ;//ConsistencyCheckRace (&tmpl_P->val, &tmpl_P->state);

  if (St_DefSym (raceT_P, s, GEN_TYPE_TMPL, gval) == ST_SYM_FOUND) 
    {
      fprintf (arguments.rcc.outfile, "Warning: redefining \"%s\", line %d\n", 
               tmpl_P->val.r.trace, lineNo);
    }

  return;
}

void PutShopkeep(shopkeep_template_t *tmpl_P, int consistency_check)
{
  char *id = "shopkeep";
  if (!tmpl_P->def.store)
    NotDefined (id, "STORE");
  if (!tmpl_P->def.haggle_per)
    NotDefined (id, "HAGGLE_PER");
  if (!tmpl_P->def.inflate)
    NotDefined (id, "INFLATE");
  if (!tmpl_P->def.max_insults)
    NotDefined (id, "MAX_INSULTS");
  if (!tmpl_P->def.max_cost)
    NotDefined (id, "MAX_COST");
  if (consistency_check)
    {
      if (tmpl_P->val.insult_max == 0)
        yyerror ("max_insults can't be zero");
      if (tmpl_P->val.max_cost == 0)
        yyerror ("max_cost can't be zero");
    }
  tmpRace.val.num_shopkeeps++;
  tmpRace.val.shopkeeps = realloc(tmpRace.val.shopkeeps, 
                                  tmpRace.val.num_shopkeeps * 
                                    sizeof(owner_type));
  tmpRace.val.shopkeeps[tmpRace.val.num_shopkeeps-1] = tmpl_P->val;
}

void PutBackground(background_template_t *tmpl_P, int consistency_check)
{
  if (!tmpl_P->def.roll)
    NotDefined("fragment", "ROLL");
  if (!tmpl_P->def.social_class_bonus)
    NotDefined("fragment", "SOCIAL_CLASS_BONUS");
  tmpRace.val.num_backgrounds++;
  int num = tmpRace.val.num_backgrounds;
  tmpRace.val.backgrounds = realloc (tmpRace.val.backgrounds, 
                                     num * sizeof (background_type));
  tmpRace.val.backgrounds[num-1] = tmpBackground.val;
}

void CheckSpell (spell_type *s)
{
  if (s->slevel == 0)
    yyerror ("level can't be zero");
  if (s->smana == 0)
    yyerror ("mana can't be zero");
  if (s->sfail >= 100)
    yyerror ("fail can't be 100 or more");
}

void
PutSpell (char *s, spell_template_t *tmpl_P, int consistency_check)
{
  generic_t gval;
  int type;
  if (St_GetSym (spellsT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      yyerror (xasprintf("unknown spell `%s'", s));
      return;
    }
  tmpl_P->val.idx = gval.i;
  tmpl_P->val.line_no = lineNo;

  int i;
  for (i = 0; i < tmpClass.val.num_spells; i++)
    {
      if (tmpClass.val.spells[i].idx == tmpl_P->val.idx)
        {
          yyerror (xasprintf ("duplicate spell %s", s));
          return;
        }
    }
  char *id = xasprintf ("spell %s", s);
  if (!tmpl_P->def.level)
    NotDefined(id, "LEVEL");
  if (!tmpl_P->def.mana)
    NotDefined(id, "MANA");
  if (!tmpl_P->def.fail)
    NotDefined(id, "FAIL");
  if (!tmpl_P->def.exp)
    NotDefined(id, "EXP");
  if (consistency_check)
    CheckSpell (&tmpl_P->val.s);
  tmpClass.val.num_spells++;
  int num = tmpClass.val.num_spells;
  tmpClass.val.spells = realloc (tmpClass.val.spells,  
                                 num * sizeof(spell_t));
  tmpClass.val.spells[num-1] = tmpl_P->val;
  free (id);
}

void
PutPrayer (char *s, spell_template_t *tmpl_P, int consistency_check)
{
  generic_t gval;
  int type;
  if (St_GetSym (prayersT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      yyerror (xasprintf("unknown prayer `%s'", s));
      return;
    }
  tmpl_P->val.idx = gval.i;
  tmpl_P->val.line_no = lineNo;
  int i;
  for (i = 0; i < tmpClass.val.num_prayers; i++)
    {
      if (tmpClass.val.prayers[i].idx == tmpl_P->val.idx)
        {
          yyerror (xasprintf ("duplicate prayer %s", s));
          return;
        }
    }
  char *id = xasprintf ("prayer %s", s);
  if (!tmpl_P->def.level)
    NotDefined(id, "LEVEL");
  if (!tmpl_P->def.mana)
    NotDefined(id, "MANA");
  if (!tmpl_P->def.fail)
    NotDefined(id, "FAIL");
  if (!tmpl_P->def.exp)
    NotDefined(id, "EXP");
  if (consistency_check)
    CheckSpell (&tmpl_P->val.s);
  tmpClass.val.num_prayers++;
  int num = tmpClass.val.num_prayers;
  tmpClass.val.prayers = realloc (tmpClass.val.prayers,  
                                 num * sizeof(spell_t));
  tmpClass.val.prayers[num-1] = tmpl_P->val;
  free (id);
}

int compare_ints (const void *i1, const void *i2)
{
  int num1 = *(int*)i1;
  int num2 = *(int*)i2;
  return num1 - num2;
}

void CheckBackground (int chart, int next)
{
  //check to see if the background has no dup rolls, and a roll of 100.
  int i;
  int rolls[tmpRace.val.num_backgrounds];
  int num_rolls = 0;
  if (chart == 0)
    yyerror ("invalid background id of 0");
  if (chart == next)
    yyerror ("next background id can't point to this background");
  memset (rolls, 0, sizeof (rolls));
  for (i = 0; i < tmpRace.val.num_backgrounds; i++)
    {
      if (tmpRace.val.backgrounds[i].chart != chart)
        continue;
      if (tmpRace.val.backgrounds[i].next != next)
        { 
          yyerror ("background has duplicate id or points " 
                   "to wrong next background");
          return;
        }
      rolls[num_rolls] = tmpRace.val.backgrounds[i].roll;
      num_rolls++;
    }
  qsort (rolls, num_rolls, sizeof (int), compare_ints);
  for (i = 0; i < num_rolls; i++)
    {
      if (rolls[i] == rolls[i-1])
        {
          yyerror (xasprintf ("duplicate roll value of %d", rolls[i]));
          return;
        }
    }
  if (num_rolls)
    {
      if (rolls[num_rolls-1] != 100)
        {
          yyerror ("background needs fragment with roll of 100");
          return;
        }
      if (rolls[0] == 0)
        {
          yyerror ("background has fragment with roll of 0");
          return;
        }
    }
}

void WriteGenerationNotice()
{
  fprintf (arguments.rcc.outfile,
	   "/* The following was generated by the %s race & class compiler \n"
           "   (%s-rcc %s) on %s. \n", 
           PACKAGE_NAME, GAME_NAME, VERSION, __DATE__);
  fprintf (arguments.rcc.outfile,"\n\
   Copyright (c) 1989-94 James E. Wilson, Robert A. Koeneke\n\
   This program is free software; you can redistribute it and/or modify\n\
   it under the terms of the GNU General Public License as published by\n\
   the Free Software Foundation; either version 3 of the License, or\n\
   (at your option) any later version.\n\
   \n\
   This program is distributed in the hope that it will be useful,\n\
   but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
   GNU Library General Public License for more details.\n\
   \n\
   You should have received a copy of the GNU General Public License\n\
   along with this program; if not, write to the Free Software\n\
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n");
  fprintf (arguments.rcc.outfile,
	   "*/\n\n");
  return;
}

void 
PutClass (char *s, class_template_t *tmpl_P, int consistency_check)
{
  generic_t gval;

  gval.v = malloc (sizeof(class_template_t));
  *(class_template_t *) gval.v = *tmpl_P;

  if (!tmpl_P->def.hit_points)
    NotDefined (tmpl_P->val.c.title, "HIT_POINTS");
  if (!tmpl_P->def.disarming)
    NotDefined (tmpl_P->val.c.title, "DISARMING");
  if (!tmpl_P->def.search_chance)
    NotDefined (tmpl_P->val.c.title, "SEARCH_CHANCE");
  if (!tmpl_P->def.stealth_factor)
    NotDefined (tmpl_P->val.c.title, "STEALTH_FACTOR");
  if (!tmpl_P->def.frequency_of_search)
    NotDefined (tmpl_P->val.c.title, "FREQUENCY_OF_SEARCH");
  if (!tmpl_P->def.base_to_hit)
    NotDefined (tmpl_P->val.c.title, "BASE_TO_HIT");
  if (!tmpl_P->def.base_to_hit_with_bows)
    NotDefined (tmpl_P->val.c.title, "BASE_TO_HIT_WITH_BOWS");
  if (!tmpl_P->def.saving_throw)
    NotDefined (tmpl_P->val.c.title, "SAVING_THROW");
  if (!tmpl_P->def.strength_modifier)
    NotDefined (tmpl_P->val.c.title, "STRENGTH_MODIFIER");
  if (!tmpl_P->def.intelligence_modifier)
    NotDefined (tmpl_P->val.c.title, "INTELLIGENCE_MODIFIER");
  if (!tmpl_P->def.wisdom_modifier)
    NotDefined (tmpl_P->val.c.title, "WISDOM_MODIFIER");
  if (!tmpl_P->def.dexterity_modifier)
    NotDefined (tmpl_P->val.c.title, "DEXTERITY_MODIFIER");
  if (!tmpl_P->def.constitution_modifier)
    NotDefined (tmpl_P->val.c.title, "CONSTITUTION_MODIFIER");
  if (!tmpl_P->def.charisma_modifier)
    NotDefined (tmpl_P->val.c.title, "CHARISMA_MODIFIER");
  if (!tmpl_P->def.experience_factor)
    NotDefined (tmpl_P->val.c.title, "EXPERIENCE_FACTOR");
  if (!tmpl_P->def.adjust_base_to_hit)
    NotDefined (tmpl_P->val.c.title, "ADJUST_BASE_TO_HIT");
  if (!tmpl_P->def.adjust_base_to_hit_with_bows)
    NotDefined (tmpl_P->val.c.title, "ADJUST_BASE_TO_HIT_WITH_BOWS");
  if (!tmpl_P->def.adjust_use_device)
    NotDefined (tmpl_P->val.c.title, "ADJUST_USE_DEVICE");
  if (!tmpl_P->def.adjust_disarming)
    NotDefined (tmpl_P->val.c.title, "ADJUST_DISARMING");
  if (!tmpl_P->def.adjust_saving_throw)
    NotDefined (tmpl_P->val.c.title, "ADJUST_SAVING_THROW");

  if (St_DefSym (classT_P, s, GEN_TYPE_TMPL, gval) == ST_SYM_FOUND) 
    {
      fprintf (arguments.rcc.outfile, "Warning: redefining \"%s\", line %d\n", 
               tmpl_P->val.c.title, lineNo);
    }

  return;
}

race_template_t* get_race(char *race)
{
  race_template_t *r;
  generic_t gval;
  int type;
  if (St_GetSym (raceT_P, race, &type, &gval) != ST_SYM_FOUND) 
    return NULL;
  r = (race_template_t*) gval.v;
  return r;
}

char *get_race_for_idx(int idx)
{
  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  St_SArgzTable (raceT_P, &argz, &argz_len);
  race_template_t *r;
  generic_t gval;
  int type;
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (raceT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        continue;
      r = (race_template_t*) gval.v;
      if (r->idx == idx)
        return r->val.r.trace;
    }
  return NULL;
}


void 
WriteConstants ()
{
  fprintf (arguments.rcc.outfile, "#ifndef RACE_CLASS_CONSTANT_H\n");
  fprintf (arguments.rcc.outfile, "#define RACE_CLASS_CONSTANT_H\n");

  fprintf (arguments.rcc.outfile, "#define MAX_PLAYER_LEVEL %3d    %s\n", 
           num_experience_levels, 
           "/* Maximum possible character level      */");
  if (num_experience_levels > 0)
    fprintf (arguments.rcc.outfile, "#define MAX_EXP  %10dL    %s\n", 
             experience_levels[num_experience_levels-1]-1,
             "/* Maximum amount of experience -CJS- */");
  else
    fprintf (arguments.rcc.outfile, "#define MAX_EXP   %10d    %s\n", 0,
             "/* Maximum amount of experience -CJS- */");
  fprintf (arguments.rcc.outfile, "#define MAX_RACES      %5d    %s\n", 
           St_TableSize(raceT_P),
           "/* Number of defined races               */");
  fprintf (arguments.rcc.outfile, "#define MAX_CLASS      %5d    %s\n", 
           St_TableSize(classT_P),
           "/* Number of defined classes             */");

  int num_backgrounds = 0;
  int i;
  int num_races = St_TableSize(raceT_P);
  for (i = 0; i < num_races; i++)
    {
      char *race = get_race_for_idx(i);
      if (!race)
        continue;
      race_template_t *r = get_race(race);
      num_backgrounds += r->val.num_backgrounds;
    }
  fprintf (arguments.rcc.outfile, "#define MAX_BACKGROUND   %3d    %s\n",
           num_backgrounds, "/* Number of types of histories for univ */");
  fprintf (arguments.rcc.outfile, "#define MAX_OWNERS     %5d    %s\n", 
           num_shopkeeps, "/* Number of owners to choose from       */");
  fprintf (arguments.rcc.outfile, "#endif\n");
}

void CheckRace (race_template_t *race)
{
  int i;
  for (i = 0; i < race->val.num_price_adjust; i++)
    {
      generic_t gval;
      int type;
      if (St_GetSym (raceT_P, race->val.price_adjust[i].race, 
                     &type, &gval) != ST_SYM_FOUND) 
        {
          ErrMsgLineNo (xasprintf("unknown race `%s'", 
                                   race->val.price_adjust[i].race), 
                        race->line_no_for_price_adjust);
        }
    }
  if (race->val.num_price_adjust != St_TableSize(raceT_P))
    {
      ErrMsgLineNo ("missing races in store price adjust block", 
                    race->line_no_for_price_adjust);
    }
  
  char *entry = NULL;
  while ((entry = argz_next (race->val.classes_argz, race->val.classes_len, 
                             entry)))
    {
      generic_t gval;
      int type;
      if (St_GetSym (classT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        {
          ErrMsgLineNo (xasprintf("unknown class `%s'", entry), 
                        race->line_no_for_classes);
        }
    }
}

int check_background_chart (int chart, background_type *b, int num, int *depth)
{
  //recursively check the chart until we get zero, or loop too many times.
  //or we don't find a chart.
  int i;
  int found = 0;
  int next = -1;
  for (i = 0; i < num; i++)
    {
      if (b[i].chart == chart)
        {
          next = b[i].next;
          found = 1;
        }
    }
  if (!found)
    return -1;
  *depth  = *depth + 1;
  if (*depth > num)
    return -2;
  for (i = 0; i < num; i++)
    {
      if (b[i].chart == next)
        {
          found = 1;
          break;
        }
    }
  if (!found)
    return -3;
  else if (next == 0)
    return 0;
  else
    return check_background_chart (next, b, num, depth);
}

int is_starting_chart(int chart)
{
  int i;
  int num_races = St_TableSize(raceT_P);
  for (i = 0; i < num_races; i++)
    {
      char *race = get_race_for_idx(i);
      if (!race)
        continue;
      race_template_t *r = get_race(race);
      if (r->val.num_backgrounds && r->val.backgrounds[0].chart == chart)
        return 1;
    }
  return 0;
}

void CheckRaces()
{
  char *argz = NULL;
  size_t argz_len = 0;;
  char *entry = NULL;
  int type;
  int num_races = St_TableSize(raceT_P);
  if (num_races == 0)
    {
      ErrMsgLineNo("no race blocks found", -1);
      return;
    }
  generic_t gval;
  St_SArgzTable (raceT_P, &argz, &argz_len);
  race_template_t *r;
  int num_backgrounds = 0;
  int starting_chart[num_races];
  int race_count = 0;
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (raceT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        {
          fprintf (stderr, "internal err. in CheckRaces\n");
          exit (1);
        }
      r = (race_template_t *) gval.v;
      CheckRace(r);
      num_backgrounds += r->val.num_backgrounds;
      starting_chart[race_count] = r->val.backgrounds[0].chart;
      race_count++;
    }

  //collect the backgrounds into a single array
  entry = NULL;
  if (num_backgrounds)
    {
      int count = 0;
      int i;
      background_type backgrounds[num_backgrounds];
      while ((entry = argz_next (argz, argz_len, entry)))
        {
          if (St_GetSym (raceT_P, entry, &type, &gval) != ST_SYM_FOUND) 
            continue;
          r = (race_template_t *) gval.v;
          for (i = 0; i < r->val.num_backgrounds; i++)
            {
              backgrounds[count] = r->val.backgrounds[i];
              count++;
            }
        }
      for (i = 0; i < num_races; i++)
        {
          int depth = 0;
          int chart = starting_chart[i];
          if (check_background_chart(chart, backgrounds, num_backgrounds, &depth))
            ErrMsgLineNo (xasprintf ("background %d isn't complete, or loops infinitely", chart), -1);
        }

      int j;
      //every next needs a chart except for 0.
      for (i = 0; i < num_backgrounds; i++)
        {
          if (backgrounds[i].next == 0)
            continue;
          int found = 0;
          for (j = 0; j < num_backgrounds; j++)
            {
              if (backgrounds[j].chart == backgrounds[i].next)
                {
                  found = 1;
                  break;
                }
            }
          if (!found)
            {
              ErrMsgLineNo(xasprintf("background %d points to non-existent next", backgrounds[i].chart), -1);
              break;
            }
        }
        //each chart needs a next that points to it except for starting ones.
      for (i = 0; i < num_backgrounds; i++)
        {
          if (is_starting_chart(backgrounds[i].chart))
            continue;
          int found = 0;
          for (j = 0; j < num_backgrounds; j++)
            {
              if (backgrounds[j].next == backgrounds[i].chart)
                {
                  found = 1;
                  break;
                }
            }
          if (!found)
            {
              ErrMsgLineNo(xasprintf("background %d doesn't have another background pointing to it", backgrounds[i].chart), -1);
              break;
            }
        }
    }

  int shopkeeps[MAX_STORES];
  memset (shopkeeps, 0, sizeof (shopkeeps));
//check for one shopkeep for every pstore.
  entry = NULL;
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      int i;
      if (St_GetSym (raceT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        continue;
      r = (race_template_t *) gval.v;
      for (i = 0; i < r->val.num_shopkeeps; i++)
        shopkeeps[r->val.shopkeeps[i].pstore]++;
    }
  int j;
  for (j = 0; j < MAX_STORES; j++)
    if (shopkeeps[j] == 0)
      ErrMsgLineNo (xasprintf ("store '%c' doesn't have any shopkeeps", 
                               j + '1'), -1);
}

void CheckClass(class_template_t *c)
{
  if (c->val.num_spells && c->val.num_prayers)
    {
      ErrMsgLineNo(xasprintf("Class `%s' can't have both spells and prayers", c->val.c.title), -1);
    }
  int i;
  int max_levels = num_experience_levels;
  for (i = 0; i < c->val.num_spells; i++)
    {
      if (c->val.spells[i].s.slevel > max_levels)
        ErrMsgLineNo(xasprintf("spell has level exceeding %d", max_levels), c->val.spells[i].line_no);
    }
  for (i = 0; i < c->val.num_prayers; i++)
    {
      if (c->val.prayers[i].s.slevel > max_levels)
        ErrMsgLineNo(xasprintf("prayer has level exceeding %d", max_levels), c->val.prayers[i].line_no);
    }
  if (num_experience_levels != 
      argz_count (c->val.titles_argz, c->val.titles_len))
    {
      ErrMsgLineNo(xasprintf("%d titles given for `%s' but need %d",
                             argz_count(c->val.titles_argz, c->val.titles_len),
                             c->val.c.title, max_levels), -1);
    }

    //is this class referenced by a race?
    int found = 0;
    int num_races = St_TableSize(raceT_P);
    for (i = 0; i < num_races; i++)
      {
        char *race = get_race_for_idx(i);
        if (!race)
          continue;
        race_template_t *r = get_race(race);
        char *argz = r->val.classes_argz;
        size_t len = r->val.classes_len;
        char *cl = NULL;
        while ((cl = argz_next (argz, len, cl)))
          {
            if (strcmp (cl, c->val.c.title) == 0)
              {
                found = 1;
                break;
              }
          }
        if (found)
          break;
      }
      if (!found)
        ErrMsgLineNo(xasprintf("class `%s' is not referenced by any race's "
                               "classes block.", c->val.c.title), -1);
}

void CheckClasses()
{
  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  int type;
  generic_t gval;
  St_SArgzTable (classT_P, &argz, &argz_len);
  class_template_t *c;
  int num_classes = St_TableSize(classT_P);
  if (num_classes == 0)
    {
      ErrMsgLineNo("no class blocks found", -1);
      return;
    }
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (classT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        {
          fprintf (stderr, "internal err. in CheckClasses\n");
          exit (1);
        }
      c = (class_template_t *) gval.v;
      CheckClass(c);
    }
}

void WriteExperienceTable()
{
  int i;
  fprintf (arguments.rcc.outfile, "/* Base experience levels, may be adjusted"
                                  " up for race and/or class*/\n");
  fprintf (arguments.rcc.outfile, "int32u player_exp[MAX_PLAYER_LEVEL] = {");
  for (i = 0; i < num_experience_levels; i++)
    {
      if (i % 8 == 0)
        fprintf (arguments.rcc.outfile, "\n  ");
      else
        fprintf (arguments.rcc.outfile, " ");
      if (experience_levels[i] >= 32768)
        fprintf (arguments.rcc.outfile, "%dL,", experience_levels[i]);
      else
        fprintf (arguments.rcc.outfile, "%d,", experience_levels[i]);
    }
  fprintf (arguments.rcc.outfile, "\n};\n\n");
}

int sort_by_pstore (const void *s1, const void *s2)
{
  owner_type *lowner = (owner_type*) s1;
  owner_type *rowner = (owner_type*) s2;
  return lowner->pstore - rowner->pstore;
}

void WriteShopkeepTable()
{
  //dump all the shopkeeps from each race into an array
  owner_type shopkeeps[num_shopkeeps];

  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  int type;
  int count = 0;
  int i, j, k;
  generic_t gval;
  St_SArgzTable (raceT_P, &argz, &argz_len);
  race_template_t *r;
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (raceT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        continue;
      r = (race_template_t *) gval.v;
      for (i = 0; i < r->val.num_shopkeeps; i++)
        {
          shopkeeps[count] = r->val.shopkeeps[i];

          count++;
        }
    }
  qsort (shopkeeps, num_shopkeeps, sizeof (owner_type), sort_by_pstore);

  fprintf (arguments.rcc.outfile, "/* Store owners have different characteristics for pricing and haggling*/\n");
  fprintf (arguments.rcc.outfile, "owner_type owners[MAX_OWNERS] = {\n");
  owner_type *o = NULL;
  int last_idx[MAX_STORES];
  memset (last_idx, 0, sizeof (last_idx));
  //here we make an attempt to dump out the shopkeeps in groups of 6.
  for (k = 0; k < num_shopkeeps; k++)
    {
      for (i = 0; i < MAX_STORES; i++)
        {
          for (j = last_idx[i]; j < num_shopkeeps; j++)
            {
              o = &shopkeeps[j];
              if (o->pstore != i)
                continue;
              fprintf (arguments.rcc.outfile, "  {\"%s\",\n", o->owner_name);
              fprintf (arguments.rcc.outfile, 
                       "   %d, %d, %d, %d, %d, %d, %d},\n", 
                       o->max_cost, o->max_inflate, o->min_inflate, 
                       o->haggle_per, o->owner_race, o->insult_max, o->pstore);
              last_idx[i] = j + 1;
              break;
            }
        }
    }
  fprintf (arguments.rcc.outfile, "};\n\n");

}

char *get_short_name_for_race(char *race)
{
  if (strcmp (race, "Half-Elf") == 0)
    return strdup ("HfE");
  else if (strcmp (race, "Halfling") == 0)
    return strdup ("Hal");
  else if (strcmp (race, "Half-Orc") == 0)
    return strdup ("HfO");
  else if (strcmp (race, "Half-Troll") == 0)
    return strdup ("HfT");
  else
    {
      char nam[4];
      memset(nam, 0, sizeof (nam));
      strncpy (nam, race, 3);
      return strdup (nam);
    }
}

int get_idx_for_race(char *race)
{
  race_template_t *r;
  generic_t gval;
  int type;
  if (St_GetSym (raceT_P, race, &type, &gval) != ST_SYM_FOUND) 
    return -1;
  r = (race_template_t*) gval.v;
  return r->idx;
}

void WriteShopkeepRacePriceAdjustmentTable()
{
  fprintf (arguments.rcc.outfile, 
           "/* Buying and selling adjustments "
           "for character race VS store   */\n");
  fprintf (arguments.rcc.outfile, 
           "/* owner race                     "
           "                               */\n");
  fprintf (arguments.rcc.outfile, 
           "int8u rgold_adj[MAX_RACES][MAX_RACES] = {\n");

  int num_races = St_TableSize(raceT_P);
  int i, j, k;
  fprintf (arguments.rcc.outfile, "%18s/* ", "");
  for (i = 0; i < num_races; i++)
    {
      char *race = get_race_for_idx(i);
      if (race)
        {
          char *s = get_short_name_for_race(race);
          fprintf (arguments.rcc.outfile, "%-3s", s);
          if (i != num_races - 1)
            fprintf (arguments.rcc.outfile, ", ");
          free (s);
        }
    }
  fprintf (arguments.rcc.outfile, " */\n");
  for (i = 0; i < num_races; i++)
    {
      char *argz = NULL;
      size_t argz_len = 0;
      char *entry = NULL;
      St_SArgzTable (raceT_P, &argz, &argz_len);
      race_template_t *r;
      generic_t gval;
      int type;
      while ((entry = argz_next (argz, argz_len, entry)))
        {
          if (St_GetSym (raceT_P, entry, &type, &gval) != ST_SYM_FOUND) 
            continue;
          r = (race_template_t*) gval.v;
          if (r->idx == i)
            {
              fprintf (arguments.rcc.outfile, "/*%-15s*/ {", r->val.r.trace);
              for (j = 0; j < num_races; j++)
                {
                  for (k = 0; k < r->val.num_price_adjust; k++)
                    {
                      if (get_idx_for_race(r->val.price_adjust[k].race) == j)
                        {
                          fprintf (arguments.rcc.outfile, "%3d", 
                                   r->val.price_adjust[k].price);
                          if (j != num_races - 1)
                            fprintf (arguments.rcc.outfile, ", ");
                        }
                    }
                }
              fprintf (arguments.rcc.outfile, "}");
              if (r->idx != num_races - 1)
                fprintf (arguments.rcc.outfile, ",");
              fprintf (arguments.rcc.outfile, "\n");
            }
        }
      free(argz);
    }
  fprintf (arguments.rcc.outfile, "};\n\n");
}

class_template_t* get_class(char *class)
{
  class_template_t *c;
  generic_t gval;
  int type;
  if (St_GetSym (classT_P, class, &type, &gval) != ST_SYM_FOUND) 
    return NULL;
  c = (class_template_t*) gval.v;
  return c;
}

char *get_class_for_idx(int idx)
{
  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  St_SArgzTable (classT_P, &argz, &argz_len);
  class_template_t *c;
  generic_t gval;
  int type;
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (classT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        continue;
      c = (class_template_t*) gval.v;
      if (c->idx == idx)
        return c->val.c.title;
    }
  return NULL;
}

void WriteTitlesForClass(char *argz, size_t len)
{
  char *entry = NULL;
  int count = 0;
  int col_count = 0;
  int first = 1;
  while ((entry = argz_next (argz, len, entry)))
    {
      if (col_count + strlen (entry) + 4 > 80)
        {
          fprintf (arguments.rcc.outfile, "\n");
          col_count = 0;
        }
      if (col_count == 0)
        {
          if (first)
            {
              fprintf (arguments.rcc.outfile, "  {");
              first = 0;
            }
          else
            fprintf (arguments.rcc.outfile, "   ");
          col_count+=3;
        }
      fprintf (arguments.rcc.outfile, "\"%s\"", entry);
      col_count += strlen (entry) + 2;
      if (count != num_experience_levels -1)
        {
          fprintf (arguments.rcc.outfile, ", ");
          col_count += 2;
        }
      count++;
      if (count == num_experience_levels)
        fprintf (arguments.rcc.outfile, "},\n");
    }
}

void WriteClassTitles()
{
  int i;
  int num_classes = St_TableSize(classT_P);
  fprintf (arguments.rcc.outfile, 
           "/* Class titles for different levels"
           "                            */\n");
  fprintf (arguments.rcc.outfile,
           "char *player_title[MAX_CLASS][MAX_PLAYER_LEVEL] = {\n");
  for (i = 0; i < num_classes; i++)
    {
      char *class = get_class_for_idx(i);
      if (!class)
        continue;
      class_template_t *c = get_class(class);
      fprintf (arguments.rcc.outfile, "  /* %-13s */\n", class);
      WriteTitlesForClass(c->val.titles_argz, c->val.titles_len);
    }
  fprintf (arguments.rcc.outfile, "};\n\n");
}
      
void WriteRaceTable()
{
  fprintf (arguments.rcc.outfile, "/*  Race  STR,INT,WIS,DEX,CON,CHR, \n");
  fprintf (arguments.rcc.outfile, 
           "    Ages, heights, and weights (male then female)\n");
  fprintf (arguments.rcc.outfile, 
           "    Racial Bases for: dis,srh,stl,fos,bth,bthb,bsav,hitdie,\n");
  fprintf (arguments.rcc.outfile, 
           "    infra, exp base, choice-classes */\n");
  fprintf (arguments.rcc.outfile, "race_type race[MAX_RACES] = {\n");
  int i;
  int num_races = St_TableSize(raceT_P);
  for (i = 0; i < num_races; i++)
    {
      char *race = get_race_for_idx(i);
      if (!race)
        continue;
      race_template_t *r = get_race(race);
      fprintf (arguments.rcc.outfile, 
               "  {\"%s\", %hd, %hd, %hd, %hd, %hd, %hd,\n",
               r->val.r.trace, r->val.r.str_adj, r->val.r.int_adj, 
               r->val.r.wis_adj, r->val.r.dex_adj, r->val.r.con_adj,
               r->val.r.chr_adj);
      fprintf (arguments.rcc.outfile,  "   "
               "%hhu, %hhu, %hhu, %hhu, %hhu, %hhu, %hhu, %hhu, %hhu, %hhu,\n",
               r->val.r.b_age, r->val.r.m_age, r->val.r.m_b_ht, 
               r->val.r.m_m_ht, r->val.r.m_b_wt, r->val.r.m_m_wt,
               r->val.r.f_b_ht, r->val.r.f_m_ht, r->val.r.f_b_wt,
               r->val.r.f_m_wt);
      fprintf (arguments.rcc.outfile, "   "
               "%hd, %hd, %hd, %hd, %hd, %hd, %hd, %hhu, %hhu, %hhu, 0x%02X,\n",
                r->val.r.b_dis, r->val.r.srh, r->val.r.stl, r->val.r.fos,
                r->val.r.bth, r->val.r.bthb, r->val.r.bsav, r->val.r.bhitdie,
                r->val.r.infra, r->val.r.b_exp, r->val.r.rtclass);
      fprintf (arguments.rcc.outfile, "   },\n");
    }
  fprintf (arguments.rcc.outfile, "};\n\n");

}

int get_min_spell_level(class_template_t *c)
{
  int min = num_experience_levels + 1;
  int i;
  for (i = 0; i < c->val.num_spells; i++)
    if (c->val.spells[i].s.slevel < min)
      min = c->val.spells[i].s.slevel;
  for (i = 0; i < c->val.num_prayers; i++)
    if (c->val.prayers[i].s.slevel < min)
      min = c->val.prayers[i].s.slevel;
  if (min == num_experience_levels + 1)
    return 0;
  return min;
}

void WriteClassTable()
{
  fprintf (arguments.rcc.outfile,
           "/* Classes.                       "
           "                              */\n");
  fprintf (arguments.rcc.outfile, "class_type class[MAX_CLASS] = {\n");
  fprintf (arguments.rcc.outfile, "/*%-11s HP Dis Src Stl Fos bth btb sve  "
                                  "S  I  W  D Co Ch Spell Exp spl */\n", "");
  int i;
  int num_classes = St_TableSize(classT_P);
  for (i = 0; i < num_classes; i++)
    {
      char *class = get_class_for_idx(i);
      if (!class)
        continue;
      class_template_t *c = get_class(class);
      char *name = xasprintf ("\"%s\",", c->val.c.title);
      char *spells = "NONE,";
      if (c->val.num_prayers)
        spells = "PRIEST,";
      else if (c->val.num_spells)
        spells = "MAGE,";
      int min_spell_level = get_min_spell_level(c);
      fprintf (arguments.rcc.outfile, "  {%-10s "
               "%2hhu, %2hhu, %2hhu, %2hhu, %2hhu, %2hhu, %2hhu, %2hhu,"
               "%2hd,%2hd,%2hd,%2hd,%2hd,%2hd,%-7s%2hhu, %2d}", 
               name, c->val.c.adj_hd, c->val.c.mdis, c->val.c.msrh, 
               c->val.c.mstl, c->val.c.mfos, c->val.c.mbth, c->val.c.mbthb,
               c->val.c.msav, c->val.c.madj_str, c->val.c.madj_int,
               c->val.c.madj_wis, c->val.c.madj_dex, c->val.c.madj_con,
               c->val.c.madj_chr, spells, c->val.c.m_exp, min_spell_level);
      if (i != num_classes - 1)
        fprintf (arguments.rcc.outfile, ",");
      fprintf (arguments.rcc.outfile, "\n");
      free (name);
    }
  fprintf (arguments.rcc.outfile, "};\n\n");
}
      
void WriteClassLevelAdjustmentTable()
{
  fprintf (arguments.rcc.outfile,
           "/* making it 16 bits wastes a little space, but saves "
           "much signed/unsigned\n");
  fprintf (arguments.rcc.outfile,
           "   headaches in its use */\n");
  fprintf (arguments.rcc.outfile,
           "/* CLA_MISC_HIT is identical to CLA_SAVE, "
           "which takes advantage of\n");
  fprintf (arguments.rcc.outfile, "   "
           "the fact that the save values are independent of the class */\n");
  fprintf (arguments.rcc.outfile, 
           "int16 class_level_adj[MAX_CLASS][MAX_LEV_ADJ] = {\n");
  fprintf (arguments.rcc.outfile, 
           "/*%-13sbth bthb  devices disarm save/misc hit  */\n", "");
  int i;
  int num_classes = St_TableSize(classT_P);
  for (i = 0; i < num_classes; i++)
    {
      char *class = get_class_for_idx(i);
      if (!class)
        continue;
      class_template_t *c = get_class(class);
      fprintf (arguments.rcc.outfile, 
               "/* %-7s */ {%3hd, %3hd, %7hd, %5hd, %12hd}", 
               c->val.c.title, c->val.adjust_per_one_third_level[0],
               c->val.adjust_per_one_third_level[1],
               c->val.adjust_per_one_third_level[2],
               c->val.adjust_per_one_third_level[3],
               c->val.adjust_per_one_third_level[4]);
      if (i != num_classes -1)
        fprintf (arguments.rcc.outfile, ",");
      fprintf (arguments.rcc.outfile, "\n");
    }
  fprintf (arguments.rcc.outfile, 
           "};\n\n");
}

void FillClassFlagsInRaces()
{
  //here we take the list of named allowable classes for each race,
  //and we fill in the bitwise field "race_type.rtclass"
  char *argz = NULL;
  size_t argz_len = 0;
  const char *entry = NULL;
  int type;
  int num_races = St_TableSize(raceT_P);
  generic_t gval;
  St_SArgzTable (raceT_P, &argz, &argz_len);
  race_template_t *r;
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (raceT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        continue;
      r = (race_template_t *) gval.v;
      char *cl = NULL;
      while ((cl = argz_next (r->val.classes_argz, r->val.classes_len, cl)))
        {
          class_template_t *c = get_class(cl);
          if (!c)
            continue;
          int mask = (int) pow (2, c->idx);
          r->val.r.rtclass |= mask;
        }
    }
}
      
int sort_by_chart_and_roll (const void *lhs, const void *rhs)
{
  background_type *l = (background_type*) lhs;
  background_type *r = (background_type*) rhs;
  int diff = l->chart - r->chart;
  if (diff == 0)
    diff = l->roll - r->roll;
  return diff;
}

void WriteBackgrounds()
{
  int num_backgrounds = 0;
  int i;
  int num_races = St_TableSize(raceT_P);
  fprintf (arguments.rcc.outfile, "/* Background information"
           "                                       */\n");
  fprintf (arguments.rcc.outfile,
           "int background_start[MAX_RACES] = { "
           "/* starting .chart not index */\n");
  for (i = 0; i < num_races; i++)
    {
      char *race = get_race_for_idx(i);
      if (!race)
        continue;
      race_template_t *r = get_race(race);
      int start = 0;
      if (r->val.num_backgrounds)
        start = r->val.backgrounds[0].chart;
      fprintf (arguments.rcc.outfile, "  %3d, /* %s */\n", 
               start, r->val.r.trace);
      num_backgrounds += r->val.num_backgrounds;
    }
  fprintf (arguments.rcc.outfile, "};\n\n");

  //collect all of the backgrounds into an array and sort them
  background_type backgrounds[num_backgrounds];
  int count = 0;
  int j;
  for (i = 0; i < num_races; i++)
    {
      char *race = get_race_for_idx(i);
      if (!race)
        continue;
      race_template_t *r = get_race(race);
      for (j = 0; j < r->val.num_backgrounds; j++)
        {
          backgrounds[count] = r->val.backgrounds[j];
          count++;
        }
    }
  qsort (backgrounds, num_backgrounds, sizeof (background_type), 
         sort_by_chart_and_roll);
   //okay, dump them out
  fprintf (arguments.rcc.outfile, 
           "background_type background[MAX_BACKGROUND] = {\n");
  for (i = 0; i < num_backgrounds; i++)
    {
      background_type b = backgrounds[i];
      fprintf (arguments.rcc.outfile, 
               "  {\"%s\", %hhu, %hhu, %hhu, %hhu}",
               b.info, b.roll, b.chart, b.next, b.bonus);
      if (i != num_backgrounds - 1)
        fprintf (arguments.rcc.outfile, ",");
      fprintf (arguments.rcc.outfile, "\n");
    }
  fprintf (arguments.rcc.outfile, "};\n\n");
}
      
void WriteClassSpells(spell_t *spells, int num)
{
  int i, j;
  int max = 31;
  for (i = 0; i < max; i++)
    {
      int found = 0;
      for (j = 0; j < num; j++)
        {
          if (spells[j].idx == i)
            {
              fprintf (arguments.rcc.outfile, "   {%hhu, %hhu, %hhu, %hhu}",
                       spells[j].s.slevel, spells[j].s.smana, 
                       spells[j].s.sfail, spells[j].s.sexp);
              found = 1;
              break;
            }
        }
      if (!found)
        fprintf (arguments.rcc.outfile, "   {99, 99, 0, 0}");
      if (i != max - 1)
        fprintf (arguments.rcc.outfile, ",");
      fprintf (arguments.rcc.outfile, "\n");
    }
}

void WriteSpells()
{
  fprintf (arguments.rcc.outfile,
           "spell_type magic_spell[MAX_CLASS][31] = {\n");
  int num_classes = St_TableSize(classT_P);
  int i, j;
  for (i = 0; i < num_classes; i++)
    {
      char *class = get_class_for_idx(i);
      if (!class)
        continue;
      class_template_t *c = get_class(class);
      fprintf (arguments.rcc.outfile, 
               "  {%-29s /* %-13s */\n", "", c->val.c.title);
      if (c->val.num_spells)
        WriteClassSpells(c->val.spells, c->val.num_spells);
      else if (c->val.num_prayers)
        WriteClassSpells(c->val.prayers, c->val.num_prayers);
      else
        WriteClassSpells(c->val.spells, 0);
      fprintf (arguments.rcc.outfile, "   }");
      if (i != num_classes - 1)
        fprintf (arguments.rcc.outfile, ",");
      fprintf (arguments.rcc.outfile, "\n");
    }
  fprintf (arguments.rcc.outfile,"};\n\n");
}

int
rcc_main (char *inputFilename)
{
  InitTables ();

  if (strcmp (inputFilename, "-") == 0)
    input_F = stdin;
  else
    {
      input_F = fopen (inputFilename, "r");
      if (!input_F) 
	{
	  fprintf (stderr, "Error: couldn't open file.\n");
	  return -1;
	}
    }

  if (yyparse ()) 
    {
      fprintf (stderr, "Errors prevent continuation.\n");
      return -2;
    }

  FillClassFlagsInRaces();
  if (arguments.rcc.consistency_check)
    {
      CheckRaces();
      CheckClasses();
    }
  WriteGenerationNotice();
  if (arguments.rcc.only_generate_constants)
    WriteConstants ();
  else
    {
      fprintf (arguments.rcc.outfile, "#include \"constant.h\"\n");
      fprintf (arguments.rcc.outfile, "#include \"types.h\"\n\n");
      WriteShopkeepTable();
      WriteShopkeepRacePriceAdjustmentTable();
      WriteClassTitles();
      WriteExperienceTable();
      WriteRaceTable();
      WriteClassTable();
      WriteClassLevelAdjustmentTable();
      WriteBackgrounds();
      WriteSpells();
    }

  return 0;
}
