/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 21 "creature.y"

#include "config.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <netinet/in.h>

#include "st.h"
#include "opts.h"
#include "creature.h"
#include "mcheck.h"

int yylex();
int yyerror( char *s );

/*
 * defined_t is used to indicate whether all fields have been defined
 */

typedef struct {
    unsigned	move: 1,
		special: 1,
		treasure: 1,
		spell: 1,
		breath: 1,
		resist: 1,
		defense: 1,
		mexp: 1,
		sleep: 1,
		aaf: 1,
		ac: 1,
		speed: 1,
		cchar: 1,
		hd: 1,
		damage: 1,
		level: 1;
} defined_t;



/*
 * template_t contains creature definition & flags
 */

typedef struct 
{
  int idx;
  creature_type	val;
  defined_t def;
} template_t;




/*
 * symInit_t is used to initialize symbol tables with integer values
 */

typedef struct 
{
  char *name;
  int32u val;
} symInit_t;



static symInit_t 
defenseInit[] = 
{
    { "dragon", 0 },
    { "animal", 1 },
    { "evil", 2 },
    { "undead", 3 },
    { "frost", 4 },
    { "fire", 5 },
    { "poison", 6 },
    { "acid", 7 },
    { "light", 8 },
    { "stone", 9 },
    { "bit_9", 10 },
    { "bit_10", 11 },
    { "no_sleep", 12 },
    { "infra", 13 },
    { "max_hp", 14 },
    { "bit_15", 15 },
    { NULL, 0 }
};

static symInit_t 
moveInit[] = 
{
    { "attack_only", 0 },
    { "move_normal", 1 },
    { "magic_only", 2 },
    { "random_20", 3 },
    { "random_40", 4 },
    { "random_75", 5 },
    { "persistent", 6 },
    { NULL, 0 }
};

static symInit_t 
specialInit[] = 
{
    { "invisible", 16 },
    { "open_door", 17 },
    { "phase", 18 },
    { "eats_other", 19 },
    { "picks_up", 20 },
    { "multiply", 21 },
    { "win_creature", 31 },
    { NULL, 0 }
};

static symInit_t 
treasureInit[] = 
{
    { "carry_small_obj", 23 },
    { "carry_obj", 24 },
    { "carry_gold", 25 },
    { "has_random_60", 26 },
    { "has_random_90", 27 },
    { "has_1d2_obj", 28 },
    { "has_2d2_obj", 29 },
    { "has_4d2_obj", 30 },
    { NULL, 0 }
};

static symInit_t 
spellInit[] = 
{
    { "tel_short", 4 },
    { "tel_long", 5 },
    { "tel_to", 6 },
    { "lght_wnd", 7 },
    { "ser_wnd", 8 },
    { "hold_per", 9 },
    { "blind", 10 },
    { "confuse", 11 },
    { "fear", 12 },
    { "summon_mon", 13 },
    { "summon_und", 14 },
    { "slow_per", 15 },
    { "drain_mana", 16 },
    { "bit_17", 17 },
    { "bit_18", 18 },
    { NULL, 0 }
};

static symInit_t 
breathInit[] = 
{
    { "light", 19 },
    { "gas", 20 },
    { "acid", 21 },
    { "frost", 22 },
    { "fire", 23 },
    { NULL, 0 }
};

static symInit_t 
attackTypeInit[] = 
{
    { "normal_damage", 1 },
    { "lose_str", 2 },
    { "confusion", 3 },
    { "cause_fear", 4 },
    { "fire_damage", 5 },
    { "acid_damage", 6 },
    { "cold_damage", 7 },
    { "lightning_damage", 8 },
    { "corrosion", 9 },
    { "cause_blindness", 10 },
    { "cause_paralysis", 11 },
    { "steal_money", 12 },
    { "steal_obj", 13 },
    { "poison", 14 },
    { "lose_dex", 15 },
    { "lose_con", 16 },
    { "lose_int", 17 },
    { "lose_wis", 18 },
    { "lose_exp", 19 },
    { "aggravation", 20 },
    { "disenchant", 21 },
    { "eat_food", 22 },
    { "eat_light", 23 },
    { "eat_charges", 24 },
    { "blank", 99 },
    { NULL, 0 }
};

static symInit_t 
attackDescInit[] = 
{
    { "hits", 1 },
    { "bites", 2 },
    { "claws", 3 },
    { "stings", 4 },
    { "touches", 5 },
    { "kicks", 6 },
    { "gazes", 7 },
    { "breathes", 8 },
    { "spits", 9 },
    { "wails", 10 },
    { "embraces", 11 },
    { "crawls_on", 12 },
    { "releases_spores", 13 },
    { "begs_for_money", 14 },
    { "slimes", 15 },
    { "crushes", 16 },
    { "tramples", 17 },
    { "drools_on", 18 },
    { "insults", 19 },
    { "is_repelled", 99 },
    { NULL, 0 }
};





/*
 * Maximum token length = maximum string constant length
 * Also, trim the stack to an "acceptable" size.
 */

#define	MAX_TOK_LEN	64		/* maximum acceptable token length  */
#define	YYSTACKSIZE	128

#define GEN_TYPE_TMPL	256		/* type of a template for st	    */

/*
 * Globals used by the tokenizer (lexical analyzer)
 */

#define INPUT_BUF_SIZE 256
static char	inputBuf[INPUT_BUF_SIZE] = { 0 };
					/* input line buffer		    */
static char	*inputBufp = inputBuf;	/* position in input line buffer    */
static int	lineNo = 0;		/* number of current line	    */
static FILE	*input_F;
static char	tokStr[MAX_TOK_LEN];	/* text of current token	    */
static	int	tokType;		/* type of current token	    */

static template_t blankTemplate;	/* blank template for init-ing     */
static template_t tmpTemplate;		/* working template for current     */
					/* class or creature		    */

#define MAX_ATTACK 250
static m_attack_type attackList[MAX_ATTACK];
static m_attack_type sorted_attackList[MAX_ATTACK];
static int attackCt = 1;
static int creatureAttacks = 0;
static int maxCreatureLevel = 0;

/*
 * Global symbol tables
 */

static st_Table_Pt keywordT_P;		/* parser's keywords		    */
static st_Table_Pt defenseT_P;		/* defense flags		    */
static st_Table_Pt moveT_P;		/* movement flags		    */
static st_Table_Pt specialT_P;		/* special flags		    */
static st_Table_Pt treasureT_P;		/* treasure flags		    */
static st_Table_Pt spellT_P;		/* spell flags			    */
static st_Table_Pt breathT_P;		/* breath flags			    */
static st_Table_Pt attackTypeT_P;	/* attack type flags		    */
static st_Table_Pt attackDescT_P;	/* attack desc flags		    */
static st_Table_Pt classT_P;		/* class templates		    */
static st_Table_Pt creatureT_P;		/* creature definitions		    */

/*
 * Function declarations
 */

extern void AddDefense ();
extern void NegDefense ();
extern void AddMove ();
extern void NegMove ();
extern void AddTreasure ();
extern void NegTreasure ();
extern void AddSpecial ();
extern void NegSpecial ();
extern void AddSpell ();
extern void NegSpell ();
extern void AddBreath ();
extern void AddFreq ();
extern void NegBreath ();
extern void AddResist ();
extern void NegResist ();
extern void AddAttack ();
extern void AddUnusedAttack ();
extern void WriteCreature ();
extern void PutClassTemplate ();
extern template_t GetClassTemplate ();
extern int MergeClassTemplate (char *s, template_t *t1);
extern void PutCreature ();
extern int FindAttackCount (int8u *);


#line 374 "creature.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif


/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    YYEOF = 0,                     /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    CLASS = 258,                   /* CLASS  */
    CREATURE = 259,                /* CREATURE  */
    UNUSED = 260,                  /* UNUSED  */
    NAMED = 261,                   /* NAMED  */
    HD = 262,                      /* HD  */
    MOVE = 263,                    /* MOVE  */
    SPELL = 264,                   /* SPELL  */
    BREATH = 265,                  /* BREATH  */
    DEFENSE = 266,                 /* DEFENSE  */
    XP = 267,                      /* XP  */
    CCHAR = 268,                   /* CCHAR  */
    SLEEP = 269,                   /* SLEEP  */
    RADIUS = 270,                  /* RADIUS  */
    SPEED = 271,                   /* SPEED  */
    ATTACK = 272,                  /* ATTACK  */
    FOR = 273,                     /* FOR  */
    AC = 274,                      /* AC  */
    LEVEL = 275,                   /* LEVEL  */
    TREASURE = 276,                /* TREASURE  */
    SPECIAL = 277,                 /* SPECIAL  */
    OF = 278,                      /* OF  */
    IN = 279,                      /* IN  */
    NOTHING = 280,                 /* NOTHING  */
    DESCRIPTION = 281,             /* DESCRIPTION  */
    RESIST = 282,                  /* RESIST  */
    IDENTIFIER = 283,              /* IDENTIFIER  */
    FLOAT_LIT = 284,               /* FLOAT_LIT  */
    INT_LIT = 285,                 /* INT_LIT  */
    STRING_LIT = 286,              /* STRING_LIT  */
    BOOL_LIT = 287                 /* BOOL_LIT  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif
/* Token kinds.  */
#define YYEMPTY -2
#define YYEOF 0
#define YYerror 256
#define YYUNDEF 257
#define CLASS 258
#define CREATURE 259
#define UNUSED 260
#define NAMED 261
#define HD 262
#define MOVE 263
#define SPELL 264
#define BREATH 265
#define DEFENSE 266
#define XP 267
#define CCHAR 268
#define SLEEP 269
#define RADIUS 270
#define SPEED 271
#define ATTACK 272
#define FOR 273
#define AC 274
#define LEVEL 275
#define TREASURE 276
#define SPECIAL 277
#define OF 278
#define IN 279
#define NOTHING 280
#define DESCRIPTION 281
#define RESIST 282
#define IDENTIFIER 283
#define FLOAT_LIT 284
#define INT_LIT 285
#define STRING_LIT 286
#define BOOL_LIT 287

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
union YYSTYPE
{
#line 333 "creature.y"

	int ival;
	double dval;
	char sval[MAX_TOK_LEN];
	

#line 495 "creature.c"

};
typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;


int yyparse (void);



/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_CLASS = 3,                      /* CLASS  */
  YYSYMBOL_CREATURE = 4,                   /* CREATURE  */
  YYSYMBOL_UNUSED = 5,                     /* UNUSED  */
  YYSYMBOL_NAMED = 6,                      /* NAMED  */
  YYSYMBOL_HD = 7,                         /* HD  */
  YYSYMBOL_MOVE = 8,                       /* MOVE  */
  YYSYMBOL_SPELL = 9,                      /* SPELL  */
  YYSYMBOL_BREATH = 10,                    /* BREATH  */
  YYSYMBOL_DEFENSE = 11,                   /* DEFENSE  */
  YYSYMBOL_XP = 12,                        /* XP  */
  YYSYMBOL_CCHAR = 13,                     /* CCHAR  */
  YYSYMBOL_SLEEP = 14,                     /* SLEEP  */
  YYSYMBOL_RADIUS = 15,                    /* RADIUS  */
  YYSYMBOL_SPEED = 16,                     /* SPEED  */
  YYSYMBOL_ATTACK = 17,                    /* ATTACK  */
  YYSYMBOL_FOR = 18,                       /* FOR  */
  YYSYMBOL_AC = 19,                        /* AC  */
  YYSYMBOL_LEVEL = 20,                     /* LEVEL  */
  YYSYMBOL_TREASURE = 21,                  /* TREASURE  */
  YYSYMBOL_SPECIAL = 22,                   /* SPECIAL  */
  YYSYMBOL_OF = 23,                        /* OF  */
  YYSYMBOL_IN = 24,                        /* IN  */
  YYSYMBOL_NOTHING = 25,                   /* NOTHING  */
  YYSYMBOL_DESCRIPTION = 26,               /* DESCRIPTION  */
  YYSYMBOL_RESIST = 27,                    /* RESIST  */
  YYSYMBOL_IDENTIFIER = 28,                /* IDENTIFIER  */
  YYSYMBOL_FLOAT_LIT = 29,                 /* FLOAT_LIT  */
  YYSYMBOL_INT_LIT = 30,                   /* INT_LIT  */
  YYSYMBOL_STRING_LIT = 31,                /* STRING_LIT  */
  YYSYMBOL_BOOL_LIT = 32,                  /* BOOL_LIT  */
  YYSYMBOL_33_ = 33,                       /* ';'  */
  YYSYMBOL_34_ = 34,                       /* '#'  */
  YYSYMBOL_35_ = 35,                       /* '{'  */
  YYSYMBOL_36_ = 36,                       /* '}'  */
  YYSYMBOL_37_ = 37,                       /* ':'  */
  YYSYMBOL_38_ = 38,                       /* ','  */
  YYSYMBOL_39_ = 39,                       /* '|'  */
  YYSYMBOL_40_ = 40,                       /* '/'  */
  YYSYMBOL_41_ = 41,                       /* '~'  */
  YYSYMBOL_YYACCEPT = 42,                  /* $accept  */
  YYSYMBOL_creatures = 43,                 /* creatures  */
  YYSYMBOL_comment_def = 44,               /* comment_def  */
  YYSYMBOL_comments = 45,                  /* comments  */
  YYSYMBOL_comment = 46,                   /* comment  */
  YYSYMBOL_more_comments = 47,             /* more_comments  */
  YYSYMBOL_class_def = 48,                 /* class_def  */
  YYSYMBOL_unused_def = 49,                /* unused_def  */
  YYSYMBOL_parent_classes = 50,            /* parent_classes  */
  YYSYMBOL_parent_class = 51,              /* parent_class  */
  YYSYMBOL_more_classes = 52,              /* more_classes  */
  YYSYMBOL_creature_def = 53,              /* creature_def  */
  YYSYMBOL_unusedfeatures = 54,            /* unusedfeatures  */
  YYSYMBOL_unusedfeature = 55,             /* unusedfeature  */
  YYSYMBOL_features = 56,                  /* features  */
  YYSYMBOL_feature = 57,                   /* feature  */
  YYSYMBOL_description = 58,               /* description  */
  YYSYMBOL_unusedattacks = 59,             /* unusedattacks  */
  YYSYMBOL_unusedattack = 60,              /* unusedattack  */
  YYSYMBOL_more_unusedattacks = 61,        /* more_unusedattacks  */
  YYSYMBOL_attacks = 62,                   /* attacks  */
  YYSYMBOL_attack = 63,                    /* attack  */
  YYSYMBOL_more_attacks = 64,              /* more_attacks  */
  YYSYMBOL_moves = 65,                     /* moves  */
  YYSYMBOL_move = 66,                      /* move  */
  YYSYMBOL_more_moves = 67,                /* more_moves  */
  YYSYMBOL_spells = 68,                    /* spells  */
  YYSYMBOL_spell = 69,                     /* spell  */
  YYSYMBOL_more_spells = 70,               /* more_spells  */
  YYSYMBOL_resists = 71,                   /* resists  */
  YYSYMBOL_resist = 72,                    /* resist  */
  YYSYMBOL_more_resists = 73,              /* more_resists  */
  YYSYMBOL_breaths = 74,                   /* breaths  */
  YYSYMBOL_breath = 75,                    /* breath  */
  YYSYMBOL_more_breaths = 76,              /* more_breaths  */
  YYSYMBOL_defenses = 77,                  /* defenses  */
  YYSYMBOL_defense = 78,                   /* defense  */
  YYSYMBOL_more_defenses = 79,             /* more_defenses  */
  YYSYMBOL_carries = 80,                   /* carries  */
  YYSYMBOL_carry = 81,                     /* carry  */
  YYSYMBOL_more_carries = 82,              /* more_carries  */
  YYSYMBOL_specials = 83,                  /* specials  */
  YYSYMBOL_special = 84,                   /* special  */
  YYSYMBOL_more_specials = 85              /* more_specials  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;


/* Second part of user prologue.  */
#line 347 "creature.y"

static symInit_t 
keywordInit[] = 
{
    { "class", CLASS },
    { "creature", CREATURE },
    { "unused", UNUSED},
    { "named", NAMED },
    { "hd", HD },
    { "move", MOVE },
    { "spell", SPELL },
    { "breath", BREATH },
    { "defense", DEFENSE },
    { "exp", XP },
    { "letter", CCHAR },
    { "sleep", SLEEP },
    { "radius", RADIUS },
    { "speed", SPEED },
    { "attack", ATTACK },
    { "for", FOR },
    { "ac", AC },
    { "level", LEVEL },
    { "treasure", TREASURE },
    { "special", SPECIAL },
    { "of", OF },
    { "in", IN },
    { "none", NOTHING },
    { "description", DESCRIPTION},
    { "resist", RESIST},
    { NULL, 0 }
};

#line 639 "creature.c"


#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_uint8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  16
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   172

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  42
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  44
/* YYNRULES -- Number of rules.  */
#define YYNRULES  99
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  207

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   287


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,    34,     2,     2,     2,     2,
       2,     2,     2,     2,    38,     2,     2,    40,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    37,    33,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    35,    39,    36,    41,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   403,   403,   404,   405,   406,   407,   410,   414,   417,
     421,   422,   425,   429,   432,   434,   438,   443,   448,   449,
     452,   463,   464,   467,   470,   471,   474,   477,   481,   484,
     487,   490,   493,   496,   499,   500,   501,   502,   508,   509,
     515,   516,   517,   518,   519,   522,   523,   526,   529,   531,
     534,   535,   538,   541,   543,   554,   555,   558,   561,   562,
     563,   566,   567,   570,   571,   574,   575,   576,   579,   580,
     583,   586,   587,   588,   591,   592,   595,   598,   599,   600,
     603,   604,   607,   610,   611,   612,   615,   616,   619,   622,
     623,   624,   627,   628,   631,   634,   635,   636,   639,   640
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "CLASS", "CREATURE",
  "UNUSED", "NAMED", "HD", "MOVE", "SPELL", "BREATH", "DEFENSE", "XP",
  "CCHAR", "SLEEP", "RADIUS", "SPEED", "ATTACK", "FOR", "AC", "LEVEL",
  "TREASURE", "SPECIAL", "OF", "IN", "NOTHING", "DESCRIPTION", "RESIST",
  "IDENTIFIER", "FLOAT_LIT", "INT_LIT", "STRING_LIT", "BOOL_LIT", "';'",
  "'#'", "'{'", "'}'", "':'", "','", "'|'", "'/'", "'~'", "$accept",
  "creatures", "comment_def", "comments", "comment", "more_comments",
  "class_def", "unused_def", "parent_classes", "parent_class",
  "more_classes", "creature_def", "unusedfeatures", "unusedfeature",
  "features", "feature", "description", "unusedattacks", "unusedattack",
  "more_unusedattacks", "attacks", "attack", "more_attacks", "moves",
  "move", "more_moves", "spells", "spell", "more_spells", "resists",
  "resist", "more_resists", "breaths", "breath", "more_breaths",
  "defenses", "defense", "more_defenses", "carries", "carry",
  "more_carries", "specials", "special", "more_specials", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-74)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-1)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int8 yypact[] =
{
      -2,    -8,   -10,    15,    31,    62,    -2,    30,    32,    33,
      34,    34,    47,   -74,   -74,    31,   -74,   -74,    -2,    -2,
      -2,    39,    35,    37,    36,    40,    41,    31,   -74,   -74,
     -74,   -74,   -74,    42,    -3,    -3,    12,   -74,    47,   -74,
      39,   -74,    44,    45,   -15,     9,    46,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    59,    43,
      64,    63,   -74,    60,   -74,    65,   -74,    42,    68,     0,
      28,     1,    61,     2,     6,    70,    71,    74,    75,    76,
      27,    77,    78,     8,    10,    29,    20,   -74,    -3,   -74,
      79,    12,   -74,   -74,    72,   -74,   -74,    82,   -74,    80,
      83,   -74,   -74,    84,   -74,    81,    85,   -74,   -74,    86,
     -74,    87,   -74,   -74,    88,   -74,    89,   -74,   -74,   -74,
     -74,   -74,   -74,    66,   -74,    90,   -74,   -74,   -74,   -74,
      92,   -74,    91,   -74,   -74,    93,   -74,    94,   -74,   -74,
     -74,   -74,   -74,    95,   -74,    96,   -74,    97,    65,   100,
     -74,     0,   -74,    98,   -74,     1,   -74,   101,   -74,     2,
     -74,   -74,     6,   -74,   103,    27,   -74,   -74,     8,   -74,
     -74,    10,   -74,   -74,    20,   -74,   107,   -74,   -74,    80,
       1,    81,     2,    87,    89,   102,    90,    91,    94,    96,
      99,   -74,   -74,   -74,   -74,   -74,   -74,   109,   -74,   -74,
     -74,   -74,   112,   108,   -74,   114,   -74
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int8 yydefact[] =
{
       6,     0,     0,     0,     0,     0,     6,     0,     0,     0,
      15,    15,    22,     9,     7,    11,     1,     5,     6,     6,
       6,    17,     0,     0,     0,     0,     0,    11,     8,     2,
       4,     3,    16,    19,    25,    25,     0,    13,    22,    10,
      17,    14,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    49,     0,    23,    51,    21,    19,     0,     0,
       0,    64,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    12,    25,    20,
       0,     0,    47,    18,     0,    60,    58,     0,    35,    62,
       0,    67,    65,     0,    36,    69,     0,    79,    77,     0,
      38,    81,    85,    83,     0,    41,    87,    28,    29,    31,
      32,    33,    54,     0,    34,    56,    30,    26,    91,    89,
       0,    42,    93,    97,    95,     0,    43,    99,    46,    45,
      44,    73,    71,     0,    40,    75,    24,     0,    51,     0,
      59,     0,    57,     0,    66,     0,    63,     0,    78,     0,
      76,    84,     0,    82,     0,     0,    52,    90,     0,    88,
      96,     0,    94,    72,     0,    70,     0,    50,    27,    62,
      64,    69,     0,    81,    87,     0,    56,    93,    99,    75,
       0,    61,    37,    68,    39,    80,    86,     0,    55,    92,
      98,    74,     0,     0,    48,     0,    53
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -74,    38,   -74,   -74,    73,   116,   -74,   -74,   106,   104,
     105,   -74,   110,   -74,   -35,   -74,   -74,   -74,   -22,   -73,
     -74,   -41,   -60,   -74,    -6,   -33,   -31,    -5,   -34,   -74,
     -23,   -37,   -29,    -4,   -27,   -74,    -1,   -30,   -74,   -11,
     -28,   -74,   -13,   -26
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_uint8 yydefgoto[] =
{
       0,     5,     6,    14,    27,    28,     7,     8,    22,    33,
      41,     9,    25,    26,    59,    60,   140,    64,    65,    92,
     124,   125,   166,    98,    99,   152,   104,   105,   156,   144,
     145,   175,   110,   111,   160,   115,   116,   163,   131,   132,
     169,   136,   137,   172
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_uint8 yytable[] =
{
      61,     1,     2,     3,    42,    43,    44,    45,    46,    47,
      48,    49,    50,    51,    52,    70,    53,    54,    55,    56,
      10,    11,    71,    57,    58,    95,   101,   107,    96,   102,
     108,   112,     4,   128,   113,   133,   129,    62,   134,    72,
      63,    97,   103,   109,    17,   141,    73,   114,   142,   130,
      12,   135,   122,   146,   138,   123,    29,    30,    31,    13,
     139,   143,    16,    18,    24,    19,    20,    32,   100,   148,
      34,    21,    35,    36,    38,   177,    37,    15,    90,    87,
      40,    68,    69,    74,   164,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    88,    94,    89,
     117,   106,   118,    91,   119,   120,   121,   126,   127,   147,
     150,   149,   154,   153,   158,   157,   161,    23,   151,   155,
     167,   170,   202,   173,   186,   159,   198,   162,   165,   168,
     178,   205,   171,   185,   174,   180,   176,   190,   182,   203,
     204,   197,   206,    39,    67,   179,   191,   193,    66,   192,
     181,   189,   201,   194,   196,   183,   195,   187,   188,   199,
       0,   184,   200,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    93
};

static const yytype_int16 yycheck[] =
{
      35,     3,     4,     5,     7,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    30,    19,    20,    21,    22,
      28,    31,    37,    26,    27,    25,    25,    25,    28,    28,
      28,    25,    34,    25,    28,    25,    28,    25,    28,    30,
      28,    41,    41,    41,     6,    25,    37,    41,    28,    41,
      35,    41,    25,    88,    25,    28,    18,    19,    20,    28,
      31,    41,     0,    33,    17,    33,    33,    28,    40,    91,
      35,    37,    35,    37,    33,   148,    36,     4,    18,    36,
      38,    37,    37,    37,    18,    37,    37,    37,    37,    37,
      37,    37,    37,    37,    37,    37,    37,    33,    30,    36,
      30,    40,    31,    38,    30,    30,    30,    30,    30,    30,
      28,    39,    28,    30,    28,    30,    28,    11,    38,    38,
      28,    28,    23,    28,   165,    38,   186,    38,    38,    38,
      30,    23,    38,    30,    38,    37,    39,    30,    37,    30,
      28,    39,    28,    27,    40,   151,   179,   181,    38,   180,
     155,   174,   189,   182,   184,   159,   183,   168,   171,   187,
      -1,   162,   188,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    67
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,     3,     4,     5,    34,    43,    44,    48,    49,    53,
      28,    31,    35,    28,    45,    46,     0,    43,    33,    33,
      33,    37,    50,    50,    17,    54,    55,    46,    47,    43,
      43,    43,    28,    51,    35,    35,    37,    36,    33,    47,
      38,    52,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    19,    20,    21,    22,    26,    27,    56,
      57,    56,    25,    28,    59,    60,    54,    51,    37,    37,
      30,    37,    30,    37,    37,    37,    37,    37,    37,    37,
      37,    37,    37,    37,    37,    37,    37,    36,    33,    36,
      18,    38,    61,    52,    30,    25,    28,    41,    65,    66,
      40,    25,    28,    41,    68,    69,    40,    25,    28,    41,
      74,    75,    25,    28,    41,    77,    78,    30,    31,    30,
      30,    30,    25,    28,    62,    63,    30,    30,    25,    28,
      41,    80,    81,    25,    28,    41,    83,    84,    25,    31,
      58,    25,    28,    41,    71,    72,    56,    30,    60,    39,
      28,    38,    67,    30,    28,    38,    70,    30,    28,    38,
      76,    28,    38,    79,    18,    38,    64,    28,    38,    82,
      28,    38,    85,    28,    38,    73,    39,    61,    30,    66,
      37,    69,    37,    75,    78,    30,    63,    81,    84,    72,
      30,    67,    68,    70,    74,    76,    79,    39,    64,    82,
      85,    73,    23,    30,    28,    23,    28
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    42,    43,    43,    43,    43,    43,    44,    45,    46,
      47,    47,    48,    49,    50,    50,    51,    51,    52,    52,
      53,    54,    54,    55,    56,    56,    57,    57,    57,    57,
      57,    57,    57,    57,    57,    57,    57,    57,    57,    57,
      57,    57,    57,    57,    57,    58,    58,    59,    60,    60,
      61,    61,    62,    63,    63,    64,    64,    65,    66,    66,
      66,    67,    67,    68,    68,    69,    69,    69,    70,    70,
      71,    72,    72,    72,    73,    73,    74,    75,    75,    75,
      76,    76,    77,    78,    78,    78,    79,    79,    80,    81,
      81,    81,    82,    82,    83,    84,    84,    84,    85,    85
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     3,     3,     3,     2,     0,     2,     2,     1,
       2,     0,     6,     4,     3,     0,     1,     0,     3,     0,
       6,     3,     0,     3,     3,     0,     3,     5,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     6,     3,     6,
       3,     3,     3,     3,     3,     1,     1,     2,     7,     1,
       3,     0,     2,     7,     1,     3,     0,     2,     1,     2,
       1,     3,     0,     2,     0,     1,     2,     1,     3,     0,
       2,     1,     2,     1,     3,     0,     2,     1,     2,     1,
       3,     0,     2,     1,     2,     1,     3,     0,     2,     1,
       2,     1,     3,     0,     2,     1,     2,     1,     3,     0
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 7: /* comment_def: '#' comments  */
#line 411 "creature.y"
                        {/*don't do anything*/;}
#line 1725 "creature.c"
    break;

  case 9: /* comment: IDENTIFIER  */
#line 418 "creature.y"
                        {/* don't do anything with it*/;}
#line 1731 "creature.c"
    break;

  case 12: /* class_def: CLASS IDENTIFIER parent_classes '{' features '}'  */
#line 426 "creature.y"
                                { PutClassTemplate((yyvsp[-4].sval), &tmpTemplate); }
#line 1737 "creature.c"
    break;

  case 15: /* parent_classes: %empty  */
#line 434 "creature.y"
                        { tmpTemplate = blankTemplate;
			  creatureAttacks = 0; }
#line 1744 "creature.c"
    break;

  case 16: /* parent_class: IDENTIFIER  */
#line 439 "creature.y"
                                { MergeClassTemplate ((yyvsp[0].sval), &tmpTemplate);
				  creatureAttacks = 
				    FindAttackCount (tmpTemplate.val.damage); }
#line 1752 "creature.c"
    break;

  case 17: /* parent_class: %empty  */
#line 443 "creature.y"
                                { tmpTemplate = blankTemplate;
				  creatureAttacks = 0; }
#line 1759 "creature.c"
    break;

  case 20: /* creature_def: CREATURE STRING_LIT parent_classes '{' features '}'  */
#line 454 "creature.y"
                                { tmpTemplate.val.name =
				    (char *) malloc(strlen((yyvsp[-4].sval)) + 1);
				  strcpy(tmpTemplate.val.name, (yyvsp[-4].sval));
				  PutCreature((yyvsp[-4].sval), &tmpTemplate,
					      arguments.mc.consistency_check);
				  tmpTemplate = blankTemplate;
				}
#line 1771 "creature.c"
    break;

  case 26: /* feature: LEVEL ':' INT_LIT  */
#line 475 "creature.y"
                                { tmpTemplate.val.level = (yyvsp[0].ival);
				  tmpTemplate.def.level = TRUE; }
#line 1778 "creature.c"
    break;

  case 27: /* feature: HD ':' INT_LIT '|' INT_LIT  */
#line 478 "creature.y"
                                { tmpTemplate.val.hd[0] = (yyvsp[-2].ival);
				  tmpTemplate.val.hd[1] = (yyvsp[0].ival);
				  tmpTemplate.def.hd = TRUE; }
#line 1786 "creature.c"
    break;

  case 28: /* feature: XP ':' INT_LIT  */
#line 482 "creature.y"
                                { tmpTemplate.val.mexp = (yyvsp[0].ival);
				  tmpTemplate.def.mexp = TRUE; }
#line 1793 "creature.c"
    break;

  case 29: /* feature: CCHAR ':' STRING_LIT  */
#line 485 "creature.y"
                                { tmpTemplate.val.cchar = (yyvsp[0].sval)[0];
				  tmpTemplate.def.cchar = TRUE; }
#line 1800 "creature.c"
    break;

  case 30: /* feature: AC ':' INT_LIT  */
#line 488 "creature.y"
                                { tmpTemplate.val.ac = (yyvsp[0].ival);
				  tmpTemplate.def.ac = TRUE; }
#line 1807 "creature.c"
    break;

  case 31: /* feature: SLEEP ':' INT_LIT  */
#line 491 "creature.y"
                                { tmpTemplate.val.sleep = (yyvsp[0].ival);
				  tmpTemplate.def.sleep = TRUE; }
#line 1814 "creature.c"
    break;

  case 32: /* feature: RADIUS ':' INT_LIT  */
#line 494 "creature.y"
                                { tmpTemplate.val.aaf = (yyvsp[0].ival);
				  tmpTemplate.def.aaf = TRUE; }
#line 1821 "creature.c"
    break;

  case 33: /* feature: SPEED ':' INT_LIT  */
#line 497 "creature.y"
                                { tmpTemplate.val.speed = (yyvsp[0].ival) + 10;
				  tmpTemplate.def.speed = TRUE; }
#line 1828 "creature.c"
    break;

  case 37: /* feature: SPELL INT_LIT '/' INT_LIT ':' spells  */
#line 503 "creature.y"
                                { 
                                  int i = (yyvsp[-3].ival);
                                  int j = (yyvsp[-1].ival);
				  AddFreq (i, j, "spell");
				}
#line 1838 "creature.c"
    break;

  case 39: /* feature: BREATH INT_LIT '/' INT_LIT ':' breaths  */
#line 510 "creature.y"
                                { 
                                  int i = (yyvsp[-3].ival);
                                  int j = (yyvsp[-1].ival);
				  AddFreq (i, j, "breath");
				}
#line 1848 "creature.c"
    break;

  case 48: /* unusedattack: IDENTIFIER FOR INT_LIT '|' INT_LIT OF IDENTIFIER  */
#line 530 "creature.y"
                        { AddUnusedAttack((yyvsp[-6].sval), (yyvsp[-4].ival), (yyvsp[-2].ival), (yyvsp[0].sval)); }
#line 1854 "creature.c"
    break;

  case 53: /* attack: IDENTIFIER FOR INT_LIT '|' INT_LIT OF IDENTIFIER  */
#line 542 "creature.y"
                        { AddAttack((yyvsp[-6].sval), (yyvsp[-4].ival), (yyvsp[-2].ival), (yyvsp[0].sval)); }
#line 1860 "creature.c"
    break;

  case 54: /* attack: NOTHING  */
#line 544 "creature.y"
                                {
				  tmpTemplate.val.damage[0] = 0;
				  tmpTemplate.val.damage[1] = 0;
				  tmpTemplate.val.damage[2] = 0;
				  tmpTemplate.val.damage[3] = 0;
				  creatureAttacks = 0;
				  tmpTemplate.def.damage = TRUE; 
				}
#line 1873 "creature.c"
    break;

  case 58: /* move: IDENTIFIER  */
#line 561 "creature.y"
                                   { AddMove((yyvsp[0].sval)); }
#line 1879 "creature.c"
    break;

  case 59: /* move: '~' IDENTIFIER  */
#line 562 "creature.y"
                                       { NegMove((yyvsp[0].sval)); }
#line 1885 "creature.c"
    break;

  case 65: /* spell: IDENTIFIER  */
#line 574 "creature.y"
                                   { AddSpell((yyvsp[0].sval)); }
#line 1891 "creature.c"
    break;

  case 66: /* spell: '~' IDENTIFIER  */
#line 575 "creature.y"
                                       { NegSpell((yyvsp[0].sval)); }
#line 1897 "creature.c"
    break;

  case 71: /* resist: IDENTIFIER  */
#line 586 "creature.y"
                                   { AddResist((yyvsp[0].sval)); }
#line 1903 "creature.c"
    break;

  case 72: /* resist: '~' IDENTIFIER  */
#line 587 "creature.y"
                                       { NegResist((yyvsp[0].sval)); }
#line 1909 "creature.c"
    break;

  case 77: /* breath: IDENTIFIER  */
#line 598 "creature.y"
                                   { AddBreath((yyvsp[0].sval)); }
#line 1915 "creature.c"
    break;

  case 78: /* breath: '~' IDENTIFIER  */
#line 599 "creature.y"
                                       { NegBreath((yyvsp[0].sval)); }
#line 1921 "creature.c"
    break;

  case 83: /* defense: IDENTIFIER  */
#line 610 "creature.y"
                                   { AddDefense((yyvsp[0].sval)); }
#line 1927 "creature.c"
    break;

  case 84: /* defense: '~' IDENTIFIER  */
#line 611 "creature.y"
                                       { NegDefense((yyvsp[0].sval)); }
#line 1933 "creature.c"
    break;

  case 85: /* defense: NOTHING  */
#line 612 "creature.y"
                                { tmpTemplate.def.defense = TRUE; }
#line 1939 "creature.c"
    break;

  case 89: /* carry: IDENTIFIER  */
#line 622 "creature.y"
                                   { AddTreasure((yyvsp[0].sval)); }
#line 1945 "creature.c"
    break;

  case 90: /* carry: '~' IDENTIFIER  */
#line 623 "creature.y"
                                       { NegTreasure((yyvsp[0].sval)); }
#line 1951 "creature.c"
    break;

  case 91: /* carry: NOTHING  */
#line 624 "creature.y"
                                { tmpTemplate.def.treasure = TRUE; }
#line 1957 "creature.c"
    break;

  case 95: /* special: IDENTIFIER  */
#line 634 "creature.y"
                                   { AddSpecial((yyvsp[0].sval)); }
#line 1963 "creature.c"
    break;

  case 96: /* special: '~' IDENTIFIER  */
#line 635 "creature.y"
                                       { NegSpecial((yyvsp[0].sval)); }
#line 1969 "creature.c"
    break;


#line 1973 "creature.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 644 "creature.y"




/*
 * MyFGetC--
 *	fgetc with support for comments
 *
 *	# is the comment character.  comment lasts till end of line.
 * Spews out an extra char of whitespace at EOF since something seems to
 * need it.  I'll figure this out eventually...
 */
static int 
MyFGetC (FILE *input_F)
{
  while (!*inputBufp || (*inputBufp == '#')) 
    {
      (void) fgets (inputBuf, INPUT_BUF_SIZE, input_F);
      if (feof (input_F))
	return EOF;
      lineNo++;
      inputBufp = inputBuf;
    }
  return *inputBufp++;
}



/*
 * Advance--
 *	Advance to the next token in the input stream and set tokStr,
 * tokType.
 *
 *	On error, tokType is set to a negative value.
 */
static void 
Advance (FILE *input_F)
{
  register char *tok = tokStr;	/* accumulating token string		    */
  register int len = 0;		/* length of current token		    */
  static int c = 32;		/* current character; ' ' is harmless init  */


  /*
   * Skip whitespace in the stream
   */
  while ((c != EOF) && isspace (c))
    c = MyFGetC (input_F);

  /*
   * At end of file?
   */
  if (c == EOF) 
    {
      tokType = EOF;
      strcpy (tokStr, "[EOF]");
      return;
    }

  /*
   * Recognize a number [+|-][dddd][.][dddd][{e|E}[+|-]dddd]
   */
  if (isdigit (c) || (c == '.') || (c == '+') || (c == '-')) 
    {
      register int decPt = FALSE,   /* seen a decimal point yet?	*/
	       hasExp = FALSE;	    /* has an exponent?			*/

      if ((c == '-') || (c == '+')) 
	{
	  *tok++ = c;
	  c = MyFGetC (input_F);
	}

      while ((len < MAX_TOK_LEN - 1) && (isdigit (c) || (c == '.'))) 
	{
	  if (c == '.') 
	    {
	      if (decPt)
		break;
	      else
		decPt = TRUE;
	    }

	  *tok++ = c;
	  c = MyFGetC (input_F);
	  len++;
	}

      if ((c == 'e') || (c == 'E')) 
	{
	  hasExp = TRUE;
	  *tok++ = c;
	  c = MyFGetC (input_F);
	  len++;

	  if ((c == '-') || (c == '+')) 
	    {
	      *tok++ = c;
	      c = MyFGetC (input_F);
	      len++;
	    }

	  while ((len < MAX_TOK_LEN - 1) && isdigit (c)) 
	    {
	      *tok++ = c;
	      c = MyFGetC (input_F);
	      len++;
	    }
	}

      *tok = 0;

      if (decPt || hasExp) 
	{
	  tokType = FLOAT_LIT;
	  yylval.dval = atof (tokStr);
	} 
      else 
	{
	  tokType = INT_LIT;
	  yylval.ival = atoi (tokStr);
	}

      return;

    }

  /*
   * Recognize a quoted string
   */
  if (c == '\"') 
    {

      c = MyFGetC (input_F);

      while ((len < MAX_TOK_LEN - 1) &&
	     (c != EOF) && (c != '\n') && (c != '\"')) 
	{
	  *tok++ = c;
	  c = MyFGetC (input_F);
	}

      *tok = 0;

      c = MyFGetC (input_F);

      tokType = STRING_LIT;
      strncpy (yylval.sval, tokStr, MAX_TOK_LEN - 1);
      yylval.sval[MAX_TOK_LEN - 1] = 0;

      return;

    }

  /*
   * Recognize an identifier and try to match it with a keyword.
   * Identifiers begin with a letter and continue in letters and/or
   * digits.  Convert it to lowercase.
   */
  if (isalpha (c) || (c == '_') || (c == '$')) {

    if (isupper (c))
      c = tolower (c);
    *tok++ = c;
    c = MyFGetC (input_F);
    len++;

    while ((len < MAX_TOK_LEN - 1) && (isalpha (c) || isdigit (c) ||
				       (c == '_') || (c == '$'))) 
      {
	if (isupper (c))
	  c = tolower (c);
	*tok++ = c;
	c = MyFGetC (input_F);
	len++;
      }

    *tok = 0;

    /*
     * We've got the identifier; see if it matches any keywords.
     */

      {
	generic_t gval;
	int type;
	if (St_GetSym (keywordT_P, tokStr, &type, &gval) == ST_SYM_FOUND) 
	  {
	    tokType = gval.i;
	    strncpy (yylval.sval, tokStr, MAX_TOK_LEN - 1);
	    yylval.sval[MAX_TOK_LEN - 1] = 0;
	  } 
	else if (!strcmp (tokStr, "true")) 
	  {
	    tokType = BOOL_LIT;
	    yylval.ival = 1;
	  } 
	else if (!strcmp (tokStr, "false")) 
	  {
	    tokType = BOOL_LIT;
	    yylval.ival = 0;
	  } 
	else 
	  {
	    tokType = IDENTIFIER;
	    strncpy (yylval.sval, tokStr, MAX_TOK_LEN - 1);
	    yylval.sval[MAX_TOK_LEN - 1] = 0;
	  }
      }

    return;

  }

  /*
   * Recognize punctuation
   */

  tokType = c;
  *tok++ = c;
  *tok = 0;
  c = MyFGetC (input_F);
  return;
}

void 
ErrMsg (char *s)
{
  int i;

  fprintf (stderr, "Error: %s at line %d\n", s, lineNo);
  fprintf (stderr, "%s", inputBuf);
  for (i = 0; i < inputBufp - inputBuf; i++) 
    {
      fputc ((inputBuf[i] == '\t' ? '\t' : ' '), stderr);
    }
  fprintf (stderr, "^ before here\n\n");
  return;
}

int 
yyerror (char *s)
{
  ErrMsg (s);
  return 0;
}


int 
yylex ()
{
  Advance (input_F);
  return tokType;
}

void 
AddSpell (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (spellT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown spell '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      if (tmpTemplate.def.resist)
	{
	  sprintf (s1, "Setting spell '%s' when a resist is already set causes the resist to turn into breath which probably isn't want you want.", s);
	  ErrMsg (s1);
	}
      else
	{
	  tmpTemplate.val.spells |= (1 << gval.i);
	  tmpTemplate.def.spell = TRUE;
	}
    }
  return;
}


void 
NegSpell (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (spellT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown spell '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      tmpTemplate.val.spells &= ~(1 << gval.i);
      tmpTemplate.def.spell = TRUE;
    }
  return;
}

unsigned int
lookup_flag (char *kind, char *f)
{
  char *flags;
  generic_t gval;
  int retval = 0;
  char *s;
  int type;
  char s1[256];
  static st_Table_Pt table;
  int negate = 0;

  if (strcmp (kind, "defense") == 0)
    table = defenseT_P;
  else if (strcmp (kind, "move") == 0)
    table = moveT_P;
  else if (strcmp (kind, "special") == 0)
    table = specialT_P;
  else if (strcmp (kind, "treasure") == 0)
    table = treasureT_P;
  else if (strcmp (kind, "spell") == 0)
    table = spellT_P;
  else if (strcmp (kind, "breath") == 0)
    table = breathT_P;
  else if (strcmp (kind, "resist") == 0)
    table = breathT_P;
  else if (strcmp (kind, "attacktype") == 0)
    table = attackTypeT_P;
  else if (strcmp (kind, "attackdesc") == 0)
    table = attackDescT_P;
  else
    return -1;

  flags = strdup (f);
  for (s = strtok (flags, ", "); s != NULL; s = strtok (NULL, ", "))
    {
      negate = 0;
      if (s[0] == '~')
	{
	  negate = 1;
	  s++;
	}
      if (St_GetSym (table, s, &type, &gval) != ST_SYM_FOUND) 
	{
	  sprintf (s1, "unknown %s '%s' (in internal code)", kind, s);
	  ErrMsg (s1);
	} 
      else
	{
	  if (negate)
	    retval &= ~(1 << gval.i);
	  else
	    retval |= (1 << gval.i);
	}
    }
  free (flags);
  return retval;
}

void 
AddResist (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (breathT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown resist '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      if ((tmpTemplate.def.breath) && 
	  ((tmpTemplate.val.spells & (1 << gval.i))) == 0)
	{
	  sprintf (s1, "4. Setting resist '%s' when non-identical breath already set causes %s-breath to be enabled which probably isn't want you want.", s, s);
	  ErrMsg (s1);
	}
      else if ((tmpTemplate.def.spell) && (tmpTemplate.def.breath == 0))
	{
	  sprintf (s1, "5. Setting resist '%s' when a spell frequency is already set causes %s-breath to be enabled which probably isn't want you want.", s, s);
	  ErrMsg (s1);
	}
      else
	{
	  tmpTemplate.val.spells |= (1 << gval.i);
	  tmpTemplate.def.resist = TRUE;
	}
    }
  return;
}


void 
NegResist (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (breathT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown resist '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      tmpTemplate.val.spells &= ~(1 << gval.i);
      tmpTemplate.def.resist = TRUE;
    }
  return;
}

void 
AddBreath (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (breathT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown breath '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      if ((tmpTemplate.def.resist) && 
	  ((tmpTemplate.val.spells & (1 << gval.i)) == 0))
	{
	  sprintf (s1, "6. Setting breath '%s' when non-identical resist was already set causes the resist to become a breath which probably isn't want you want.", s);
	  ErrMsg (s1);
	}
      else
	{
	  tmpTemplate.val.spells |= (1 << gval.i);
	  tmpTemplate.def.breath = TRUE;
	}
    }
  return;
}


void 
NegBreath (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (breathT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown breath '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      tmpTemplate.val.spells &= ~(1 << gval.i);
      tmpTemplate.def.breath = TRUE;
    }
  return;
}


void 
AddSpecial (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (specialT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown special '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      tmpTemplate.val.cmove |= (1 << gval.i);
      tmpTemplate.def.special = TRUE;
    }
  return;
}


void 
NegSpecial (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (specialT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown special '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      tmpTemplate.val.cmove &= ~(1 << gval.i);
      tmpTemplate.def.special = TRUE;
    }
  return;
}

void AddMove(char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (moveT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown move '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      tmpTemplate.val.cmove |= (1 << gval.i);
      tmpTemplate.def.move = TRUE;
    }
  return;
}


void 
NegMove (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (moveT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown move '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      tmpTemplate.val.cmove &= ~(1 << gval.i);
      tmpTemplate.def.move = TRUE;
    }
  return;
}

void 
AddTreasure (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (treasureT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown treasure '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      tmpTemplate.val.cmove |= (1 << gval.i);
      tmpTemplate.def.treasure = TRUE;
    }
  return;
}


void 
NegTreasure (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (treasureT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown treasure '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      tmpTemplate.val.cmove &= ~(1 << gval.i);
      tmpTemplate.def.treasure = TRUE;
    }
  return;
}


void 
AddDefense (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (defenseT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown defense '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      tmpTemplate.val.cdefense |= (1 << gval.i);
      tmpTemplate.def.defense = TRUE;
    }
  return;
}


void 
NegDefense (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (defenseT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "unknown defense '%s'", s);
      ErrMsg (s1);
    } 
  else 
    {
      tmpTemplate.val.cdefense &= ~(1 << gval.i);
      tmpTemplate.def.defense = TRUE;
    }
  return;
}


int 
PutAttack (m_attack_type attack)
{
  register int i;

  for (i = 0; i < attackCt; i++) 
    {
      if ((attack.attack_type == attackList[i].attack_type) &&
	  (attack.attack_desc == attackList[i].attack_desc) &&
	  (attack.attack_dice == attackList[i].attack_dice) &&
	  (attack.attack_sides == attackList[i].attack_sides)) 
	{
	  return i;
	}
    }

  if (attackCt == MAX_ATTACK) 
    {
      fprintf (stderr, "fatal error: too many different attacks.\n");
      fprintf (stderr, "increase MAX_ATTACK.\n");
      exit (1);
    }

  attackList[attackCt].attack_type = attack.attack_type;
  attackList[attackCt].attack_desc = attack.attack_desc;
  attackList[attackCt].attack_dice = attack.attack_dice;
  attackList[attackCt].attack_sides = attack.attack_sides;

  attackCt++;
  return attackCt - 1;
}

void 
AddUnusedAttack (char *s1, int dice, int sides, char *s2)
{
  generic_t gval;
  int type, aDesc;
  m_attack_type attack;
  char s[256];

  if (St_GetSym (attackDescT_P, s1, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s, "unknown attack description '%s'", s1);
      ErrMsg (s);
      return;
    } 
  else 
    {
      aDesc = gval.i;
    }

  if (St_GetSym (attackTypeT_P, s2, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s, "unknown attack type '%s'", s2);
      ErrMsg (s);
    } 
  else 
    {
      attack.attack_type = gval.i;
      attack.attack_dice = dice;
      attack.attack_desc = aDesc;
      attack.attack_sides = sides;

      PutAttack (attack);
    }
  return;
}

void 
AddAttack (char *s1, int dice, int sides, char *s2)
{
  generic_t gval;
  int type, aDesc;
  m_attack_type attack;
  char s[256];

  if (St_GetSym (attackDescT_P, s1, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s, "unknown attack description '%s'", s1);
      ErrMsg (s);
      return;
    } 
  else 
    {
      aDesc = gval.i;
    }

  if (St_GetSym (attackTypeT_P, s2, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s, "unknown attack type '%s'", s2);
      ErrMsg (s);
    } 
  else 
    {
      if (creatureAttacks > 3) 
	{
	  sprintf (s, "creature limited to 4 attacks");
	  ErrMsg (s);
	  return;
	}
      attack.attack_type = gval.i;
      attack.attack_dice = dice;
      attack.attack_desc = aDesc;
      attack.attack_sides = sides;

      tmpTemplate.val.damage[creatureAttacks++] = PutAttack (attack);
      tmpTemplate.def.damage = TRUE;
    }
  return;
}

int
FindAttackCount (int8u *damage)
{
  int max = 4;
  int i;
  for (i = 0; i < max; i++)
    {
      if (damage[i] == 0)
	return i;
    }
  return max;
}

void
AddFreq (int i, int chance, char *kind)
{
  char s1[256];
  if (((tmpTemplate.def.breath) || (tmpTemplate.def.spell)) &&
      (tmpTemplate.val.spells & CS_FREQ) && 
      ((tmpTemplate.val.spells & CS_FREQ) != chance))
    {
      sprintf (s1, "Setting new %s frequency causes previous spells or breaths to happen at this new rate which probably isn't want you want.", kind);
      ErrMsg (s1);
    }
  else if (i != 1 || (chance < 0 || chance > 15))
    {
      sprintf (s1, "%s frequency must be between 1/1 and 1/15.", kind);
      ErrMsg (s1);
    }
  else
    {
      tmpTemplate.val.spells &= ~(CS_FREQ);
      tmpTemplate.val.spells |= chance;
      tmpTemplate.def.spell = TRUE; 
    }
  return;
}

st_Table_Pt 
InitTable (char *name, symInit_t *init)
{
  int i;
  st_Table_Pt table_P;
  generic_t gval;

  table_P = St_NewTable (name, 20);
  for (i = 0; init[i].name; i++) 
    {
      gval.i = init[i].val;
      St_DefSym (table_P, init[i].name, GEN_TYPE_INT, gval);
    }

  return table_P;
}


void 
InitTables ()
{
  keywordT_P = InitTable ("keyword", keywordInit);
  defenseT_P = InitTable ("defense", defenseInit);
  spellT_P = InitTable ("spell", spellInit);
  moveT_P = InitTable ("move", moveInit);
  specialT_P = InitTable ("special", specialInit);
  breathT_P = InitTable ("breath", breathInit);
  treasureT_P = InitTable ("treasure", treasureInit);
  attackTypeT_P = InitTable ("attackType", attackTypeInit);
  attackDescT_P = InitTable ("attackDesc", attackDescInit);

  classT_P = St_NewTable ("class", 40);
  creatureT_P = St_NewTable ("creature", 200);

  return;
}

void 
WriteCreature (template_t *tmpl_P)
{
  char s[256];
  strcpy (s, "\"");
  strcat (s, tmpl_P->val.name);
  strcat (s, "\"");
  fprintf (arguments.mc.outfile, "{%-28s, 0x%08XL,0x%08XL,0x%04X,%5d,%3d,\n",
	   s, (unsigned int) tmpl_P->val.cmove, 
	   (unsigned int) tmpl_P->val.spells, tmpl_P->val.cdefense, 
	   tmpl_P->val.mexp, tmpl_P->val.sleep);
  fprintf (arguments.mc.outfile, 
	   " %2d, %3d, %2d, '%c', {%3d,%2d}, {%3d,%3d,%3d,%3d}, %3d},\n",
	   tmpl_P->val.aaf, tmpl_P->val.ac, tmpl_P->val.speed,
	   tmpl_P->val.cchar,
	   tmpl_P->val.hd[0], tmpl_P->val.hd[1],
	   tmpl_P->val.damage[0], tmpl_P->val.damage[1],
	   tmpl_P->val.damage[2], tmpl_P->val.damage[3],
	   tmpl_P->val.level);
  return;
}

void 
WriteCreaturesHdr ()
{
  fprintf (arguments.mc.outfile, "\n\
/* Following are creature arrays and variables			*/\n\
	/* Creatures must be defined here                               */\n\
	/*      See types.h under creature_type for a complete list\n\
	   of all variables for creatures.       Some of the less obvious\n\
	   are explained below.\n\
\n\
	   Hit points:  #1, #2: where #2 is the range of each roll and\n\
	   #1 is the number of added up rolls to make.\n\
	   Example: a creature with 5 eight-sided hit die\n\
	   is given {5,8}.\n\
\n\
	   Attack types:\n\
	   1    Normal attack\n\
	   2    Poison Strength\n\
	   3    Confusion attack\n\
	   4    Fear attack\n\
	   5    Fire attack\n\
	   6    Acid attack\n\
	   7    Cold attack\n\
	   8    Lightning attack\n\
	   9    Corrosion attack\n\
	   10   Blindness attack\n\
	   11   Paralysis attack\n\
	   12   Steal Money\n\
	   13   Steal Object\n\
	   14   Poison\n\
	   15   Lose dexterity\n\
	   16   Lose constitution\n\
	   17   Lose intelligence\n\
	   18   Lose wisdom\n\
	   19   Lose experience\n\
	   20   Aggravation\n\
	   21   Disenchants\n\
	   22   Eats food\n\
	   23   Eats light\n\
	   24   Eats charges\n\
	   99   Blank\n\
\n\
	   Attack descriptions:\n\
	   1    hits you.\n\
	   2    bites you.\n\
	   3    claws you.\n\
	   4    stings you.\n\
	   5    touches you.\n\
	   6    kicks you.\n\
	   7    gazes at you.\n\
	   8    breathes on you.\n\
	   9    spits on you.\n\
	   10   makes a horrible wail.\n\
	   11   embraces you.\n\
	   12   crawls on you.\n\
	   13   releases a cloud of spores.\n\
	   14   begs you for money.\n\
	   15   You've been slimed.\n\
	   16   crushes you.\n\
	   17   tramples you.\n\
	   18   drools on you.\n\
	   19   insults you.\n\
	   99   is repelled.\n\
\n\
	   Example:  For a creature which bites for 1d6, then stings for\n\
	   2d4 and loss of dex you would use:\n\
	   {1,2,1,6},{15,4,2,4}\n\
\n\
	   CMOVE flags:\n\
	   Movement.    00000001        Move only to attack\n\
	   .    00000002        Move, attack normal\n\
	   .    00000008        20%% random movement\n\
	   .    00000010        40%% random movement\n\
	   .    00000020        75%% random movement\n\
	   .    00000040        persistent movement\n\
	   Special +    00010000        Invisible movement\n\
	   +    00020000        Move through door\n\
	   +    00040000        Move through wall\n\
	   +    00080000        Move through creatures\n\
	   +    00100000        Picks up objects\n\
	   +    00200000        Multiply monster\n\
	   Carries =    01000000        Carries objects.\n\
	   =    02000000        Carries gold.\n\
	   =    04000000        Has 60%% of time.\n\
	   =    08000000        Has 90%% of time.\n\
	   =    10000000        1d2 objects/gold.\n\
	   =    20000000        2d2 objects/gold.\n\
	   =    40000000        4d2 objects/gold.\n\
	   Special ~    80000000        Win-the-Game creature.\n\
\n\
	   SPELL Flags:\n\
	   Frequency    000001    1     These add up to x.  Then\n\
	   (1 in x).    000002    2     if RANDINT(X) = 1 the\n\
	   .    000004    4     creature casts a spell.\n\
	   .    000008    8\n\
	   Spells       =       000010  Teleport short (blink)\n\
	   =    000020  Teleport long\n\
	   =    000040  Teleport player to monster\n\
	   =    000080  Cause light wound\n\
	   =    000100  Cause serious wound\n\
	   =    000200  Hold person (Paralysis)\n\
	   =    000400  Cause blindness\n\
	   =    000800  Cause confusion\n\
	   =    001000  Cause fear\n\
	   =    002000  Summon monster\n\
	   =    004000  Summon undead\n\
	   =    008000  Slow Person\n\
	   =    010000  Drain Mana\n\
	   =    020000  Not Used\n\
	   =    040000  Not Used\n\
	   Breath/      +       080000  Breathe/Resist Lightning\n\
	   Resist       +       100000  Breathe/Resist Gas\n\
	   +    200000  Breathe/Resist Acid\n\
	   +    400000  Breathe/Resist Frost\n\
	   +    800000  Breathe/Resist Fire\n\
\n\
	   CDEFENSE flags:\n\
	   0001 Hurt by Slay Dragon.\n\
	   0002 Hurt by Slay Animal.\n\
	   0004 Hurt by Slay Evil.\n\
	   0008 Hurt by Slay Undead.\n\
	   0010 Hurt by Frost.\n\
	   0020 Hurt by Fire.\n\
	   0040 Hurt by Poison.\n\
	   0080 Hurt by Acid.\n\
	   0100 Hurt by Light-Wand.\n\
	   0200 Hurt by Stone-to-Mud.\n\
	   0400 Not used.\n\
	   0800 Not used.\n\
	   1000 Cannot be charmed or slept.\n\
	   2000 Can be seen with infra-vision.\n\
	   4000 Max Hit points.\n\
	   8000 Not used.\n\
\n\
\n\
	   Sleep (sleep)        :       A measure in turns of how fast creature\n\
	   will notice player (on the average).\n\
	   Area of affect (aaf) :       Max range that creature is able to \"notice\"\n\
	   the player.\n\
	 */\n\n");
}

void 
WriteCreatures ()
{
  char **s_A, **sp;
  int level, type;
  generic_t gval;
  int i;

  fprintf(arguments.mc.outfile, "#include \"constant.h\"\n");
  fprintf(arguments.mc.outfile, "#include \"types.h\"\n\n");
  WriteCreaturesHdr();
  s_A = St_SListTable (creatureT_P);

  fprintf (arguments.mc.outfile, "creature_type c_list[MAX_CREATURES] = {\n");
  for (i = 0; i < St_TableSize (creatureT_P); i++)
    {
      for (sp = s_A; *sp; sp++) 
	{
	  if (St_GetSym (creatureT_P, *sp, &type, &gval) != ST_SYM_FOUND) 
	    {
	      fprintf (stderr, "internal err. in WriteCreatures\n");
	      exit (1);
	    }
	  if ((*(template_t *) gval.v).idx == i) 
	    {
	      WriteCreature ((template_t *) gval.v);
	    }
	}
    }

  fprintf (arguments.mc.outfile, "};\n\n");

  St_SListTable (NULL);
  return;
}

void 
PutClassTemplate (char *s, template_t *tmpl_P)
{
  generic_t gval;
  char s1[256];

  gval.v = malloc (sizeof(template_t));
  *(template_t *) gval.v = *tmpl_P;

  if (St_DefSym (classT_P, s, GEN_TYPE_TMPL, gval) == ST_SYM_FOUND) 
    {
      sprintf (s1, "attempt to redefine class '%s'", s);
      ErrMsg (s1);
      free (gval.v);
      return;
    }
  return;
}


int
MergeClassTemplate (char *s, template_t *t1)
{
  template_t t2;
  t2 = GetClassTemplate (s);
  if (t2.def.move == TRUE)
    {
      t1->val.cmove |= (t2.val.cmove & CM_ALL_MV_FLAGS);
      t1->def.move = TRUE;
    }
  if (t2.def.special == TRUE)
    {
      t1->val.cmove |= (t2.val.cmove & CM_SPECIAL & CM_WIN);
      t1->def.special = TRUE;
    }
  if (t2.def.treasure == TRUE)
    {
      t1->val.cmove |= (t2.val.cmove & CM_TREASURE);
      t1->def.treasure = TRUE;
    }
  if (t2.def.spell == TRUE)
    {
      t1->val.spells = (t2.val.spells & CS_SPELLS & CS_FREQ);
      t1->def.spell = TRUE;
    }
  if (t2.def.breath == TRUE)
    {
      t1->val.spells |= (t2.val.spells & CS_BREATHE & CS_FREQ);
      t1->def.breath = TRUE;
    }
  if (t2.def.resist == TRUE)
    {
      t1->val.spells |= (t2.val.spells & CS_BREATHE);
      t1->def.resist = TRUE;
    }
  if (t2.def.defense == TRUE)
    {
      t1->val.cdefense |= t2.val.cdefense;
      t1->def.defense = TRUE;
    }
  if (t2.def.mexp == TRUE)
    {
      t1->val.mexp = t2.val.mexp;
      t1->def.mexp = TRUE;
    }
  if (t2.def.sleep == TRUE)
    {
      t1->val.sleep = t2.val.sleep;
      t1->def.sleep = TRUE;
    }
  if (t2.def.aaf == TRUE)
    {
      t1->val.aaf = t2.val.aaf;
      t1->def.aaf = TRUE;
    }
  if (t2.def.ac == TRUE)
    {
      t1->val.ac = t2.val.ac;
      t1->def.ac = TRUE;
    }
  if (t2.def.speed == TRUE)
    {
      t1->val.speed = t2.val.speed;
      t1->def.speed = TRUE;
    }
  if (t2.def.cchar == TRUE)
    {
      t1->val.cchar = t2.val.cchar;
      t1->def.cchar = TRUE;
    }
  if (t2.def.hd == TRUE)
    {
      t1->val.hd[0] = t2.val.hd[0];
      t1->val.hd[1] = t2.val.hd[1];
      t1->def.hd = TRUE;
    }
  if (t2.def.damage == TRUE)
    {
      int i, j;
      int t2attackcount;
      int found = 0;
      t2attackcount = FindAttackCount (t2.val.damage);
      for (i = 0; i < t2attackcount; i++)
	{
	  /* do i have this one already? */
	  for (j = 0; j < creatureAttacks; j++)
	    {
	      if (t1->val.damage[j] == t2.val.damage[i])
		{
		  found = 1;
		  break;
		}
	    }
	  /* no?  great. now add it to our attack list */
	  if (!found)
	    {
	      //add it, and increment.
	      if (creatureAttacks > 3) 
		{
		  ErrMsg ("creature limited to 4 attacks");
		  return -1;
		}
	      else
		{
		  creatureAttacks++;
		  t1->val.damage[creatureAttacks -1] = t2.val.damage[i];
		}
	      found = 0;
	    }
	}
      if (t2attackcount == 0)
	{
	  t1->val.damage[0] = 0;
	  creatureAttacks = 0;
	}
      t1->def.damage = TRUE;
    }
  if (t2.def.level == TRUE)
    {
      t1->val.level = t2.val.level;
      t1->def.level = TRUE;
    }

  return 0;
}

template_t 
GetClassTemplate (char *s)
{
  generic_t gval;
  int type;
  char s1[256];

  if (St_GetSym (classT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      sprintf (s1, "class '%s' undefined\n", s);
      ErrMsg (s1);
      return blankTemplate;
    } 
  else 
    {
      return *(template_t *) gval.v;
    }
  return blankTemplate;
}


void 
NotDefined(char *name, char *s)
{
  fprintf (arguments.mc.outfile, 
	   "Warning: %s not defined for \"%s\", line %d\n",
	   s, name, lineNo);
  return;
}


void 
PutCreature (char *s, template_t *tmpl_P, int consistency_check)
{
  static int idx;
  generic_t gval;
  char s1[256];

  gval.v = malloc (sizeof(template_t));
  *(template_t *) gval.v = *tmpl_P;

  if (!tmpl_P->def.move)
    NotDefined (tmpl_P->val.name, "MOVE");
  if (!tmpl_P->def.treasure)
    NotDefined (tmpl_P->val.name, "TREASURE");
  if (!tmpl_P->def.defense)
    NotDefined (tmpl_P->val.name, "DEFENSE");
  if (!tmpl_P->def.mexp)
    NotDefined (tmpl_P->val.name, "XP");
  if (!tmpl_P->def.sleep)
    NotDefined (tmpl_P->val.name, "SLEEP");
  if (!tmpl_P->def.aaf)
    NotDefined (tmpl_P->val.name, "RADIUS");
  if (!tmpl_P->def.ac)
    NotDefined (tmpl_P->val.name, "AC");
  if (!tmpl_P->def.speed)
    NotDefined (tmpl_P->val.name, "SPEED");
  if (!tmpl_P->def.cchar)
    NotDefined (tmpl_P->val.name, "CCHAR");
  if (!tmpl_P->def.hd)
    NotDefined (tmpl_P->val.name, "HD");
  if (!tmpl_P->def.damage)
    NotDefined (tmpl_P->val.name, "ATTACK");
  if (!tmpl_P->def.level)
    NotDefined (tmpl_P->val.name, "LEVEL");

  if (consistency_check)
    ConsistencyCheckCreature (&tmpl_P->val);

  (*(template_t *) gval.v).idx = idx;

  if (St_DefSym (creatureT_P, s, GEN_TYPE_TMPL, gval) == ST_SYM_FOUND) 
    {
      sprintf (s1, "attempt to redefine creature '%s'\n", s);
      ErrMsg (s1);
      free (gval.v);
      return;
    }

  if (tmpl_P->val.level > maxCreatureLevel)
    maxCreatureLevel = tmpl_P->val.level;

  idx++;
  return;
}

int 
compare_attacks(const void *lhs_attack, const void *rhs_attack)
{
  const int *lhs = lhs_attack;
  const int *rhs = rhs_attack;
  return ntohl(*lhs) - ntohl(*rhs);
}

void
SortAttacks ()
{
  int i = 0;
  int j = 0;
  for (i = 0; i < attackCt; i++) 
    sorted_attackList[i] = attackList[i];
  qsort (sorted_attackList, attackCt, sizeof (m_attack_type), compare_attacks);
int v = memcmp(attackList, sorted_attackList, attackCt * sizeof(m_attack_type));
  //now find the diffs.
  int diffs[MAX_ATTACK];
  memset (diffs, 0, sizeof (diffs));
  for (i = 0; i < attackCt; i++) 
    {
      m_attack_type attack = attackList[i];
      for (j = 0; j < attackCt; j++)
        {
          if (attack.attack_type == sorted_attackList[j].attack_type &&
              attack.attack_desc == sorted_attackList[j].attack_desc &&
              attack.attack_dice == sorted_attackList[j].attack_dice &&
              attack.attack_sides == sorted_attackList[j].attack_sides)
            {
              diffs[i] = j;
              break;
            }
        }
    }
  //now we change each of the creatures in order to point to their new attacks.
  char **s_A, **sp;
  int type;
  generic_t gval;

  s_A = St_SListTable (creatureT_P);

  for (i = 0; i < St_TableSize (creatureT_P); i++)
    {
      for (sp = s_A; *sp; sp++) 
	{
	  if (St_GetSym (creatureT_P, *sp, &type, &gval) != ST_SYM_FOUND) 
	    {
	      fprintf (stderr, "internal err. in WriteCreatures\n");
	      exit (1);
	    }
	  if ((*(template_t *) gval.v).idx == i) 
	    {
              creature_type *c = (creature_type*) &(*(template_t*)gval.v).val;
              for (j = 0; j < 4; j++)
                {
                  if (c->damage[j] == 0)
                    break;
                  c->damage[j] = diffs[c->damage[j]];
                }
	    }
	}
    }

  St_SListTable (NULL);
  for (i = 0; i < attackCt; i++) 
    attackList[i] = sorted_attackList[i];
}

void 
WriteAttacks ()
{
  int i;
  int record_count = 0;

  fprintf (arguments.mc.outfile, 
	   "struct m_attack_type monster_attacks[N_MONS_ATTS] = {\n");

  for (i = 0; i < attackCt; i++) 
    {

      if ((i % 4) == 0)
	{
	  if (i != 0)
	    fprintf (arguments.mc.outfile, "\n");
	  if ((record_count % 5) == 0)
	    fprintf (arguments.mc.outfile, "/*%3d */", i);
	  else
	    {
	      if (i > attackCt - 4)
		fprintf (arguments.mc.outfile, "/*%3d */", i);
	      else
		fprintf (arguments.mc.outfile, "        ");
	    }
	  record_count++;
	}

      fprintf (arguments.mc.outfile, "{%2d,%2d,%2d,%2d}", 
	       attackList[i].attack_type, attackList[i].attack_desc,
	       attackList[i].attack_dice, attackList[i].attack_sides);

      if (!(i == attackCt - 1))
	fprintf (arguments.mc.outfile, ",\t");

    };

  fprintf (arguments.mc.outfile, "\n};\n");
  return;
}

void 
WriteConstants ()
{
  fprintf (arguments.mc.outfile,
	   "\n#define MAX_CREATURES\t%d\n", St_TableSize (creatureT_P));
  fprintf (arguments.mc.outfile,
	   "#define N_MONS_ATTS\t%d\n\n", attackCt);
  return;
}

void WriteGenerationNotice()
{
  fprintf (arguments.mc.outfile,
	   "/* The following was generated by the %s monster compiler \n"
           "   (%s-mc %s) on %s. \n", 
           PACKAGE_NAME, GAME_NAME, VERSION, __DATE__);
  fprintf (arguments.mc.outfile,"\n\
   Copyright (c) 1989-94 James E. Wilson, Robert A. Koeneke\n\
   This program is free software; you can redistribute it and/or modify\n\
   it under the terms of the GNU General Public License as published by\n\
   the Free Software Foundation; either version 3 of the License, or\n\
   (at your option) any later version.\n\
   \n\
   This program is distributed in the hope that it will be useful,\n\
   but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
   GNU Library General Public License for more details.\n\
   \n\
   You should have received a copy of the GNU General Public License\n\
   along with this program; if not, write to the Free Software\n\
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n");
  fprintf (arguments.mc.outfile,
	   "*/\n\n");
  return;
}

int
mc_main (char *inputFilename)
{
  InitTables ();

  if (strcmp (inputFilename, "-") == 0)
    input_F = stdin;
  else
    {
      input_F = fopen (inputFilename, "r");
      if (!input_F) 
	{
	  fprintf (stderr, "Error: couldn't open file.\n");
	  return -1;
	}
    }

  if (yyparse ()) 
    {
      fprintf (stderr, "Errors prevent continuation.\n");
      return -2;
    }

  WriteGenerationNotice();
  if (arguments.mc.only_generate_constants)
    WriteConstants ();
  else
    {
      SortAttacks();
      WriteCreatures ();
      WriteAttacks ();
    }

  return 0;
}
