/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 21 "race-class.y"

#include "config.h"
#include <stdlib.h>
#include "argz.h"
#include "xvasprintf.h"
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <netinet/in.h>
#include <dirent.h>

#include "st.h"
#include "opts.h"
#include "race-class.h"
#include "object_constant.h"

int yylex();
int yyerror( char *s );

/*
 * defined_t is used to indicate whether all fields have been defined
 */

typedef struct {
    unsigned	age: 1,
		infra_vision: 1,
		male_height: 1,
		male_weight: 1,
		female_height: 1,
		female_weight: 1,
		hit_points: 1,
		disarming: 1,
		search_chance: 1,
		stealth_factor: 1,
		frequency_of_search: 1,
		base_to_hit: 1,
		base_to_hit_with_bows: 1,
		saving_throw: 1,
		strength_modifier: 1,
		intelligence_modifier: 1,
		wisdom_modifier: 1,
		dexterity_modifier: 1,
		constitution_modifier: 1,
		charisma_modifier: 1,
		experience_factor: 1,
		classes: 1,
		store_price_adjust_by_race: 1,
		shopkeep: 1,
		backgrounds: 1;
} race_defined_t;

typedef struct {
    unsigned    hit_points: 1,
		disarming: 1,
		search_chance: 1,
		stealth_factor: 1,
		frequency_of_search: 1,
		base_to_hit: 1,
		base_to_hit_with_bows: 1,
		saving_throw: 1,
		strength_modifier: 1,
		intelligence_modifier: 1,
		wisdom_modifier: 1,
		dexterity_modifier: 1,
		constitution_modifier: 1,
		charisma_modifier: 1,
		experience_factor: 1,
                adjust_base_to_hit: 1,
                adjust_base_to_hit_with_bows: 1,
                adjust_use_device: 1,
                adjust_disarming: 1,
                adjust_saving_throw: 1,
                titles: 1,
                spells: 1,
                prayers: 1;
} class_defined_t;

typedef struct {
    unsigned    store: 1,
                haggle_per: 1,
                inflate: 1,
                max_insults: 1,
                max_cost: 1;
} shopkeep_defined_t;

typedef struct {
    unsigned    roll: 1,
                social_class_bonus: 1;
} fragment_defined_t;

typedef struct {
    unsigned    adjust_base_to_hit: 1,
                adjust_base_to_hit_with_bows: 1,
                adjust_use_device: 1,
                adjust_disarming: 1,
                adjust_saving_throw: 1;
} adjust_per_one_third_level_defined_t;

typedef struct {
    unsigned    roll: 1,
                social_class_bonus: 1;
} background_defined_t;

typedef struct {
    unsigned    level: 1,
                mana: 1,
                fail: 1,
                exp: 1;
} spell_defined_t;

typedef struct
{
  char *race;
  int price;
} race_price_t;

typedef struct
{
  race_type r;
  race_price_t *price_adjust;
  int num_price_adjust;
  char *classes_argz;
  size_t classes_len;
  owner_type *shopkeeps;
  int num_shopkeeps;
  background_type *backgrounds;
  int num_backgrounds;
} race_t;

typedef struct
{
  int idx;
  race_t val;
  race_defined_t def;
  int line_no_for_classes;
  int line_no_for_price_adjust;
} race_template_t;


typedef struct
{
  int idx;
  spell_type s;
  int line_no;
} spell_t;

typedef struct
{
  class_type c;
  char *male_titles_argz;
  size_t male_titles_len;
  char *female_titles_argz;
  size_t female_titles_len;
  int adjust_per_one_third_level[MAX_LEV_ADJ];
  spell_t *spells;
  int num_spells;
  spell_t *prayers;
  int num_prayers;
} class_t;

typedef struct
{
  int idx;
  class_t val;
  class_defined_t def;
} class_template_t;

typedef struct
{
  owner_type val;
  shopkeep_defined_t def;
  int line_no;
} shopkeep_template_t;

typedef struct
{
  background_type val;
  background_defined_t def;
  int line_no;
} background_template_t;

typedef struct
{
  background_type val;
  fragment_defined_t def;
} fragment_template_t;

typedef struct
{
  spell_t val;
  spell_defined_t def;
} spell_template_t;


struct name_block_t
{
  char *name;
  int val;
};

struct name_block_t * spell_names;
int num_spells_named;
struct name_block_t* prayer_names;
int num_prayers_named;

/*
 * symInit_t is used to initialize symbol tables with integer values
 */

typedef struct 
{
  char *name;
  int32u val;
} symInit_t;



/*
 * Maximum token length = maximum string constant length
 * Also, trim the stack to an "acceptable" size.
 */

#define	MAX_TOK_LEN	64		/* maximum acceptable token length  */
#define	YYSTACKSIZE	128

#define GEN_TYPE_TMPL	256		/* type of a template for st	    */

/*
 * Globals used by the tokenizer (lexical analyzer)
 */

#define INPUT_BUF_SIZE 256
static char	inputBuf[INPUT_BUF_SIZE] = { 0 };
					/* input line buffer		    */
static char	*inputBufp = inputBuf;	/* position in input line buffer    */
static int	lineNo = 0;		/* number of current line	    */
static FILE	*input_F;
static char	tokStr[MAX_TOK_LEN];	/* text of current token	    */
static	int	tokType;		/* type of current token	    */

static race_template_t blankRace;	/* blank race for init-ing     */
static race_template_t tmpRace;		/* working race for current race   */

static class_template_t blankClass;	/* blank class for init-ing     */
static class_template_t tmpClass;	/* working class for current class */

static shopkeep_template_t blankShopkeep;
static shopkeep_template_t tmpShopkeep;
static fragment_template_t blankFragment;
static fragment_template_t tmpFragment;

int num_shopkeeps;
int *experience_levels;
int num_experience_levels;
background_template_t tmpBackground;
background_template_t blankBackground;
spell_template_t tmpSpell;
spell_template_t blankSpell;
spell_template_t tmpPrayer;
spell_template_t blankPrayer;

/*
 * Global symbol tables
 */

static st_Table_Pt keywordT_P;		/* parser's keywords		    */
static st_Table_Pt spellsT_P;		/* spells that go in books	    */
static st_Table_Pt prayersT_P;		/* prayers that go in books	    */
static st_Table_Pt raceT_P;		/* race definitions		    */
static st_Table_Pt classT_P;		/* class definitions */

static symInit_t
spellsInit[] = 
{
    { "magic_missile", 0},
    { "detect_monsters", 1},
    { "phase_door", 2},
    { "light_area", 3},
    { "cure_light_wounds", 4},
    { "find_hidden_traps_and_doors", 5},
    { "stinking_cloud", 6},
    { "confusion", 7},
    { "lightning_bolt", 8},
    { "trap_and_door_destruction", 9},
    { "sleep_i", 10},
    { "cure_poison", 11},
    { "teleport_self", 12},
    { "remove_curse", 13},
    { "frost_bolt", 14},
    { "turn_stone_to_mud", 15},
    { "create_food", 16},
    { "recharge_item_i", 17},
    { "sleep_ii", 18},
    { "polymorph_other", 19},
    { "identify", 20},
    { "sleep_iii", 21},
    { "fire_bolt", 22},
    { "slow_monster", 23},
    { "frost_ball", 24},
    { "recharge_item_ii", 25},
    { "teleport_other", 26},
    { "haste_self", 27},
    { "fire_ball", 28},
    { "resist_poison_gas", 29},
    { "word_of_destruction", 30},
    { "genocide", 31},
    { NULL, 0 },
};

static symInit_t
prayersInit[] = 
{
    { "detect_evil", 0},
    { "cure_light_wounds", 1},
    { "bless", 2},
    { "remove_fear", 3},
    { "call_light", 4},
    { "find_traps", 5},
    { "detect_doors_and_stairs", 6},
    { "slow_poison", 7},
    { "blind_creature", 8},
    { "portal", 9},
    { "cure_medium_wounds", 10},
    { "chant", 11},
    { "sanctuary", 12},
    { "create_food", 13},
    { "remove_curse", 14},
    { "resist_heat_and_cold", 15},
    { "neutralize_poison", 16},
    { "orb_of_draining", 17},
    { "cure_serious_wounds", 18},
    { "sense_invisible", 19},
    { "protection_from_evil", 20},
    { "earthquake", 21},
    { "sense_surroundings", 22},
    { "cure_critical_wounds", 23},
    { "turn_undead", 24},
    { "pray_prayer", 25},
    { "dispel_undead", 26},
    { "heal", 27},
    { "dispel_evil", 28},
    { "resist_poison_gas", 29},
    { "glyph_of_warding", 30},
    { "holy_word", 31},
    { NULL, 0 },
};
/*
 * Function declarations
 */

void PutRace (char *s, race_template_t *tmpl_P, int consistency_check);
void PutShopkeep(shopkeep_template_t *tmpl_P, int consistency_check);
void PutBackground(background_template_t *tmpl_P, int consistency_check);
void PutSpell (char *s, spell_template_t *tmpl_P, int consistency_check);
void PutPrayer (char *s, spell_template_t *tmpl_P, int consistency_check);
void PutSpellName(char *s1, char *s2, int consistency_check);
void PutPrayerName(char *s1, char *s2, int consistency_check);
void CheckBackground (int chart, int next);
void PutClass (char *s, class_template_t *tmpl_P, int consistency_check);

int yyerror (char *s);


#line 436 "race-class.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif


/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    YYEOF = 0,                     /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    RACE = 258,                    /* RACE  */
    CLASS = 259,                   /* CLASS  */
    EXPERIENCE_LEVELS = 260,       /* EXPERIENCE_LEVELS  */
    AGE = 261,                     /* AGE  */
    MALE_HEIGHT = 262,             /* MALE_HEIGHT  */
    MALE_WEIGHT = 263,             /* MALE_WEIGHT  */
    FEMALE_HEIGHT = 264,           /* FEMALE_HEIGHT  */
    FEMALE_WEIGHT = 265,           /* FEMALE_WEIGHT  */
    INFRA_VISION = 266,            /* INFRA_VISION  */
    ATTRIBUTES = 267,              /* ATTRIBUTES  */
    HIT_POINTS = 268,              /* HIT_POINTS  */
    DISARMING = 269,               /* DISARMING  */
    SEARCH_CHANCE = 270,           /* SEARCH_CHANCE  */
    STEALTH_FACTOR = 271,          /* STEALTH_FACTOR  */
    FREQUENCY_OF_SEARCH = 272,     /* FREQUENCY_OF_SEARCH  */
    BASE_TO_HIT = 273,             /* BASE_TO_HIT  */
    BASE_TO_HIT_WITH_BOWS = 274,   /* BASE_TO_HIT_WITH_BOWS  */
    SAVING_THROW = 275,            /* SAVING_THROW  */
    STRENGTH_MODIFIER = 276,       /* STRENGTH_MODIFIER  */
    INTELLIGENCE_MODIFIER = 277,   /* INTELLIGENCE_MODIFIER  */
    WISDOM_MODIFIER = 278,         /* WISDOM_MODIFIER  */
    DEXTERITY_MODIFIER = 279,      /* DEXTERITY_MODIFIER  */
    CONSTITUTION_MODIFIER = 280,   /* CONSTITUTION_MODIFIER  */
    CHARISMA_MODIFIER = 281,       /* CHARISMA_MODIFIER  */
    EXPERIENCE_FACTOR = 282,       /* EXPERIENCE_FACTOR  */
    CLASSES = 283,                 /* CLASSES  */
    STORE_PRICE_ADJUST_BY_RACE = 284, /* STORE_PRICE_ADJUST_BY_RACE  */
    SHOPKEEP = 285,                /* SHOPKEEP  */
    STORE = 286,                   /* STORE  */
    HAGGLE_PER = 287,              /* HAGGLE_PER  */
    INFLATE = 288,                 /* INFLATE  */
    MAX_INSULTS = 289,             /* MAX_INSULTS  */
    MAX_COST = 290,                /* MAX_COST  */
    BACKGROUNDS = 291,             /* BACKGROUNDS  */
    BACKGROUND = 292,              /* BACKGROUND  */
    FRAGMENT = 293,                /* FRAGMENT  */
    ROLL = 294,                    /* ROLL  */
    SOCIAL_CLASS_BONUS = 295,      /* SOCIAL_CLASS_BONUS  */
    ADJUST_PER_ONE_THIRD_LEVEL = 296, /* ADJUST_PER_ONE_THIRD_LEVEL  */
    MALE_TITLES = 297,             /* MALE_TITLES  */
    FEMALE_TITLES = 298,           /* FEMALE_TITLES  */
    SPELLS = 299,                  /* SPELLS  */
    SPELL = 300,                   /* SPELL  */
    LEVEL = 301,                   /* LEVEL  */
    MANA = 302,                    /* MANA  */
    FAIL = 303,                    /* FAIL  */
    EXP = 304,                     /* EXP  */
    PRAYERS = 305,                 /* PRAYERS  */
    PRAYER = 306,                  /* PRAYER  */
    ADJUST_BASE_TO_HIT = 307,      /* ADJUST_BASE_TO_HIT  */
    ADJUST_BASE_TO_HIT_WITH_BOWS = 308, /* ADJUST_BASE_TO_HIT_WITH_BOWS  */
    ADJUST_USE_DEVICE = 309,       /* ADJUST_USE_DEVICE  */
    ADJUST_DISARMING = 310,        /* ADJUST_DISARMING  */
    ADJUST_SAVING_THROW = 311,     /* ADJUST_SAVING_THROW  */
    SPELL_NAMES = 312,             /* SPELL_NAMES  */
    PRAYER_NAMES = 313,            /* PRAYER_NAMES  */
    IDENTIFIER = 314,              /* IDENTIFIER  */
    FLOAT_LIT = 315,               /* FLOAT_LIT  */
    INT_LIT = 316,                 /* INT_LIT  */
    STRING_LIT = 317,              /* STRING_LIT  */
    BOOL_LIT = 318                 /* BOOL_LIT  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif
/* Token kinds.  */
#define YYEMPTY -2
#define YYEOF 0
#define YYerror 256
#define YYUNDEF 257
#define RACE 258
#define CLASS 259
#define EXPERIENCE_LEVELS 260
#define AGE 261
#define MALE_HEIGHT 262
#define MALE_WEIGHT 263
#define FEMALE_HEIGHT 264
#define FEMALE_WEIGHT 265
#define INFRA_VISION 266
#define ATTRIBUTES 267
#define HIT_POINTS 268
#define DISARMING 269
#define SEARCH_CHANCE 270
#define STEALTH_FACTOR 271
#define FREQUENCY_OF_SEARCH 272
#define BASE_TO_HIT 273
#define BASE_TO_HIT_WITH_BOWS 274
#define SAVING_THROW 275
#define STRENGTH_MODIFIER 276
#define INTELLIGENCE_MODIFIER 277
#define WISDOM_MODIFIER 278
#define DEXTERITY_MODIFIER 279
#define CONSTITUTION_MODIFIER 280
#define CHARISMA_MODIFIER 281
#define EXPERIENCE_FACTOR 282
#define CLASSES 283
#define STORE_PRICE_ADJUST_BY_RACE 284
#define SHOPKEEP 285
#define STORE 286
#define HAGGLE_PER 287
#define INFLATE 288
#define MAX_INSULTS 289
#define MAX_COST 290
#define BACKGROUNDS 291
#define BACKGROUND 292
#define FRAGMENT 293
#define ROLL 294
#define SOCIAL_CLASS_BONUS 295
#define ADJUST_PER_ONE_THIRD_LEVEL 296
#define MALE_TITLES 297
#define FEMALE_TITLES 298
#define SPELLS 299
#define SPELL 300
#define LEVEL 301
#define MANA 302
#define FAIL 303
#define EXP 304
#define PRAYERS 305
#define PRAYER 306
#define ADJUST_BASE_TO_HIT 307
#define ADJUST_BASE_TO_HIT_WITH_BOWS 308
#define ADJUST_USE_DEVICE 309
#define ADJUST_DISARMING 310
#define ADJUST_SAVING_THROW 311
#define SPELL_NAMES 312
#define PRAYER_NAMES 313
#define IDENTIFIER 314
#define FLOAT_LIT 315
#define INT_LIT 316
#define STRING_LIT 317
#define BOOL_LIT 318

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
union YYSTYPE
{
#line 395 "race-class.y"

	int ival;
	double dval;
	char sval[MAX_TOK_LEN];
	

#line 619 "race-class.c"

};
typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;


int yyparse (void);



/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_RACE = 3,                       /* RACE  */
  YYSYMBOL_CLASS = 4,                      /* CLASS  */
  YYSYMBOL_EXPERIENCE_LEVELS = 5,          /* EXPERIENCE_LEVELS  */
  YYSYMBOL_AGE = 6,                        /* AGE  */
  YYSYMBOL_MALE_HEIGHT = 7,                /* MALE_HEIGHT  */
  YYSYMBOL_MALE_WEIGHT = 8,                /* MALE_WEIGHT  */
  YYSYMBOL_FEMALE_HEIGHT = 9,              /* FEMALE_HEIGHT  */
  YYSYMBOL_FEMALE_WEIGHT = 10,             /* FEMALE_WEIGHT  */
  YYSYMBOL_INFRA_VISION = 11,              /* INFRA_VISION  */
  YYSYMBOL_ATTRIBUTES = 12,                /* ATTRIBUTES  */
  YYSYMBOL_HIT_POINTS = 13,                /* HIT_POINTS  */
  YYSYMBOL_DISARMING = 14,                 /* DISARMING  */
  YYSYMBOL_SEARCH_CHANCE = 15,             /* SEARCH_CHANCE  */
  YYSYMBOL_STEALTH_FACTOR = 16,            /* STEALTH_FACTOR  */
  YYSYMBOL_FREQUENCY_OF_SEARCH = 17,       /* FREQUENCY_OF_SEARCH  */
  YYSYMBOL_BASE_TO_HIT = 18,               /* BASE_TO_HIT  */
  YYSYMBOL_BASE_TO_HIT_WITH_BOWS = 19,     /* BASE_TO_HIT_WITH_BOWS  */
  YYSYMBOL_SAVING_THROW = 20,              /* SAVING_THROW  */
  YYSYMBOL_STRENGTH_MODIFIER = 21,         /* STRENGTH_MODIFIER  */
  YYSYMBOL_INTELLIGENCE_MODIFIER = 22,     /* INTELLIGENCE_MODIFIER  */
  YYSYMBOL_WISDOM_MODIFIER = 23,           /* WISDOM_MODIFIER  */
  YYSYMBOL_DEXTERITY_MODIFIER = 24,        /* DEXTERITY_MODIFIER  */
  YYSYMBOL_CONSTITUTION_MODIFIER = 25,     /* CONSTITUTION_MODIFIER  */
  YYSYMBOL_CHARISMA_MODIFIER = 26,         /* CHARISMA_MODIFIER  */
  YYSYMBOL_EXPERIENCE_FACTOR = 27,         /* EXPERIENCE_FACTOR  */
  YYSYMBOL_CLASSES = 28,                   /* CLASSES  */
  YYSYMBOL_STORE_PRICE_ADJUST_BY_RACE = 29, /* STORE_PRICE_ADJUST_BY_RACE  */
  YYSYMBOL_SHOPKEEP = 30,                  /* SHOPKEEP  */
  YYSYMBOL_STORE = 31,                     /* STORE  */
  YYSYMBOL_HAGGLE_PER = 32,                /* HAGGLE_PER  */
  YYSYMBOL_INFLATE = 33,                   /* INFLATE  */
  YYSYMBOL_MAX_INSULTS = 34,               /* MAX_INSULTS  */
  YYSYMBOL_MAX_COST = 35,                  /* MAX_COST  */
  YYSYMBOL_BACKGROUNDS = 36,               /* BACKGROUNDS  */
  YYSYMBOL_BACKGROUND = 37,                /* BACKGROUND  */
  YYSYMBOL_FRAGMENT = 38,                  /* FRAGMENT  */
  YYSYMBOL_ROLL = 39,                      /* ROLL  */
  YYSYMBOL_SOCIAL_CLASS_BONUS = 40,        /* SOCIAL_CLASS_BONUS  */
  YYSYMBOL_ADJUST_PER_ONE_THIRD_LEVEL = 41, /* ADJUST_PER_ONE_THIRD_LEVEL  */
  YYSYMBOL_MALE_TITLES = 42,               /* MALE_TITLES  */
  YYSYMBOL_FEMALE_TITLES = 43,             /* FEMALE_TITLES  */
  YYSYMBOL_SPELLS = 44,                    /* SPELLS  */
  YYSYMBOL_SPELL = 45,                     /* SPELL  */
  YYSYMBOL_LEVEL = 46,                     /* LEVEL  */
  YYSYMBOL_MANA = 47,                      /* MANA  */
  YYSYMBOL_FAIL = 48,                      /* FAIL  */
  YYSYMBOL_EXP = 49,                       /* EXP  */
  YYSYMBOL_PRAYERS = 50,                   /* PRAYERS  */
  YYSYMBOL_PRAYER = 51,                    /* PRAYER  */
  YYSYMBOL_ADJUST_BASE_TO_HIT = 52,        /* ADJUST_BASE_TO_HIT  */
  YYSYMBOL_ADJUST_BASE_TO_HIT_WITH_BOWS = 53, /* ADJUST_BASE_TO_HIT_WITH_BOWS  */
  YYSYMBOL_ADJUST_USE_DEVICE = 54,         /* ADJUST_USE_DEVICE  */
  YYSYMBOL_ADJUST_DISARMING = 55,          /* ADJUST_DISARMING  */
  YYSYMBOL_ADJUST_SAVING_THROW = 56,       /* ADJUST_SAVING_THROW  */
  YYSYMBOL_SPELL_NAMES = 57,               /* SPELL_NAMES  */
  YYSYMBOL_PRAYER_NAMES = 58,              /* PRAYER_NAMES  */
  YYSYMBOL_IDENTIFIER = 59,                /* IDENTIFIER  */
  YYSYMBOL_FLOAT_LIT = 60,                 /* FLOAT_LIT  */
  YYSYMBOL_INT_LIT = 61,                   /* INT_LIT  */
  YYSYMBOL_STRING_LIT = 62,                /* STRING_LIT  */
  YYSYMBOL_BOOL_LIT = 63,                  /* BOOL_LIT  */
  YYSYMBOL_64_ = 64,                       /* ';'  */
  YYSYMBOL_65_ = 65,                       /* '#'  */
  YYSYMBOL_66_ = 66,                       /* '{'  */
  YYSYMBOL_67_ = 67,                       /* '}'  */
  YYSYMBOL_68_ = 68,                       /* ':'  */
  YYSYMBOL_69_ = 69,                       /* '|'  */
  YYSYMBOL_70_ = 70,                       /* ','  */
  YYSYMBOL_YYACCEPT = 71,                  /* $accept  */
  YYSYMBOL_race_and_class = 72,            /* race_and_class  */
  YYSYMBOL_comment_def = 73,               /* comment_def  */
  YYSYMBOL_comments = 74,                  /* comments  */
  YYSYMBOL_comment = 75,                   /* comment  */
  YYSYMBOL_more_comments = 76,             /* more_comments  */
  YYSYMBOL_race_def = 77,                  /* race_def  */
  YYSYMBOL_class_def = 78,                 /* class_def  */
  YYSYMBOL_race_attributes = 79,           /* race_attributes  */
  YYSYMBOL_race_attribute = 80,            /* race_attribute  */
  YYSYMBOL_classes_def = 81,               /* classes_def  */
  YYSYMBOL_ok_classes = 82,                /* ok_classes  */
  YYSYMBOL_ok_class = 83,                  /* ok_class  */
  YYSYMBOL_more_ok_classes = 84,           /* more_ok_classes  */
  YYSYMBOL_price_race_adj = 85,            /* price_race_adj  */
  YYSYMBOL_race_prices = 86,               /* race_prices  */
  YYSYMBOL_race_price = 87,                /* race_price  */
  YYSYMBOL_more_race_prices = 88,          /* more_race_prices  */
  YYSYMBOL_shopkeep_def = 89,              /* shopkeep_def  */
  YYSYMBOL_shopkeep_attrs = 90,            /* shopkeep_attrs  */
  YYSYMBOL_more_shop_attrs = 91,           /* more_shop_attrs  */
  YYSYMBOL_shopkeep_attr = 92,             /* shopkeep_attr  */
  YYSYMBOL_backgrounds_def = 93,           /* backgrounds_def  */
  YYSYMBOL_backgrounds = 94,               /* backgrounds  */
  YYSYMBOL_background = 95,                /* background  */
  YYSYMBOL_more_backgrounds = 96,          /* more_backgrounds  */
  YYSYMBOL_fragments = 97,                 /* fragments  */
  YYSYMBOL_fragment = 98,                  /* fragment  */
  YYSYMBOL_more_fragments = 99,            /* more_fragments  */
  YYSYMBOL_frag_attrs = 100,               /* frag_attrs  */
  YYSYMBOL_frag_attr = 101,                /* frag_attr  */
  YYSYMBOL_more_frag_attrs = 102,          /* more_frag_attrs  */
  YYSYMBOL_class_attributes = 103,         /* class_attributes  */
  YYSYMBOL_class_attribute = 104,          /* class_attribute  */
  YYSYMBOL_adjust_per_lev = 105,           /* adjust_per_lev  */
  YYSYMBOL_adj_attrs = 106,                /* adj_attrs  */
  YYSYMBOL_more_adj_attrs = 107,           /* more_adj_attrs  */
  YYSYMBOL_adj_attr = 108,                 /* adj_attr  */
  YYSYMBOL_male_titles_def = 109,          /* male_titles_def  */
  YYSYMBOL_male_titles = 110,              /* male_titles  */
  YYSYMBOL_male_title = 111,               /* male_title  */
  YYSYMBOL_more_male_titles = 112,         /* more_male_titles  */
  YYSYMBOL_female_titles_def = 113,        /* female_titles_def  */
  YYSYMBOL_female_titles = 114,            /* female_titles  */
  YYSYMBOL_female_title = 115,             /* female_title  */
  YYSYMBOL_more_female_titles = 116,       /* more_female_titles  */
  YYSYMBOL_spells_def = 117,               /* spells_def  */
  YYSYMBOL_spells = 118,                   /* spells  */
  YYSYMBOL_more_spells = 119,              /* more_spells  */
  YYSYMBOL_spell = 120,                    /* spell  */
  YYSYMBOL_spell_attrs = 121,              /* spell_attrs  */
  YYSYMBOL_more_spell_attrs = 122,         /* more_spell_attrs  */
  YYSYMBOL_spell_attr = 123,               /* spell_attr  */
  YYSYMBOL_prayers_def = 124,              /* prayers_def  */
  YYSYMBOL_prayers = 125,                  /* prayers  */
  YYSYMBOL_more_prayers = 126,             /* more_prayers  */
  YYSYMBOL_prayer = 127,                   /* prayer  */
  YYSYMBOL_prayer_attrs = 128,             /* prayer_attrs  */
  YYSYMBOL_more_prayer_attrs = 129,        /* more_prayer_attrs  */
  YYSYMBOL_prayer_attr = 130,              /* prayer_attr  */
  YYSYMBOL_exp_levels_def = 131,           /* exp_levels_def  */
  YYSYMBOL_exp_levels = 132,               /* exp_levels  */
  YYSYMBOL_exp_level = 133,                /* exp_level  */
  YYSYMBOL_more_exp_levels = 134,          /* more_exp_levels  */
  YYSYMBOL_spell_names_def = 135,          /* spell_names_def  */
  YYSYMBOL_spell_names = 136,              /* spell_names  */
  YYSYMBOL_more_spell_names = 137,         /* more_spell_names  */
  YYSYMBOL_spell_name = 138,               /* spell_name  */
  YYSYMBOL_prayer_names_def = 139,         /* prayer_names_def  */
  YYSYMBOL_prayer_names = 140,             /* prayer_names  */
  YYSYMBOL_more_prayer_names = 141,        /* more_prayer_names  */
  YYSYMBOL_prayer_name = 142               /* prayer_name  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;


/* Second part of user prologue.  */
#line 417 "race-class.y"

static symInit_t 
keywordInit[] = 
{
    { "race", RACE},
    { "class", CLASS},
    { "experience_levels", EXPERIENCE_LEVELS},
    { "age", AGE},
    { "male_height", MALE_HEIGHT},
    { "male_weight", MALE_WEIGHT},
    { "female_height", FEMALE_HEIGHT},
    { "female_weight", FEMALE_WEIGHT},
    { "infra_vision", INFRA_VISION},
    { "attributes", ATTRIBUTES},
    { "hit_points", HIT_POINTS},
    { "disarming", DISARMING},
    { "search_chance", SEARCH_CHANCE},
    { "stealth_factor", STEALTH_FACTOR},
    { "frequency_of_search", FREQUENCY_OF_SEARCH},
    { "base_to_hit", BASE_TO_HIT},
    { "base_to_hit_with_bows", BASE_TO_HIT_WITH_BOWS},
    { "saving_throw", SAVING_THROW},
    { "strength_modifier", STRENGTH_MODIFIER},
    { "intelligence_modifier", INTELLIGENCE_MODIFIER},
    { "wisdom_modifier", WISDOM_MODIFIER},
    { "dexterity_modifier", DEXTERITY_MODIFIER},
    { "constitution_modifier", CONSTITUTION_MODIFIER},
    { "charisma_modifier", CHARISMA_MODIFIER},
    { "experience_factor", EXPERIENCE_FACTOR},
    { "classes", CLASSES},
    { "store_price_adjust_by_race", STORE_PRICE_ADJUST_BY_RACE},
    { "shopkeep", SHOPKEEP},
    { "store", STORE},
    { "haggle_per", HAGGLE_PER},
    { "inflate", INFLATE},
    { "max_insults", MAX_INSULTS},
    { "max_cost", MAX_COST},
    { "backgrounds", BACKGROUNDS},
    { "background", BACKGROUND},
    { "fragment", FRAGMENT},
    { "roll", ROLL},
    { "social_class_bonus", SOCIAL_CLASS_BONUS},
    { "adjust_per_one_third_level", ADJUST_PER_ONE_THIRD_LEVEL},
    { "male_titles", MALE_TITLES},
    { "female_titles", FEMALE_TITLES},
    { "spells", SPELLS},
    { "spell", SPELL},
    { "level", LEVEL},
    { "mana", MANA},
    { "fail", FAIL},
    { "exp", EXP},
    { "prayers", PRAYERS},
    { "prayer", PRAYER},
    { "adjust_base_to_hit", ADJUST_BASE_TO_HIT},
    { "adjust_base_to_hit_with_bows", ADJUST_BASE_TO_HIT_WITH_BOWS},
    { "adjust_use_device", ADJUST_USE_DEVICE},
    { "adjust_disarming", ADJUST_DISARMING},
    { "adjust_saving_throw", ADJUST_SAVING_THROW},
    { "spell_names", SPELL_NAMES},
    { "prayer_names", PRAYER_NAMES},
    { NULL, 0 }
};

#line 851 "race-class.c"


#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  22
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   373

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  71
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  72
/* YYNRULES -- Number of rules.  */
#define YYNRULES  155
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  421

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   318


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,    65,     2,     2,     2,     2,
       2,     2,     2,     2,    70,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    68,    64,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    66,    69,    67,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   504,   504,   505,   506,   507,   508,   509,   510,   513,
     517,   520,   524,   525,   528,   539,   550,   551,   552,   553,
     554,   555,   558,   562,   565,   569,   573,   577,   581,   584,
     587,   590,   593,   596,   599,   602,   605,   608,   611,   614,
     617,   620,   623,   628,   634,   637,   642,   643,   646,   651,
     654,   688,   689,   692,   709,   712,   713,   716,   727,   730,
     735,   738,   743,   747,   750,   764,   765,   768,   771,   779,
     780,   783,   786,   792,   797,   798,   801,   802,   803,   804,
     805,   806,   807,   810,   813,   816,   819,   822,   825,   828,
     831,   834,   837,   840,   843,   846,   849,   852,   857,   860,
     863,   864,   867,   871,   875,   879,   883,   889,   893,   896,
     920,   921,   924,   928,   931,   957,   958,   961,   964,   967,
     968,   971,   977,   980,   981,   984,   987,   990,   993,   998,
    1001,  1004,  1005,  1008,  1014,  1017,  1018,  1021,  1024,  1027,
    1030,  1035,  1038,  1041,  1062,  1063,  1066,  1069,  1072,  1073,
    1076,  1082,  1085,  1088,  1089,  1092
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "RACE", "CLASS",
  "EXPERIENCE_LEVELS", "AGE", "MALE_HEIGHT", "MALE_WEIGHT",
  "FEMALE_HEIGHT", "FEMALE_WEIGHT", "INFRA_VISION", "ATTRIBUTES",
  "HIT_POINTS", "DISARMING", "SEARCH_CHANCE", "STEALTH_FACTOR",
  "FREQUENCY_OF_SEARCH", "BASE_TO_HIT", "BASE_TO_HIT_WITH_BOWS",
  "SAVING_THROW", "STRENGTH_MODIFIER", "INTELLIGENCE_MODIFIER",
  "WISDOM_MODIFIER", "DEXTERITY_MODIFIER", "CONSTITUTION_MODIFIER",
  "CHARISMA_MODIFIER", "EXPERIENCE_FACTOR", "CLASSES",
  "STORE_PRICE_ADJUST_BY_RACE", "SHOPKEEP", "STORE", "HAGGLE_PER",
  "INFLATE", "MAX_INSULTS", "MAX_COST", "BACKGROUNDS", "BACKGROUND",
  "FRAGMENT", "ROLL", "SOCIAL_CLASS_BONUS", "ADJUST_PER_ONE_THIRD_LEVEL",
  "MALE_TITLES", "FEMALE_TITLES", "SPELLS", "SPELL", "LEVEL", "MANA",
  "FAIL", "EXP", "PRAYERS", "PRAYER", "ADJUST_BASE_TO_HIT",
  "ADJUST_BASE_TO_HIT_WITH_BOWS", "ADJUST_USE_DEVICE", "ADJUST_DISARMING",
  "ADJUST_SAVING_THROW", "SPELL_NAMES", "PRAYER_NAMES", "IDENTIFIER",
  "FLOAT_LIT", "INT_LIT", "STRING_LIT", "BOOL_LIT", "';'", "'#'", "'{'",
  "'}'", "':'", "'|'", "','", "$accept", "race_and_class", "comment_def",
  "comments", "comment", "more_comments", "race_def", "class_def",
  "race_attributes", "race_attribute", "classes_def", "ok_classes",
  "ok_class", "more_ok_classes", "price_race_adj", "race_prices",
  "race_price", "more_race_prices", "shopkeep_def", "shopkeep_attrs",
  "more_shop_attrs", "shopkeep_attr", "backgrounds_def", "backgrounds",
  "background", "more_backgrounds", "fragments", "fragment",
  "more_fragments", "frag_attrs", "frag_attr", "more_frag_attrs",
  "class_attributes", "class_attribute", "adjust_per_lev", "adj_attrs",
  "more_adj_attrs", "adj_attr", "male_titles_def", "male_titles",
  "male_title", "more_male_titles", "female_titles_def", "female_titles",
  "female_title", "more_female_titles", "spells_def", "spells",
  "more_spells", "spell", "spell_attrs", "more_spell_attrs", "spell_attr",
  "prayers_def", "prayers", "more_prayers", "prayer", "prayer_attrs",
  "more_prayer_attrs", "prayer_attr", "exp_levels_def", "exp_levels",
  "exp_level", "more_exp_levels", "spell_names_def", "spell_names",
  "more_spell_names", "spell_name", "prayer_names_def", "prayer_names",
  "more_prayer_names", "prayer_name", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-279)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-1)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
      -3,   -44,    -9,    19,    25,    26,    34,    94,    -3,    31,
      32,    33,    36,    37,    38,    39,    42,    40,    43,  -279,
    -279,    34,  -279,  -279,    -3,    -3,    -3,    -3,    -3,    50,
     -10,  -279,    44,    28,    45,    47,    40,    48,    51,    43,
      34,  -279,  -279,  -279,  -279,  -279,  -279,    49,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    46,    74,
      79,    76,    77,    81,    82,    83,    84,    85,    75,    86,
      87,    88,    89,    90,    91,    92,    93,    95,    96,    97,
      98,    99,   100,   103,   104,   105,   106,   107,   108,   110,
     112,   113,   114,   115,   116,  -279,    42,  -279,   119,  -279,
    -279,    40,   120,  -279,  -279,    43,  -279,   101,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,    72,  -279,    50,    50,    50,    50,    50,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,   156,   157,
     158,   159,   160,   -26,   161,   162,   177,   102,  -279,   -10,
     -10,   -10,   -10,   -10,   -10,    28,   163,  -279,   164,  -279,
     165,   166,   167,   168,   169,  -279,  -279,  -279,  -279,  -279,
    -279,  -279,  -279,  -279,  -279,  -279,  -279,  -279,  -279,  -279,
    -279,  -279,   172,    80,   173,   175,   176,   170,   182,   178,
     174,  -279,  -279,  -279,  -279,  -279,  -279,  -279,  -279,  -279,
    -279,  -279,  -279,  -279,  -279,  -279,  -279,  -279,  -279,  -279,
    -279,   179,   180,   181,   183,   184,   186,   190,  -279,   188,
     187,  -279,   189,   191,   171,   192,   193,   199,   195,   194,
    -279,  -279,  -279,  -279,  -279,  -279,  -279,  -279,  -279,   185,
     204,   205,   206,   207,  -279,   142,  -279,   208,  -279,   143,
     209,   210,  -279,    72,  -279,   211,   212,   213,   215,   216,
    -279,   -26,  -279,   161,  -279,  -279,   162,  -279,   214,  -279,
     177,  -279,   217,  -279,   102,  -279,  -279,  -279,  -279,  -279,
    -279,    80,  -279,   196,  -279,    10,   218,   174,  -279,  -279,
    -279,  -279,  -279,  -279,   221,   187,   191,    35,   193,    41,
     194,  -279,   143,   202,   219,   220,   222,   223,   225,   229,
     240,  -279,   -26,  -279,  -279,   226,   227,   228,   230,   232,
     233,  -279,   234,   235,   236,   237,   239,   243,  -279,  -279,
     224,   247,   248,   249,   250,  -279,    10,   238,   245,   231,
    -279,   252,   253,   254,   255,  -279,    35,   256,   257,   258,
     259,  -279,    41,  -279,  -279,   260,  -279,  -279,  -279,   261,
     262,  -279,   240,  -279,  -279,  -279,  -279,  -279,  -279,   263,
    -279,  -279,  -279,  -279,  -279,   266,   265,    10,    12,   231,
      35,    41,  -279,  -279,   264,   267,   269,   270,  -279,  -279,
    -279,   272,   276,  -279,    12,  -279,  -279,   274,  -279,    12,
    -279
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       8,     0,     0,     0,     0,     0,     0,     0,     8,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    11,
       9,    13,     1,     7,     8,     8,     8,     8,     8,    21,
      82,   143,     0,   145,     0,     0,   149,     0,     0,   154,
      13,    10,     2,     3,     4,     5,     6,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   141,     0,   142,     0,   146,
     147,   149,     0,   151,   152,   154,    12,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    14,    21,    21,    21,    21,    21,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    15,    82,
      82,    82,    82,    82,    82,   145,     0,   148,     0,   153,
       0,     0,     0,     0,     0,    23,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    45,     0,    47,     0,     0,     0,     0,     0,     0,
      66,    16,    17,    18,    19,    20,    83,    84,    85,    86,
      87,    88,    89,    90,    91,    92,    93,    94,    95,    96,
      97,     0,     0,     0,     0,     0,     0,     0,   109,     0,
     111,   114,     0,   116,     0,     0,   120,     0,     0,   132,
      76,    77,    78,    79,    80,    81,   144,   150,   155,     0,
       0,     0,     0,     0,    43,     0,    44,     0,    48,    52,
       0,     0,    62,     0,    63,     0,     0,     0,     0,     0,
      98,   101,   107,     0,   108,   112,     0,   113,     0,   117,
       0,   118,     0,   129,     0,   130,    22,    24,    25,    26,
      27,    47,    50,     0,    49,     0,     0,    66,   102,   103,
     104,   105,   106,    99,     0,   111,   116,     0,   120,     0,
     132,    46,    52,     0,     0,     0,     0,     0,     0,     0,
       0,    65,   101,   110,   115,     0,     0,     0,     0,     0,
       0,   119,     0,     0,     0,     0,     0,     0,   131,    51,
       0,     0,     0,     0,     0,    53,    56,     0,     0,    70,
     100,     0,     0,     0,     0,   121,   124,     0,     0,     0,
       0,   133,   136,    57,    58,     0,    60,    61,    54,     0,
       0,    64,     0,    67,   125,   126,   127,   128,   122,     0,
     137,   138,   139,   140,   134,     0,     0,    56,     0,    70,
     124,   136,    59,    55,     0,     0,     0,     0,    69,   123,
     135,     0,     0,    68,    75,    72,    73,     0,    71,    75,
      74
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -279,    11,  -279,  -279,   109,   111,  -279,  -279,   -97,  -279,
    -279,  -279,  -159,  -194,  -279,  -279,   -31,  -212,  -279,  -279,
    -278,  -153,  -279,  -279,   -70,   -82,  -279,  -156,  -170,  -279,
    -167,  -186,  -149,  -279,  -279,  -279,   -53,   118,  -279,  -279,
     -33,     6,  -279,  -279,    -4,   -27,  -279,  -279,     4,    73,
    -279,   -77,     7,  -279,  -279,    20,    78,  -279,   -62,    22,
    -279,  -279,   241,   198,  -279,  -279,   242,   314,  -279,  -279,
     244,   324
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     7,     8,    20,    40,    41,     9,    10,    72,    73,
      74,   202,   203,   266,    75,   205,   303,   304,    76,   328,
     378,   379,    77,   209,   210,   274,   358,   359,   383,   406,
     417,   418,    98,    99,   100,   236,   313,   314,   101,   239,
     240,   284,   102,   242,   243,   287,   103,   245,   291,   246,
     339,   388,   389,   104,   248,   295,   249,   346,   394,   395,
      11,    32,    33,   107,    12,    35,   110,   111,    13,    38,
     114,   115
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
       1,     2,     3,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    14,    23,
     250,   251,   252,   253,   254,   255,   231,   232,   233,   234,
     235,    93,    94,    95,    96,    42,    43,    44,    45,    46,
      97,   323,   324,   325,   326,   327,   211,   212,   213,   214,
     215,   404,   405,    15,     4,     5,    47,    48,    49,    50,
      51,    52,     6,    53,    54,    55,    56,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    69,
      70,   335,   336,   337,   338,    16,    71,   342,   343,   344,
     345,    17,    18,    19,    22,    24,    25,    26,   106,    34,
      27,    28,    37,    31,    29,    30,   301,   321,   206,   208,
     349,   105,   138,   108,   109,    21,   112,   117,   113,   403,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     139,   140,   141,   148,   142,   143,   144,   145,   146,   147,
     265,   116,   329,   247,   149,   150,   151,   152,   153,   154,
     155,   156,   180,   157,   158,   159,   160,   161,   162,   163,
     164,   165,   166,   167,   169,   168,   170,   171,   172,   173,
     174,   176,   178,   181,   182,   183,   184,   185,   186,   187,
     188,   189,   190,   191,   192,   193,   194,   195,   196,   197,
     198,   199,   200,   307,   201,   204,   207,   216,   217,   218,
     219,   220,   221,   222,   223,   224,   225,   226,   227,   228,
     229,   230,   244,   238,   241,   331,   399,   257,   258,   408,
     288,   407,   270,   420,   259,   260,   261,   262,   263,   264,
     269,   267,   268,   271,   273,   272,   296,   275,   276,   277,
     315,   278,   279,   280,   281,   282,   285,   283,   292,   289,
     322,   286,   293,   290,   294,   297,   298,   299,   300,   302,
     350,   306,   308,   309,   310,   305,   311,   312,   357,   360,
     317,   237,   316,   319,   330,   332,   373,   351,   352,   334,
     353,   354,   355,   356,   361,   362,   363,   366,   364,   365,
     380,   382,   367,   368,   369,   370,   371,   372,   374,   375,
     376,   377,   381,   384,   385,   386,   387,   390,   391,   392,
     393,   333,   341,   409,   340,   397,   402,   400,   398,   396,
     401,    36,   411,   415,   414,   412,   413,   416,   419,   410,
     348,   347,    39,     0,     0,     0,     0,   175,     0,     0,
       0,     0,     0,   177,     0,     0,     0,     0,     0,   179,
       0,     0,     0,   318,     0,     0,     0,     0,     0,     0,
       0,     0,   320,   256
};

static const yytype_int16 yycheck[] =
{
       3,     4,     5,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    62,     8,
     169,   170,   171,   172,   173,   174,    52,    53,    54,    55,
      56,    41,    42,    43,    44,    24,    25,    26,    27,    28,
      50,    31,    32,    33,    34,    35,   143,   144,   145,   146,
     147,    39,    40,    62,    57,    58,     6,     7,     8,     9,
      10,    11,    65,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    46,    47,    48,    49,    66,    36,    46,    47,    48,
      49,    66,    66,    59,     0,    64,    64,    64,    70,    59,
      64,    64,    59,    61,    66,    66,   265,   301,   139,    37,
     322,    67,    66,    68,    67,     6,    68,    68,    67,   397,
      68,    68,    68,    68,    68,    68,    68,    68,    68,    68,
      68,    68,    68,    68,    68,    68,    68,    68,    68,    68,
      66,    62,    66,    68,    67,    64,    64,    64,    64,    64,
      70,    40,   305,    51,    68,    68,    68,    68,    68,    68,
      68,    68,    61,    68,    68,    68,    68,    68,    68,    66,
      66,    66,    66,    66,    64,    67,    64,    64,    64,    64,
      64,    62,    62,    61,    61,    61,    61,    61,    61,    61,
      61,    61,    61,    61,    61,    61,    61,    61,    61,    61,
      61,    61,    61,   273,    62,    62,    62,    61,    61,    61,
      61,    61,    61,    61,    61,    61,    61,    61,    61,    61,
      61,    61,    45,    62,    62,   307,   382,    64,    64,   399,
      59,   398,    62,   419,    69,    69,    69,    69,    69,    67,
      64,    68,    67,    61,    70,    67,    61,    68,    68,    68,
     283,    68,    68,    67,    64,    67,    67,    70,    59,    67,
      64,    70,    67,    70,    70,    61,    61,    61,    61,    61,
      68,    61,    61,    61,    61,    66,    61,    61,    38,   332,
      66,   163,   286,    66,    66,    64,    62,    68,    68,   316,
      68,    68,    67,    64,    68,    68,    68,    64,    68,    67,
      62,    70,    68,    68,    68,    68,    67,    64,    61,    61,
      61,    61,    67,    61,    61,    61,    61,    61,    61,    61,
      61,   315,   318,   400,   317,    64,    61,    64,    66,    69,
      64,    17,    68,    61,    64,    68,    67,    61,    64,   401,
     320,   319,    18,    -1,    -1,    -1,    -1,   106,    -1,    -1,
      -1,    -1,    -1,   111,    -1,    -1,    -1,    -1,    -1,   115,
      -1,    -1,    -1,   290,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   294,   175
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     3,     4,     5,    57,    58,    65,    72,    73,    77,
      78,   131,   135,   139,    62,    62,    66,    66,    66,    59,
      74,    75,     0,    72,    64,    64,    64,    64,    64,    66,
      66,    61,   132,   133,    59,   136,   138,    59,   140,   142,
      75,    76,    72,    72,    72,    72,    72,     6,     7,     8,
       9,    10,    11,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    36,    79,    80,    81,    85,    89,    93,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    41,    42,    43,    44,    50,   103,   104,
     105,   109,   113,   117,   124,    67,    70,   134,    68,    67,
     137,   138,    68,    67,   141,   142,    76,    68,    68,    68,
      68,    68,    68,    68,    68,    68,    68,    68,    68,    68,
      68,    68,    68,    68,    68,    68,    68,    68,    66,    66,
      62,    66,    67,    64,    64,    64,    64,    64,    68,    68,
      68,    68,    68,    68,    68,    68,    68,    68,    68,    68,
      68,    68,    68,    66,    66,    66,    66,    66,    67,    64,
      64,    64,    64,    64,    64,   133,    62,   137,    62,   141,
      61,    61,    61,    61,    61,    61,    61,    61,    61,    61,
      61,    61,    61,    61,    61,    61,    61,    61,    61,    61,
      61,    62,    82,    83,    62,    86,    87,    62,    37,    94,
      95,    79,    79,    79,    79,    79,    61,    61,    61,    61,
      61,    61,    61,    61,    61,    61,    61,    61,    61,    61,
      61,    52,    53,    54,    55,    56,   106,   108,    62,   110,
     111,    62,   114,   115,    45,   118,   120,    51,   125,   127,
     103,   103,   103,   103,   103,   103,   134,    64,    64,    69,
      69,    69,    69,    69,    67,    70,    84,    68,    67,    64,
      62,    61,    67,    70,    96,    68,    68,    68,    68,    68,
      67,    64,    67,    70,   112,    67,    70,   116,    59,    67,
      70,   119,    59,    67,    70,   126,    61,    61,    61,    61,
      61,    83,    61,    87,    88,    66,    61,    95,    61,    61,
      61,    61,    61,   107,   108,   111,   115,    66,   120,    66,
     127,    84,    64,    31,    32,    33,    34,    35,    90,    92,
      66,    96,    64,   112,   116,    46,    47,    48,    49,   121,
     123,   119,    46,    47,    48,    49,   128,   130,   126,    88,
      68,    68,    68,    68,    68,    67,    64,    38,    97,    98,
     107,    68,    68,    68,    68,    67,    64,    68,    68,    68,
      68,    67,    64,    62,    61,    61,    61,    61,    91,    92,
      62,    67,    70,    99,    61,    61,    61,    61,   122,   123,
      61,    61,    61,    61,   129,   130,    69,    64,    66,    98,
      64,    64,    61,    91,    39,    40,   100,   101,    99,   122,
     129,    68,    68,    67,    64,    61,    61,   101,   102,    64,
     102
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_uint8 yyr1[] =
{
       0,    71,    72,    72,    72,    72,    72,    72,    72,    73,
      74,    75,    76,    76,    77,    78,    79,    79,    79,    79,
      79,    79,    80,    80,    80,    80,    80,    80,    80,    80,
      80,    80,    80,    80,    80,    80,    80,    80,    80,    80,
      80,    80,    80,    81,    82,    83,    84,    84,    85,    86,
      87,    88,    88,    89,    90,    91,    91,    92,    92,    92,
      92,    92,    93,    94,    95,    96,    96,    97,    98,    99,
      99,   100,   101,   101,   102,   102,   103,   103,   103,   103,
     103,   103,   103,   104,   104,   104,   104,   104,   104,   104,
     104,   104,   104,   104,   104,   104,   104,   104,   105,   106,
     107,   107,   108,   108,   108,   108,   108,   109,   110,   111,
     112,   112,   113,   114,   115,   116,   116,   117,   118,   119,
     119,   120,   121,   122,   122,   123,   123,   123,   123,   124,
     125,   126,   126,   127,   128,   129,   129,   130,   130,   130,
     130,   131,   132,   133,   134,   134,   135,   136,   137,   137,
     138,   139,   140,   141,   141,   142
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     3,     3,     3,     3,     3,     2,     0,     2,
       2,     1,     2,     0,     5,     5,     3,     3,     3,     3,
       3,     0,     5,     3,     5,     5,     5,     5,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     4,     2,     1,     3,     0,     4,     3,
       3,     3,     0,     7,     3,     3,     0,     3,     3,     5,
       3,     3,     4,     2,     6,     3,     0,     2,     5,     3,
       0,     3,     3,     3,     3,     0,     3,     3,     3,     3,
       3,     3,     0,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     4,     3,
       3,     0,     3,     3,     3,     3,     3,     4,     2,     1,
       3,     0,     4,     2,     1,     3,     0,     4,     2,     3,
       0,     5,     3,     3,     0,     3,     3,     3,     3,     4,
       2,     3,     0,     5,     3,     3,     0,     3,     3,     3,
       3,     4,     2,     1,     3,     0,     4,     2,     2,     0,
       4,     4,     2,     2,     0,     4
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 9: /* comment_def: '#' comments  */
#line 514 "race-class.y"
                        {/*don't do anything*/;}
#line 2089 "race-class.c"
    break;

  case 11: /* comment: IDENTIFIER  */
#line 521 "race-class.y"
                        {/* don't do anything with it*/;}
#line 2095 "race-class.c"
    break;

  case 14: /* race_def: RACE STRING_LIT '{' race_attributes '}'  */
#line 529 "race-class.y"
                                { tmpRace.val.r.trace =
				    (char *) malloc(strlen((yyvsp[-3].sval)) + 1);
				  strcpy(tmpRace.val.r.trace, (yyvsp[-3].sval));
                                  tmpRace.idx = St_TableSize(raceT_P);
				  PutRace((yyvsp[-3].sval), &tmpRace,
					      arguments.rcc.consistency_check);
				  tmpRace = blankRace;
				}
#line 2108 "race-class.c"
    break;

  case 15: /* class_def: CLASS STRING_LIT '{' class_attributes '}'  */
#line 540 "race-class.y"
                                { tmpClass.val.c.title =
				    (char *) malloc(strlen((yyvsp[-3].sval)) + 1);
				  strcpy(tmpClass.val.c.title, (yyvsp[-3].sval));
                                  tmpClass.idx = St_TableSize(classT_P);
				  PutClass((yyvsp[-3].sval), &tmpClass,
					      arguments.rcc.consistency_check);
				  tmpClass = blankClass;
				}
#line 2121 "race-class.c"
    break;

  case 22: /* race_attribute: AGE ':' INT_LIT '|' INT_LIT  */
#line 559 "race-class.y"
                                { tmpRace.val.r.b_age = (yyvsp[-2].ival);
                                  tmpRace.val.r.m_age = (yyvsp[0].ival);
				  tmpRace.def.age = TRUE; }
#line 2129 "race-class.c"
    break;

  case 23: /* race_attribute: INFRA_VISION ':' INT_LIT  */
#line 563 "race-class.y"
                                { tmpRace.val.r.infra = (yyvsp[0].ival);
				  tmpRace.def.infra_vision = TRUE; }
#line 2136 "race-class.c"
    break;

  case 24: /* race_attribute: MALE_HEIGHT ':' INT_LIT '|' INT_LIT  */
#line 566 "race-class.y"
                                { tmpRace.val.r.m_b_ht = (yyvsp[-2].ival);
				  tmpRace.val.r.m_m_ht = (yyvsp[0].ival);
				  tmpRace.def.male_height = TRUE; }
#line 2144 "race-class.c"
    break;

  case 25: /* race_attribute: MALE_WEIGHT ':' INT_LIT '|' INT_LIT  */
#line 570 "race-class.y"
                                { tmpRace.val.r.m_b_wt = (yyvsp[-2].ival);
				  tmpRace.val.r.m_m_wt = (yyvsp[0].ival);
				  tmpRace.def.male_weight = TRUE; }
#line 2152 "race-class.c"
    break;

  case 26: /* race_attribute: FEMALE_HEIGHT ':' INT_LIT '|' INT_LIT  */
#line 574 "race-class.y"
                                { tmpRace.val.r.f_b_ht = (yyvsp[-2].ival);
				  tmpRace.val.r.f_m_ht = (yyvsp[0].ival);
				  tmpRace.def.female_height = TRUE; }
#line 2160 "race-class.c"
    break;

  case 27: /* race_attribute: FEMALE_WEIGHT ':' INT_LIT '|' INT_LIT  */
#line 578 "race-class.y"
                                { tmpRace.val.r.f_b_wt = (yyvsp[-2].ival);
				  tmpRace.val.r.f_m_wt = (yyvsp[0].ival);
				  tmpRace.def.female_weight = TRUE; }
#line 2168 "race-class.c"
    break;

  case 28: /* race_attribute: HIT_POINTS ':' INT_LIT  */
#line 582 "race-class.y"
                                { tmpRace.val.r.bhitdie = (yyvsp[0].ival);
				  tmpRace.def.hit_points = TRUE; }
#line 2175 "race-class.c"
    break;

  case 29: /* race_attribute: DISARMING ':' INT_LIT  */
#line 585 "race-class.y"
                                { tmpRace.val.r.b_dis = (yyvsp[0].ival);
				  tmpRace.def.disarming = TRUE; }
#line 2182 "race-class.c"
    break;

  case 30: /* race_attribute: SEARCH_CHANCE ':' INT_LIT  */
#line 588 "race-class.y"
                                { tmpRace.val.r.srh = (yyvsp[0].ival);
				  tmpRace.def.search_chance = TRUE; }
#line 2189 "race-class.c"
    break;

  case 31: /* race_attribute: STEALTH_FACTOR ':' INT_LIT  */
#line 591 "race-class.y"
                                { tmpRace.val.r.stl = (yyvsp[0].ival);
				  tmpRace.def.stealth_factor = TRUE; }
#line 2196 "race-class.c"
    break;

  case 32: /* race_attribute: FREQUENCY_OF_SEARCH ':' INT_LIT  */
#line 594 "race-class.y"
                                { tmpRace.val.r.fos = (yyvsp[0].ival);
				  tmpRace.def.frequency_of_search = TRUE; }
#line 2203 "race-class.c"
    break;

  case 33: /* race_attribute: BASE_TO_HIT ':' INT_LIT  */
#line 597 "race-class.y"
                                { tmpRace.val.r.bth = (yyvsp[0].ival);
				  tmpRace.def.base_to_hit = TRUE; }
#line 2210 "race-class.c"
    break;

  case 34: /* race_attribute: BASE_TO_HIT_WITH_BOWS ':' INT_LIT  */
#line 600 "race-class.y"
                                { tmpRace.val.r.bthb = (yyvsp[0].ival);
				  tmpRace.def.base_to_hit_with_bows = TRUE; }
#line 2217 "race-class.c"
    break;

  case 35: /* race_attribute: SAVING_THROW ':' INT_LIT  */
#line 603 "race-class.y"
                                { tmpRace.val.r.bsav = (yyvsp[0].ival);
				  tmpRace.def.saving_throw = TRUE; }
#line 2224 "race-class.c"
    break;

  case 36: /* race_attribute: STRENGTH_MODIFIER ':' INT_LIT  */
#line 606 "race-class.y"
                                { tmpRace.val.r.str_adj = (yyvsp[0].ival);
				  tmpRace.def.strength_modifier = TRUE; }
#line 2231 "race-class.c"
    break;

  case 37: /* race_attribute: INTELLIGENCE_MODIFIER ':' INT_LIT  */
#line 609 "race-class.y"
                                { tmpRace.val.r.int_adj = (yyvsp[0].ival);
				  tmpRace.def.intelligence_modifier = TRUE; }
#line 2238 "race-class.c"
    break;

  case 38: /* race_attribute: WISDOM_MODIFIER ':' INT_LIT  */
#line 612 "race-class.y"
                                { tmpRace.val.r.wis_adj = (yyvsp[0].ival);
				  tmpRace.def.wisdom_modifier = TRUE; }
#line 2245 "race-class.c"
    break;

  case 39: /* race_attribute: DEXTERITY_MODIFIER ':' INT_LIT  */
#line 615 "race-class.y"
                                { tmpRace.val.r.dex_adj = (yyvsp[0].ival);
				  tmpRace.def.dexterity_modifier = TRUE; }
#line 2252 "race-class.c"
    break;

  case 40: /* race_attribute: CONSTITUTION_MODIFIER ':' INT_LIT  */
#line 618 "race-class.y"
                                { tmpRace.val.r.con_adj = (yyvsp[0].ival);
				  tmpRace.def.constitution_modifier = TRUE; }
#line 2259 "race-class.c"
    break;

  case 41: /* race_attribute: CHARISMA_MODIFIER ':' INT_LIT  */
#line 621 "race-class.y"
                                { tmpRace.val.r.chr_adj = (yyvsp[0].ival);
				  tmpRace.def.charisma_modifier = TRUE; }
#line 2266 "race-class.c"
    break;

  case 42: /* race_attribute: EXPERIENCE_FACTOR ':' INT_LIT  */
#line 624 "race-class.y"
                                { tmpRace.val.r.b_exp = (yyvsp[0].ival);
				  tmpRace.def.experience_factor = TRUE; }
#line 2273 "race-class.c"
    break;

  case 43: /* classes_def: CLASSES '{' ok_classes '}'  */
#line 629 "race-class.y"
                                { /*PutAllowedClassesForRace();*/ 
                                  tmpRace.def.classes = TRUE; 
                                  tmpRace.line_no_for_classes = lineNo;}
#line 2281 "race-class.c"
    break;

  case 45: /* ok_class: STRING_LIT  */
#line 638 "race-class.y"
                                { argz_add(&tmpRace.val.classes_argz,
                                           &tmpRace.val.classes_len, (yyvsp[0].sval));}
#line 2288 "race-class.c"
    break;

  case 48: /* price_race_adj: STORE_PRICE_ADJUST_BY_RACE '{' race_prices '}'  */
#line 647 "race-class.y"
                                {tmpRace.def.store_price_adjust_by_race = TRUE;
                                 tmpRace.line_no_for_price_adjust = lineNo; }
#line 2295 "race-class.c"
    break;

  case 50: /* race_price: STRING_LIT ':' INT_LIT  */
#line 655 "race-class.y"
                                {if (arguments.rcc.consistency_check)
                                   {
                                     int i = 0;
                                     for (; i<tmpRace.val.num_price_adjust; i++)
                                       {
                                         race_price_t val =
                                           tmpRace.val.price_adjust[i];
                                         if (strcmp (val.race, (yyvsp[-2].sval)) == 0)
                                           {
                                             char *msg = 
                                               xasprintf ("duplicate race `%s'",
                                                           val.race);
                                             yyerror (msg);
                                           }
                                       }
                                       if ((yyvsp[0].ival) == 0)
                                         {
                                           char *msg = "price must be greater "
                                                       "than zero";
                                           yyerror (msg);
                                         }
                                   }
                                 tmpRace.val.num_price_adjust++;
                                 int num = tmpRace.val.num_price_adjust;
                                 tmpRace.val.price_adjust = 
                                   realloc (tmpRace.val.price_adjust,
                                            num * sizeof (race_price_t));
                                 race_price_t val;
                                 val.race = strdup((yyvsp[-2].sval)); //FIXME leak
                                 val.price = (yyvsp[0].ival);
                                 tmpRace.val.price_adjust[num-1] = val;}
#line 2331 "race-class.c"
    break;

  case 53: /* shopkeep_def: SHOPKEEP STRING_LIT STRING_LIT STRING_LIT '{' shopkeep_attrs '}'  */
#line 693 "race-class.y"
                                { 
                                  tmpRace.def.shopkeep = TRUE;
                                  char *r = xasprintf ("(%s)", (yyvsp[-4].sval));
                                  tmpShopkeep.val.owner_name = 
                                    xasprintf ("%-22s %-12s %s", 
                                      (yyvsp[-5].sval), r, (yyvsp[-3].sval));
                                  tmpShopkeep.line_no = lineNo;
                                  tmpShopkeep.val.owner_race = 
                                    St_TableSize(raceT_P);
				  PutShopkeep(&tmpShopkeep,
					      arguments.rcc.consistency_check);
				  tmpShopkeep = blankShopkeep;
                                  num_shopkeeps++;
				}
#line 2350 "race-class.c"
    break;

  case 57: /* shopkeep_attr: STORE ':' STRING_LIT  */
#line 717 "race-class.y"
                                {
                                 if (arguments.rcc.consistency_check)
                                   {
                                     if (strlen ((yyvsp[0].sval)) > 1 || 
                                         strlen ((yyvsp[0].sval)) == 0 ||
                                         (yyvsp[0].sval)[0] - '1' > MAX_STORES)
                                       yyerror ("invalid store");
                                   }
                                 tmpShopkeep.def.store = TRUE;
                                 tmpShopkeep.val.pstore = (yyvsp[0].sval)[0] - '1';}
#line 2365 "race-class.c"
    break;

  case 58: /* shopkeep_attr: HAGGLE_PER ':' INT_LIT  */
#line 728 "race-class.y"
                                {tmpShopkeep.def.haggle_per = TRUE;
                                 tmpShopkeep.val.haggle_per = (yyvsp[0].ival);}
#line 2372 "race-class.c"
    break;

  case 59: /* shopkeep_attr: INFLATE ':' INT_LIT '|' INT_LIT  */
#line 731 "race-class.y"
                                {tmpShopkeep.def.inflate = TRUE;
                                 tmpShopkeep.val.min_inflate = (yyvsp[-2].ival);
                                 tmpShopkeep.val.max_inflate = 
                                   tmpShopkeep.val.min_inflate + (yyvsp[0].ival);}
#line 2381 "race-class.c"
    break;

  case 60: /* shopkeep_attr: MAX_INSULTS ':' INT_LIT  */
#line 736 "race-class.y"
                                {tmpShopkeep.def.max_insults = TRUE;
                                 tmpShopkeep.val.insult_max = (yyvsp[0].ival);}
#line 2388 "race-class.c"
    break;

  case 61: /* shopkeep_attr: MAX_COST ':' INT_LIT  */
#line 739 "race-class.y"
                                {tmpShopkeep.def.max_cost = TRUE;
                                 tmpShopkeep.val.max_cost = (yyvsp[0].ival);}
#line 2395 "race-class.c"
    break;

  case 62: /* backgrounds_def: BACKGROUNDS '{' backgrounds '}'  */
#line 744 "race-class.y"
                                {tmpRace.def.backgrounds = TRUE;}
#line 2401 "race-class.c"
    break;

  case 64: /* background: BACKGROUND INT_LIT INT_LIT '{' fragments '}'  */
#line 751 "race-class.y"
                                {int i;
                                 for (i=0; i<tmpRace.val.num_backgrounds; i++)
                                   if (!tmpRace.val.backgrounds[i].chart)
                                     {
                                       tmpRace.val.backgrounds[i].chart = 
                                         (yyvsp[-4].ival);
                                       tmpRace.val.backgrounds[i].next = 
                                         (yyvsp[-3].ival);
                                     }
                                 if (arguments.rcc.consistency_check)
                                   CheckBackground((yyvsp[-4].ival), (yyvsp[-3].ival)); }
#line 2417 "race-class.c"
    break;

  case 68: /* fragment: FRAGMENT STRING_LIT '{' frag_attrs '}'  */
#line 772 "race-class.y"
                                {tmpBackground.val.info = strdup((yyvsp[-3].sval));
                                 //FIXME leak
                                 PutBackground(&tmpBackground,
                                               arguments.rcc.consistency_check);
                                 tmpBackground = blankBackground;}
#line 2427 "race-class.c"
    break;

  case 72: /* frag_attr: ROLL ':' INT_LIT  */
#line 787 "race-class.y"
                                {if (arguments.rcc.consistency_check &&
                                     (yyvsp[0].ival) > 100)
                                   yyerror("roll exceeds 100");
                                 tmpBackground.def.roll = TRUE;
                                 tmpBackground.val.roll = (yyvsp[0].ival);}
#line 2437 "race-class.c"
    break;

  case 73: /* frag_attr: SOCIAL_CLASS_BONUS ':' INT_LIT  */
#line 793 "race-class.y"
                                {tmpBackground.def.social_class_bonus = TRUE;
                                 tmpBackground.val.bonus = (yyvsp[0].ival);}
#line 2444 "race-class.c"
    break;

  case 83: /* class_attribute: HIT_POINTS ':' INT_LIT  */
#line 811 "race-class.y"
                                { tmpClass.val.c.adj_hd = (yyvsp[0].ival);
				  tmpClass.def.hit_points = TRUE; }
#line 2451 "race-class.c"
    break;

  case 84: /* class_attribute: DISARMING ':' INT_LIT  */
#line 814 "race-class.y"
                                { tmpClass.val.c.mdis = (yyvsp[0].ival);
				  tmpClass.def.disarming = TRUE; }
#line 2458 "race-class.c"
    break;

  case 85: /* class_attribute: SEARCH_CHANCE ':' INT_LIT  */
#line 817 "race-class.y"
                                { tmpClass.val.c.msrh = (yyvsp[0].ival);
				  tmpClass.def.search_chance = TRUE; }
#line 2465 "race-class.c"
    break;

  case 86: /* class_attribute: STEALTH_FACTOR ':' INT_LIT  */
#line 820 "race-class.y"
                                { tmpClass.val.c.mstl = (yyvsp[0].ival);
				  tmpClass.def.stealth_factor = TRUE; }
#line 2472 "race-class.c"
    break;

  case 87: /* class_attribute: FREQUENCY_OF_SEARCH ':' INT_LIT  */
#line 823 "race-class.y"
                                { tmpClass.val.c.mfos = (yyvsp[0].ival);
				  tmpClass.def.frequency_of_search = TRUE; }
#line 2479 "race-class.c"
    break;

  case 88: /* class_attribute: BASE_TO_HIT ':' INT_LIT  */
#line 826 "race-class.y"
                                { tmpClass.val.c.mbth = (yyvsp[0].ival);
				  tmpClass.def.base_to_hit = TRUE; }
#line 2486 "race-class.c"
    break;

  case 89: /* class_attribute: BASE_TO_HIT_WITH_BOWS ':' INT_LIT  */
#line 829 "race-class.y"
                                { tmpClass.val.c.mbthb = (yyvsp[0].ival);
				  tmpClass.def.base_to_hit_with_bows = TRUE; }
#line 2493 "race-class.c"
    break;

  case 90: /* class_attribute: SAVING_THROW ':' INT_LIT  */
#line 832 "race-class.y"
                                { tmpClass.val.c.msav = (yyvsp[0].ival);
				  tmpClass.def.saving_throw = TRUE; }
#line 2500 "race-class.c"
    break;

  case 91: /* class_attribute: STRENGTH_MODIFIER ':' INT_LIT  */
#line 835 "race-class.y"
                                { tmpClass.val.c.madj_str = (yyvsp[0].ival);
				  tmpClass.def.strength_modifier = TRUE; }
#line 2507 "race-class.c"
    break;

  case 92: /* class_attribute: INTELLIGENCE_MODIFIER ':' INT_LIT  */
#line 838 "race-class.y"
                                { tmpClass.val.c.madj_int = (yyvsp[0].ival);
				  tmpClass.def.intelligence_modifier = TRUE; }
#line 2514 "race-class.c"
    break;

  case 93: /* class_attribute: WISDOM_MODIFIER ':' INT_LIT  */
#line 841 "race-class.y"
                                { tmpClass.val.c.madj_wis = (yyvsp[0].ival);
				  tmpClass.def.wisdom_modifier = TRUE; }
#line 2521 "race-class.c"
    break;

  case 94: /* class_attribute: DEXTERITY_MODIFIER ':' INT_LIT  */
#line 844 "race-class.y"
                                { tmpClass.val.c.madj_dex = (yyvsp[0].ival);
				  tmpClass.def.dexterity_modifier = TRUE; }
#line 2528 "race-class.c"
    break;

  case 95: /* class_attribute: CONSTITUTION_MODIFIER ':' INT_LIT  */
#line 847 "race-class.y"
                                { tmpClass.val.c.madj_con = (yyvsp[0].ival);
				  tmpClass.def.constitution_modifier = TRUE; }
#line 2535 "race-class.c"
    break;

  case 96: /* class_attribute: CHARISMA_MODIFIER ':' INT_LIT  */
#line 850 "race-class.y"
                                { tmpClass.val.c.madj_chr = (yyvsp[0].ival);
				  tmpClass.def.charisma_modifier = TRUE; }
#line 2542 "race-class.c"
    break;

  case 97: /* class_attribute: EXPERIENCE_FACTOR ':' INT_LIT  */
#line 853 "race-class.y"
                                { tmpClass.val.c.m_exp = (yyvsp[0].ival);
				  tmpClass.def.experience_factor = TRUE; }
#line 2549 "race-class.c"
    break;

  case 102: /* adj_attr: ADJUST_BASE_TO_HIT ':' INT_LIT  */
#line 868 "race-class.y"
                                {tmpClass.val.adjust_per_one_third_level[0] =
                                 (yyvsp[0].ival);
                                 tmpClass.def.adjust_base_to_hit = TRUE;}
#line 2557 "race-class.c"
    break;

  case 103: /* adj_attr: ADJUST_BASE_TO_HIT_WITH_BOWS ':' INT_LIT  */
#line 872 "race-class.y"
                                {tmpClass.val.adjust_per_one_third_level[1] =
                                 (yyvsp[0].ival);
                                 tmpClass.def.adjust_base_to_hit_with_bows = TRUE;}
#line 2565 "race-class.c"
    break;

  case 104: /* adj_attr: ADJUST_USE_DEVICE ':' INT_LIT  */
#line 876 "race-class.y"
                                {tmpClass.val.adjust_per_one_third_level[2] =
                                 (yyvsp[0].ival);
                                 tmpClass.def.adjust_use_device = TRUE;}
#line 2573 "race-class.c"
    break;

  case 105: /* adj_attr: ADJUST_DISARMING ':' INT_LIT  */
#line 880 "race-class.y"
                                {tmpClass.val.adjust_per_one_third_level[3] =
                                 (yyvsp[0].ival);
                                 tmpClass.def.adjust_disarming = TRUE;}
#line 2581 "race-class.c"
    break;

  case 106: /* adj_attr: ADJUST_SAVING_THROW ':' INT_LIT  */
#line 884 "race-class.y"
                                {tmpClass.val.adjust_per_one_third_level[4] =
                                 (yyvsp[0].ival);
                                 tmpClass.def.adjust_saving_throw = TRUE;}
#line 2589 "race-class.c"
    break;

  case 107: /* male_titles_def: MALE_TITLES '{' male_titles '}'  */
#line 890 "race-class.y"
                                { /*PutTitles();*/ }
#line 2595 "race-class.c"
    break;

  case 109: /* male_title: STRING_LIT  */
#line 897 "race-class.y"
                                { 
                                 if (arguments.rcc.consistency_check)
                                   {
                                     const char *t = NULL;
                                     char *argz = tmpClass.val.male_titles_argz;
                                     size_t len = tmpClass.val.male_titles_len;
                                     while ((t = argz_next (argz, len, t)))
                                       {
                                         if (strcmp (t, (yyvsp[0].sval)) == 0)
                                           {
                                             char *msg = 
                                               xasprintf ("duplicate title %s",
                                                          (yyvsp[0].sval));
                                             yyerror (msg);
                                           }
                                       }
                                   }

                                 argz_add (&tmpClass.val.male_titles_argz,
                                           &tmpClass.val.male_titles_len, 
                                           (yyvsp[0].sval)); }
#line 2621 "race-class.c"
    break;

  case 112: /* female_titles_def: FEMALE_TITLES '{' female_titles '}'  */
#line 925 "race-class.y"
                                { /*PutTitles();*/ }
#line 2627 "race-class.c"
    break;

  case 114: /* female_title: STRING_LIT  */
#line 932 "race-class.y"
                                { 
                                 if (arguments.rcc.consistency_check)
                                   {
                                     const char *t = NULL;
                                     char *argz = 
                                       tmpClass.val.female_titles_argz;
                                     size_t len = 
                                       tmpClass.val.female_titles_len;
                                     while ((t = argz_next (argz, len, t)))
                                       {
                                         if (strcmp (t, (yyvsp[0].sval)) == 0)
                                           {
                                             char *msg = 
                                               xasprintf ("duplicate title %s",
                                                          (yyvsp[0].sval));
                                             yyerror (msg);
                                           }
                                       }
                                   }

                                 argz_add (&tmpClass.val.female_titles_argz,
                                           &tmpClass.val.female_titles_len, 
                                           (yyvsp[0].sval)); }
#line 2655 "race-class.c"
    break;

  case 121: /* spell: SPELL IDENTIFIER '{' spell_attrs '}'  */
#line 972 "race-class.y"
                                {PutSpell((yyvsp[-3].sval), &tmpSpell,
                                          arguments.rcc.consistency_check);
                                 tmpSpell = blankSpell;}
#line 2663 "race-class.c"
    break;

  case 125: /* spell_attr: LEVEL ':' INT_LIT  */
#line 985 "race-class.y"
                                {tmpSpell.val.s.slevel = (yyvsp[0].ival);
                                 tmpSpell.def.level = TRUE;}
#line 2670 "race-class.c"
    break;

  case 126: /* spell_attr: MANA ':' INT_LIT  */
#line 988 "race-class.y"
                                {tmpSpell.val.s.smana = (yyvsp[0].ival);
                                 tmpSpell.def.mana = TRUE;}
#line 2677 "race-class.c"
    break;

  case 127: /* spell_attr: FAIL ':' INT_LIT  */
#line 991 "race-class.y"
                                {tmpSpell.val.s.sfail = (yyvsp[0].ival);
                                 tmpSpell.def.fail = TRUE;}
#line 2684 "race-class.c"
    break;

  case 128: /* spell_attr: EXP ':' INT_LIT  */
#line 994 "race-class.y"
                                {tmpSpell.val.s.sexp = (yyvsp[0].ival);
                                 tmpSpell.def.exp = TRUE;}
#line 2691 "race-class.c"
    break;

  case 133: /* prayer: PRAYER IDENTIFIER '{' prayer_attrs '}'  */
#line 1009 "race-class.y"
                                {PutPrayer((yyvsp[-3].sval), &tmpPrayer,
                                           arguments.rcc.consistency_check);
                                 tmpPrayer = blankPrayer;}
#line 2699 "race-class.c"
    break;

  case 137: /* prayer_attr: LEVEL ':' INT_LIT  */
#line 1022 "race-class.y"
                                {tmpPrayer.val.s.slevel = (yyvsp[0].ival);
                                 tmpPrayer.def.level = TRUE;}
#line 2706 "race-class.c"
    break;

  case 138: /* prayer_attr: MANA ':' INT_LIT  */
#line 1025 "race-class.y"
                                {tmpPrayer.val.s.smana = (yyvsp[0].ival);
                                 tmpPrayer.def.mana = TRUE;}
#line 2713 "race-class.c"
    break;

  case 139: /* prayer_attr: FAIL ':' INT_LIT  */
#line 1028 "race-class.y"
                                {tmpPrayer.val.s.sfail = (yyvsp[0].ival);
                                 tmpPrayer.def.fail = TRUE;}
#line 2720 "race-class.c"
    break;

  case 140: /* prayer_attr: EXP ':' INT_LIT  */
#line 1031 "race-class.y"
                                {tmpPrayer.val.s.sexp = (yyvsp[0].ival);
                                 tmpPrayer.def.exp = TRUE;}
#line 2727 "race-class.c"
    break;

  case 143: /* exp_level: INT_LIT  */
#line 1042 "race-class.y"
                                { 
                                  int lvl = num_experience_levels;
                                  if (lvl > 0 &&
                                      experience_levels[lvl-1] > (yyvsp[0].ival) &&
                                      arguments.rcc.consistency_check)
                                    yyerror (xasprintf("%s %d is too small",
                                                       "experience level",
                                                       (yyvsp[0].ival)));
                                  else
                                    {
                                      num_experience_levels++;
                                      lvl++;
                                      experience_levels =
                                        realloc (experience_levels, lvl * 
                                                   sizeof (int));
                                      experience_levels[lvl-1] = (yyvsp[0].ival);
                                    }
                                }
#line 2750 "race-class.c"
    break;

  case 150: /* spell_name: IDENTIFIER ':' STRING_LIT ';'  */
#line 1077 "race-class.y"
                         { PutSpellName ((yyvsp[-2].sval), (yyvsp[-1].sval),
                                         arguments.rcc.consistency_check);
                         }
#line 2758 "race-class.c"
    break;

  case 155: /* prayer_name: IDENTIFIER ':' STRING_LIT ';'  */
#line 1093 "race-class.y"
                         { PutPrayerName ((yyvsp[-2].sval), (yyvsp[-1].sval),
                                         arguments.rcc.consistency_check);
                         }
#line 2766 "race-class.c"
    break;


#line 2770 "race-class.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 1097 "race-class.y"




/*
 * MyFGetC--
 *	fgetc with support for comments
 *
 *	# is the comment character.  comment lasts till end of line.
 * Spews out an extra char of whitespace at EOF since something seems to
 * need it.  I'll figure this out eventually...
 */
static int 
MyFGetC (FILE *input_F)
{
  while (!*inputBufp || (*inputBufp == '#')) 
    {
      (void) fgets (inputBuf, INPUT_BUF_SIZE, input_F);
      if (feof (input_F))
	return EOF;
      lineNo++;
      inputBufp = inputBuf;
    }
  return *inputBufp++;
}



/*
 * Advance--
 *	Advance to the next token in the input stream and set tokStr,
 * tokType.
 *
 *	On error, tokType is set to a negative value.
 */
static void 
Advance (FILE *input_F)
{
  register char *tok = tokStr;	/* accumulating token string		    */
  register int len = 0;		/* length of current token		    */
  static int c = 32;		/* current character; ' ' is harmless init  */


  /*
   * Skip whitespace in the stream
   */
  while ((c != EOF) && isspace (c))
    c = MyFGetC (input_F);

  /*
   * At end of file?
   */
  if (c == EOF) 
    {
      tokType = EOF;
      strcpy (tokStr, "[EOF]");
      return;
    }

  /*
   * Recognize a number [+|-][dddd][.][dddd][{e|E}[+|-]dddd]
   */
  if (isdigit (c) || (c == '.') || (c == '+') || (c == '-')) 
    {
      register int decPt = FALSE,   /* seen a decimal point yet?	*/
	       hasExp = FALSE;	    /* has an exponent?			*/

      if ((c == '-') || (c == '+')) 
	{
	  *tok++ = c;
	  c = MyFGetC (input_F);
	}

      while ((len < MAX_TOK_LEN - 1) && (isdigit (c) || (c == '.'))) 
	{
	  if (c == '.') 
	    {
	      if (decPt)
		break;
	      else
		decPt = TRUE;
	    }

	  *tok++ = c;
	  c = MyFGetC (input_F);
	  len++;
	}

      if ((c == 'e') || (c == 'E')) 
	{
	  hasExp = TRUE;
	  *tok++ = c;
	  c = MyFGetC (input_F);
	  len++;

	  if ((c == '-') || (c == '+')) 
	    {
	      *tok++ = c;
	      c = MyFGetC (input_F);
	      len++;
	    }

	  while ((len < MAX_TOK_LEN - 1) && isdigit (c)) 
	    {
	      *tok++ = c;
	      c = MyFGetC (input_F);
	      len++;
	    }
	}

      *tok = 0;

      if (decPt || hasExp) 
	{
	  tokType = FLOAT_LIT;
	  yylval.dval = atof (tokStr);
	} 
      else 
	{
	  tokType = INT_LIT;
	  yylval.ival = atoi (tokStr);
	}

      return;

    }

  /*
   * Recognize a quoted string
   */
  if (c == '\"') 
    {

      c = MyFGetC (input_F);

      while ((len < MAX_TOK_LEN - 1) &&
	     (c != EOF) && (c != '\n') && (c != '\"')) 
	{
	  *tok++ = c;
	  c = MyFGetC (input_F);
	}

      *tok = 0;

      c = MyFGetC (input_F);

      tokType = STRING_LIT;
      strncpy (yylval.sval, tokStr, MAX_TOK_LEN - 1);
      yylval.sval[MAX_TOK_LEN - 1] = 0;

      return;

    }

  /*
   * Recognize an identifier and try to match it with a keyword.
   * Identifiers begin with a letter and continue in letters and/or
   * digits.  Convert it to lowercase.
   */
  if (isalpha (c) || (c == '_') || (c == '$')) {

    if (isupper (c))
      c = tolower (c);
    *tok++ = c;
    c = MyFGetC (input_F);
    len++;

    while ((len < MAX_TOK_LEN - 1) && (isalpha (c) || isdigit (c) ||
				       (c == '_') || (c == '$'))) 
      {
	if (isupper (c))
	  c = tolower (c);
	*tok++ = c;
	c = MyFGetC (input_F);
	len++;
      }

    *tok = 0;

    /*
     * We've got the identifier; see if it matches any keywords.
     */

      {
	generic_t gval;
	int type;
	if (St_GetSym (keywordT_P, tokStr, &type, &gval) == ST_SYM_FOUND) 
	  {
	    tokType = gval.i;
	    strncpy (yylval.sval, tokStr, MAX_TOK_LEN - 1);
	    yylval.sval[MAX_TOK_LEN - 1] = 0;
	  } 
	else if (!strcmp (tokStr, "true")) 
	  {
	    tokType = BOOL_LIT;
	    yylval.ival = 1;
	  } 
	else if (!strcmp (tokStr, "false")) 
	  {
	    tokType = BOOL_LIT;
	    yylval.ival = 0;
	  } 
	else 
	  {
	    tokType = IDENTIFIER;
	    strncpy (yylval.sval, tokStr, MAX_TOK_LEN - 1);
	    yylval.sval[MAX_TOK_LEN - 1] = 0;
	  }
      }

    return;

  }

  /*
   * Recognize punctuation
   */

  tokType = c;
  *tok++ = c;
  *tok = 0;
  c = MyFGetC (input_F);
  return;
}

void 
ErrMsgLineNo (char *s, int line_no)
{
  if (line_no >= 0)
    fprintf (stderr, "Error: %s at line %d\n", s, line_no);
  else
    fprintf (stderr, "Error: %s\n", s);
}

void 
ErrMsg (char *s)
{
  int i;

  fprintf (stderr, "Error: %s at line %d\n", s, lineNo);
  fprintf (stderr, "%s", inputBuf);
  for (i = 0; i < inputBufp - inputBuf; i++) 
    {
      fputc ((inputBuf[i] == '\t' ? '\t' : ' '), stderr);
    }
  fprintf (stderr, "^ before here\n\n");
  return;
}

int 
yyerror (char *s)
{
  ErrMsg (s);
  return 0;
}


int 
yylex ()
{
  Advance (input_F);
  return tokType;
}

st_Table_Pt 
InitTable (char *name, symInit_t *init)
{
  int i;
  st_Table_Pt table_P;
  generic_t gval;

  table_P = St_NewTable (name, 20);
  for (i = 0; init[i].name; i++) 
    {
      gval.i = init[i].val;
      St_DefSym (table_P, init[i].name, GEN_TYPE_INT, gval);
    }

  return table_P;
}

void 
InitTables ()
{
  keywordT_P = InitTable ("keyword", keywordInit);
  spellsT_P = InitTable ("spells", spellsInit);
  prayersT_P = InitTable ("prayers", prayersInit);

  raceT_P = St_NewTable ("race", 200);
  classT_P = St_NewTable ("class", 40);

  return;
}

void 
NotDefined(char *name, char *s)
{
  fprintf (stderr, 
	   "Warning: %s not defined for \"%s\", line %d\n",
	   s, name, lineNo);
  return;
}

void 
PutRace (char *s, race_template_t *tmpl_P, int consistency_check)
{
  generic_t gval;

  gval.v = malloc (sizeof(race_template_t));
  *(race_template_t *) gval.v = *tmpl_P;

  if (!tmpl_P->def.age)
    NotDefined (tmpl_P->val.r.trace, "AGE");
  if (!tmpl_P->def.infra_vision)
    NotDefined (tmpl_P->val.r.trace, "INFRA_VISION");
  if (!tmpl_P->def.male_height)
    NotDefined (tmpl_P->val.r.trace, "MALE_HEIGHT");
  if (!tmpl_P->def.male_weight)
    NotDefined (tmpl_P->val.r.trace, "MALE_WEIGHT");
  if (!tmpl_P->def.female_height)
    NotDefined (tmpl_P->val.r.trace, "FEMALE_HEIGHT");
  if (!tmpl_P->def.female_weight)
    NotDefined (tmpl_P->val.r.trace, "FEMALE_WEIGHT");
  if (!tmpl_P->def.hit_points)
    NotDefined (tmpl_P->val.r.trace, "HIT_POINTS");
  if (!tmpl_P->def.disarming)
    NotDefined (tmpl_P->val.r.trace, "DISARMING");
  if (!tmpl_P->def.search_chance)
    NotDefined (tmpl_P->val.r.trace, "SEARCH_CHANCE");
  if (!tmpl_P->def.stealth_factor)
    NotDefined (tmpl_P->val.r.trace, "STEALTH_FACTOR");
  if (!tmpl_P->def.frequency_of_search)
    NotDefined (tmpl_P->val.r.trace, "FREQUENCY_OF_SEARCH");
  if (!tmpl_P->def.base_to_hit)
    NotDefined (tmpl_P->val.r.trace, "BASE_TO_HIT");
  if (!tmpl_P->def.base_to_hit_with_bows)
    NotDefined (tmpl_P->val.r.trace, "BASE_TO_HIT_WITH_BOWS");
  if (!tmpl_P->def.saving_throw)
    NotDefined (tmpl_P->val.r.trace, "SAVING_THROW");
  if (!tmpl_P->def.strength_modifier)
    NotDefined (tmpl_P->val.r.trace, "STRENGTH_MODIFIER");
  if (!tmpl_P->def.intelligence_modifier)
    NotDefined (tmpl_P->val.r.trace, "INTELLIGENCE_MODIFIER");
  if (!tmpl_P->def.wisdom_modifier)
    NotDefined (tmpl_P->val.r.trace, "WISDOM_MODIFIER");
  if (!tmpl_P->def.dexterity_modifier)
    NotDefined (tmpl_P->val.r.trace, "DEXTERITY_MODIFIER");
  if (!tmpl_P->def.constitution_modifier)
    NotDefined (tmpl_P->val.r.trace, "CONSTITUTION_MODIFIER");
  if (!tmpl_P->def.charisma_modifier)
    NotDefined (tmpl_P->val.r.trace, "CHARISMA_MODIFIER");
  if (!tmpl_P->def.experience_factor)
    NotDefined (tmpl_P->val.r.trace, "EXPERIENCE_FACTOR");
  if (!tmpl_P->def.classes)
    NotDefined (tmpl_P->val.r.trace, "CLASSES");
  if (!tmpl_P->def.store_price_adjust_by_race)
    NotDefined (tmpl_P->val.r.trace, "STORE_PRICE_ADJUST_BY_RACE");
  if (!tmpl_P->def.shopkeep)
    ;//NotDefined (tmpl_P->val.r.trace, ""); it's okay if we don't have one.
  if (!tmpl_P->def.backgrounds)
    NotDefined (tmpl_P->val.r.trace, "BACKGROUNDS");

  if (consistency_check)
    ;//ConsistencyCheckRace (&tmpl_P->val, &tmpl_P->state);

  if (St_DefSym (raceT_P, s, GEN_TYPE_TMPL, gval) == ST_SYM_FOUND) 
    {
      fprintf (arguments.rcc.outfile, "Warning: redefining \"%s\", line %d\n", 
               tmpl_P->val.r.trace, lineNo);
    }

  return;
}

void PutShopkeep(shopkeep_template_t *tmpl_P, int consistency_check)
{
  char *id = "shopkeep";
  if (!tmpl_P->def.store)
    NotDefined (id, "STORE");
  if (!tmpl_P->def.haggle_per)
    NotDefined (id, "HAGGLE_PER");
  if (!tmpl_P->def.inflate)
    NotDefined (id, "INFLATE");
  if (!tmpl_P->def.max_insults)
    NotDefined (id, "MAX_INSULTS");
  if (!tmpl_P->def.max_cost)
    NotDefined (id, "MAX_COST");
  if (consistency_check)
    {
      if (tmpl_P->val.insult_max == 0)
        yyerror ("max_insults can't be zero");
      if (tmpl_P->val.max_cost == 0)
        yyerror ("max_cost can't be zero");
    }
  tmpRace.val.num_shopkeeps++;
  tmpRace.val.shopkeeps = realloc(tmpRace.val.shopkeeps, 
                                  tmpRace.val.num_shopkeeps * 
                                    sizeof(owner_type));
  tmpRace.val.shopkeeps[tmpRace.val.num_shopkeeps-1] = tmpl_P->val;
}

void PutBackground(background_template_t *tmpl_P, int consistency_check)
{
  if (!tmpl_P->def.roll)
    NotDefined("fragment", "ROLL");
  if (!tmpl_P->def.social_class_bonus)
    NotDefined("fragment", "SOCIAL_CLASS_BONUS");
  tmpRace.val.num_backgrounds++;
  int num = tmpRace.val.num_backgrounds;
  tmpRace.val.backgrounds = realloc (tmpRace.val.backgrounds, 
                                     num * sizeof (background_type));
  tmpRace.val.backgrounds[num-1] = tmpBackground.val;
}

void CheckSpell (spell_type *s)
{
  if (s->slevel == 0)
    yyerror ("level can't be zero");
  if (s->smana == 0)
    yyerror ("mana can't be zero");
  if (s->sfail >= 100)
    yyerror ("fail can't be 100 or more");
}

void
PutSpell (char *s, spell_template_t *tmpl_P, int consistency_check)
{
  generic_t gval;
  int type;
  if (St_GetSym (spellsT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      yyerror (xasprintf("unknown spell `%s'", s));
      return;
    }
  tmpl_P->val.idx = gval.i;
  tmpl_P->val.line_no = lineNo;

  int i;
  for (i = 0; i < tmpClass.val.num_spells; i++)
    {
      if (tmpClass.val.spells[i].idx == tmpl_P->val.idx)
        {
          yyerror (xasprintf ("duplicate spell %s", s));
          return;
        }
    }
  char *id = xasprintf ("spell %s", s);
  if (!tmpl_P->def.level)
    NotDefined(id, "LEVEL");
  if (!tmpl_P->def.mana)
    NotDefined(id, "MANA");
  if (!tmpl_P->def.fail)
    NotDefined(id, "FAIL");
  if (!tmpl_P->def.exp)
    NotDefined(id, "EXP");
  if (consistency_check)
    CheckSpell (&tmpl_P->val.s);
  tmpClass.val.num_spells++;
  int num = tmpClass.val.num_spells;
  tmpClass.val.spells = realloc (tmpClass.val.spells,  
                                 num * sizeof(spell_t));
  tmpClass.val.spells[num-1] = tmpl_P->val;
  free (id);
}

int
name_block_contains_type (struct name_block_t *names, int num_names, int type)
{
  int i;
  for (i = 0; i < num_names; i++)
    {
      if (names[i].val == type)
        return 1;
    }
  return 0;
}

int
CheckSpellName (char *token, char *name, int type)
{
  if (name_block_contains_type (spell_names, num_spells_named, type))
    {
      yyerror (xasprintf("spell `%s' appears more than once in spell_names", token));
      return 1;
    }
  return 0;
}

void
PutSpellName (char *s, char *name, int consistency_check)
{
  //check if token is a spell name.
  generic_t gval;
  int type;
  if (St_GetSym (spellsT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      yyerror (xasprintf("unknown spell `%s'", s));
      return;
    }
  if (consistency_check)
    {
       if (CheckSpellName(s, name, gval.i))
         return;
    }
  num_spells_named++;
  spell_names = realloc (spell_names, num_spells_named * sizeof (struct name_block_t));
  spell_names[num_spells_named-1].name = strdup (name);
  spell_names[num_spells_named-1].val = gval.i;
}

int
CheckPrayerName (char *token, char *name, int type)
{
  if (name_block_contains_type (prayer_names, num_prayers_named, type))
    {
      yyerror (xasprintf("prayer `%s' appears more than once in prayer_names", token));
      return 1;
    }
  return 0;
}

void
PutPrayerName (char *s, char *name, int consistency_check)
{
  //check if token is a prayer name.
  generic_t gval;
  int type;
  if (St_GetSym (prayersT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      yyerror (xasprintf("unknown prayer `%s'", s));
      return;
    }
  if (consistency_check)
    {
       if (CheckPrayerName(s, name, gval.i))
         return;
    }
  num_prayers_named++;
  prayer_names = realloc (prayer_names, num_prayers_named * sizeof (struct name_block_t));
  prayer_names[num_prayers_named-1].name = strdup (name);
  prayer_names[num_prayers_named-1].val = gval.i;
}


void
PutPrayer (char *s, spell_template_t *tmpl_P, int consistency_check)
{
  generic_t gval;
  int type;
  if (St_GetSym (prayersT_P, s, &type, &gval) != ST_SYM_FOUND) 
    {
      yyerror (xasprintf("unknown prayer `%s'", s));
      return;
    }
  tmpl_P->val.idx = gval.i;
  tmpl_P->val.line_no = lineNo;
  int i;
  for (i = 0; i < tmpClass.val.num_prayers; i++)
    {
      if (tmpClass.val.prayers[i].idx == tmpl_P->val.idx)
        {
          yyerror (xasprintf ("duplicate prayer %s", s));
          return;
        }
    }
  char *id = xasprintf ("prayer %s", s);
  if (!tmpl_P->def.level)
    NotDefined(id, "LEVEL");
  if (!tmpl_P->def.mana)
    NotDefined(id, "MANA");
  if (!tmpl_P->def.fail)
    NotDefined(id, "FAIL");
  if (!tmpl_P->def.exp)
    NotDefined(id, "EXP");
  if (consistency_check)
    CheckSpell (&tmpl_P->val.s);
  tmpClass.val.num_prayers++;
  int num = tmpClass.val.num_prayers;
  tmpClass.val.prayers = realloc (tmpClass.val.prayers,  
                                 num * sizeof(spell_t));
  tmpClass.val.prayers[num-1] = tmpl_P->val;
  free (id);
}

int compare_ints (const void *i1, const void *i2)
{
  int num1 = *(int*)i1;
  int num2 = *(int*)i2;
  return num1 - num2;
}

void CheckBackground (int chart, int next)
{
  //check to see if the background has no dup rolls, and a roll of 100.
  int i;
  int rolls[tmpRace.val.num_backgrounds];
  int num_rolls = 0;
  if (chart == 0)
    yyerror ("invalid background id of 0");
  if (chart == next)
    yyerror ("next background id can't point to this background");
  memset (rolls, 0, sizeof (rolls));
  for (i = 0; i < tmpRace.val.num_backgrounds; i++)
    {
      if (tmpRace.val.backgrounds[i].chart != chart)
        continue;
      if (tmpRace.val.backgrounds[i].next != next)
        { 
          yyerror ("background has duplicate id or points " 
                   "to wrong next background");
          return;
        }
      rolls[num_rolls] = tmpRace.val.backgrounds[i].roll;
      num_rolls++;
    }
  qsort (rolls, num_rolls, sizeof (int), compare_ints);
  for (i = 0; i < num_rolls; i++)
    {
      if (rolls[i] == rolls[i-1])
        {
          yyerror (xasprintf ("duplicate roll value of %d", rolls[i]));
          return;
        }
    }
  if (num_rolls)
    {
      if (rolls[num_rolls-1] != 100)
        {
          yyerror ("background needs fragment with roll of 100");
          return;
        }
      if (rolls[0] == 0)
        {
          yyerror ("background has fragment with roll of 0");
          return;
        }
    }
}

void WriteGenerationNotice()
{
  fprintf (arguments.rcc.outfile,
	   "/* The following was generated by the %s race & class compiler \n"
           "   (%s-rcc %s) on %s. \n", 
           PACKAGE_NAME, GAME_NAME, VERSION, __DATE__);
  fprintf (arguments.rcc.outfile,"\n\
   Copyright (c) 1989-94 James E. Wilson, Robert A. Koeneke\n\
   This program is free software; you can redistribute it and/or modify\n\
   it under the terms of the GNU General Public License as published by\n\
   the Free Software Foundation; either version 3 of the License, or\n\
   (at your option) any later version.\n\
   \n\
   This program is distributed in the hope that it will be useful,\n\
   but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
   GNU Library General Public License for more details.\n\
   \n\
   You should have received a copy of the GNU General Public License\n\
   along with this program; if not, write to the Free Software\n\
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n");
  fprintf (arguments.rcc.outfile,
	   "*/\n\n");
  return;
}

void 
PutClass (char *s, class_template_t *tmpl_P, int consistency_check)
{
  generic_t gval;

  gval.v = malloc (sizeof(class_template_t));
  *(class_template_t *) gval.v = *tmpl_P;

  if (!tmpl_P->def.hit_points)
    NotDefined (tmpl_P->val.c.title, "HIT_POINTS");
  if (!tmpl_P->def.disarming)
    NotDefined (tmpl_P->val.c.title, "DISARMING");
  if (!tmpl_P->def.search_chance)
    NotDefined (tmpl_P->val.c.title, "SEARCH_CHANCE");
  if (!tmpl_P->def.stealth_factor)
    NotDefined (tmpl_P->val.c.title, "STEALTH_FACTOR");
  if (!tmpl_P->def.frequency_of_search)
    NotDefined (tmpl_P->val.c.title, "FREQUENCY_OF_SEARCH");
  if (!tmpl_P->def.base_to_hit)
    NotDefined (tmpl_P->val.c.title, "BASE_TO_HIT");
  if (!tmpl_P->def.base_to_hit_with_bows)
    NotDefined (tmpl_P->val.c.title, "BASE_TO_HIT_WITH_BOWS");
  if (!tmpl_P->def.saving_throw)
    NotDefined (tmpl_P->val.c.title, "SAVING_THROW");
  if (!tmpl_P->def.strength_modifier)
    NotDefined (tmpl_P->val.c.title, "STRENGTH_MODIFIER");
  if (!tmpl_P->def.intelligence_modifier)
    NotDefined (tmpl_P->val.c.title, "INTELLIGENCE_MODIFIER");
  if (!tmpl_P->def.wisdom_modifier)
    NotDefined (tmpl_P->val.c.title, "WISDOM_MODIFIER");
  if (!tmpl_P->def.dexterity_modifier)
    NotDefined (tmpl_P->val.c.title, "DEXTERITY_MODIFIER");
  if (!tmpl_P->def.constitution_modifier)
    NotDefined (tmpl_P->val.c.title, "CONSTITUTION_MODIFIER");
  if (!tmpl_P->def.charisma_modifier)
    NotDefined (tmpl_P->val.c.title, "CHARISMA_MODIFIER");
  if (!tmpl_P->def.experience_factor)
    NotDefined (tmpl_P->val.c.title, "EXPERIENCE_FACTOR");
  if (!tmpl_P->def.adjust_base_to_hit)
    NotDefined (tmpl_P->val.c.title, "ADJUST_BASE_TO_HIT");
  if (!tmpl_P->def.adjust_base_to_hit_with_bows)
    NotDefined (tmpl_P->val.c.title, "ADJUST_BASE_TO_HIT_WITH_BOWS");
  if (!tmpl_P->def.adjust_use_device)
    NotDefined (tmpl_P->val.c.title, "ADJUST_USE_DEVICE");
  if (!tmpl_P->def.adjust_disarming)
    NotDefined (tmpl_P->val.c.title, "ADJUST_DISARMING");
  if (!tmpl_P->def.adjust_saving_throw)
    NotDefined (tmpl_P->val.c.title, "ADJUST_SAVING_THROW");

  if (St_DefSym (classT_P, s, GEN_TYPE_TMPL, gval) == ST_SYM_FOUND) 
    {
      fprintf (arguments.rcc.outfile, "Warning: redefining \"%s\", line %d\n", 
               tmpl_P->val.c.title, lineNo);
    }

  return;
}

race_template_t* get_race(char *race)
{
  race_template_t *r;
  generic_t gval;
  int type;
  if (St_GetSym (raceT_P, race, &type, &gval) != ST_SYM_FOUND) 
    return NULL;
  r = (race_template_t*) gval.v;
  return r;
}

char *get_race_for_idx(int idx)
{
  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  St_SArgzTable (raceT_P, &argz, &argz_len);
  race_template_t *r;
  generic_t gval;
  int type;
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (raceT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        continue;
      r = (race_template_t*) gval.v;
      if (r->idx == idx)
        return r->val.r.trace;
    }
  return NULL;
}


void 
WriteConstants ()
{
  fprintf (arguments.rcc.outfile, "#ifndef RACE_CLASS_CONSTANT_H\n");
  fprintf (arguments.rcc.outfile, "#define RACE_CLASS_CONSTANT_H\n");

  fprintf (arguments.rcc.outfile, "#define MAX_PLAYER_LEVEL %3d    %s\n", 
           num_experience_levels, 
           "/* Maximum possible character level      */");
  if (num_experience_levels > 0)
    fprintf (arguments.rcc.outfile, "#define MAX_EXP  %10dL    %s\n", 
             experience_levels[num_experience_levels-1]-1,
             "/* Maximum amount of experience -CJS- */");
  else
    fprintf (arguments.rcc.outfile, "#define MAX_EXP   %10d    %s\n", 0,
             "/* Maximum amount of experience -CJS- */");
  fprintf (arguments.rcc.outfile, "#define MAX_RACES      %5d    %s\n", 
           St_TableSize(raceT_P),
           "/* Number of defined races               */");
  fprintf (arguments.rcc.outfile, "#define MAX_CLASS      %5d    %s\n", 
           St_TableSize(classT_P),
           "/* Number of defined classes             */");

  int num_backgrounds = 0;
  int i;
  int num_races = St_TableSize(raceT_P);
  for (i = 0; i < num_races; i++)
    {
      char *race = get_race_for_idx(i);
      if (!race)
        continue;
      race_template_t *r = get_race(race);
      num_backgrounds += r->val.num_backgrounds;
    }
  fprintf (arguments.rcc.outfile, "#define MAX_BACKGROUND   %3d    %s\n",
           num_backgrounds, "/* Number of types of histories for univ */");
  fprintf (arguments.rcc.outfile, "#define MAX_OWNERS     %5d    %s\n", 
           num_shopkeeps, "/* Number of owners to choose from       */");
  fprintf (arguments.rcc.outfile, "#endif\n");
}

void CheckRace (race_template_t *race)
{
  int i;
  for (i = 0; i < race->val.num_price_adjust; i++)
    {
      generic_t gval;
      int type;
      if (St_GetSym (raceT_P, race->val.price_adjust[i].race, 
                     &type, &gval) != ST_SYM_FOUND) 
        {
          ErrMsgLineNo (xasprintf("unknown race `%s'", 
                                   race->val.price_adjust[i].race), 
                        race->line_no_for_price_adjust);
        }
    }
  if (race->val.num_price_adjust != St_TableSize(raceT_P))
    {
      ErrMsgLineNo ("missing races in store price adjust block", 
                    race->line_no_for_price_adjust);
    }
  
  char *entry = NULL;
  while ((entry = argz_next (race->val.classes_argz, race->val.classes_len, 
                             entry)))
    {
      generic_t gval;
      int type;
      if (St_GetSym (classT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        {
          ErrMsgLineNo (xasprintf("unknown class `%s'", entry), 
                        race->line_no_for_classes);
        }
    }
}

int check_background_chart (int chart, background_type *b, int num, int *depth)
{
  //recursively check the chart until we get zero, or loop too many times.
  //or we don't find a chart.
  int i;
  int found = 0;
  int next = -1;
  for (i = 0; i < num; i++)
    {
      if (b[i].chart == chart)
        {
          next = b[i].next;
          found = 1;
        }
    }
  if (!found)
    return -1;
  *depth  = *depth + 1;
  if (*depth > num)
    return -2;
  for (i = 0; i < num; i++)
    {
      if (b[i].chart == next)
        {
          found = 1;
          break;
        }
    }
  if (!found)
    return -3;
  else if (next == 0)
    return 0;
  else
    return check_background_chart (next, b, num, depth);
}

int is_starting_chart(int chart)
{
  int i;
  int num_races = St_TableSize(raceT_P);
  for (i = 0; i < num_races; i++)
    {
      char *race = get_race_for_idx(i);
      if (!race)
        continue;
      race_template_t *r = get_race(race);
      if (r->val.num_backgrounds && r->val.backgrounds[0].chart == chart)
        return 1;
    }
  return 0;
}

void CheckRaces()
{
  char *argz = NULL;
  size_t argz_len = 0;;
  char *entry = NULL;
  int type;
  int num_races = St_TableSize(raceT_P);
  if (num_races == 0)
    {
      ErrMsgLineNo("no race blocks found", -1);
      return;
    }
  generic_t gval;
  St_SArgzTable (raceT_P, &argz, &argz_len);
  race_template_t *r;
  int num_backgrounds = 0;
  int starting_chart[num_races];
  int race_count = 0;
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (raceT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        {
          fprintf (stderr, "internal err. in CheckRaces\n");
          exit (1);
        }
      r = (race_template_t *) gval.v;
      CheckRace(r);
      num_backgrounds += r->val.num_backgrounds;
      starting_chart[race_count] = r->val.backgrounds[0].chart;
      race_count++;
    }

  //collect the backgrounds into a single array
  entry = NULL;
  if (num_backgrounds)
    {
      int count = 0;
      int i;
      background_type backgrounds[num_backgrounds];
      while ((entry = argz_next (argz, argz_len, entry)))
        {
          if (St_GetSym (raceT_P, entry, &type, &gval) != ST_SYM_FOUND) 
            continue;
          r = (race_template_t *) gval.v;
          for (i = 0; i < r->val.num_backgrounds; i++)
            {
              backgrounds[count] = r->val.backgrounds[i];
              count++;
            }
        }
      for (i = 0; i < num_races; i++)
        {
          int depth = 0;
          int chart = starting_chart[i];
          if (check_background_chart(chart, backgrounds, num_backgrounds, &depth))
            ErrMsgLineNo (xasprintf ("background %d isn't complete, or loops infinitely", chart), -1);
        }

      int j;
      //every next needs a chart except for 0.
      for (i = 0; i < num_backgrounds; i++)
        {
          if (backgrounds[i].next == 0)
            continue;
          int found = 0;
          for (j = 0; j < num_backgrounds; j++)
            {
              if (backgrounds[j].chart == backgrounds[i].next)
                {
                  found = 1;
                  break;
                }
            }
          if (!found)
            {
              ErrMsgLineNo(xasprintf("background %d points to non-existent next", backgrounds[i].chart), -1);
              break;
            }
        }
        //each chart needs a next that points to it except for starting ones.
      for (i = 0; i < num_backgrounds; i++)
        {
          if (is_starting_chart(backgrounds[i].chart))
            continue;
          int found = 0;
          for (j = 0; j < num_backgrounds; j++)
            {
              if (backgrounds[j].next == backgrounds[i].chart)
                {
                  found = 1;
                  break;
                }
            }
          if (!found)
            {
              ErrMsgLineNo(xasprintf("background %d doesn't have another background pointing to it", backgrounds[i].chart), -1);
              break;
            }
        }
    }

  int shopkeeps[MAX_STORES];
  memset (shopkeeps, 0, sizeof (shopkeeps));
//check for one shopkeep for every pstore.
  entry = NULL;
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      int i;
      if (St_GetSym (raceT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        continue;
      r = (race_template_t *) gval.v;
      for (i = 0; i < r->val.num_shopkeeps; i++)
        shopkeeps[r->val.shopkeeps[i].pstore]++;
    }
  int j;
  for (j = 0; j < MAX_STORES; j++)
    if (shopkeeps[j] == 0)
      ErrMsgLineNo (xasprintf ("store '%c' doesn't have any shopkeeps", 
                               j + '1'), -1);
}

void CheckClass(class_template_t *c)
{
  if (c->val.num_spells && c->val.num_prayers)
    {
      ErrMsgLineNo(xasprintf("Class `%s' can't have both spells and prayers", c->val.c.title), -1);
    }
  int i;
  int max_levels = num_experience_levels;
  for (i = 0; i < c->val.num_spells; i++)
    {
      if (c->val.spells[i].s.slevel > max_levels)
        ErrMsgLineNo(xasprintf("spell has level exceeding %d", max_levels), c->val.spells[i].line_no);
    }
  for (i = 0; i < c->val.num_prayers; i++)
    {
      if (c->val.prayers[i].s.slevel > max_levels)
        ErrMsgLineNo(xasprintf("prayer has level exceeding %d", max_levels), c->val.prayers[i].line_no);
    }
  if (num_experience_levels != 
      argz_count (c->val.male_titles_argz, c->val.male_titles_len))
    {
      ErrMsgLineNo(xasprintf("%d titles given for `%s' but need %d",
                             argz_count(c->val.male_titles_argz, 
                                        c->val.male_titles_len),
                             c->val.c.title, max_levels), -1);
    }

    //is this class referenced by a race?
    int found = 0;
    int num_races = St_TableSize(raceT_P);
    for (i = 0; i < num_races; i++)
      {
        char *race = get_race_for_idx(i);
        if (!race)
          continue;
        race_template_t *r = get_race(race);
        char *argz = r->val.classes_argz;
        size_t len = r->val.classes_len;
        char *cl = NULL;
        while ((cl = argz_next (argz, len, cl)))
          {
            if (strcmp (cl, c->val.c.title) == 0)
              {
                found = 1;
                break;
              }
          }
        if (found)
          break;
      }
      if (!found)
        ErrMsgLineNo(xasprintf("class `%s' is not referenced by any race's "
                               "classes block.", c->val.c.title), -1);
}

void CheckClasses()
{
  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  int type;
  generic_t gval;
  St_SArgzTable (classT_P, &argz, &argz_len);
  class_template_t *c;
  int num_classes = St_TableSize(classT_P);
  if (num_classes == 0)
    {
      ErrMsgLineNo("no class blocks found", -1);
      return;
    }
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (classT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        {
          fprintf (stderr, "internal err. in CheckClasses\n");
          exit (1);
        }
      c = (class_template_t *) gval.v;
      CheckClass(c);
    }
}
      
void CheckNames()
{
  int i = 0;
  while (spellsInit[i].name != NULL)
  {
    if (!name_block_contains_type (spell_names, num_spells_named, 
                                   spellsInit[i].val))
      {
        yyerror (xasprintf ("spell %s lacks a name in spell_names", spellsInit[i].name));
      }
    i++;
  }
  i = 0;
  while (prayersInit[i].name != NULL)
  {
    if (!name_block_contains_type (prayer_names, num_prayers_named, 
                                   prayersInit[i].val))
      {
        yyerror (xasprintf ("prayer %s lacks a name in prayer_names", prayersInit[i].name));
      }
    i++;
  }
}

void WriteExperienceTable()
{
  int i;
  fprintf (arguments.rcc.outfile, "/* Base experience levels, may be adjusted"
                                  " up for race and/or class*/\n");
  fprintf (arguments.rcc.outfile, "int32u player_exp[MAX_PLAYER_LEVEL] = {");
  for (i = 0; i < num_experience_levels; i++)
    {
      if (i % 8 == 0)
        fprintf (arguments.rcc.outfile, "\n  ");
      else
        fprintf (arguments.rcc.outfile, " ");
      if (experience_levels[i] >= 32768)
        fprintf (arguments.rcc.outfile, "%dL,", experience_levels[i]);
      else
        fprintf (arguments.rcc.outfile, "%d,", experience_levels[i]);
    }
  fprintf (arguments.rcc.outfile, "\n};\n\n");
}

int sort_by_pstore (const void *s1, const void *s2)
{
  owner_type *lowner = (owner_type*) s1;
  owner_type *rowner = (owner_type*) s2;
  return lowner->pstore - rowner->pstore;
}

void WriteShopkeepTable()
{
  //dump all the shopkeeps from each race into an array
  owner_type shopkeeps[num_shopkeeps];

  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  int type;
  int count = 0;
  int i, j, k;
  generic_t gval;
  St_SArgzTable (raceT_P, &argz, &argz_len);
  race_template_t *r;
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (raceT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        continue;
      r = (race_template_t *) gval.v;
      for (i = 0; i < r->val.num_shopkeeps; i++)
        {
          shopkeeps[count] = r->val.shopkeeps[i];

          count++;
        }
    }
  qsort (shopkeeps, num_shopkeeps, sizeof (owner_type), sort_by_pstore);

  fprintf (arguments.rcc.outfile, "/* Store owners have different characteristics for pricing and haggling*/\n");
  fprintf (arguments.rcc.outfile, "owner_type owners[MAX_OWNERS] = {\n");
  owner_type *o = NULL;
  int last_idx[MAX_STORES];
  memset (last_idx, 0, sizeof (last_idx));
  //here we make an attempt to dump out the shopkeeps in groups of 6.
  for (k = 0; k < num_shopkeeps; k++)
    {
      for (i = 0; i < MAX_STORES; i++)
        {
          for (j = last_idx[i]; j < num_shopkeeps; j++)
            {
              o = &shopkeeps[j];
              if (o->pstore != i)
                continue;
              fprintf (arguments.rcc.outfile, "  {\"%s\",\n", o->owner_name);
              fprintf (arguments.rcc.outfile, 
                       "   %d, %d, %d, %d, %d, %d, %d},\n", 
                       o->max_cost, o->max_inflate, o->min_inflate, 
                       o->haggle_per, o->owner_race, o->insult_max, o->pstore);
              last_idx[i] = j + 1;
              break;
            }
        }
    }
  fprintf (arguments.rcc.outfile, "};\n\n");

}

char *get_short_name_for_race(char *race)
{
  if (strcmp (race, "Half-Elf") == 0)
    return strdup ("HfE");
  else if (strcmp (race, "Halfling") == 0)
    return strdup ("Hal");
  else if (strcmp (race, "Half-Orc") == 0)
    return strdup ("HfO");
  else if (strcmp (race, "Half-Troll") == 0)
    return strdup ("HfT");
  else
    {
      char nam[4];
      memset(nam, 0, sizeof (nam));
      strncpy (nam, race, 3);
      return strdup (nam);
    }
}

int get_idx_for_race(char *race)
{
  race_template_t *r;
  generic_t gval;
  int type;
  if (St_GetSym (raceT_P, race, &type, &gval) != ST_SYM_FOUND) 
    return -1;
  r = (race_template_t*) gval.v;
  return r->idx;
}

void WriteShopkeepRacePriceAdjustmentTable()
{
  fprintf (arguments.rcc.outfile, 
           "/* Buying and selling adjustments "
           "for character race VS store   */\n");
  fprintf (arguments.rcc.outfile, 
           "/* owner race                     "
           "                               */\n");
  fprintf (arguments.rcc.outfile, 
           "int8u rgold_adj[MAX_RACES][MAX_RACES] = {\n");

  int num_races = St_TableSize(raceT_P);
  int i, j, k;
  fprintf (arguments.rcc.outfile, "%18s/* ", "");
  for (i = 0; i < num_races; i++)
    {
      char *race = get_race_for_idx(i);
      if (race)
        {
          char *s = get_short_name_for_race(race);
          fprintf (arguments.rcc.outfile, "%-3s", s);
          if (i != num_races - 1)
            fprintf (arguments.rcc.outfile, ", ");
          free (s);
        }
    }
  fprintf (arguments.rcc.outfile, " */\n");
  for (i = 0; i < num_races; i++)
    {
      char *argz = NULL;
      size_t argz_len = 0;
      char *entry = NULL;
      St_SArgzTable (raceT_P, &argz, &argz_len);
      race_template_t *r;
      generic_t gval;
      int type;
      while ((entry = argz_next (argz, argz_len, entry)))
        {
          if (St_GetSym (raceT_P, entry, &type, &gval) != ST_SYM_FOUND) 
            continue;
          r = (race_template_t*) gval.v;
          if (r->idx == i)
            {
              fprintf (arguments.rcc.outfile, "/*%-15s*/ {", r->val.r.trace);
              for (j = 0; j < num_races; j++)
                {
                  for (k = 0; k < r->val.num_price_adjust; k++)
                    {
                      if (get_idx_for_race(r->val.price_adjust[k].race) == j)
                        {
                          fprintf (arguments.rcc.outfile, "%3d", 
                                   r->val.price_adjust[k].price);
                          if (j != num_races - 1)
                            fprintf (arguments.rcc.outfile, ", ");
                        }
                    }
                }
              fprintf (arguments.rcc.outfile, "}");
              if (r->idx != num_races - 1)
                fprintf (arguments.rcc.outfile, ",");
              fprintf (arguments.rcc.outfile, "\n");
            }
        }
      free(argz);
    }
  fprintf (arguments.rcc.outfile, "};\n\n");
}

class_template_t* get_class(char *class)
{
  class_template_t *c;
  generic_t gval;
  int type;
  if (St_GetSym (classT_P, class, &type, &gval) != ST_SYM_FOUND) 
    return NULL;
  c = (class_template_t*) gval.v;
  return c;
}

char *get_class_for_idx(int idx)
{
  char *argz = NULL;
  size_t argz_len = 0;
  char *entry = NULL;
  St_SArgzTable (classT_P, &argz, &argz_len);
  class_template_t *c;
  generic_t gval;
  int type;
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (classT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        continue;
      c = (class_template_t*) gval.v;
      if (c->idx == idx)
        return c->val.c.title;
    }
  return NULL;
}

void WriteTitlesForClass(char *argz, size_t len)
{
  char *entry = NULL;
  int count = 0;
  int col_count = 0;
  int first = 1;
  while ((entry = argz_next (argz, len, entry)))
    {
      if (col_count + strlen (entry) + 4 > 80)
        {
          fprintf (arguments.rcc.outfile, "\n");
          col_count = 0;
        }
      if (col_count == 0)
        {
          if (first)
            {
              fprintf (arguments.rcc.outfile, "  {");
              first = 0;
            }
          else
            fprintf (arguments.rcc.outfile, "   ");
          col_count+=3;
        }
      fprintf (arguments.rcc.outfile, "\"%s\"", entry);
      col_count += strlen (entry) + 2;
      if (count != num_experience_levels -1)
        {
          fprintf (arguments.rcc.outfile, ", ");
          col_count += 2;
        }
      count++;
      if (count == num_experience_levels)
        fprintf (arguments.rcc.outfile, "},\n");
    }
}

void WriteClassTitles()
{
  int i;
  int num_classes = St_TableSize(classT_P);
  fprintf (arguments.rcc.outfile, 
           "/* Class titles for different levels"
           "                            */\n");
  fprintf (arguments.rcc.outfile,
           "char *player_title[MAX_CLASS][2][MAX_PLAYER_LEVEL] = {\n");
  for (i = 0; i < num_classes; i++)
    {
      char *class = get_class_for_idx(i);
      if (!class)
        continue;
      class_template_t *c = get_class(class);
      fprintf (arguments.rcc.outfile, "  /* %s %-13s */\n", "Female", class);
fprintf (arguments.rcc.outfile, "{\n");
      WriteTitlesForClass(c->val.female_titles_argz, c->val.female_titles_len);
      fprintf (arguments.rcc.outfile, "  /* %s %-15s */\n", "Male", class);
      WriteTitlesForClass(c->val.male_titles_argz, c->val.male_titles_len);
fprintf (arguments.rcc.outfile, "},\n");
    }
  fprintf (arguments.rcc.outfile, "};\n\n");
}
      
void WriteRaceTable()
{
  fprintf (arguments.rcc.outfile, "/*  Race  STR,INT,WIS,DEX,CON,CHR, \n");
  fprintf (arguments.rcc.outfile, 
           "    Ages, heights, and weights (male then female)\n");
  fprintf (arguments.rcc.outfile, 
           "    Racial Bases for: dis,srh,stl,fos,bth,bthb,bsav,hitdie,\n");
  fprintf (arguments.rcc.outfile, 
           "    infra, exp base, choice-classes */\n");
  fprintf (arguments.rcc.outfile, "race_type race[MAX_RACES] = {\n");
  int i;
  int num_races = St_TableSize(raceT_P);
  for (i = 0; i < num_races; i++)
    {
      char *race = get_race_for_idx(i);
      if (!race)
        continue;
      race_template_t *r = get_race(race);
      fprintf (arguments.rcc.outfile, 
               "  {\"%s\", %hd, %hd, %hd, %hd, %hd, %hd,\n",
               r->val.r.trace, r->val.r.str_adj, r->val.r.int_adj, 
               r->val.r.wis_adj, r->val.r.dex_adj, r->val.r.con_adj,
               r->val.r.chr_adj);
      fprintf (arguments.rcc.outfile,  "   "
               "%hhu, %hhu, %hhu, %hhu, %hhu, %hhu, %hhu, %hhu, %hhu, %hhu,\n",
               r->val.r.b_age, r->val.r.m_age, r->val.r.m_b_ht, 
               r->val.r.m_m_ht, r->val.r.m_b_wt, r->val.r.m_m_wt,
               r->val.r.f_b_ht, r->val.r.f_m_ht, r->val.r.f_b_wt,
               r->val.r.f_m_wt);
      fprintf (arguments.rcc.outfile, "   "
               "%hd, %hd, %hd, %hd, %hd, %hd, %hd, %hhu, %hhu, %hhu, 0x%08X,\n",
                r->val.r.b_dis, r->val.r.srh, r->val.r.stl, r->val.r.fos,
                r->val.r.bth, r->val.r.bthb, r->val.r.bsav, r->val.r.bhitdie,
                r->val.r.infra, r->val.r.b_exp, r->val.r.rtclass);
      fprintf (arguments.rcc.outfile, "   },\n");
    }
  fprintf (arguments.rcc.outfile, "};\n\n");

}

int get_min_spell_level(class_template_t *c)
{
  int min = num_experience_levels + 1;
  int i;
  for (i = 0; i < c->val.num_spells; i++)
    if (c->val.spells[i].s.slevel < min)
      min = c->val.spells[i].s.slevel;
  for (i = 0; i < c->val.num_prayers; i++)
    if (c->val.prayers[i].s.slevel < min)
      min = c->val.prayers[i].s.slevel;
  if (min == num_experience_levels + 1)
    return 0;
  return min;
}

void WriteClassTable()
{
  fprintf (arguments.rcc.outfile,
           "/* Classes.                       "
           "                              */\n");
  fprintf (arguments.rcc.outfile, "class_type class[MAX_CLASS] = {\n");
  fprintf (arguments.rcc.outfile, "/*%-11s HP Dis Src Stl Fos bth btb sve  "
                                  "S  I  W  D Co Ch Spell Exp spl */\n", "");
  int i;
  int num_classes = St_TableSize(classT_P);
  for (i = 0; i < num_classes; i++)
    {
      char *class = get_class_for_idx(i);
      if (!class)
        continue;
      class_template_t *c = get_class(class);
      char *name = xasprintf ("\"%s\",", c->val.c.title);
      char *spells = "NONE,";
      if (c->val.num_prayers)
        spells = "PRIEST,";
      else if (c->val.num_spells)
        spells = "MAGE,";
      int min_spell_level = get_min_spell_level(c);
      fprintf (arguments.rcc.outfile, "  {%-10s "
               "%2hhu, %2hhu, %2hhu, %2hhu, %2hhu, %2hhu, %2hhu, %2hhu,"
               "%2hd,%2hd,%2hd,%2hd,%2hd,%2hd,%-7s%2hhu, %2d}", 
               name, c->val.c.adj_hd, c->val.c.mdis, c->val.c.msrh, 
               c->val.c.mstl, c->val.c.mfos, c->val.c.mbth, c->val.c.mbthb,
               c->val.c.msav, c->val.c.madj_str, c->val.c.madj_int,
               c->val.c.madj_wis, c->val.c.madj_dex, c->val.c.madj_con,
               c->val.c.madj_chr, spells, c->val.c.m_exp, min_spell_level);
      if (i != num_classes - 1)
        fprintf (arguments.rcc.outfile, ",");
      fprintf (arguments.rcc.outfile, "\n");
      free (name);
    }
  fprintf (arguments.rcc.outfile, "};\n\n");
}
      
void WriteClassLevelAdjustmentTable()
{
  fprintf (arguments.rcc.outfile,
           "/* making it 16 bits wastes a little space, but saves "
           "much signed/unsigned\n");
  fprintf (arguments.rcc.outfile,
           "   headaches in its use */\n");
  fprintf (arguments.rcc.outfile,
           "/* CLA_MISC_HIT is identical to CLA_SAVE, "
           "which takes advantage of\n");
  fprintf (arguments.rcc.outfile, "   "
           "the fact that the save values are independent of the class */\n");
  fprintf (arguments.rcc.outfile, 
           "int16 class_level_adj[MAX_CLASS][MAX_LEV_ADJ] = {\n");
  fprintf (arguments.rcc.outfile, 
           "/*%-13sbth bthb  devices disarm save/misc hit  */\n", "");
  int i;
  int num_classes = St_TableSize(classT_P);
  for (i = 0; i < num_classes; i++)
    {
      char *class = get_class_for_idx(i);
      if (!class)
        continue;
      class_template_t *c = get_class(class);
      fprintf (arguments.rcc.outfile, 
               "/* %-7s */ {%3hd, %3hd, %7hd, %5hd, %12hd}", 
               c->val.c.title, c->val.adjust_per_one_third_level[0],
               c->val.adjust_per_one_third_level[1],
               c->val.adjust_per_one_third_level[2],
               c->val.adjust_per_one_third_level[3],
               c->val.adjust_per_one_third_level[4]);
      if (i != num_classes -1)
        fprintf (arguments.rcc.outfile, ",");
      fprintf (arguments.rcc.outfile, "\n");
    }
  fprintf (arguments.rcc.outfile, 
           "};\n\n");
}

void FillClassFlagsInRaces()
{
  //here we take the list of named allowable classes for each race,
  //and we fill in the bitwise field "race_type.rtclass"
  char *argz = NULL;
  size_t argz_len = 0;
  const char *entry = NULL;
  int type;
  int num_races = St_TableSize(raceT_P);
  generic_t gval;
  St_SArgzTable (raceT_P, &argz, &argz_len);
  race_template_t *r;
  while ((entry = argz_next (argz, argz_len, entry)))
    {
      if (St_GetSym (raceT_P, entry, &type, &gval) != ST_SYM_FOUND) 
        continue;
      r = (race_template_t *) gval.v;
      char *cl = NULL;
      while ((cl = argz_next (r->val.classes_argz, r->val.classes_len, cl)))
        {
          class_template_t *c = get_class(cl);
          if (!c)
            continue;
          int mask = (int) pow (2, c->idx);
          r->val.r.rtclass |= mask;
        }
    }
}
      
int sort_by_chart_and_roll (const void *lhs, const void *rhs)
{
  background_type *l = (background_type*) lhs;
  background_type *r = (background_type*) rhs;
  int diff = l->chart - r->chart;
  if (diff == 0)
    diff = l->roll - r->roll;
  return diff;
}

void WriteBackgrounds()
{
  int num_backgrounds = 0;
  int i;
  int num_races = St_TableSize(raceT_P);
  fprintf (arguments.rcc.outfile, "/* Background information"
           "                                       */\n");
  fprintf (arguments.rcc.outfile,
           "int background_start[MAX_RACES] = { "
           "/* starting .chart not index */\n");
  for (i = 0; i < num_races; i++)
    {
      char *race = get_race_for_idx(i);
      if (!race)
        continue;
      race_template_t *r = get_race(race);
      int start = 0;
      if (r->val.num_backgrounds)
        start = r->val.backgrounds[0].chart;
      fprintf (arguments.rcc.outfile, "  %3d, /* %s */\n", 
               start, r->val.r.trace);
      num_backgrounds += r->val.num_backgrounds;
    }
  fprintf (arguments.rcc.outfile, "};\n\n");

  //collect all of the backgrounds into an array and sort them
  background_type backgrounds[num_backgrounds];
  int count = 0;
  int j;
  for (i = 0; i < num_races; i++)
    {
      char *race = get_race_for_idx(i);
      if (!race)
        continue;
      race_template_t *r = get_race(race);
      for (j = 0; j < r->val.num_backgrounds; j++)
        {
          backgrounds[count] = r->val.backgrounds[j];
          count++;
        }
    }
  qsort (backgrounds, num_backgrounds, sizeof (background_type), 
         sort_by_chart_and_roll);
   //okay, dump them out
  fprintf (arguments.rcc.outfile, 
           "background_type background[MAX_BACKGROUND] = {\n");
  for (i = 0; i < num_backgrounds; i++)
    {
      background_type b = backgrounds[i];
      fprintf (arguments.rcc.outfile, 
               "  {\"%s\", %hhu, %hhu, %hhu, %hhu}",
               b.info, b.roll, b.chart, b.next, b.bonus);
      if (i != num_backgrounds - 1)
        fprintf (arguments.rcc.outfile, ",");
      fprintf (arguments.rcc.outfile, "\n");
    }
  fprintf (arguments.rcc.outfile, "};\n\n");
}
      
void WriteClassSpells(int max, spell_t *spells, int num)
{
  int i, j;
  for (i = 0; i < max; i++)
    {
      int found = 0;
      for (j = 0; j < num; j++)
        {
          if (spells[j].idx == i)
            {
              fprintf (arguments.rcc.outfile, "   {%hhu, %hhu, %hhu, %hhu}",
                       spells[j].s.slevel, spells[j].s.smana, 
                       spells[j].s.sfail, spells[j].s.sexp);
              found = 1;
              break;
            }
        }
      if (!found)
        fprintf (arguments.rcc.outfile, "   {MAX_SPELLS, MAX_SPELLS, 0, 0}");
      if (i != max - 1)
        fprintf (arguments.rcc.outfile, ",");
      fprintf (arguments.rcc.outfile, "\n");
    }
}

void WriteSpells()
{
  fprintf (arguments.rcc.outfile,
           "spell_type magic_spell[MAX_CLASS][MAX_SPELLS] = {\n");
  int num_classes = St_TableSize(classT_P);
  int i, j;
  for (i = 0; i < num_classes; i++)
    {
      char *class = get_class_for_idx(i);
      if (!class)
        continue;
      class_template_t *c = get_class(class);
      fprintf (arguments.rcc.outfile, 
               "  {%-29s /* %-13s */\n", "", c->val.c.title);
      if (c->val.num_spells)
        WriteClassSpells((sizeof (spellsInit) / sizeof (symInit_t)) -1,
                         c->val.spells, c->val.num_spells);
      else if (c->val.num_prayers)
        WriteClassSpells((sizeof (prayersInit) / sizeof (symInit_t)) -1,
                         c->val.prayers, c->val.num_prayers);
      else
        WriteClassSpells((sizeof (spellsInit) / sizeof (symInit_t)) -1,
                         c->val.spells, 0);
      fprintf (arguments.rcc.outfile, "   }");
      if (i != num_classes - 1)
        fprintf (arguments.rcc.outfile, ",");
      fprintf (arguments.rcc.outfile, "\n");
    }
  fprintf (arguments.rcc.outfile,"};\n\n");
}

char * lookup_spell_name (int idx)
{
  char *name = NULL;
  int i;
  for (i = 0; i < num_spells_named; i++)
    {
      if (spell_names[i].val == idx)
        {
          name = spell_names[i].name;
          break;
        }
    }
  return name;
}

char * lookup_prayer_name (int idx)
{
  char *name = NULL;
  int i;
  for (i = 0; i < num_prayers_named; i++)
    {
      if (prayer_names[i].val == idx)
        {
          name = prayer_names[i].name;
          break;
        }
    }
  return name;
}

void WriteSpellNames()
{
  //step 1 collect the spells
  int i, j;
  int max = (sizeof (spellsInit) / sizeof (symInit_t)) -1;
  spell_t s[max];
  memset (s, 0, sizeof (s));
  int num_classes = St_TableSize(classT_P);
  for (i = 0; i < num_classes; i++)
    {
      char *class = get_class_for_idx(i);
      if (!class)
        continue;
      class_template_t *c = get_class(class);
      if (c->val.num_spells)
        {
          for (j = 0; j < c->val.num_spells; j++)
            {
              if (s[c->val.spells[j].idx].line_no == 0)
                s[c->val.spells[j].idx] = c->val.spells[j];
            }
        }
    }
  // step 2 dump them out, all pretty-print like.
  fprintf (arguments.rcc.outfile, 
    "  /* Mage Spells */\n");
  int len = 0;
  for (i = 0; i < max; i++)
    {
      char *name = lookup_spell_name (s[i].idx);
      if (!name || s[i].line_no == 0)
        name = "";
      if (len == 0)
        {
          fprintf (arguments.rcc.outfile, "    ");
          len += 4;
        }
      len += strlen (name) + 2;
      fprintf (arguments.rcc.outfile, "\"%s\"", name);
      if (i != max -1)
        {
          fprintf (arguments.rcc.outfile, ", ");
          len += 2;
        }
      if (len >= 59)
        {
          fprintf (arguments.rcc.outfile, "\n");
          len = 0;
        }
    }
  fprintf (arguments.rcc.outfile, "\n");
}

void WritePrayerNames()
{
  //step 1 collect the prayers
  int i, j;
  int max = (sizeof (prayersInit) / sizeof (symInit_t)) -1;
  spell_t s[max];
  memset (s, 0, sizeof (s));
  int num_classes = St_TableSize(classT_P);
  for (i = 0; i < num_classes; i++)
    {
      char *class = get_class_for_idx(i);
      if (!class)
        continue;
      class_template_t *c = get_class(class);
      if (c->val.num_prayers)
        {
          for (j = 0; j < c->val.num_prayers; j++)
            {
              if (s[c->val.prayers[j].idx].line_no == 0)
                s[c->val.prayers[j].idx] = c->val.prayers[j];
            }
        }
    }
  // step 2 dump them out, all pretty-print like.
  fprintf (arguments.rcc.outfile, 
    "  /* Priest Prayers */\n");
  int len = 0;
  for (i = 0; i < max; i++)
    {
      char *name = lookup_prayer_name (s[i].idx);
      if (!name || s[i].line_no == 0)
        name = "";
      if (len == 0)
        {
          fprintf (arguments.rcc.outfile, "    ");
          len += 4;
        }
      len += strlen (name) + 2;
      fprintf (arguments.rcc.outfile, "\"%s\"", name);
      if (i != max -1)
        {
          fprintf (arguments.rcc.outfile, ", ");
          len += 2;
        }
      if (len >= 59)
        {
          fprintf (arguments.rcc.outfile, "\n");
          len = 0;
        }
    }
  fprintf (arguments.rcc.outfile, "\n");
}

void WriteNames()
{
  //pad the spell and prayer names
  fprintf (arguments.rcc.outfile,
    "char *spell_names[2][MAX_SPELLS] = {\n");
  fprintf (arguments.rcc.outfile,
    "  {\n");
  WriteSpellNames ();
  fprintf (arguments.rcc.outfile,
    "  }, {\n");
  WritePrayerNames ();
  fprintf (arguments.rcc.outfile,
    "  }\n");
  fprintf (arguments.rcc.outfile,"};\n\n");
}

int
rcc_main (char *inputFilename)
{
  InitTables ();

  if (strcmp (inputFilename, "-") == 0)
    input_F = stdin;
  else
    {
      input_F = fopen (inputFilename, "r");
      if (!input_F) 
	{
	  fprintf (stderr, "Error: couldn't open file.\n");
	  return -1;
	}
    }

  if (yyparse ()) 
    {
      fprintf (stderr, "Errors prevent continuation.\n");
      return -2;
    }

  FillClassFlagsInRaces();
  if (arguments.rcc.consistency_check)
    {
      CheckRaces();
      CheckClasses();
      CheckNames();
    }
  WriteGenerationNotice();
  if (arguments.rcc.only_generate_constants)
    WriteConstants ();
  else
    {
      fprintf (arguments.rcc.outfile, "#include \"constant.h\"\n");
      fprintf (arguments.rcc.outfile, "#include \"types.h\"\n\n");
      WriteShopkeepTable();
      WriteShopkeepRacePriceAdjustmentTable();
      WriteClassTitles();
      WriteExperienceTable();
      WriteRaceTable();
      WriteClassTable();
      WriteClassLevelAdjustmentTable();
      WriteBackgrounds();
      WriteSpells();
      WriteNames();
    }

  return 0;
}
