/* $Id: main.c,v 1.7 2004/02/08 23:18:47 thrulliq Exp $ */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <glade/glade.h>
#include <gnokii.h>

#include "gnocky.h"
#include "monitor.h"
#include "utils.h"
#include "statusbar.h"
#include "preferences.h"

#include "phoneview.h"
#include "phonebookview.h"
#include "smsview.h"
#include "logosview.h"

/* GUI stuff */
GladeXML *xml;
GtkWidget *window;
GtkWidget *main_view;
GtkWidget *phone_view;
GtkWidget *phonebook_view;
GtkWidget *sms_view;
GtkWidget *logos_view;
GtkWidget *current_view = NULL;

extern GAsyncQueue *events;

extern GnockyPhoneMonitor pm;
extern struct gn_statemachine statemachine;

void gnocky_set_current_view(GtkWidget *view)
{
	if (current_view == view)
		return;
	
	if (current_view) {
		gtk_widget_ref(current_view);
		gtk_container_remove(GTK_CONTAINER(main_view), current_view);
		/* FIXME - needed to keep recount at reasonable level*/
		if (G_OBJECT(current_view)->ref_count >= 2) {
			gtk_widget_unref(current_view);
		}
	}
	gtk_container_add(GTK_CONTAINER(main_view), view);
	current_view = view;
}

gint gnocky_view_update(gpointer data)
{
	gnocky_statusbar_update();
	
	gnocky_phone_view_update(pm);
	gnocky_phonebook_view_update(pm);
	gnocky_sms_view_update(pm);
	
	return TRUE;
}

gboolean gnocky_button_label_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	if (event->type == GDK_ENTER_NOTIFY) {
		gtk_button_set_relief (GTK_BUTTON(widget), GTK_RELIEF_NORMAL);
		gtk_button_enter(GTK_BUTTON(widget));
	} else	if (event->type == GDK_LEAVE_NOTIFY) {
		gtk_button_set_relief (GTK_BUTTON(widget), GTK_RELIEF_NONE);
		gtk_button_leave(GTK_BUTTON(widget));
	} else if (event->type == GDK_BUTTON_PRESS) {
		gtk_button_clicked(GTK_BUTTON(widget));
	} else if (event->type == GDK_BUTTON_RELEASE) {
		gtk_button_released(GTK_BUTTON(widget));
	}

	return FALSE;
}

void gnocky_button_menu_clicked(GtkWidget *widget, gpointer data)
{
	g_print("button clicked\n");
	gnocky_set_current_view(data);
}

void on_preferences_button_clicked(GtkWidget *widget, gpointer data)
{
	create_preferences(&statemachine.config);
}

void on_about_activate(GtkWidget *widget, gpointer data)
{
	gnocky_show_message(GTK_MESSAGE_INFO,"Gnocky " VERSION "\n(C) Copyleft 2004 Igor Popik");
}

void gnocky_set_main_gui_callbacks()
{
	GtkWidget *button;
	
	button = glade_xml_get_widget(xml, "phone_button");
	
	if (button)
		g_signal_connect(G_OBJECT(button), "clicked", (GCallback) gnocky_button_menu_clicked, phone_view);
	
	button = glade_xml_get_widget(xml, "phonebook_button");
	if (button)
		g_signal_connect(G_OBJECT(button), "clicked", (GCallback) gnocky_button_menu_clicked, phonebook_view);
	
	button = glade_xml_get_widget(xml, "sms_button");
	if (button)
		g_signal_connect(G_OBJECT(button), "clicked", (GCallback) gnocky_button_menu_clicked, sms_view);
	
	button = glade_xml_get_widget(xml, "logos_button");
	if (button)
		g_signal_connect(G_OBJECT(button), "clicked", (GCallback) gnocky_button_menu_clicked, logos_view);
}
void gnocky_interface_create()
{
	/* main interface */
	xml = create_gladexml("gnocky.glade", NULL);

	if (!xml) {
		gnocky_show_error("Cannot create user interface!\n");
		gtk_main_quit();
	}

	glade_xml_signal_autoconnect(xml);
	window = glade_xml_get_widget(xml, "window");

	main_view = glade_xml_get_widget(xml, "main_view");
	
	gnocky_statusbar_init(glade_xml_get_widget(xml, "statusbar_progress"), 
				glade_xml_get_widget(xml, "statusbar"));
	/* views creation */
	phone_view = gnocky_phone_view_create();
	phonebook_view = gnocky_phonebook_view_create();
	sms_view = gnocky_sms_view_create();
	logos_view = gnocky_logos_view_create();

	gnocky_set_main_gui_callbacks();
	
	/* setting the default view */
	gnocky_set_current_view(phone_view);

	g_timeout_add(1000, gnocky_view_update, NULL);
}

static void gnocky_bus_terminate(void)
{
	gn_sm_functions(GN_OP_Terminate, NULL, &statemachine);
}

int
main (int argc, char *argv[])
{

#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

	gtk_set_locale();
	gtk_init(&argc, &argv);
	g_thread_init(NULL);

	events = g_async_queue_new();

	gnocky_interface_create();

	gnocky_monitor_create();

	gtk_main ();

	gnocky_bus_terminate();

	return 0;
}
