%define name gnokii
%define version 0.6.1
%define release 1

Summary: multisystem tool suite for the mobile phones
Name: %{name}
Version: %{version}
Release: %{release}
License: GNU GPL
Packager: Pavel Janik ml. <Pavel.Janik@linux.cz>, Jan Derfinak <ja@mail.upjs.sk>
Group: Applications/Communications
Source: htp://www.gnokii.org/download/%{name}-%{version}.tar.gz
BuildRoot: /var/tmp/%{name}-%{version}-root
BuildPreReq: gettext, gtk+-devel >= 1.2.0, flex

%description
Gnokii is a multisystem tool suite and (eventually) modem/fax driver for
the mobile phones, released under the GPL.

%package xgnokii
Summary: Graphical gtk+ based tool suite for the mobile phones.
Group: X11/Applications
%description xgnokii
Xgnokii is a graphical gtk+ based tool suite for the mobile phones. It
allows you to edit your contacts book, send/read SMS's from/in your
computer and more.

%package devel
Summary: Headers for gnokii application development
Group: Development/Communication
%description devel
Header files needed for developing applications using gnokii.

%prep

%setup -q

%build
./configure --prefix=/usr --with-xgnokiidir=/usr/X11R6 --enable-security
make

%install
rm -rf ${RPM_BUILD_ROOT}

make DESTDIR=${RPM_BUILD_ROOT} install

mkdir -p ${RPM_BUILD_ROOT}%{_sysconfdir}

sed 's#/usr/local/sbin/#%{_sbindir}#' <Docs/sample/gnokiirc >${RPM_BUILD_ROOT}%{_sysconfdir}/gnokiirc

# I know of no proper rpm macro to pickup manpages, they're expected
# to be part of make install - So until that happens this hack is needed
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man1
mkdir -p ${RPM_BUILD_ROOT}%{_mandir}/man8
mkdir -p ${RPM_BUILD_ROOT}%{_prefix}/X11R6/man/man1
cp Docs/man/*.1 ${RPM_BUILD_ROOT}%{_mandir}/man1
cp Docs/man/*.8 ${RPM_BUILD_ROOT}%{_mandir}/man8
cp Docs/man/*.1x ${RPM_BUILD_ROOT}%{_prefix}/X11R6/man/man1

%pre
/usr/sbin/groupadd -r -f gnokii >/dev/null 2>&1

%post
/sbin/ldconfig

%postun
/usr/sbin/groupdel gnokii >/dev/null 2>&1

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root)
%doc Docs/CREDITS Docs/DataCalls-QuickStart Docs/FAQ Docs/README
%doc Docs/README-3810 Docs/README-6110 Docs/README-2110 Docs/README-6510 Docs/README-7110
%doc Docs/README-dancall Docs/README-siemens Docs/README-ericsson Docs/README-Symbian
%doc Docs/README-WIN32 Docs/README-MacOSX
%doc Docs/gettext-howto Docs/gnokii-IrDA-Linux Docs/gnokii-ir-howto Docs/packaging-howto
%doc Docs/gnokii-hackers-howto Docs/gnokii.nol Docs/logos.txt Docs/ringtones.txt Docs/Bugs
%doc Docs/sample/logo/gnokii.xpm Docs/sample/ringtone/star.imelody Docs/sample/ringtone/star.rtttl
%doc Docs/sample/gnokiirc
%doc Docs/sample/ppp/options Docs/sample/ppp/pap-secrets
%doc Docs/sample/ppp/ppp-gnokii Docs/sample/ppp/ppp-on
%doc Docs/sample/ppp/cimd-connect Docs/sample/ppp/ppp-6210-modem
%doc Docs/sample/ppp/ppp-hscsd
%doc Docs/protocol/nk2110.txt Docs/protocol/nk3110.txt Docs/protocol/nk6110.txt Docs/protocol/nk6160.txt
%doc Docs/protocol/nk6185.txt Docs/protocol/nk640.txt Docs/protocol/nk7110.txt Docs/protocol/nk6510.txt
%doc Docs/protocol/nokia.txt

%attr(0750, root, gnokii) %{_bindir}/gnokii
%attr(0750, root, gnokii) %{_sbindir}/gnokiid
%attr(4750, root, gnokii) %{_sbindir}/mgnokiidev
%attr(0750, root, gnokii) %{_libdir}/libgnokii.so.*
%attr(0750, root, gnokii) %{_libdir}/libgnokii.a
%attr(0750, root, gnokii) %{_libdir}/libgnokii.la
%{_bindir}/ppm2nokia
%{_bindir}/sendsms
%{_datadir}/locale/*
%config %{_sysconfdir}/gnokiirc
%{_mandir}/*/*
%{_prefix}/X11R6/man/*/*

%files xgnokii
%defattr(-,root,root)
%{_prefix}/X11R6/bin/xgnokii
%{_bindir}/todologo
%{_prefix}/X11R6/share/xgnokii

%files devel
%defattr(-,root,root)
%{_includedir}/*
%{_libdir}/*.so
%{_libdir}/*.a
%{_libdir}/*.la
%{_libdir}/pkgconfig/*

%changelog

* Mon Feb 23 2004 BORBELY Zoltan <bozo@andrews.hu>
- require flex at build time (suggested by Olivier Kaloudoff)

* Fri Jan 30 2004 Pawel Kot <pkot@linuxnews.pl>
- gnokii is for mobile phones not only for Nokia mobile phones and also
  works with non unix systems

* Tue Jan 20 2004 Pawel Kot <pkot@linuxnews.pl>
- install *.a and *.la into -devel package

* Wed Apr  2 2003 Tom G. Christensen <tom.christensen@get2net.dk>
- add a -devel package
- add manpages to package 
- use proper %{_*dir} macros when referring to paths
- use make DESTDIR for install
- made sure that no files are left unpackaged

* Sat Jan  4 2003 Pawel Kot <pkot@linuxnews.pl>
- reflect changes in the file layout

* Thu Aug 15 2002 Pawel Kot <pkot@linuxnews.pl>
- misc path problems fixed

* Fri Apr 12 2002 Pawel Kot <pkot@linuxnews.pl>
- replace 'Copyright' with 'License' (submitted by Rui Miguel Silva Seabra)

* Fri Sep 28 2001 Pawel Kot <pkot@linuxnews.pl>
- last minute fixes

* Thu Sep 27 2001 Pawel Kot <pkot@linuxnews.pl>
- updates to 0.3.3 version - new docs, new ftp server

* Sun Sep  2 2001 Pawel Kot <pkot@linuxnews.pl>
- removes xlogos

* Thu Jan 11 2001 Pawel Kot <pkot@linuxnews.pl>
- misc updates

* Fri Oct 27 2000 Pavel Janik ml. <Pavel.Janik@linux.cz>
- todologo added to the package

* Mon May 15 2000 Pavel Janik ml. <Pavel.Janik@linux.cz>
- proper access rights for gnokiid, gnokii and mgnokiidev

* Sat May 13 2000 Pavel Janik ml. <Pavel.Janik@linux.cz>
- new doc files added

* Tue Mar 21 2000 Pavel Janik ml. <Pavel.Janik@linux.cz>
- permission on /usr/sbin fixed
- correct /etc/gnokiirc file

* Mon Mar 20 2000 Pavel Janik ml. <Pavel.Janik@linux.cz>
- mkdir of directories in install removed
- xgnokii package should contain lib/xgnokii directory

* Mon Mar 20 2000 Jan Derfinak <ja@mail.upjs.sk>
- split package into gnokii and xgnokii
- added configure
- correct xgnokii installation
- installation with make install
- fixing paths

* Thu Aug  5 1999 Pavel Janik ml. <Pavel.Janik@linux.cz>
- documentation files changed

* Thu Aug  5 1999 Pavel Janik ml. <Pavel.Janik@linux.cz>
- xkeyb and xlogos added to RPM package

* Sat Jul 24 1999 Pavel Janik ml. <Pavel.Janik@linux.cz>
- stripping of binaries

* Thu Jul 22 1999 Pavel Janik ml. <Pavel.Janik@linux.cz>
- gnokii.nol added - nice example for logo uploading

* Sun Jul 18 1999 Pavel Janik ml. <Pavel.Janik@linux.cz>
- mgnokiidev added to RPM package
- config file in /etc (it is not used now...)

* Sat Jul 10 1999 Pavel Janik ml. <Pavel.Janik@linux.cz>
- use of ~/.gnokiirc so not magic model stuff
- new doc files

* Mon Jun 28 1999 Pavel Janik ml. <Pavel.Janik@linux.cz>
- Nokia auth. protocol is there now
- xgnokii and gnokiid added to RPM

* Sun May  9 1999 Pavel Janik ml. <Pavel.Janik@linux.cz>
- included 6110-patch updated to my prepatches

* Thu May  6 1999 Pavel Janik ml. <Pavel.Janik@linux.cz>
- TODO-6110 file added to documentation files

* Sun Mar 28 1999 Pavel Janik ml. <Pavel.Janik@linux.cz>
- upgraded to gnokii-0.2.4
- 6110 version of gnokii added

* Fri Mar  5 1999 Pavel Janik ml. <Pavel.Janik@linux.cz>
- the first SPEC file for gnokii
