/*****
 *       xhackometer - part of the Hackometer project
 *                                                                   
 * xhackometer records keyboard and mouse and cache files
 * for later delivery to hackometer server
 *                                                                   
 *        Copyright (C) 2009 Henrik Sandklef      
 *                                                                   
 * This program is free software; you can redistribute it and/or     
 * modify it under the terms of the GNU General Public License       
 * as published by the Free Software Foundation; either version 3    
 * of the License, or any later version.                             
 *                                                                   
 *                                                                   
 * This program is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of    
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     
 * GNU General Public License for more details.                      
 *                                                                   
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software       
 * Foundation, Inc., 51 Franklin Street, Boston,            
 * MA  02110-1301, USA.                                              
 ****/



/*
 Xhackometer 
*/


/* Standard includes */
#include <stdio.h>
#include <unistd.h>

/* thread includes */
#include <pthread.h>

/* xhm includes */
#include "xhm/xhm.h"
#include "send/send.h"
#include "send/socket_send.h"
#include "send/print.h"
#include "collect/collect.h"
#include "collect/record.h"
#include "collect/select.h"

#include "cache/cache.h"
#include "cache/file.h"



/*********************
 * internal use 
 *
 */

int 
xhm_check ( char *arg, char *long_arg , char *short_arg ) 
{
  return ( ! strcmp ( arg, long_arg) || ( ! strcmp ( arg, short_arg) )) ; 
}

#define XHM_PRINT_HELP(lstr, sstr) fprintf(stdout, "%20s [%s]\n", lstr, sstr);
void
xhm_usage(void)
{
  XHM_PRINT_HELP("--verbose", "-v"  );
  XHM_PRINT_HELP("--record", "-r"  );
  XHM_PRINT_HELP("--no-record", "-nr"  );
  XHM_PRINT_HELP("--display", "-d"  );
  XHM_PRINT_HELP("--help", "-h"  );
  return;
}


int
parse_args (xhm_data* xd, int argc, char *argv[])
{
  int i ;
  for (i = 1; i < argc; i++) 
    {
      if ( xhm_check (argv[i], "--verbose", "-v"  ) )
	{
	  xd->xhm_ctrl->verbose_fd=stderr;
	  continue;
	}
      else if ( xhm_check (argv[i], "--record", "-r"  ) )
	{
	  set_collect_fun (xd, &start_record);
	}
      else if ( xhm_check (argv[i], "--no-record", "-nr"  ) )
	{
	  set_collect_fun (xd, &start_query);
	}
      else if ( xhm_check (argv[i], "--display", "-d"  ) )
	{
	  xd->xhm_ctrl->display=argv[++i];
	}
      else if ( xhm_check (argv[i], "--help", "-h"  ) )
	{
	  xhm_usage();
	  exit(0);
	}
    }
  return 0;
}



void
thr_cache (void *data)
{
  xhm_data* xd;
  xd = (xhm_data*)data;
  int sem_ret;

  while (1) 
    {
      usleep (1000*1000*2);

      xhm_verbose (xd, "cache_thread\n");
      printf("tc --> get sem "); fflush(stdout);
      sem_ret = sem_post(&xd->sem);
      printf("tc got sem"); fflush(stdout);

      cache_fun (xd);      

      

      sem_ret = sem_wait(&xd->sem);
      printf("tc <-- rel sem\n"); fflush(stdout);

    }
  
}


/*
 * end of internal use 
 *
 *********************/

















int main(int argc,char *argv[])
{
  FILE  *rc;
  int ret;
  int nr_of_loops=5;
  pthread_t       cache_thread;
  pthread_attr_t attr;

  /* create a data struct */
  xhm_data *xd = xhm_new_xhm_data();

  /* By default: SET RECORD collecting */
  set_collect_fun (xd, &start_record);

  /* By default: SET FILE CACHING */
  set_cache_fun (xd,  &xhm_file_cache);
  set_send_cache_fun (xd,  &xhm_file_cache );
  
  parse_args (xd, argc, argv);


  /* Find (and use) resource file */
  rc=xhm_find_rc (xd);
  if (rc==NULL )
    {
      xhm_verbose  (xd, "Create a new rc\n");
      rc=xhm_create_rc(xd);
      if (rc==NULL)
	{
	  fprintf  (stderr, "Could not read or create an resource file\n");
	  exit(-1);
	}
    }
  xhm_use_rc (xd, rc);

#ifdef USE_REGISTER_CODE
  /* If we haven't got any Uin ... register */
  if ( (xd->xhm_ctrl->uin==NULL) || (strlen (xd->xhm_ctrl->uin) == 0))
    {
      int uin;
      xhm_verbose (xd, " --- send a registration\n");
      ret=send_fun (xd, NULL , XHM_REGISTER_USER);
      xhm_verbose (xd, " --- registration sent\n");
      
      if (ret)
	{
	  xhm_verbose (xd, " <---  registration failed\n");
	  fflush(stderr);
	  fflush(stdout);
	  exit(0);
	}
      else
	{
	  struct server_status   _s_stat;
	  struct server_status  *s_stat=&_s_stat;
	  struct register_reply *rr;
	  xhm_verbose (xd, " User has been registred on the server\n");

	  s_stat = xd->s_stat;
	  
	  if ( ((s_stat->type) == XHM_REGISTER_USER)
	       &&
	       ((s_stat->status) == XHM_REGISTER_OK))
	    {
	      xhm_verbose (xd, "  ... and everything seems to be fine\n");
	    }
	  else
	    {
	      xhm_verbose (xd, "  ... however something is wrong with the received data\n");
	      xhm_verbose (xd, "RECEVIED\n");
	      xhm_verbose (xd, "  type   =%d\n", s_stat->type);
	      xhm_verbose (xd, "  status =%d\n", s_stat->status);
	      xhm_verbose (xd, "WANTED\n");
	      xhm_verbose (xd, "  type   =%d\n", XHM_REGISTER_USER);
	      xhm_verbose (xd, "  status =%d\n", XHM_REGISTER_OK);
	      /* TODO: add  error message and set status when leaving/exiting */


	      xhm_verbose (xd, "  ... we are continuing anyway\n");
/* 	      exit(0); */
	    }
	  
	  xhm_verbose (xd, " uin_int : %d\n", xd->s_stat->uin);
	  xhm_rcadd_uin (xd, rc, xd->s_stat->uin);

	  exit(0);
	}
    }
#endif /* REGISTER_CODE */

  
  
  /* Start sending thread */
  ret = pthread_create ( &cache_thread, NULL, (void*)&thr_cache, (void*) xd);
  if ( ret != 0 ) 
    {
      xhm_verbose (xd, "Failed to create cache thread \n");
    }
      

  /* GO on... collect data  */ 
/*   while (nr_of_loops-- > 0) */
  while(1)
    {
      printf ("+"); fflush(stdout);
      if ( collect_fun(xd) )
	{
	  xhm_verbose (xd, "recording finished\n");
	}
    }

  xhm_free_xhm_data(xd);

  exit(0); 
}

