/*****
 *       xhackometer - part of the Hackometer project
 *                                                                   
 * xhackometer records keyboard and mouse and cache files
 * for later delivery to hackometer server
 *                                                                   
 *        Copyright (C) 2009 Henrik Sandklef      
 *                                                                   
 * This program is free software; you can redistribute it and/or     
 * modify it under the terms of the GNU General Public License       
 * as published by the Free Software Foundation; either version 3    
 * of the License, or any later version.                             
 *                                                                   
 *                                                                   
 * This program is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of    
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     
 * GNU General Public License for more details.                      
 *                                                                   
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software       
 * Foundation, Inc., 51 Franklin Street, Boston,            
 * MA  02110-1301, USA.                                              
 ****/

#ifndef XHM_H
#define XHM_H

#define XHM_ABS(a)  (((a)>(0))?(a):(-(a)))

#define XHM_LOCAL_DIR   ".xhm"
#define XHM_LOCAL_CACHE "cache"
#define XHM_LOCAL_RC    ".xhmrc"
#define XHM_SYSTEM_RC   "/etc/xhmrc"
#define XHM_RC_ENV      "XHM_RC"

#define XHM_DEFAULT_SERVER "localhost"
#define XHM_DEFAULT_PORT   5551

#define MAX_COLLECT_LOOPS    200
#define MAX_FILE_NAME_LENGTH 2000

#define XHM_REGISTER_USER    1
#define XHM_SEND_DATA        2
#define XHM_SEND_CACHED_DATA 3

#define XHM_REGISTER_OK      100
#define XHM_USER_EXISTS      200

#define XHM_NOT_APPLICABLE   10

#define XHM_SLEEP printf ("sleep 10\n ####################################################################################################\n");sleep(1);

/* Standard includes */
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdarg.h>
#include <stdlib.h>
#include <setjmp.h>
#include <signal.h>

#include <semaphore.h> 

/* X11 includes */
#include <X11/Xlib.h>
#include <X11/Xmd.h>
#include <X11/Xproto.h>
#include <X11/Xos.h>
#include <X11/Xlibint.h>  /* Warning, there be dragons here.... */

/* X11 extensions includes */
#include <X11/extensions/record.h> 

/* XHM includes */
#include "xhm/xhm_proto.h"


/* 
 * this typedef should, according to XRecord,  
 * specification be defined in <X11/extensions/record.h>
 *
 * ... it is NOT !
 *
 */
typedef union { 
  unsigned char    type ;
  xEvent           event ;
  xResourceReq     req   ;
  xGenericReply    reply ;
  xError           error ;
  xConnSetupPrefix setup;
} XRecordDatum ;

/*
struct register_reply
{
  char  *uin_str;
  int   uin_int;
};

struct data_reply
{
  int   data_ret;
};


union server_reply
{
  struct register_reply *rr;
  struct data_reply     *dr;
};
*/


/* TODO 
 * ... make this struct a union instead  */
struct server_status 
{
  int   status;  
  int   uin;
  int   type;  
};


typedef struct 
{
  char *uin;
  char *password;

  FILE     *verbose_fd;
  int       use_record ;
  char     *rc_name;
  char     *display;

} xhm_control ;


typedef struct 
{
  
  char *nick_name;
  char *real_name;
  char *email;
  char *url;
  char *os;
  char *win_env;

} xhm_register ;


typedef struct 
{
  int  nr_of_kpress   ;
  int  nr_of_krelease ;

  int  pasted_chars ;
  int  copied_chars ;
  int  cut_chars ;

  int  nr_of_bpress   ;
  int  nr_of_brelease ;
  
  int  nr_of_motions  ;
  long long  nr_of_xpix  ;
  long long  nr_of_ypix  ;

  time_t  sample_time_start;
  time_t  sample_time_stop;

  xhm_control  *xhm_ctrl ;
  xhm_register *xhm_reg  ;
  struct server_status *s_stat;
  
  /* private data */
  char         *xhm_collect_data; /* can be used by collectors */
  char         *xhm_cache_data;   /* can be used by cachers */

  sem_t         sem;

} xhm_data ;



void
xhm_verbose (xhm_data *xd , char * str, ...);

int
xhm_null_struct (xhm_data *xd);

int
xhm_cache_struct (xhm_data *xd);

FILE*
xhm_create_rc (xhm_data *xd);

FILE*
xhm_find_rc (xhm_data *xd);

int
xhm_use_rc (xhm_data *xd, FILE *fd);

int
xhm_fill_rc (xhm_data *xd, FILE* fd);

int
xhm_rcadd_uin (xhm_data *xd, FILE* fd, int uin);

xhm_data*
xhm_new_xhm_data();

int
xhm_free_xhm_data(xhm_data* xd);

xhm_register*
xhm_new_xhm_reg(xhm_data *xd);

int
xhm_free_xhm_reg(xhm_data *xd);

char **
xhm_data2string ( xhm_data *xd , xhm_data *data);

xhm_data *
string2xhm_data ( xhm_data *xd, char **buf);

int
xhm_data_full (xhm_data* xd, xhm_data *data);

int
xhm_continue_collect (xhm_data* xd, int loops);

int
xhm_free_datastrings (xhm_data* xd, char **buf);


#endif /*XHM_H  */
