/*
 * Decompiled with CFR 0.152.
 */
package hanzitrainer;

import hanzitrainer.DBTableFiller;
import hanzitrainer.HanziApplicationUpdater;
import hanzitrainer.HanziDB;
import hanzitrainer.HanziTrainerApp;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterTestPanel
extends JPanel
implements TableModel {
    private JLabel CharacterLabel;
    private JButton DoneGuessCharacterButton;
    private JLabel GoodOrBadLabel;
    private JTextField GuessChineseTextField;
    private JTextField GuessPinyinTextField;
    private JLabel PinyinsLabel;
    private JLabel PinyinsLabel1;
    private JScrollPane PreviousCharDBScroll;
    private JTable PreviousCharDBTable;
    private JLabel PreviousCharacterLabel;
    private JLabel PreviousPinyinsLabel;
    private JLabel PreviouslyLabel;
    private DBTableFiller char_table_filler;
    private ArrayList<String> character_history;
    private HanziDB main_database;
    private HanziApplicationUpdater parent_app;
    private String current_character;
    private ArrayList<String> current_pinyins;
    private ArrayList<String> current_chinese_words;
    private String previous_character;
    private ArrayList<String> previous_pinyins;
    private ArrayList<String> previous_chinese_words;
    private ArrayList<String> guess_pinyins;
    private ArrayList<String> guess_chinese_words;
    private ArrayList<String> chinese_word_list;
    private ArrayList<Integer> chinese_word_list_state;

    public CharacterTestPanel(HanziDB database, HanziApplicationUpdater updater) {
        this.main_database = database;
        this.parent_app = updater;
        this.initComponents();
        this.character_history = new ArrayList();
        this.chinese_word_list = new ArrayList();
        this.chinese_word_list_state = new ArrayList();
        this.current_chinese_words = new ArrayList();
        this.guess_pinyins = new ArrayList();
        this.guess_chinese_words = new ArrayList();
        this.set_new_character_to_guess();
    }

    public void CharacterTestUpdateDB() {
        this.set_new_character_to_guess();
    }

    private void check_old_data() {
        ArrayList<String> good_pinyins = new ArrayList<String>();
        ArrayList<String> bad_pinyins = new ArrayList<String>();
        ArrayList<String> other_pinyins = new ArrayList<String>();
        ArrayList<String> good_chinese = new ArrayList<String>();
        ArrayList<String> bad_chinese = new ArrayList<String>();
        ArrayList<String> other_chinese = new ArrayList<String>();
        TableModelEvent t_event = new TableModelEvent(this);
        this.previous_character = this.current_character;
        this.previous_pinyins = this.current_pinyins;
        this.previous_chinese_words = this.current_chinese_words;
        String[] guessed_pinyins = this.GuessPinyinTextField.getText().split("[,\uff0c]");
        this.guess_pinyins.clear();
        for (String item : guessed_pinyins) {
            this.guess_pinyins.add(item.trim());
        }
        for (String item : this.guess_pinyins) {
            if (!this.previous_pinyins.contains(item)) {
                bad_pinyins.add(item);
                continue;
            }
            good_pinyins.add(item);
        }
        for (String item : this.previous_pinyins) {
            if (good_pinyins.contains(item) || bad_pinyins.contains(item)) continue;
            other_pinyins.add(item);
        }
        String pinyins_result = "<HTML><FONT COLOR=\"RED\">";
        for (String item : bad_pinyins) {
            pinyins_result = pinyins_result + item + " ";
        }
        pinyins_result = pinyins_result + "</FONT><FONT COLOR=\"GREEN\">";
        for (String item : good_pinyins) {
            pinyins_result = pinyins_result + item + " ";
        }
        pinyins_result = pinyins_result + "</FONT><FONT COLOR=\"BLACK\">";
        for (String item : other_pinyins) {
            pinyins_result = pinyins_result + item + " ";
        }
        pinyins_result = pinyins_result + "</HTML>";
        if (!this.GuessChineseTextField.getText().equals("")) {
            String[] guessed_chinese = this.GuessChineseTextField.getText().split("[,\uff0c]");
            this.guess_chinese_words.clear();
            for (String item : guessed_chinese) {
                this.guess_chinese_words.add(item.trim());
            }
            for (String item : this.guess_chinese_words) {
                if (!this.previous_chinese_words.contains(item)) {
                    bad_chinese.add(item);
                    continue;
                }
                good_chinese.add(item);
            }
        }
        for (String item : this.previous_chinese_words) {
            if (good_chinese.contains(item) || bad_chinese.contains(item)) continue;
            other_chinese.add(item);
        }
        this.chinese_word_list.clear();
        this.chinese_word_list_state.clear();
        for (String item : bad_chinese) {
            this.chinese_word_list.add(item);
            this.chinese_word_list_state.add(0);
        }
        for (String item : good_chinese) {
            this.chinese_word_list.add(item);
            this.chinese_word_list_state.add(1);
        }
        for (String item : other_chinese) {
            this.chinese_word_list.add(item);
            this.chinese_word_list_state.add(2);
        }
        this.PreviousCharDBTable.tableChanged(t_event);
        this.PreviousPinyinsLabel.setText(pinyins_result);
        this.PreviousCharacterLabel.setText(this.previous_character);
    }

    private void set_new_character_to_guess() {
        int index;
        String hanzi;
        int num_char = this.main_database.get_number_characters();
        if (num_char == 0) {
            return;
        }
        while (this.character_history.contains(hanzi = this.main_database.get_character_details(index = (int)(Math.random() * (double)num_char) + 1))) {
        }
        this.character_history.add(hanzi);
        if (this.character_history.size() > (num_char - 1) / 2) {
            this.character_history.remove(0);
        }
        this.current_chinese_words.clear();
        ArrayList<ArrayList<String>> words = this.main_database.get_words_with_character(hanzi);
        for (ArrayList<String> word : words) {
            this.current_chinese_words.add(word.get(0));
        }
        this.current_pinyins = this.main_database.get_pinyin_from_character(hanzi);
        this.current_character = hanzi;
        this.CharacterLabel.setText(hanzi);
        this.GuessPinyinTextField.setText("");
        this.GuessChineseTextField.setText("");
    }

    private void initComponents() {
        this.CharacterLabel = new JLabel();
        this.DoneGuessCharacterButton = new JButton();
        this.PinyinsLabel = new JLabel();
        this.PinyinsLabel1 = new JLabel();
        this.GuessPinyinTextField = new JTextField();
        this.GuessChineseTextField = new JTextField();
        this.PreviousCharacterLabel = new JLabel();
        this.PreviouslyLabel = new JLabel();
        this.GoodOrBadLabel = new JLabel();
        this.PreviousCharDBScroll = new JScrollPane();
        this.PreviousCharDBTable = new JTable();
        this.char_table_filler = new DBTableFiller(this.main_database);
        this.PreviousPinyinsLabel = new JLabel();
        this.setName("Form");
        ResourceMap resourceMap = Application.getInstance(HanziTrainerApp.class).getContext().getResourceMap(CharacterTestPanel.class);
        this.CharacterLabel.setFont(resourceMap.getFont("CharacterLabel.font"));
        this.CharacterLabel.setHorizontalAlignment(0);
        this.CharacterLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.CharacterLabel.setName("CharacterLabel");
        this.DoneGuessCharacterButton.setText(resourceMap.getString("DoneGuessCharacterButton.text", new Object[0]));
        this.DoneGuessCharacterButton.setName("DoneGuessCharacterButton");
        this.DoneGuessCharacterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CharacterTestPanel.this.DoneGuessCharacterButton_action(evt);
            }
        });
        this.PinyinsLabel.setText(resourceMap.getString("PinyinsLabel.text", new Object[0]));
        this.PinyinsLabel.setName("PinyinsLabel");
        this.PinyinsLabel1.setText(resourceMap.getString("PinyinsLabel1.text", new Object[0]));
        this.PinyinsLabel1.setName("PinyinsLabel1");
        this.GuessPinyinTextField.setText(resourceMap.getString("GuessPinyinTextField.text", new Object[0]));
        this.GuessPinyinTextField.setName("GuessPinyinTextField");
        this.GuessPinyinTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CharacterTestPanel.this.GuessPinyinTextFieldActionPerformed(evt);
            }
        });
        this.GuessChineseTextField.setText(resourceMap.getString("GuessChineseTextField.text", new Object[0]));
        this.GuessChineseTextField.setName("GuessChineseTextField");
        this.GuessChineseTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CharacterTestPanel.this.GuessChineseTextFieldActionPerformed(evt);
            }
        });
        this.GuessChineseTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                CharacterTestPanel.this.GuessChineseTextFieldFocusGained(evt);
            }

            public void focusLost(FocusEvent evt) {
                CharacterTestPanel.this.GuessChineseTextFieldFocusLost(evt);
            }
        });
        this.PreviousCharacterLabel.setFont(resourceMap.getFont("PreviousCharacterLabel.font"));
        this.PreviousCharacterLabel.setHorizontalAlignment(0);
        this.PreviousCharacterLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.PreviousCharacterLabel.setName("PreviousCharacterLabel");
        this.PreviouslyLabel.setText(resourceMap.getString("PreviouslyLabel.text", new Object[0]));
        this.PreviouslyLabel.setName("PreviouslyLabel");
        this.GoodOrBadLabel.setText(resourceMap.getString("GoodOrBadLabel.text", new Object[0]));
        this.GoodOrBadLabel.setName("GoodOrBadLabel");
        this.PreviousCharDBScroll.setName("PreviousCharDBScroll");
        this.PreviousCharDBScroll.setPreferredSize(new Dimension(447, 402));
        this.PreviousCharDBTable.setModel(this);
        this.PreviousCharDBTable.setName("PreviousCharDBTable");
        this.PreviousCharDBTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                CharacterTestPanel.this.PreviousCharDBTableMouseClicked(evt);
            }
        });
        this.PreviousCharDBScroll.setViewportView(this.PreviousCharDBTable);
        this.PreviousPinyinsLabel.setText(resourceMap.getString("PreviousPinyinsLabel.text", new Object[0]));
        this.PreviousPinyinsLabel.setName("PreviousPinyinsLabel");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.CharacterLabel, -2, 131, -2).addGap(32, 32, 32).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.PreviouslyLabel).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.GoodOrBadLabel, -2, 35, -2).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.PreviousCharacterLabel, -2, 72, -2))).addGap(8, 8, 8).addComponent(this.PreviousPinyinsLabel)).addComponent(this.DoneGuessCharacterButton, -2, 81, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.PreviousCharDBScroll, -1, 207, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.PinyinsLabel, GroupLayout.Alignment.TRAILING).addComponent(this.PinyinsLabel1, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.GuessPinyinTextField, -1, 284, Short.MAX_VALUE).addComponent(this.GuessChineseTextField, -1, 284, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.CharacterLabel, -2, 128, -2).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.PinyinsLabel).addComponent(this.GuessPinyinTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.PinyinsLabel1).addComponent(this.GuessChineseTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.DoneGuessCharacterButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.PreviousCharacterLabel, -2, 71, -2).addComponent(this.PreviouslyLabel))).addGroup(layout.createSequentialGroup().addGap(35, 35, 35).addComponent(this.PreviousCharDBScroll, -1, 117, Short.MAX_VALUE))).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(52, 52, 52).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(77, 77, 77).addComponent(this.GoodOrBadLabel, -2, 34, -2)).addComponent(this.PreviousPinyinsLabel, -2, 14, -2))))))));
    }

    private void DoneGuessCharacterButton_action(ActionEvent evt) {
        this.check_old_data();
        this.set_new_character_to_guess();
        this.GuessPinyinTextField.requestFocus();
    }

    private void PreviousCharDBTableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            int row = this.PreviousCharDBTable.getSelectedRow();
            String chinese_word = this.chinese_word_list.get(row);
            this.parent_app.edit_word(chinese_word);
        }
    }

    private void GuessChineseTextFieldFocusLost(FocusEvent evt) {
        this.GuessChineseTextField.getInputContext().selectInputMethod(Locale.getDefault());
    }

    private void GuessChineseTextFieldFocusGained(FocusEvent evt) {
        this.GuessChineseTextField.getInputContext().selectInputMethod(Locale.CHINA);
    }

    private void GuessPinyinTextFieldActionPerformed(ActionEvent evt) {
        this.DoneGuessCharacterButton_action(evt);
    }

    private void GuessChineseTextFieldActionPerformed(ActionEvent evt) {
        this.DoneGuessCharacterButton_action(evt);
    }

    @Override
    public int getRowCount() {
        return this.chinese_word_list.size();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex != 0) {
            return "column " + columnIndex + " ??";
        }
        return "Chinese Word";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int state = this.chinese_word_list_state.get(rowIndex);
        switch (state) {
            case 0: {
                return "<HTML><FONT COLOR=\"RED\">" + this.chinese_word_list.get(rowIndex) + "</FONT></HTML>";
            }
            case 1: {
                return "<HTML><FONT COLOR=\"GREEN\">" + this.chinese_word_list.get(rowIndex) + "</FONT></HTML>";
            }
            case 2: {
                return this.chinese_word_list.get(rowIndex);
            }
        }
        return "??";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }
}

