/*
 * Decompiled with CFR 0.152.
 */
package hanzitrainer;

import hanzitrainer.HanziDB;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PinyinChooserFrame
extends JPanel
implements DocumentListener {
    private ArrayList<JComponent> entry_list;
    private int number_of_boxes;
    private FlowLayout panel_layout;
    private JScrollPane scroller_container;
    private int entry_length;
    private JTextArea to_update = null;
    private HanziDB database;

    public PinyinChooserFrame(JScrollPane scroller, HanziDB db, JTextArea log) {
        this.scroller_container = scroller;
        this.entry_list = new ArrayList();
        this.number_of_boxes = 0;
        this.panel_layout = new FlowLayout(0);
        this.setLayout(this.panel_layout);
        this.to_update = log;
        this.entry_length = 0;
        this.database = db;
    }

    public PinyinChooserFrame(JScrollPane scroller, HanziDB db) {
        this.scroller_container = scroller;
        this.entry_list = new ArrayList();
        this.number_of_boxes = 0;
        this.panel_layout = new FlowLayout(0);
        this.setLayout(this.panel_layout);
        this.entry_length = 0;
        this.database = db;
    }

    private void debuglog(String log) {
        if (this.to_update != null) {
            this.to_update.append(log);
        }
    }

    private Boolean is_chinese_char(String input) {
        if (input.codePointCount(0, input.length()) != 1) {
            return false;
        }
        int entry = input.codePointAt(0);
        if (entry >= 19968 && entry <= 40959) {
            return true;
        }
        return false;
    }

    private void add_item(int index, String entry) {
        if (this.is_chinese_char(entry).booleanValue()) {
            ArrayList<String> possibilities = this.database.get_pinyin_from_character(entry);
            this.add_combo_box(index, possibilities);
        } else {
            this.add_label(index, entry);
        }
    }

    private void add_combo_box(int index, ArrayList<String> content) {
        JComboBox<String> temp_box = new JComboBox<String>();
        for (int i = 0; i < content.size(); ++i) {
            temp_box.addItem(content.get(i));
        }
        temp_box.setEditable(true);
        this.entry_list.add(index, temp_box);
        ++this.number_of_boxes;
        this.update_layout();
    }

    private void add_label(int index, String content) {
        JLabel temp_label = new JLabel();
        temp_label.setText(content);
        this.entry_list.add(index, temp_label);
        ++this.number_of_boxes;
        this.update_layout();
    }

    private void remove_combo_box(int index) {
        JComponent item = this.entry_list.get(index);
        this.entry_list.remove(index);
        --this.number_of_boxes;
        this.update_layout();
        this.panel_layout.removeLayoutComponent(item);
    }

    public ArrayList<String> get_pinyins() {
        ArrayList<String> res = new ArrayList<String>();
        for (int i = 0; i < this.number_of_boxes; ++i) {
            if (this.entry_list.get(i) instanceof JLabel) continue;
            JComboBox box = (JComboBox)this.entry_list.get(i);
            String selected = (String)box.getSelectedItem();
            res.add(selected);
        }
        return res;
    }

    private void update_layout() {
        this.removeAll();
        for (int i = 0; i < this.number_of_boxes; ++i) {
            this.add(this.entry_list.get(i));
        }
        this.scroller_container.setViewportView(this);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        Document doc = e.getDocument();
        e.getChange(e.getDocument().getDefaultRootElement());
        try {
            String inserted = doc.getText(e.getOffset(), e.getLength());
            if (Character.isWhitespace(inserted.codePointAt(e.getLength() - 1))) {
                this.debuglog("not yet\n");
            } else {
                int i;
                if (e.getOffset() > this.entry_length) {
                    this.debuglog("inserted " + (e.getOffset() - this.entry_length) + " spaces\n");
                    for (i = 0; i < e.getOffset() - this.entry_length; ++i) {
                        this.add_label(e.getOffset(), new String(" "));
                    }
                }
                for (i = e.getLength() - 1; i >= 0; --i) {
                    this.add_item(e.getOffset(), doc.getText(e.getOffset() + i, 1));
                }
                this.debuglog("inserted " + e.getLength() + " long, at " + e.getOffset() + " added [" + doc.getText(e.getOffset(), e.getLength()) + "]\n");
                this.entry_length = doc.getLength();
            }
        }
        catch (BadLocationException ex) {
            this.debuglog("bad location !\n");
            Logger.getLogger(PinyinChooserFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc.getLength() == this.entry_length) {
            this.debuglog("no change\n");
        } else {
            this.debuglog(doc.getLength() + " != " + this.entry_length + "\n");
            this.entry_length = doc.getLength();
            try {
                this.debuglog("removed " + e.getLength() + " long, at " + e.getOffset() + " now [" + doc.getText(0, doc.getLength()) + "]\n");
                for (int i = 0; i < e.getLength(); ++i) {
                    this.remove_combo_box(e.getOffset());
                }
            }
            catch (BadLocationException ex) {
                this.debuglog("bad location !\n");
                Logger.getLogger(PinyinChooserFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

