/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;

public class JdbcSQLException
extends SQLException {
    private static final long serialVersionUID = -8200821788226954151L;
    private final String originalMessage;
    private final Throwable cause;
    private final String stackTrace;
    private String message;
    private String sql;
    private volatile Object payload;

    public JdbcSQLException(String string, String string2, String string3, int n, Throwable throwable, String string4) {
        super(string, string3, n);
        this.originalMessage = string;
        this.sql = string2;
        this.cause = throwable;
        this.stackTrace = string4;
        this.buildMessage();
        this.initCause(throwable);
    }

    public String getMessage() {
        return this.message;
    }

    public String getOriginalMessage() {
        return this.originalMessage;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintWriter printWriter) {
        if (printWriter != null) {
            super.printStackTrace(printWriter);
            SQLException sQLException = this.getNextException();
            for (int n = 0; n < 100 && sQLException != null; sQLException = sQLException.getNextException(), ++n) {
                printWriter.println(sQLException.toString());
            }
            if (sQLException != null) {
                printWriter.println("(truncated)");
            }
        }
    }

    public void printStackTrace(PrintStream printStream) {
        if (printStream != null) {
            super.printStackTrace(printStream);
            SQLException sQLException = this.getNextException();
            for (int n = 0; n < 100 && sQLException != null; sQLException = sQLException.getNextException(), ++n) {
                printStream.println(sQLException.toString());
            }
            if (sQLException != null) {
                printStream.println("(truncated)");
            }
        }
    }

    public Throwable getOriginalCause() {
        return this.cause;
    }

    public String getSQL() {
        return this.sql;
    }

    public void setSQL(String string) {
        this.sql = string;
        this.buildMessage();
    }

    private void buildMessage() {
        StringBuffer stringBuffer = new StringBuffer(this.originalMessage == null ? "- " : this.originalMessage);
        if (this.sql != null) {
            stringBuffer.append("; SQL statement:\n");
            stringBuffer.append(this.sql);
        }
        stringBuffer.append(" [");
        stringBuffer.append(this.getErrorCode());
        stringBuffer.append('-');
        stringBuffer.append(106);
        stringBuffer.append(']');
        this.message = stringBuffer.toString();
    }

    public String toString() {
        if (this.stackTrace == null) {
            return super.toString();
        }
        return this.stackTrace;
    }

    public Object getPayload() {
        return this.payload;
    }

    public void setPayload(Object object) {
        this.payload = object;
    }
}

