/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.store.DataPage;
import org.h2.store.PageInputStream;
import org.h2.store.PageOutputStream;
import org.h2.store.PageStore;
import org.h2.util.BitField;
import org.h2.value.Value;

public class PageLog {
    private static final int UNDO = 0;
    private static final int COMMIT = 1;
    private static final int ADD = 2;
    private static final int REMOVE = 3;
    private PageStore store;
    private BitField undo = new BitField();
    private DataOutputStream out;
    private int firstPage;
    private DataPage data;
    private boolean recoveryRunning;

    PageLog(PageStore pageStore, int n) {
        this.store = pageStore;
        this.firstPage = n;
        this.data = pageStore.createDataPage();
    }

    void openForWriting() {
        this.out = new DataOutputStream(new PageOutputStream(this.store, 0, this.firstPage, 5));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover(boolean bl) throws SQLException {
        System.out.println("=recover= " + bl);
        DataInputStream dataInputStream = new DataInputStream(new PageInputStream(this.store, 0, this.firstPage, 5));
        DataPage dataPage = this.store.createDataPage();
        try {
            int n;
            this.recoveryRunning = true;
            while ((n = dataInputStream.read()) >= 0) {
                int n2;
                if (n == 0) {
                    n2 = dataInputStream.readInt();
                    System.out.println("redo " + n2);
                    dataInputStream.read(dataPage.getBytes(), 0, this.store.getPageSize());
                    if (!bl) continue;
                    this.store.writePage(n2, dataPage);
                    continue;
                }
                if (n == 2 || n == 3) {
                    n2 = dataInputStream.readInt();
                    int n3 = dataInputStream.readInt();
                    Row row = this.readRow(dataInputStream);
                    System.out.println((n == 2 ? " add" : " remove") + " " + n3 + " " + row);
                    Database database = this.store.getDatabase();
                    if (bl) continue;
                    database.redo(n3, row, n == 2);
                    continue;
                }
                if (n != 1) continue;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println("recovery stopped: " + iOException.toString());
        }
        finally {
            this.recoveryRunning = false;
        }
    }

    private Row readRow(DataInputStream dataInputStream) throws IOException, SQLException {
        int n = dataInputStream.readInt();
        this.data.reset();
        this.data.checkCapacity(n);
        dataInputStream.read(this.data.getBytes(), 0, n);
        int n2 = this.data.readInt();
        Value[] valueArray = new Value[n2];
        for (int i = 0; i < n2; ++i) {
            valueArray[i] = this.data.readValue();
        }
        Row row = new Row(valueArray, 0);
        return row;
    }

    public void addUndo(int n, DataPage dataPage) throws SQLException {
        try {
            if (this.undo.get(n)) {
                return;
            }
            System.out.println("undo " + n);
            this.out.write(0);
            this.out.writeInt(n);
            this.out.write(dataPage.getBytes(), 0, this.store.getPageSize());
            this.undo.set(n);
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, "recovering");
        }
    }

    public void commit(Session session) throws SQLException {
        try {
            System.out.println("commit");
            this.out.write(1);
            this.out.writeInt(session.getId());
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, "recovering");
        }
    }

    public void addOrRemoveRow(Session session, int n, Row row, boolean bl) throws SQLException {
        try {
            if (this.recoveryRunning) {
                return;
            }
            System.out.println("  " + (bl ? "+" : "-") + " tab:" + n + " " + row);
            this.out.write(bl ? 2 : 3);
            this.out.writeInt(session.getId());
            this.out.writeInt(n);
            this.data.reset();
            row.write(this.data);
            this.out.writeInt(this.data.length());
            this.out.write(this.data.getBytes(), 0, this.data.length());
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    void reopen() throws SQLException {
        try {
            this.out.close();
            this.openForWriting();
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }
}

