/*
 * Decompiled with CFR 0.152.
 */
package hanzitrainer;

import hanzitrainer.HanziDB;
import hanzitrainer.PinyinParser;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class CDBTableFiller
extends AbstractTableModel {
    HanziDB db;

    public CDBTableFiller(HanziDB database) {
        this.db = database;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Character";
            }
            case 1: {
                return "Pinyin";
            }
            case 2: {
                return "Chinese words";
            }
            case 3: {
                return "Score";
            }
        }
        return "column " + column + "???";
    }

    public int getRowCount() {
        int res = this.db.get_number_characters();
        return res;
    }

    public int getColumnCount() {
        return 4;
    }

    public Object getValueAt(int row, int column) {
        String pinyin_list = "";
        String cword_list = "";
        if (this.getRowCount() == 0) {
            return "";
        }
        int id = this.db.get_character_id(row);
        switch (column) {
            case 0: {
                return this.db.get_character_details(id);
            }
            case 1: {
                ArrayList<String> pinyins = this.db.get_pinyin_for_character(this.db.get_character_details(id));
                pinyin_list = PinyinParser.convert_to_printed_version(pinyins.get(0));
                for (int i = 1; i < pinyins.size(); ++i) {
                    pinyin_list = pinyin_list + ", " + PinyinParser.convert_to_printed_version(pinyins.get(i));
                }
                return pinyin_list;
            }
            case 2: {
                ArrayList<ArrayList<String>> cwords = this.db.get_words_with_character(this.db.get_character_details(id));
                cword_list = cwords.get(0).get(0);
                for (int i = 1; i < cwords.size(); ++i) {
                    cword_list = cword_list + ", " + cwords.get(i).get(0);
                }
                return cword_list;
            }
            case 3: {
                return this.db.get_character_score(id);
            }
        }
        return "(" + row + "," + column + ") ?";
    }
}

