/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

/*
 *     Code to test the byte order used by your
 *     processor.
*/

#include<stdio.h>
#include<assert.h>
#define CONFIG_H "./src/config.h"

int main(void)
{ 
  union {
    unsigned char cc[4]; 
    unsigned short s[2];
    unsigned long  n;
  } u;
  int little_endian;
  FILE* pf;

  u.n = 0x12345678;
  little_endian = ( u.s[0] == 0x5678 &&  u.s[1] == 0x1234 && u.cc[0] == 0x78 &&
		   u.cc[1] == 0x56   && u.cc[2] == 0x34   && u.cc[3] == 0x12);
  assert ( (pf = fopen (CONFIG_H, "w")) != NULL );
  if ( (little_endian) )
    fprintf (pf, "#ifndef _CONFIG_H_\n#define _CONFIG_H_\n\n"
	     "#define XLITTLE_ENDIAN  1\n\n#endif\n");
  else
    fprintf (pf, "#ifndef _CONFIG_H_\n#define _CONFIG_H_\n\n"
	     "#define XBIG_ENDIAN  1\n\n#endif\n");
  assert ( fclose(pf) == 0 );
  return 0;
}
