/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

#include<stdio.h>
#include<string.h>

/* The macros VERSION, IPATH and LPATH are directly defined on the */
/* command line to the compiler.                                   */

#ifndef VERSION
#define VERSION "unknown"
#endif

#ifndef IPATH
#define IPATH ""
#endif

#ifndef LPATH
#define LPATH ""
#endif

/* Possible options: -v, -c, -l, -n */

int main (int argc, char* argv[])
{
  int i;
  unsigned char flag = 0;
  unsigned char v, c, l, n;

  if ( argc == 1)
    {
      fprintf (stderr, "*** Usage:  hpaconf [-v] [-n] or\n");
      fprintf (stderr, "***         hpaconf [-c] [-l] [-n]\n\n");
      fprintf (stderr, "*** Meaning of the options:\n");
      fprintf (stderr, "    -v      return the current version of the HPA library\n");
      fprintf (stderr, "    -c      return flags to compile using HPA library\n");
      fprintf (stderr, "    -l      return flags to link  against HPA library\n");
      fprintf (stderr, "    -n      insert a newline at the end\n\n");
      return 0;
    }
  else if ( argc > 5 )
    {
      fprintf (stderr, "*** Usage:  hpaconf [-v] [-n] or\n");
      fprintf (stderr, "***         hpaconf [-c] [-l] [-n]\n\n");
      return 1;
    }
  else
    {
      for (i=1; i<argc; i++)
	{
	  if ( strcmp ("-v", argv[i]) == 0 )
	    {
	      if (flag != 0 && flag != 8)
		{
		  fprintf (stderr, "*** Usage:  hpaconf [-v] [-n] or\n");
		  fprintf (stderr, "***         hpaconf [-c] [-l] [-n]\n\n");
		  return 1;
		}
	      else
		flag += 1;
	    }
	  else if ( strcmp ("-c", argv[i]) == 0 )
	    {
	      if ((flag % 2 == 1) || ((flag >> 1) % 2 == 1))
		{
		  fprintf (stderr, "*** Usage:  hpaconf [-v] [-n] or\n");
		  fprintf (stderr, "***         hpaconf [-c] [-l] [-n]\n\n");
		  return 1;
		}
	      else
		flag += 2;
	    }
	  else if ( strcmp ("-l", argv[i]) == 0 )
	    {
	      if ((flag % 2 == 1) || ((flag >> 2) % 2 == 1))
		{
		  fprintf (stderr, "*** Usage:  hpaconf [-v] [-n] or\n");
		  fprintf (stderr, "***         hpaconf [-c] [-l] [-n]\n\n");
		  return 1;
		}
	      else
		flag += 4;
	    }
	  else if ( strcmp ("-n", argv[i]) == 0 )
	    {
	      if ((flag >> 3) % 2 == 1)
		{
		  fprintf (stderr, "*** Usage:  hpaconf [-v] [-n] or\n");
		  fprintf (stderr, "***         hpaconf [-c] [-l] [-n]\n\n");
		  return 1;
		}
	      else
		flag += 8;
	    }
	  else
	    {
	      fprintf (stderr, "*** Usage:  hpaconf [-v] [-n] or\n");
	      fprintf (stderr, "***         hpaconf [-c] [-l] [-n]\n\n");
	      return 1;
	    }
	} /* end for */
      v = flag % 2;
      c = (flag >> 1) % 2;
      l = (flag >> 2) % 2;
      n = (flag >> 3) % 2;
      if ( (v) )
	printf (VERSION);
      if ( (c) )
	{
	  printf (IPATH);
	  putchar (' ');
	}
      if ( (l) )
	{
	  printf (LPATH);
	  putchar (' ');
	  printf ("-lhpa -lm");
	}
      if ( (n) )
	printf("\n");
      else
	fflush (stdout);
      return 0;
    } /* end else */
} 
