/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

#include<ctype.h>
#include "xpre.h"

#define UPPER_BOUND  (MAX_X10EX + 100)

struct xpr str2x (const char* q, char** endptr)
{
  struct xpr s, f;
  unsigned short pc[XDIM+1];
  unsigned short *pn,*pf,*pa,*pb;
  unsigned short sfg, ibex, fbex;
  unsigned long n; 
  long j;
  int idex = 0, fdex = 0, c, m;
  short noip, nofp;
  const char* ptr;
  
  pn=(unsigned short *)&s;
  pf=(unsigned short *)&f;
  for(j=0; j<=XDIM ; pn[j]=pf[j]=pc[j]=0, ++j);
  sfg=0; m=XDIM+1;
  if ( (endptr) )
    *endptr = (char*)q;
  /* Skip the leading spaces if there are some */
  while ( (isspace(*q)) )  q++;
  /* Sign */
  if(*q=='+') 
    ++q;
  else if(*q=='-')
    { 
      sfg=0x8000; 
      ++q;
    }
  /* Integer part */
  for(ptr = q; (c= *q - '0') >= 0 && c <= 9; ++q)
    {
      if(pn[0])
	++idex;
      else
	{
	  lshift(1,pn,m);
	  for(j=0; j<m ;++j) pc[j]=pn[j];
	  lshift(2,pn,m);
	  for(n=(unsigned int)c, pa=pn+XDIM, pb=pc+XDIM; 
	      pa>=pn ; pa--, pb--)
	    {
	      n  += *pa + *pb; 
	      *pa = n; 
	      n >>=16;
	    }
	}
    }
  for(j=0; j<m && pn[j]==0 ;++j);
  if(j==m)
    ibex = 0;
  else
    {
      ibex=bias+max_p-1;
      if(j){ j<<=4; ibex-=j; lshift(j,pn,m);}
      while(pn[0]){ rshift(1,pn,m); ++ibex;}
      pn[0]= ibex|sfg;
    }
  noip = ptr == q; 
  /* End Integer part */
  if ( *q == '.' )
    {
      /* Fractionary part */
      for(j=0; j<=XDIM ;++j) pc[j]=0;
      for( ptr = ++q; (c= *q - '0') >= 0 && c <= 9 && pf[0] == 0; --fdex, ++q)
	{
	  lshift(1,pf,m);
	  for(j=0; j<m ;++j) pc[j]=pf[j];
	  lshift(2,pf,m);
	  for(n=(unsigned int)c, pa=pf+XDIM, pb=pc+XDIM; 
	      pa>=pf ; pa--, pb--)
	    {
	      n  += *pa + *pb; 
	      *pa = n; 
	      n >>=16;
	    }
	}
      for(j=0; j<m && pf[j]==0 ;++j);
      if(j==m)
	fbex = 0;
      else
	{
	  fbex=bias+max_p-1;
	  if(j){ j<<=4; fbex-=j; lshift(j,pf,m);}
	  while(pf[0]){ rshift(1,pf,m); ++fbex;}
	  pf[0]= fbex|sfg;
	}
      nofp = ptr == q;
    } /* end if (*q == '.') */
  else
    nofp = 1;
  if ( (noip) && (nofp) )
    /* Error !*/
    return zero;
  else
    {
      if ( (endptr) )
	*endptr = (char*)q;
    }
  /* Exponent */
  if(*q=='e' || *q=='E')
    {
      ++q; sfg=0;
      if(*q=='+') 
	++q;
      else if(*q=='-')
	{ 
	  sfg=1; 
	  ++q;
	}
      for(ptr = q, j=0; (c= *q - '0') >= 0 && c <= 9 
	    && j <= UPPER_BOUND; ++q)
	{
	  j<<=1; 
	  m = j; 
	  j<<=2; 
	  j+= c+m;
	}
      if (ptr != q && (endptr))
	*endptr = (char*)q;
      if(sfg) j= -j;
      idex+=j; fdex +=j;
    }
  if ( idex > MAX_X10EX || fdex > MAX_X10EX )
    return x_huge;
  else
    {
      if(idex) s=xmul(s,xpwr(ten,idex));
      if(fdex) f=xmul(f,xpwr(ten,fdex));
      return xadd (s, f, 0);
    }
}

struct xpr atox(const char *q)
{ 
  return str2x (q, NULL);
}
