/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

#include "xpre.h"

struct xpr xadd(struct xpr s,struct xpr t,int f)
{ 
  unsigned short pe[XDIM+1],*pa,*pb,*pc,*pf=pe,h,u;
  unsigned int n=0; short e,k;
  
  pa=(unsigned short *)&s; pb=(unsigned short *)&t;
  e= *pa&m_exp; k= *pb&m_exp; if(f) *pb^=m_sgn;
  u=(*pb ^ *pa)&m_sgn; f=0;
  if(e>k){ if((k=e-k)>=max_p) return s; rshift(k,pb+1,XDIM);}
  else if(e<k){ if((e=k-e)>=max_p) return t;
    rshift(e,pa+1,XDIM); e=k; pc=pa; pa=pb; pb=pc;}
  else if(u){ for(pc=pa,pf=pb; *++pc== *++pf && f<XDIM ;++f);
    if(f>=XDIM) return zero; if(*pc<*pf){ pc=pa; pa=pb; pb=pc;}
    pf=pe+f; }
  h= *pa&m_sgn;
  if(u){ for(pc=pb+XDIM; pc>pb ;--pc) *pc= ~(*pc); n=1L;}
  for(pc=pe+XDIM,pa+=XDIM,pb+=XDIM; pc>pf ;){
    n+= *pa--;  n+= *pb--; *pc-- =n; n>>=16;
   }
  if(u){ for(; *++pc==0 ;++f);
    for(k=0; !((*pc<<k)&m_sgn) ;++k);
    if(k+=16*f){ if((e-=k)<=0) return zero; lshift(k,pe+1,XDIM);}
   }
  else{ if(n){ if((++e)==(short)m_exp) return x_huge;
    rshift(1,++pf,XDIM); *pf|=m_sgn; }
   }
  *pe=e; *pe|=h; return *(struct xpr *)pe;
}
