/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

#include "xpre.h"

static struct xpr cs[52];

void xchcof(struct xpr *c,int m,struct xpr (*xfunc)(struct xpr))
{ 
  struct xpr a,b; int i,j,k,n;
  
  ++m; n=2*m;
  a=xdiv(pi2,inttox(m)); b=a; cs[0]=one;
  for(j=0; j<m ;++j) c[j]=zero;
  for(j=1; j<=n ;b=xadd(b,a,0),++j) cs[j]=xcos(b);
  for(j=1; j<n ;j+=2){
    a=(*xfunc)(cs[j]); c[0]=xadd(c[0],a,0);
    for(k=1; k<m ;++k){
      i=(k*j)%(2*n); if(i>n) i=2*n-i;
      c[k]=xadd(c[k],xmul(a,cs[i]),0);
     }
   }
  b=xpr2(xdiv(one,inttox(m)),1);
  for(j=0; j<m ;++j) c[j]=xmul(c[j],b);
}
