/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

#include "xpre.h"
#include <math.h>

struct xpr xatan(struct xpr z)
{ 
  struct xpr s,f; int k,m;
  
  if((k=xex(&z))<k_lin) return z;
  if(k>=bias){ z=xdiv(one,z); m=1;} else m=0;
  f=dbltox(atan(xtodbl(z)));
  s=xadd(one,xmul(z,z),0);
  for(k=0; k<itt_div ;++k)
    f=xadd(f,xdiv(xadd(z,xtan(f),1),s),0);
  if(m){ if(neg(&f)) return xadd(xneg(pi2),f,1);
     else return xadd(pi2,f,1); }
  else return f;
}

struct xpr xasin(struct xpr z)
{ 
  struct xpr u,xatan();

  if(xex(&z)<k_lin) return z;
  u=xsqrt(xadd(one,xmul(z,z),1));
  if(xex(&u)== -bias){
    if(neg(&z)) return xneg(pi2); else return pi2;}
  return xatan(xdiv(z,u));
}

struct xpr xacos(struct xpr z)
{ 
  struct xpr u,xatan();
  
  if(xex(&z)== -bias) return pi2;
  u=xsqrt(xadd(one,xmul(z,z),1)); u=xatan(xdiv(u,z));
  if(neg(&u)) return xadd(pi,u,0); else return u;
}
