/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

#include "xpre.h"

/*
  Modified by Ivano Primi - 11/21/2004
  Now 'pa' and 'pb' are pointers to constant structures.
*/

int xprcmp(const struct xpr *pa, const struct xpr *pb)
{ 
  unsigned short e,k,*p,*q; int m;
  
  p=(unsigned short *)pa; e= *p&m_sgn;
  q=(unsigned short *)pb; k= *q&m_sgn;
  if(e && !k) return -1; if(!e && k) return 1;
  if(e) m= -1; else m=1;
  e= *p&m_exp; k= *q&m_exp;
  if(e>k) return m; if(e<k) return -m;
  for(e=0; *++p== *++q && e<XDIM ;++e);
  if(e<XDIM){ if(*p> *q) return m; else return -m;}
  return 0;
}
