/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

#ifndef _XPRE_H_
#define _XPRE_H_

/* Modification done by Ivano Primi - 11/19/2004 */
#if XMANTISSA_SIZE == 11
#define XDIM 11
#elif XMANTISSA_SIZE == 15
#define XDIM 15
#elif XMANTISSA_SIZE == 19
#define XDIM 19
#elif XMANTISSA_SIZE == 23
#define XDIM 23
#elif XMANTISSA_SIZE == 27
#define XDIM 27
#elif XMANTISSA_SIZE == 31
#define XDIM 31
#else
/* We assume XMANTISSA_SIZE == 7 (default) */
#define XDIM 7
#endif

/* This macro has been added by Ivano Primi - 12/21/2004 */
#define MAX_X10EX  4931

#ifdef __cplusplus
extern "C" {
#endif

struct xpr {unsigned short nmm[XDIM+1];};

extern const unsigned short m_sgn,m_exp;
extern const short bias;
extern const int itt_div,k_tanh;
extern const int ms_exp,ms_trg,ms_hyp;
extern const short max_p,k_lin;
extern const short d_bias,d_max,d_lex;
extern const short f_bias,f_max,f_lex;
extern const struct xpr zero,one,two,ten;
extern const struct xpr x_huge;
extern const struct xpr pi,pi2,pi4;
extern const struct xpr ee,srt2,ln2;

struct xpr xadd(struct xpr a,struct xpr b,int k);
struct xpr xmul(struct xpr s,struct xpr t);
struct xpr xdiv(struct xpr s,struct xpr t);
/* str2x() has been added by Ivano Primi - 12/21/2004 */
struct xpr str2x (const char* q, char** endptr);
struct xpr atox(const char *s);
struct xpr dbltox(double y);
/* flttox() has been added by Ivano Primi - 11/22/2004 */
struct xpr flttox(float  y);
struct xpr inttox(long n);
int xprcmp(const struct xpr *p, const struct xpr *q);
int neg(struct xpr *p);
int xex(struct xpr *p);
struct xpr sfmod(struct xpr t,int *p);
struct xpr xpwr(struct xpr s,int n);
struct xpr xpr2(struct xpr s,int n);
struct xpr xneg(struct xpr s);
struct xpr xabs(struct xpr s);
struct xpr xfrex(struct xpr s,int *p);
struct xpr xfmod(struct xpr s,struct xpr t,int *p);
/* xfrac() and xtrunc() have been added by Ivano Primi - 12/11/2004 */
struct xpr xfrac  (struct xpr x);
struct xpr xtrunc (struct xpr x);
double xtodbl(struct xpr s);
/* xtoflt() has been added by Ivano Primi - 11/22/2004 */
float  xtoflt(struct xpr s);
struct xpr xtan(struct xpr x);
struct xpr xsin(struct xpr x);
struct xpr xcos(struct xpr x);
struct xpr xatan(struct xpr a);
struct xpr xasin(struct xpr a);
struct xpr xacos(struct xpr a);
struct xpr xsqrt(struct xpr u);
struct xpr xexp(struct xpr u);
struct xpr xlog(struct xpr u);
struct xpr xtanh(struct xpr v);
struct xpr xsinh(struct xpr v);
struct xpr xcosh(struct xpr v);
void xchcof(struct xpr *c,int m,struct xpr (*xfunc)(struct xpr));
struct xpr xevtch(struct xpr z,struct xpr *a,int m);
/* The following 4 functions have been added */
/* by Ivano Primi 11/29/2004                 */

#include<stdio.h>

void  print_xpr (FILE* stream, struct xpr u, int sc_not, int sign, int lim);
char* asprint_xpr (struct xpr u, int sc_not, int sign, int lim);
char* xtoa (struct xpr u,int lim);
void bxprint (FILE* stream, struct xpr u);
void prxpr(struct xpr u,int m);
void xprint(struct xpr u);
void lshift(int i,unsigned short *p,int k);
void rshift(int i,unsigned short *p,int k);

#ifdef __cplusplus
}
#endif
#endif /* _XPRE_H_ */
