/*
   Copyright (C)  2000    Daniel A. Atkinson
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

/*
    Test:  xexp

    Uses:  atox  xtodbl  xprcmp  xadd  prxpr
*/
#include <stdio.h>
#include "xpre.h"

int decd=30;

int main(void)
{ 
  struct xpr z,h,f,u;

  printf("     Test of Exp Function\n");
  z=xneg(one); 
  h=atox("0.5"); 
  u=atox("3.01");
  for(; xprcmp(&z,&u)<0 ;z=xadd(z,h,0))
    {
      /* compute extended precision exponential */
      f=xexp(z);
      printf(" %8.4f  ",xtodbl(z)); prxpr(f,decd);
    }
  return 0;
}
/*  Test output

     Test of Exp Function
  -1.0000    3.678794411714423215955237701615e-1
  -0.5000    6.065306597126334236037995349912e-1
  -0.0000    1.000000000000000000000000000000e+0
   0.5000    1.648721270700128146848650787814e+0
   1.0000    2.718281828459045235360287471503e+0
   1.5000    4.481689070338064822602055460119e+0
   2.0000    7.389056098930650227230427460985e+0
   2.5000    1.218249396070347343807017595117e+1
   3.0000    2.008553692318766774092852965570e+1
*/
