/*
   Copyright (C)  2000    Daniel A. Atkinson  <DanAtk@aol.com>
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

#include"cxpre.h"		/* Automatically includes "xpre.h" */

extern int x_sgn (struct xpr x);	/* see constant.c */

struct cxpr
cxsinh (struct cxpr z)
{
  struct cxpr w;

  w = cxsub (cxexp (z), cxexp (cxneg (z)));
  w.re = xpr2 (w.re, -1);
  w.im = xpr2 (w.im, -1);
  return w;
}

struct cxpr
cxcosh (struct cxpr z)
{
  struct cxpr w;

  w = cxsum (cxexp (z), cxexp (cxneg (z)));
  w.re = xpr2 (w.re, -1);
  w.im = xpr2 (w.im, -1);
  return w;
}

struct cxpr
cxtanh (struct cxpr z)
{
  if (xsigerr (xprcmp (&z.re, &xEmax) > 0, XFPOFLOW, NULL))
    return cxOne;
  else if (xsigerr (xprcmp (&z.re, &xEmin) < 0, XFPOFLOW, NULL))
    return cxneg (cxOne);
  else
    {
      struct cxpr w;

      if (xsigerr (!cxrec (cxcosh (z), &w), XEDOM, "cxtanh()"))
	return cxZero;
      else
	return cxmul (cxsinh (z), w);
    }
}

struct cxpr
cxasinh (struct cxpr z)
{
  struct cxpr w;
  struct xpr ls, rs;

  /* In this way, cxasinh() works fine also with real numbers */
  /* very near to -oo.                                       */
  w = cxsqrt (cxsum (cxOne, cxsqr (z)));
  ls = cxabs (cxsum (z, w));
  rs = xmul (xVSV, cxabs (z));
  if (xprcmp (&ls, &rs) < 0)
    return cxneg (cxlog (cxsub (w, z)));
  else
    return cxlog (cxsum (z, w));
}

struct cxpr
cxacosh (struct cxpr z)
{
  struct cxpr w;
  struct xpr ls, rs;

  w = cxsqrt (cxsub (cxsqr (z), cxOne));
  ls = cxabs (cxsum (z, w));
  rs = xmul (xVSV, cxabs (z));
  if (xprcmp (&ls, &rs) < 0)
    return cxneg (cxlog (cxsub (z, w)));
  else
    return cxlog (cxsum (z, w));
}

struct cxpr
cxatanh (struct cxpr z)
{
  struct cxpr w;
  int errcond;

  errcond = x_sgn (z.im) == 0 && x_sgn (xadd (xabs (z.re), xOne, 1)) == 0;
  if (xsigerr (errcond, XEDOM, "cxatanh()"))
    return cxZero;
  else
    {
      w = cxdiv (cxsum (cxOne, z), cxsub (cxOne, z));
      w = cxlog_sqrt (w);
      return w;
    }
}
