/*
   Copyright (C)  2000    Daniel A. Atkinson  <DanAtk@aol.com>
   Copyright (C)  2004    Ivano Primi  <ivano.primi@tin.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.
*/

/*
    Test:  xpr_print  xpr_asprint  xtoa

    Uses:  xpr_print  xpr_asprint  xtoa  atox  

    Input file:  data/prxpr.dat
*/

#include <stdio.h>
#include <stdlib.h>
#include "xpre.h"

#define BUFF_SIZE 5120		/* 5 Kb */
int decd = 30;

int
main (int na, char **av)
{
  struct xpr x;
  int i;
  char buffer[BUFF_SIZE];
  char *dyn_buff[16];
  FILE *fp;

  if (na != 2)
    {
      printf ("para: input_file\n");
      exit (-1);
    }
  fp = fopen (*++av, "r");
  printf ("     Test of Printing Functions\n");
  while (fgets (buffer, BUFF_SIZE, fp) != NULL)
    {
      for (i = 0; buffer[i] != '\0'; i++);
      if (i > 0 && buffer[i - 1] == '\n')
	buffer[i - 1] = '\0';
      printf ("buffer : %s\n", buffer);
      x = atox (buffer);
      xpr_print (stdout, x, 0, 0, -1);
      putchar ('\n');
      xpr_print (stdout, x, 0, 0, 6);
      putchar ('\n');
      xpr_print (stdout, x, 0, 0, decd);
      putchar ('\n');
      xpr_print (stdout, x, 0, 0, 160);
      putchar ('\n');
      xpr_print (stdout, x, 0, 1, -1);
      putchar ('\n');
      xpr_print (stdout, x, 0, 1, 6);
      putchar ('\n');
      xpr_print (stdout, x, 0, 1, decd);
      putchar ('\n');
      xpr_print (stdout, x, 0, 1, 160);
      putchar ('\n');
      xpr_print (stdout, x, 1, 0, -1);
      putchar ('\n');
      xpr_print (stdout, x, 1, 0, 6);
      putchar ('\n');
      xpr_print (stdout, x, 1, 0, decd);
      putchar ('\n');
      xpr_print (stdout, x, 1, 0, 160);
      putchar ('\n');
      xpr_print (stdout, x, 1, 1, -1);
      putchar ('\n');
      xpr_print (stdout, x, 1, 1, 6);
      putchar ('\n');
      xpr_print (stdout, x, 1, 1, decd);
      putchar ('\n');
      xpr_print (stdout, x, 1, 1, 160);
      putchar ('\n');
      dyn_buff[0] = xpr_asprint (x, 0, 0, -1);
      dyn_buff[1] = xpr_asprint (x, 0, 0, 6);
      dyn_buff[2] = xpr_asprint (x, 0, 0, decd);
      dyn_buff[3] = xpr_asprint (x, 0, 0, 160);
      dyn_buff[4] = xpr_asprint (x, 0, 1, -1);
      dyn_buff[5] = xpr_asprint (x, 0, 1, 6);
      dyn_buff[6] = xpr_asprint (x, 0, 1, decd);
      dyn_buff[7] = xpr_asprint (x, 0, 1, 160);
      dyn_buff[8] = xpr_asprint (x, 1, 0, -1);
      dyn_buff[9] = xpr_asprint (x, 1, 0, 6);
      dyn_buff[10] = xpr_asprint (x, 1, 0, decd);
      dyn_buff[11] = xpr_asprint (x, 1, 0, 160);
      dyn_buff[12] = xpr_asprint (x, 1, 1, -1);
      dyn_buff[13] = xpr_asprint (x, 1, 1, 6);
      dyn_buff[14] = xpr_asprint (x, 1, 1, decd);
      dyn_buff[15] = xpr_asprint (x, 1, 1, 160);
      for (i = 0; i < 16; i++)
	{
	  printf ("%s\n", dyn_buff[i]);
	  free ((void *) dyn_buff[i]);
	}
    }
  fclose (fp);
  return 0;
}

/*  Test output

     Test of Printing Functions
buffer : 0.000000000987654321
0.000000001
0.0000000009876543
0.0000000009876543210000000000000000000000
0.00000000098765432099999999999999999999997951303
+0.000000001
+0.0000000009876543
+0.0000000009876543210000000000000000000000
+0.00000000098765432099999999999999999999997951303
1.e-9
9.876543e-10
9.876543210000000000000000000000e-10
9.8765432099999999999999999999997951303e-10
+1.e-9
+9.876543e-10
+9.876543210000000000000000000000e-10
+9.8765432099999999999999999999997951303e-10
0.000000001
0.0000000009876543
0.0000000009876543210000000000000000000000
0.00000000098765432099999999999999999999997951303
+0.000000001
+0.0000000009876543
+0.0000000009876543210000000000000000000000
+0.00000000098765432099999999999999999999997951303
1.e-9
9.876543e-10
9.876543210000000000000000000000e-10
9.8765432099999999999999999999997951303e-10
+1.e-9
+9.876543e-10
+9.876543210000000000000000000000e-10
+9.8765432099999999999999999999997951303e-10
buffer : 0.0000987654321e-2
0.000001
0.0000009876543
0.0000009876543210000000000000000000000
0.00000098765432099999999999999999999998321081
+0.000001
+0.0000009876543
+0.0000009876543210000000000000000000000
+0.00000098765432099999999999999999999998321081
1.e-6
9.876543e-7
9.876543210000000000000000000000e-7
9.8765432099999999999999999999998321081e-7
+1.e-6
+9.876543e-7
+9.876543210000000000000000000000e-7
+9.8765432099999999999999999999998321081e-7
0.000001
0.0000009876543
0.0000009876543210000000000000000000000
0.00000098765432099999999999999999999998321081
+0.000001
+0.0000009876543
+0.0000009876543210000000000000000000000
+0.00000098765432099999999999999999999998321081
1.e-6
9.876543e-7
9.876543210000000000000000000000e-7
9.8765432099999999999999999999998321081e-7
+1.e-6
+9.876543e-7
+9.876543210000000000000000000000e-7
+9.8765432099999999999999999999998321081e-7
buffer : 1.23456789e-1
0.1
0.1234568
0.1234567890000000000000000000000
0.12345678899999999999999999999999974454
+0.1
+0.1234568
+0.1234567890000000000000000000000
+0.12345678899999999999999999999999974454
1.e-1
1.234568e-1
1.234567890000000000000000000000e-1
1.2345678899999999999999999999999974454e-1
+1.e-1
+1.234568e-1
+1.234567890000000000000000000000e-1
+1.2345678899999999999999999999999974454e-1
0.1
0.1234568
0.1234567890000000000000000000000
0.12345678899999999999999999999999974454
+0.1
+0.1234568
+0.1234567890000000000000000000000
+0.12345678899999999999999999999999974454
1.e-1
1.234568e-1
1.234567890000000000000000000000e-1
1.2345678899999999999999999999999974454e-1
+1.e-1
+1.234568e-1
+1.234567890000000000000000000000e-1
+1.2345678899999999999999999999999974454e-1
buffer : 1.23456789E0
1
1.234568
1.234567890000000000000000000000
1.2345678899999999999999999999999978306
+1
+1.234568
+1.234567890000000000000000000000
+1.2345678899999999999999999999999978306
1.e+0
1.234568e+0
1.234567890000000000000000000000e+0
1.2345678899999999999999999999999978306e+0
+1.e+0
+1.234568e+0
+1.234567890000000000000000000000e+0
+1.2345678899999999999999999999999978306e+0
1
1.234568
1.234567890000000000000000000000
1.2345678899999999999999999999999978306
+1
+1.234568
+1.234567890000000000000000000000
+1.2345678899999999999999999999999978306
1.e+0
1.234568e+0
1.234567890000000000000000000000e+0
1.2345678899999999999999999999999978306e+0
+1.e+0
+1.234568e+0
+1.234567890000000000000000000000e+0
+1.2345678899999999999999999999999978306e+0
buffer : 9.87654321000000000123456789
10
9.876543
9.876543210000000001234567890000
9.8765432100000000012345678899999564006
+10
+9.876543
+9.876543210000000001234567890000
+9.8765432100000000012345678899999564006
1.e+1
9.876543e+0
9.876543210000000001234567890000e+0
9.8765432100000000012345678899999564006e+0
+1.e+1
+9.876543e+0
+9.876543210000000001234567890000e+0
+9.8765432100000000012345678899999564006e+0
10
9.876543
9.876543210000000001234567890000
9.8765432100000000012345678899999564006
+10
+9.876543
+9.876543210000000001234567890000
+9.8765432100000000012345678899999564006
1.e+1
9.876543e+0
9.876543210000000001234567890000e+0
9.8765432100000000012345678899999564006e+0
+1.e+1
+9.876543e+0
+9.876543210000000001234567890000e+0
+9.8765432100000000012345678899999564006e+0
buffer : 1024
1000
1024.000
1024.000000000000000000000000000
1023.9999999999999999999999999999972451
+1000
+1024.000
+1024.000000000000000000000000000
+1023.9999999999999999999999999999972451
1.e+3
1.024000e+3
1.024000000000000000000000000000e+3
1.0239999999999999999999999999999972451e+3
+1.e+3
+1.024000e+3
+1.024000000000000000000000000000e+3
+1.0239999999999999999999999999999972451e+3
1000
1024.000
1024.000000000000000000000000000
1023.9999999999999999999999999999972451
+1000
+1024.000
+1024.000000000000000000000000000
+1023.9999999999999999999999999999972451
1.e+3
1.024000e+3
1.024000000000000000000000000000e+3
1.0239999999999999999999999999999972451e+3
+1.e+3
+1.024000e+3
+1.024000000000000000000000000000e+3
+1.0239999999999999999999999999999972451e+3
buffer : 1024.000012
1000
1024.000
1024.000012000000000000000000000
1024.0000119999999999999999999999957139
+1000
+1024.000
+1024.000012000000000000000000000
+1024.0000119999999999999999999999957139
1.e+3
1.024000e+3
1.024000012000000000000000000000e+3
1.0240000119999999999999999999999957139e+3
+1.e+3
+1.024000e+3
+1.024000012000000000000000000000e+3
+1.0240000119999999999999999999999957139e+3
1000
1024.000
1024.000012000000000000000000000
1024.0000119999999999999999999999957139
+1000
+1024.000
+1024.000012000000000000000000000
+1024.0000119999999999999999999999957139
1.e+3
1.024000e+3
1.024000012000000000000000000000e+3
1.0240000119999999999999999999999957139e+3
+1.e+3
+1.024000e+3
+1.024000012000000000000000000000e+3
+1.0240000119999999999999999999999957139e+3
buffer : 103256
100000
103256.0
103256.0000000000000000000000000
103255.99999999999999999999999999945447
+100000
+103256.0
+103256.0000000000000000000000000
+103255.99999999999999999999999999945447
1.e+5
1.032560e+5
1.032560000000000000000000000000e+5
1.0325599999999999999999999999999945447e+5
+1.e+5
+1.032560e+5
+1.032560000000000000000000000000e+5
+1.0325599999999999999999999999999945447e+5
100000
103256.0
103256.0000000000000000000000000
103255.99999999999999999999999999945447
+100000
+103256.0
+103256.0000000000000000000000000
+103255.99999999999999999999999999945447
1.e+5
1.032560e+5
1.032560000000000000000000000000e+5
1.0325599999999999999999999999999945447e+5
+1.e+5
+1.032560e+5
+1.032560000000000000000000000000e+5
+1.0325599999999999999999999999999945447e+5
buffer : 103256.12E+2
10000000
10325610
10325612.00000000000000000000000
10325611.999999999999999999999999920286
+10000000
+10325610
+10325612.00000000000000000000000
+10325611.999999999999999999999999920286
1.e+7
1.032561e+7
1.032561200000000000000000000000e+7
1.0325611999999999999999999999999920286e+7
+1.e+7
+1.032561e+7
+1.032561200000000000000000000000e+7
+1.0325611999999999999999999999999920286e+7
10000000
10325610
10325612.00000000000000000000000
10325611.999999999999999999999999920286
+10000000
+10325610
+10325612.00000000000000000000000
+10325611.999999999999999999999999920286
1.e+7
1.032561e+7
1.032561200000000000000000000000e+7
1.0325611999999999999999999999999920286e+7
+1.e+7
+1.032561e+7
+1.032561200000000000000000000000e+7
+1.0325611999999999999999999999999920286e+7
buffer : 987654321000123456789.008
1000000000000000000000
987654300000000000000
987654321000123456789.0080000000
987654321000123456789.00799999997551894
+1000000000000000000000
+987654300000000000000
+987654321000123456789.0080000000
+987654321000123456789.00799999997551894
1.e+21
9.876543e+20
9.876543210001234567890080000000e+20
9.8765432100012345678900799999997551894e+20
+1.e+21
+9.876543e+20
+9.876543210001234567890080000000e+20
+9.8765432100012345678900799999997551894e+20
1000000000000000000000
987654300000000000000
987654321000123456789.0080000000
987654321000123456789.00799999997551894
+1000000000000000000000
+987654300000000000000
+987654321000123456789.0080000000
+987654321000123456789.00799999997551894
1.e+21
9.876543e+20
9.876543210001234567890080000000e+20
9.8765432100012345678900799999997551894e+20
+1.e+21
+9.876543e+20
+9.876543210001234567890080000000e+20
+9.8765432100012345678900799999997551894e+20
buffer : -0.000000000987654321
-0.000000001
-0.0000000009876543
-0.0000000009876543210000000000000000000000
-0.00000000098765432099999999999999999999997951303
-0.000000001
-0.0000000009876543
-0.0000000009876543210000000000000000000000
-0.00000000098765432099999999999999999999997951303
-1.e-9
-9.876543e-10
-9.876543210000000000000000000000e-10
-9.8765432099999999999999999999997951303e-10
-1.e-9
-9.876543e-10
-9.876543210000000000000000000000e-10
-9.8765432099999999999999999999997951303e-10
-0.000000001
-0.0000000009876543
-0.0000000009876543210000000000000000000000
-0.00000000098765432099999999999999999999997951303
-0.000000001
-0.0000000009876543
-0.0000000009876543210000000000000000000000
-0.00000000098765432099999999999999999999997951303
-1.e-9
-9.876543e-10
-9.876543210000000000000000000000e-10
-9.8765432099999999999999999999997951303e-10
-1.e-9
-9.876543e-10
-9.876543210000000000000000000000e-10
-9.8765432099999999999999999999997951303e-10
buffer : -0.0000987654321e-2
-0.000001
-0.0000009876543
-0.0000009876543210000000000000000000000
-0.00000098765432099999999999999999999998321081
-0.000001
-0.0000009876543
-0.0000009876543210000000000000000000000
-0.00000098765432099999999999999999999998321081
-1.e-6
-9.876543e-7
-9.876543210000000000000000000000e-7
-9.8765432099999999999999999999998321081e-7
-1.e-6
-9.876543e-7
-9.876543210000000000000000000000e-7
-9.8765432099999999999999999999998321081e-7
-0.000001
-0.0000009876543
-0.0000009876543210000000000000000000000
-0.00000098765432099999999999999999999998321081
-0.000001
-0.0000009876543
-0.0000009876543210000000000000000000000
-0.00000098765432099999999999999999999998321081
-1.e-6
-9.876543e-7
-9.876543210000000000000000000000e-7
-9.8765432099999999999999999999998321081e-7
-1.e-6
-9.876543e-7
-9.876543210000000000000000000000e-7
-9.8765432099999999999999999999998321081e-7
buffer : -1.23456789e-1
-0.1
-0.1234568
-0.1234567890000000000000000000000
-0.12345678899999999999999999999999974454
-0.1
-0.1234568
-0.1234567890000000000000000000000
-0.12345678899999999999999999999999974454
-1.e-1
-1.234568e-1
-1.234567890000000000000000000000e-1
-1.2345678899999999999999999999999974454e-1
-1.e-1
-1.234568e-1
-1.234567890000000000000000000000e-1
-1.2345678899999999999999999999999974454e-1
-0.1
-0.1234568
-0.1234567890000000000000000000000
-0.12345678899999999999999999999999974454
-0.1
-0.1234568
-0.1234567890000000000000000000000
-0.12345678899999999999999999999999974454
-1.e-1
-1.234568e-1
-1.234567890000000000000000000000e-1
-1.2345678899999999999999999999999974454e-1
-1.e-1
-1.234568e-1
-1.234567890000000000000000000000e-1
-1.2345678899999999999999999999999974454e-1
buffer : -1.23456789E0
-1
-1.234568
-1.234567890000000000000000000000
-1.2345678899999999999999999999999978306
-1
-1.234568
-1.234567890000000000000000000000
-1.2345678899999999999999999999999978306
-1.e+0
-1.234568e+0
-1.234567890000000000000000000000e+0
-1.2345678899999999999999999999999978306e+0
-1.e+0
-1.234568e+0
-1.234567890000000000000000000000e+0
-1.2345678899999999999999999999999978306e+0
-1
-1.234568
-1.234567890000000000000000000000
-1.2345678899999999999999999999999978306
-1
-1.234568
-1.234567890000000000000000000000
-1.2345678899999999999999999999999978306
-1.e+0
-1.234568e+0
-1.234567890000000000000000000000e+0
-1.2345678899999999999999999999999978306e+0
-1.e+0
-1.234568e+0
-1.234567890000000000000000000000e+0
-1.2345678899999999999999999999999978306e+0
buffer : -9.87654321000000000123456789
-10
-9.876543
-9.876543210000000001234567890000
-9.8765432100000000012345678899999564006
-10
-9.876543
-9.876543210000000001234567890000
-9.8765432100000000012345678899999564006
-1.e+1
-9.876543e+0
-9.876543210000000001234567890000e+0
-9.8765432100000000012345678899999564006e+0
-1.e+1
-9.876543e+0
-9.876543210000000001234567890000e+0
-9.8765432100000000012345678899999564006e+0
-10
-9.876543
-9.876543210000000001234567890000
-9.8765432100000000012345678899999564006
-10
-9.876543
-9.876543210000000001234567890000
-9.8765432100000000012345678899999564006
-1.e+1
-9.876543e+0
-9.876543210000000001234567890000e+0
-9.8765432100000000012345678899999564006e+0
-1.e+1
-9.876543e+0
-9.876543210000000001234567890000e+0
-9.8765432100000000012345678899999564006e+0
buffer : -1024
-1000
-1024.000
-1024.000000000000000000000000000
-1023.9999999999999999999999999999972451
-1000
-1024.000
-1024.000000000000000000000000000
-1023.9999999999999999999999999999972451
-1.e+3
-1.024000e+3
-1.024000000000000000000000000000e+3
-1.0239999999999999999999999999999972451e+3
-1.e+3
-1.024000e+3
-1.024000000000000000000000000000e+3
-1.0239999999999999999999999999999972451e+3
-1000
-1024.000
-1024.000000000000000000000000000
-1023.9999999999999999999999999999972451
-1000
-1024.000
-1024.000000000000000000000000000
-1023.9999999999999999999999999999972451
-1.e+3
-1.024000e+3
-1.024000000000000000000000000000e+3
-1.0239999999999999999999999999999972451e+3
-1.e+3
-1.024000e+3
-1.024000000000000000000000000000e+3
-1.0239999999999999999999999999999972451e+3
buffer : -1024.000012
-1000
-1024.000
-1024.000012000000000000000000000
-1024.0000119999999999999999999999957139
-1000
-1024.000
-1024.000012000000000000000000000
-1024.0000119999999999999999999999957139
-1.e+3
-1.024000e+3
-1.024000012000000000000000000000e+3
-1.0240000119999999999999999999999957139e+3
-1.e+3
-1.024000e+3
-1.024000012000000000000000000000e+3
-1.0240000119999999999999999999999957139e+3
-1000
-1024.000
-1024.000012000000000000000000000
-1024.0000119999999999999999999999957139
-1000
-1024.000
-1024.000012000000000000000000000
-1024.0000119999999999999999999999957139
-1.e+3
-1.024000e+3
-1.024000012000000000000000000000e+3
-1.0240000119999999999999999999999957139e+3
-1.e+3
-1.024000e+3
-1.024000012000000000000000000000e+3
-1.0240000119999999999999999999999957139e+3
buffer : -103256
-100000
-103256.0
-103256.0000000000000000000000000
-103255.99999999999999999999999999945447
-100000
-103256.0
-103256.0000000000000000000000000
-103255.99999999999999999999999999945447
-1.e+5
-1.032560e+5
-1.032560000000000000000000000000e+5
-1.0325599999999999999999999999999945447e+5
-1.e+5
-1.032560e+5
-1.032560000000000000000000000000e+5
-1.0325599999999999999999999999999945447e+5
-100000
-103256.0
-103256.0000000000000000000000000
-103255.99999999999999999999999999945447
-100000
-103256.0
-103256.0000000000000000000000000
-103255.99999999999999999999999999945447
-1.e+5
-1.032560e+5
-1.032560000000000000000000000000e+5
-1.0325599999999999999999999999999945447e+5
-1.e+5
-1.032560e+5
-1.032560000000000000000000000000e+5
-1.0325599999999999999999999999999945447e+5
buffer : -103256.12E+2
-10000000
-10325610
-10325612.00000000000000000000000
-10325611.999999999999999999999999920286
-10000000
-10325610
-10325612.00000000000000000000000
-10325611.999999999999999999999999920286
-1.e+7
-1.032561e+7
-1.032561200000000000000000000000e+7
-1.0325611999999999999999999999999920286e+7
-1.e+7
-1.032561e+7
-1.032561200000000000000000000000e+7
-1.0325611999999999999999999999999920286e+7
-10000000
-10325610
-10325612.00000000000000000000000
-10325611.999999999999999999999999920286
-10000000
-10325610
-10325612.00000000000000000000000
-10325611.999999999999999999999999920286
-1.e+7
-1.032561e+7
-1.032561200000000000000000000000e+7
-1.0325611999999999999999999999999920286e+7
-1.e+7
-1.032561e+7
-1.032561200000000000000000000000e+7
-1.0325611999999999999999999999999920286e+7
buffer : -987654321000123456789.008
-1000000000000000000000
-987654300000000000000
-987654321000123456789.0080000000
-987654321000123456789.00799999997551894
-1000000000000000000000
-987654300000000000000
-987654321000123456789.0080000000
-987654321000123456789.00799999997551894
-1.e+21
-9.876543e+20
-9.876543210001234567890080000000e+20
-9.8765432100012345678900799999997551894e+20
-1.e+21
-9.876543e+20
-9.876543210001234567890080000000e+20
-9.8765432100012345678900799999997551894e+20
-1000000000000000000000
-987654300000000000000
-987654321000123456789.0080000000
-987654321000123456789.00799999997551894
-1000000000000000000000
-987654300000000000000
-987654321000123456789.0080000000
-987654321000123456789.00799999997551894
-1.e+21
-9.876543e+20
-9.876543210001234567890080000000e+20
-9.8765432100012345678900799999997551894e+20
-1.e+21
-9.876543e+20
-9.876543210001234567890080000000e+20
-9.8765432100012345678900799999997551894e+20
*/
