/*
   Copyright (C)  2000    Daniel A. Atkinson  <DanAtk@aol.com>
   Copyright (C)  2004    Ivano Primi  <ivprimi@libero.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
   02110-1301 USA.
*/

/*
    Test:  cxfout  cxout  cxsout

    Uses:  cxfout  cxout  cxsout  atocx  

    Input file:  data/cxout.dat
*/

#include <stdio.h>
#include <stdlib.h>
#include "cxpre.h"

#define BUFF_SIZE 5120		/* 5 Kb */
int decd = 30;

void
getflags (const char *buffer, struct xoutflags *pofs)
{
  sscanf (buffer, "%hi %hi %hi %hi %hi %c %c %c", &pofs->fmt, &pofs->notat,
	  &pofs->sf, &pofs->mfwd, &pofs->lim, &pofs->padding,
	  &pofs->ldel, &pofs->rdel);
}

int
main (int na, char **av)
{
  struct cxpr x;
  int i;
  char buffer[BUFF_SIZE];
  struct xoutflags ofs;
  unsigned long n;
  FILE *fp;

  if (na != 2)
    {
      printf ("para: input_file\n");
      exit (-1);
    }
  fp = fopen (*++av, "r");
  printf ("     Test of Special Printing Functions\n");
  while (fgets (buffer, BUFF_SIZE, fp) != NULL)
    {
      for (i = 0; buffer[i] != '\0'; i++);
      if (i > 0 && buffer[i - 1] == '\n')
	buffer[i - 1] = '\0';
      if (buffer[0] == '*')
	{
	  getflags (buffer + 1, &ofs);
	  printf ("* %hi %hi %hi %hi %hi %c %c %c\n", ofs.fmt, ofs.notat,
		  ofs.sf, ofs.mfwd, ofs.lim, ofs.padding, ofs.ldel, ofs.rdel);
	}
      else
	{
	  printf ("buffer : %s\n", buffer);
	  x = atocx (buffer);
	  printf ("\t\t <%2d>\n", cxfout (stdout, ofs, x));
	  printf ("\t\t <%2d>\n", cxout (ofs, x));
	  n = cxsout (buffer, 30, ofs, x);
	  printf ("%s\t\t <%2lu>\n", buffer, n);
	}
    }
  fclose (fp);
  return 0;
}

/*  Test output

     Test of Special Printing Functions
* 2 0 0 -1 -1 _ { }
buffer : 345.0067
{345.0067, 0.000000}		 < 0>
{345.0067, 0.000000}		 < 0>
{345.0067, 0.000000}		 <20>
buffer : -12.9807i
{0.000000, -12.98070}		 < 0>
{0.000000, -12.98070}		 < 0>
{0.000000, -12.98070}		 <21>
buffer : +1 -1.026e14i
{1.000000, -102600000000000}		 < 0>
{1.000000, -102600000000000}		 < 0>
{1.000000, -102600000000000}		 <28>
buffer : +3.045e-16i
{0.000000, 0.0000000000000003045000}		 < 0>
{0.000000, 0.0000000000000003045000}		 < 0>
{0.000000, }		 <36>
buffer : +17.000000000000023 -21.00000000000000000023i
{17.00000, -21.00000}		 < 0>
{17.00000, -21.00000}		 < 0>
{17.00000, -21.00000}		 <21>
* 2 0 0 -5 0 _ { }
buffer : 345.0067
{300__, 0.___}		 < 0>
{300__, 0.___}		 < 0>
{300__, 0.___}		 <14>
buffer : -12.9807i
{0.___, -10__}		 < 0>
{0.___, -10__}		 < 0>
{0.___, -10__}		 <14>
buffer : +1 -1.026e14i
{1____, -100000000000000}		 < 0>
{1____, -100000000000000}		 < 0>
{1____, -100000000000000}		 <25>
buffer : +3.045e-16i
{0.___, 0.0000000000000003}		 < 0>
{0.___, 0.0000000000000003}		 < 0>
{0.___, 0.0000000000000003}		 <27>
buffer : +17.000000000000023 -21.00000000000000000023i
{20___, -20__}		 < 0>
{20___, -20__}		 < 0>
{20___, -20__}		 <14>
* 2 0 0 -14 6 _ ( )
buffer : 345.0067
(345.0067______, 0.000000______)		 < 0>
(345.0067______, 0.000000______)		 < 0>
(345.0067______, )		 <32>
buffer : -12.9807i
(0.000000______, -12.98070_____)		 < 0>
(0.000000______, -12.98070_____)		 < 0>
(0.000000______, )		 <32>
buffer : +1 -1.026e14i
(1.000000______, -102600000000000)		 < 0>
(1.000000______, -102600000000000)		 < 0>
(1.000000______, )		 <34>
buffer : +3.045e-16i
(0.000000______, 0.0000000000000003045000)		 < 0>
(0.000000______, 0.0000000000000003045000)		 < 0>
(0.000000______, )		 <42>
buffer : +17.000000000000023 -21.00000000000000000023i
(17.00000______, -21.00000_____)		 < 0>
(17.00000______, -21.00000_____)		 < 0>
(17.00000______, )		 <32>
* 2 0 0 -1 13 _ ( )
buffer : 345.0067
(345.00670000000, 0.0000000000000)		 < 0>
(345.00670000000, 0.0000000000000)		 < 0>
(345.00670000000, )		 <34>
buffer : -12.9807i
(0.0000000000000, -12.980700000000)		 < 0>
(0.0000000000000, -12.980700000000)		 < 0>
(0.0000000000000, )		 <35>
buffer : +1 -1.026e14i
(1.0000000000000, -102600000000000)		 < 0>
(1.0000000000000, -102600000000000)		 < 0>
(1.0000000000000, )		 <35>
buffer : +3.045e-16i
(0.0000000000000, 0.00000000000000030450000000000)		 < 0>
(0.0000000000000, 0.00000000000000030450000000000)		 < 0>
(0.0000000000000, )		 <50>
buffer : +17.000000000000023 -21.00000000000000000023i
(17.000000000000, -21.000000000000)		 < 0>
(17.000000000000, -21.000000000000)		 < 0>
(17.000000000000, )		 <35>
* 2 0 0 -40 22 _ { }
buffer : 345.0067
{345.00670000000000000000________________, 0.0000000000000000000000________________}		 < 0>
{345.00670000000000000000________________, 0.0000000000000000000000________________}		 < 0>
{34}		 <84>
buffer : -12.9807i
{0.0000000000000000000000________________, -12.980700000000000000000_______________}		 < 0>
{0.0000000000000000000000________________, -12.980700000000000000000_______________}		 < 0>
{0.}		 <84>
buffer : +1 -1.026e14i
{1.0000000000000000000000________________, -102600000000000.00000000_______________}		 < 0>
{1.0000000000000000000000________________, -102600000000000.00000000_______________}		 < 0>
{1.}		 <84>
buffer : +3.045e-16i
{0.0000000000000000000000________________, 0.00000000000000030450000000000000000000}		 < 0>
{0.0000000000000000000000________________, 0.00000000000000030450000000000000000000}		 < 0>
{0.}		 <84>
buffer : +17.000000000000023 -21.00000000000000000023i
{17.000000000000023000000________________, -21.000000000000000000230_______________}		 < 0>
{17.000000000000023000000________________, -21.000000000000000000230_______________}		 < 0>
{17}		 <84>
* 2 0 0 0 4 _ ' '
buffer : 345.0067
'345.01, 0.0000'		 < 0>
'345.01, 0.0000'		 < 0>
'345.01, 0.0000'		 <16>
buffer : -12.9807i
'0.0000, -12.981'		 < 0>
'0.0000, -12.981'		 < 0>
'0.0000, -12.981'		 <17>
buffer : +1 -1.026e14i
'1.0000, -102600000000000'		 < 0>
'1.0000, -102600000000000'		 < 0>
'1.0000, -102600000000000'		 <26>
buffer : +3.045e-16i
'0.0000, 0.00000000000000030450'		 < 0>
'0.0000, 0.00000000000000030450'		 < 0>
'0.0000, '		 <32>
buffer : +17.000000000000023 -21.00000000000000000023i
'17.000, -21.000'		 < 0>
'17.000, -21.000'		 < 0>
'17.000, -21.000'		 <17>
* 2 0 0 10 4 _ { }
buffer : 345.0067
{____345.01, ____0.0000}		 < 0>
{____345.01, ____0.0000}		 < 0>
{____345.01, ____0.0000}		 <24>
buffer : -12.9807i
{____0.0000, ___-12.981}		 < 0>
{____0.0000, ___-12.981}		 < 0>
{____0.0000, ___-12.981}		 <24>
buffer : +1 -1.026e14i
{____1.0000, -102600000000000}		 < 0>
{____1.0000, -102600000000000}		 < 0>
{____1.0000, -102600000000000		 <30>
buffer : +3.045e-16i
{____0.0000, 0.00000000000000030450}		 < 0>
{____0.0000, 0.00000000000000030450}		 < 0>
{____0.0000, }		 <36>
buffer : +17.000000000000023 -21.00000000000000000023i
{____17.000, ___-21.000}		 < 0>
{____17.000, ___-21.000}		 < 0>
{____17.000, ___-21.000}		 <24>
* 2 0 0 20 6 #  
buffer : 345.0067
(############345.0067, ############0.000000)		 < 0>
(############345.0067, ############0.000000)		 < 0>
(############345.0067, )		 <44>
buffer : -12.9807i
(############0.000000, ###########-12.98070)		 < 0>
(############0.000000, ###########-12.98070)		 < 0>
(############0.000000, )		 <44>
buffer : +1 -1.026e14i
(############1.000000, ####-102600000000000)		 < 0>
(############1.000000, ####-102600000000000)		 < 0>
(############1.000000, )		 <44>
buffer : +3.045e-16i
(############0.000000, 0.0000000000000003045000)		 < 0>
(############0.000000, 0.0000000000000003045000)		 < 0>
(############0.000000, )		 <48>
buffer : +17.000000000000023 -21.00000000000000000023i
(############17.00000, ###########-21.00000)		 < 0>
(############17.00000, ###########-21.00000)		 < 0>
(############17.00000, )		 <44>
* 2 0 0 40 6 $ { }
buffer : 345.0067
{$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$345.0067, $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$0.000000}		 < 0>
{$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$345.0067, $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$0.000000}		 < 0>
{$$}		 <84>
buffer : -12.9807i
{$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$0.000000, $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$-12.98070}		 < 0>
{$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$0.000000, $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$-12.98070}		 < 0>
{$$}		 <84>
buffer : +1 -1.026e14i
{$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$1.000000, $$$$$$$$$$$$$$$$$$$$$$$$-102600000000000}		 < 0>
{$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$1.000000, $$$$$$$$$$$$$$$$$$$$$$$$-102600000000000}		 < 0>
{$$}		 <84>
buffer : +3.045e-16i
{$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$0.000000, $$$$$$$$$$$$$$$$0.0000000000000003045000}		 < 0>
{$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$0.000000, $$$$$$$$$$$$$$$$0.0000000000000003045000}		 < 0>
{$$}		 <84>
buffer : +17.000000000000023 -21.00000000000000000023i
{$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$17.00000, $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$-21.00000}		 < 0>
{$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$17.00000, $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$-21.00000}		 < 0>
{$$}		 <84>
* 2 0 1 20 3 ' ( )
buffer : 345.0067
(''''''''''''''+345.0, ''''''''''''''+0.000)		 < 0>
(''''''''''''''+345.0, ''''''''''''''+0.000)		 < 0>
(''''''''''''''+345.0, )		 <44>
buffer : -12.9807i
(''''''''''''''+0.000, ''''''''''''''-12.98)		 < 0>
(''''''''''''''+0.000, ''''''''''''''-12.98)		 < 0>
(''''''''''''''+0.000, )		 <44>
buffer : +1 -1.026e14i
(''''''''''''''+1.000, ''''-102600000000000)		 < 0>
(''''''''''''''+1.000, ''''-102600000000000)		 < 0>
(''''''''''''''+1.000, )		 <44>
buffer : +3.045e-16i
(''''''''''''''+0.000, +0.0000000000000003045)		 < 0>
(''''''''''''''+0.000, +0.0000000000000003045)		 < 0>
(''''''''''''''+0.000, )		 <46>
buffer : +17.000000000000023 -21.00000000000000000023i
(''''''''''''''+17.00, ''''''''''''''-21.00)		 < 0>
(''''''''''''''+17.00, ''''''''''''''-21.00)		 < 0>
(''''''''''''''+17.00, )		 <44>
* 2 1 0 20 3   
buffer : 345.0067
(            3.450e+2,             0.000e+0)		 < 0>
(            3.450e+2,             0.000e+0)		 < 0>
(            3.450e+2, )		 <44>
buffer : -12.9807i
(            0.000e+0,            -1.298e+1)		 < 0>
(            0.000e+0,            -1.298e+1)		 < 0>
(            0.000e+0, )		 <44>
buffer : +1 -1.026e14i
(            1.000e+0,           -1.026e+14)		 < 0>
(            1.000e+0,           -1.026e+14)		 < 0>
(            1.000e+0, )		 <44>
buffer : +3.045e-16i
(            0.000e+0,            3.045e-16)		 < 0>
(            0.000e+0,            3.045e-16)		 < 0>
(            0.000e+0, )		 <44>
buffer : +17.000000000000023 -21.00000000000000000023i
(            1.700e+1,            -2.100e+1)		 < 0>
(            1.700e+1,            -2.100e+1)		 < 0>
(            1.700e+1, )		 <44>
* 2 1 1 15 2 > { }
buffer : 345.0067
{>>>>>>>+3.45e+2, >>>>>>>+0.00e+0}		 < 0>
{>>>>>>>+3.45e+2, >>>>>>>+0.00e+0}		 < 0>
{>>>>>>>+3.45e+2, }		 <34>
buffer : -12.9807i
{>>>>>>>+0.00e+0, >>>>>>>-1.30e+1}		 < 0>
{>>>>>>>+0.00e+0, >>>>>>>-1.30e+1}		 < 0>
{>>>>>>>+0.00e+0, }		 <34>
buffer : +1 -1.026e14i
{>>>>>>>+1.00e+0, >>>>>>-1.03e+14}		 < 0>
{>>>>>>>+1.00e+0, >>>>>>-1.03e+14}		 < 0>
{>>>>>>>+1.00e+0, }		 <34>
buffer : +3.045e-16i
{>>>>>>>+0.00e+0, >>>>>>+3.04e-16}		 < 0>
{>>>>>>>+0.00e+0, >>>>>>+3.04e-16}		 < 0>
{>>>>>>>+0.00e+0, }		 <34>
buffer : +17.000000000000023 -21.00000000000000000023i
{>>>>>>>+1.70e+1, >>>>>>>-2.10e+1}		 < 0>
{>>>>>>>+1.70e+1, >>>>>>>-2.10e+1}		 < 0>
{>>>>>>>+1.70e+1, }		 <34>
* 1 0 0 40 6  { }
buffer : 345.0067
                                345.0067                                  0.000000		 < 0>
                                345.0067                                  0.000000		 < 0>
  		 <82>
buffer : -12.9807i
                                0.000000                                 -12.98070		 < 0>
                                0.000000                                 -12.98070		 < 0>
  		 <82>
buffer : +1 -1.026e14i
                                1.000000                          -102600000000000		 < 0>
                                1.000000                          -102600000000000		 < 0>
  		 <82>
buffer : +3.045e-16i
                                0.000000                  0.0000000000000003045000		 < 0>
                                0.000000                  0.0000000000000003045000		 < 0>
  		 <82>
buffer : +17.000000000000023 -21.00000000000000000023i
                                17.00000                                 -21.00000		 < 0>
                                17.00000                                 -21.00000		 < 0>
  		 <82>
* 1 0 1 20 3 ' ( )
buffer : 345.0067
''''''''''''''+345.0  ''''''''''''''+0.000		 < 0>
''''''''''''''+345.0  ''''''''''''''+0.000		 < 0>
''''''''''''''+345.0  		 <42>
buffer : -12.9807i
''''''''''''''+0.000  ''''''''''''''-12.98		 < 0>
''''''''''''''+0.000  ''''''''''''''-12.98		 < 0>
''''''''''''''+0.000  		 <42>
buffer : +1 -1.026e14i
''''''''''''''+1.000  ''''-102600000000000		 < 0>
''''''''''''''+1.000  ''''-102600000000000		 < 0>
''''''''''''''+1.000  		 <42>
buffer : +3.045e-16i
''''''''''''''+0.000  +0.0000000000000003045		 < 0>
''''''''''''''+0.000  +0.0000000000000003045		 < 0>
''''''''''''''+0.000  		 <44>
buffer : +17.000000000000023 -21.00000000000000000023i
''''''''''''''+17.00  ''''''''''''''-21.00		 < 0>
''''''''''''''+17.00  ''''''''''''''-21.00		 < 0>
''''''''''''''+17.00  		 <42>
* 1 1 0 20 3   
buffer : 345.0067
            3.450e+2              0.000e+0		 < 0>
            3.450e+2              0.000e+0		 < 0>
            3.450e+2  		 <42>
buffer : -12.9807i
            0.000e+0             -1.298e+1		 < 0>
            0.000e+0             -1.298e+1		 < 0>
            0.000e+0  		 <42>
buffer : +1 -1.026e14i
            1.000e+0            -1.026e+14		 < 0>
            1.000e+0            -1.026e+14		 < 0>
            1.000e+0  		 <42>
buffer : +3.045e-16i
            0.000e+0             3.045e-16		 < 0>
            0.000e+0             3.045e-16		 < 0>
            0.000e+0  		 <42>
buffer : +17.000000000000023 -21.00000000000000000023i
            1.700e+1             -2.100e+1		 < 0>
            1.700e+1             -2.100e+1		 < 0>
            1.700e+1  		 <42>
* 1 1 1 15 2 > { }
buffer : 345.0067
>>>>>>>+3.45e+2  >>>>>>>+0.00e+0		 < 0>
>>>>>>>+3.45e+2  >>>>>>>+0.00e+0		 < 0>
>>>>>>>+3.45e+2  		 <32>
buffer : -12.9807i
>>>>>>>+0.00e+0  >>>>>>>-1.30e+1		 < 0>
>>>>>>>+0.00e+0  >>>>>>>-1.30e+1		 < 0>
>>>>>>>+0.00e+0  		 <32>
buffer : +1 -1.026e14i
>>>>>>>+1.00e+0  >>>>>>-1.03e+14		 < 0>
>>>>>>>+1.00e+0  >>>>>>-1.03e+14		 < 0>
>>>>>>>+1.00e+0  		 <32>
buffer : +3.045e-16i
>>>>>>>+0.00e+0  >>>>>>+3.04e-16		 < 0>
>>>>>>>+0.00e+0  >>>>>>+3.04e-16		 < 0>
>>>>>>>+0.00e+0  		 <32>
buffer : +17.000000000000023 -21.00000000000000000023i
>>>>>>>+1.70e+1  >>>>>>>-2.10e+1		 < 0>
>>>>>>>+1.70e+1  >>>>>>>-2.10e+1		 < 0>
>>>>>>>+1.70e+1  		 <32>
* 0 0 0 40 6  { }
buffer : 345.0067
                                345.0067                               +0.000000i		 < 0>
                                345.0067                               +0.000000i		 < 0>
i		 <81>
buffer : -12.9807i
                                0.000000                               -12.98070i		 < 0>
                                0.000000                               -12.98070i		 < 0>
i		 <81>
buffer : +1 -1.026e14i
                                1.000000                        -102600000000000i		 < 0>
                                1.000000                        -102600000000000i		 < 0>
i		 <81>
buffer : +3.045e-16i
                                0.000000               +0.0000000000000003045000i		 < 0>
                                0.000000               +0.0000000000000003045000i		 < 0>
i		 <81>
buffer : +17.000000000000023 -21.00000000000000000023i
                                17.00000                               -21.00000i		 < 0>
                                17.00000                               -21.00000i		 < 0>
i		 <81>
* 0 0 1 20 3 ' ( )
buffer : 345.0067
''''''''''''''+345.0''''''''''''''+0.000i		 < 0>
''''''''''''''+345.0''''''''''''''+0.000i		 < 0>
''''''''''''''+345.0i		 <41>
buffer : -12.9807i
''''''''''''''+0.000''''''''''''''-12.98i		 < 0>
''''''''''''''+0.000''''''''''''''-12.98i		 < 0>
''''''''''''''+0.000i		 <41>
buffer : +1 -1.026e14i
''''''''''''''+1.000''''-102600000000000i		 < 0>
''''''''''''''+1.000''''-102600000000000i		 < 0>
''''''''''''''+1.000i		 <41>
buffer : +3.045e-16i
''''''''''''''+0.000+0.0000000000000003045i		 < 0>
''''''''''''''+0.000+0.0000000000000003045i		 < 0>
''''''''''''''+0.000i		 <43>
buffer : +17.000000000000023 -21.00000000000000000023i
''''''''''''''+17.00''''''''''''''-21.00i		 < 0>
''''''''''''''+17.00''''''''''''''-21.00i		 < 0>
''''''''''''''+17.00i		 <41>
* 0 1 0 20 3   
buffer : 345.0067
            3.450e+2           +0.000e+0i		 < 0>
            3.450e+2           +0.000e+0i		 < 0>
            3.450e+2i		 <41>
buffer : -12.9807i
            0.000e+0           -1.298e+1i		 < 0>
            0.000e+0           -1.298e+1i		 < 0>
            0.000e+0i		 <41>
buffer : +1 -1.026e14i
            1.000e+0          -1.026e+14i		 < 0>
            1.000e+0          -1.026e+14i		 < 0>
            1.000e+0i		 <41>
buffer : +3.045e-16i
            0.000e+0          +3.045e-16i		 < 0>
            0.000e+0          +3.045e-16i		 < 0>
            0.000e+0i		 <41>
buffer : +17.000000000000023 -21.00000000000000000023i
            1.700e+1           -2.100e+1i		 < 0>
            1.700e+1           -2.100e+1i		 < 0>
            1.700e+1i		 <41>
* 0 1 1 15 2 > { }
buffer : 345.0067
>>>>>>>+3.45e+2>>>>>>>+0.00e+0i		 < 0>
>>>>>>>+3.45e+2>>>>>>>+0.00e+0i		 < 0>
>>>>>>>+3.45e+2i		 <31>
buffer : -12.9807i
>>>>>>>+0.00e+0>>>>>>>-1.30e+1i		 < 0>
>>>>>>>+0.00e+0>>>>>>>-1.30e+1i		 < 0>
>>>>>>>+0.00e+0i		 <31>
buffer : +1 -1.026e14i
>>>>>>>+1.00e+0>>>>>>-1.03e+14i		 < 0>
>>>>>>>+1.00e+0>>>>>>-1.03e+14i		 < 0>
>>>>>>>+1.00e+0i		 <31>
buffer : +3.045e-16i
>>>>>>>+0.00e+0>>>>>>+3.04e-16i		 < 0>
>>>>>>>+0.00e+0>>>>>>+3.04e-16i		 < 0>
>>>>>>>+0.00e+0i		 <31>
buffer : +17.000000000000023 -21.00000000000000000023i
>>>>>>>+1.70e+1>>>>>>>-2.10e+1i		 < 0>
>>>>>>>+1.70e+1>>>>>>>-2.10e+1i		 < 0>
>>>>>>>+1.70e+1i		 <31>
*/
