/*
   Copyright (C)  2000    Daniel A. Atkinson  <DanAtk@aol.com>
   Copyright (C)  2004    Ivano Primi  <ivprimi@libero.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
   02110-1301 USA.
*/

/*
    Test:  strtocx  cxpr_asprint

    Input file:  data/str2cx.dat
*/
#include<stdio.h>
#include<stdlib.h>
#include"cxpre.h"

#define DECD 30

int
isNaN (const struct cxpr* z)
{
  int i, j;

  for (i=0; i <= XDIM && z->re.nmm[i] == xNaN.nmm[i]; i++);
  for (j=0; j <= XDIM && z->im.nmm[j] == xNaN.nmm[j]; j++);
  return (i > XDIM && j > XDIM ? 1 : 0);
}

int
get_line (char *buffer, int size, FILE * fp)
{
  if ((fgets (buffer, size, fp)))
    {
      int i;

      for (i = 0; buffer[i] != '\0'; i++);
      if (i > 0 && buffer[i - 1] == '\n')
	buffer[--i] = '\0';
      return i;
    }
  else
    return -1;
}

int
main (int na, char **av)
{
  struct cxpr z;
  FILE *fp;
  char num[256], *buffer;
  char *endptr;

  if (na != 2)
    {
      printf ("para: input_file\n");
      exit (-1);
    }
  fp = fopen (*++av, "r");
  while (get_line (num, 256, fp) != -1)
    {
      printf ("*string in : \"%s\"\n", num);

      /* convert ascii string to extended precision complex */
      z = strtocx (num, &endptr);
      printf (" endptr   : \"%s\"\n", endptr);
      if ((isNaN(&z)))
	printf (" NAN\n");
      else if (xprcmp (&z.re, &xPinf) == 0 || xprcmp (&z.im, &xPinf) == 0 ||
	       xprcmp (&z.re, &xMinf) == 0 || xprcmp (&z.im, &xMinf) == 0)
	printf (" OVERFLOW\n");
      else
	{
	  printf (" z =       ");
	  if ((buffer = cxpr_asprint (z, 1, 1, DECD)))
	    {
	      printf ("%s\n", buffer);
	      free ((void *) buffer);
	    }
	  else
	    printf ("*** Out of memory\n");
	}
    }
  fclose (fp);
  return 0;
}

/*  Test output

*string in : "0.0"
 endptr   : ""
 z =       +0.000000000000000000000000000000e+0+0.000000000000000000000000000000e+0i
*string in : "1.0"
 endptr   : ""
 z =       +1.000000000000000000000000000000e+0+0.000000000000000000000000000000e+0i
*string in : "1.0i"
 endptr   : ""
 z =       +0.000000000000000000000000000000e+0+1.000000000000000000000000000000e+0i
*string in : "+3.456e10"
 endptr   : ""
 z =       +3.456000000000000000000000000000e+10+0.000000000000000000000000000000e+0i
*string in : "3.567e10i"
 endptr   : ""
 z =       +0.000000000000000000000000000000e+0+3.567000000000000000000000000000e+10i
*string in : "-5.6897"
 endptr   : ""
 z =       -5.689700000000000000000000000000e+0+0.000000000000000000000000000000e+0i
*string in : "-6.78i"
 endptr   : ""
 z =       +0.000000000000000000000000000000e+0-6.780000000000000000000000000000e+0i
*string in : "0+0i"
 endptr   : ""
 z =       +0.000000000000000000000000000000e+0+0.000000000000000000000000000000e+0i
*string in : "0.0+0.0i"
 endptr   : ""
 z =       +0.000000000000000000000000000000e+0+0.000000000000000000000000000000e+0i
*string in : "1.0+0i"
 endptr   : ""
 z =       +1.000000000000000000000000000000e+0+0.000000000000000000000000000000e+0i
*string in : "0+1.0i"
 endptr   : ""
 z =       +0.000000000000000000000000000000e+0+1.000000000000000000000000000000e+0i
*string in : "3+4i"
 endptr   : ""
 z =       +3.000000000000000000000000000000e+0+4.000000000000000000000000000000e+0i
*string in : "+4-5.89i"
 endptr   : ""
 z =       +4.000000000000000000000000000000e+0-5.890000000000000000000000000000e+0i
*string in : "-2.6+3i"
 endptr   : ""
 z =       -2.600000000000000000000000000000e+0+3.000000000000000000000000000000e+0i
*string in : "3.4+9.87i"
 endptr   : ""
 z =       +3.400000000000000000000000000000e+0+9.870000000000000000000000000000e+0i
*string in : "5.66e-20+9.89e10i"
 endptr   : ""
 z =       +5.660000000000000000000000000000e-20+9.890000000000000000000000000000e+10i
*string in : "-4.2e4+6.54E-6i"
 endptr   : ""
 z =       -4.200000000000000000000000000000e+4+6.540000000000000000000000000000e-6i
*string in : "-7.55E+5-8.65e+6i"
 endptr   : ""
 z =       -7.550000000000000000000000000000e+5-8.650000000000000000000000000000e+6i
*string in : "+7.55e-5-8.65e6i"
 endptr   : ""
 z =       +7.550000000000000000000000000000e-5-8.650000000000000000000000000000e+6i
*string in : "4.566e34 -6453.23e-48i"
 endptr   : ""
 z =       +4.566000000000000000000000000000e+34-6.453230000000000000000000000000e-45i
*string in : "3.566e-34 -6453.23e-41i"
 endptr   : ""
 z =       +3.566000000000000000000000000000e-34-6.453230000000000000000000000000e-38i
*string in : "3.566e-34 -6453.23e+42i"
 endptr   : ""
 z =       +3.566000000000000000000000000000e-34-6.453230000000000000000000000000e+45i
*string in : "7.546E34 -6853.23E+40i"
 endptr   : ""
 z =       +7.546000000000000000000000000000e+34-6.853230000000000000000000000000e+43i
*string in : "4.566e340 -6453.23e-410i"
 endptr   : ""
 z =       +4.565999999999999999999999999998e+340-6.453229999999999999999999999997e-407i
*string in : "3.566e-340 -6453.23e-418i"
 endptr   : ""
 z =       +3.565999999999999999999999999999e-340-6.453229999999999999999999999997e-415i
*string in : "3.566e-340 -6453.23e+412i"
 endptr   : ""
 z =       +3.565999999999999999999999999999e-340-6.453229999999999999999999999997e+415i
*string in : "7.546E340 -6853.23E+410i"
 endptr   : ""
 z =       +7.545999999999999999999999999997e+340-6.853229999999999999999999999997e+413i
*string in : "4.566e3400 -6453.23e-4100i"
 endptr   : ""
 z =       +4.565999999999999999999999999982e+3400-6.453229999999999999999999999969e-4097i
*string in : "3.566e-3400 -6453.23e-4108i"
 endptr   : ""
 z =       +3.565999999999999999999999999986e-3400-6.453229999999999999999999999969e-4105i
*string in : "3.566e-3400 -6453.23e+4102i"
 endptr   : ""
 z =       +3.565999999999999999999999999986e-3400-6.453229999999999999999999999969e+4105i
*string in : "7.546E3400 -6853.23E+4100i"
 endptr   : ""
 z =       +7.545999999999999999999999999970e+3400-6.853229999999999999999999999967e+4103i
*string in : "7.55e5000"
 endptr   : ""
 OVERFLOW
*string in : "-8.66E-4900"
 endptr   : ""
 z =       -8.659999999999999999999999999950e-4900+0.000000000000000000000000000000e+0i
*string in : "+7.55E+5000 +7i"
 endptr   : ""
 OVERFLOW
*string in : "-8.66e-4900  -65i"
 endptr   : ""
 z =       -8.659999999999999999999999999950e-4900-6.500000000000000000000000000000e+1i
*string in : "8.355e4400i"
 endptr   : ""
 z =       +0.000000000000000000000000000000e+0+8.354999999999999999999999999957e+4400i
*string in : "-2.66E-4800i"
 endptr   : ""
 z =       +0.000000000000000000000000000000e+0-2.659999999999999999999999999985e-4800i
*string in : "67   +8.355e+4400i"
 endptr   : ""
 z =       +6.700000000000000000000000000000e+1+8.354999999999999999999999999957e+4400i
*string in : "-654 -2.66E-4800i"
 endptr   : ""
 z =       -6.540000000000000000000000000000e+2-2.659999999999999999999999999985e-4800i
*string in : "64.32e4400 +45.322e+4500i"
 endptr   : ""
 z =       +6.431999999999999999999999999967e+4401+4.532199999999999999999999999976e+4501i
*string in : "64.32E4400 +45.322E+4500i"
 endptr   : ""
 z =       +6.431999999999999999999999999967e+4401+4.532199999999999999999999999976e+4501i
*string in : "64.32e-4400 +45.322e+4500i"
 endptr   : ""
 z =       +6.431999999999999999999999999967e-4399+4.532199999999999999999999999976e+4501i
*string in : "64.32E-4400 +45.322E+4500i"
 endptr   : ""
 z =       +6.431999999999999999999999999967e-4399+4.532199999999999999999999999976e+4501i
*string in : "64.32e4400 -45.322e-4500i"
 endptr   : ""
 z =       +6.431999999999999999999999999967e+4401-4.532199999999999999999999999976e-4499i
*string in : "64.32E4400 -45.322E-4500i"
 endptr   : ""
 z =       +6.431999999999999999999999999967e+4401-4.532199999999999999999999999976e-4499i
*string in : "-64.32e-4400 -45.322e-4500i"
 endptr   : ""
 z =       -6.431999999999999999999999999967e-4399-4.532199999999999999999999999976e-4499i
*string in : "+64.32E-4400 -45.322E-4500i"
 endptr   : ""
 z =       +6.431999999999999999999999999967e-4399-4.532199999999999999999999999976e-4499i
*string in : "0 + 0i"
 endptr   : " + 0i"
 z =       +0.000000000000000000000000000000e+0+0.000000000000000000000000000000e+0i
*string in : "0.0 +0.0i"
 endptr   : ""
 z =       +0.000000000000000000000000000000e+0+0.000000000000000000000000000000e+0i
*string in : "1.0+ 0i"
 endptr   : "+ 0i"
 z =       +1.000000000000000000000000000000e+0+0.000000000000000000000000000000e+0i
*string in : "0 +1.0i"
 endptr   : ""
 z =       +0.000000000000000000000000000000e+0+1.000000000000000000000000000000e+0i
*string in : "3   +		4i"
 endptr   : "   +		4i"
 z =       +3.000000000000000000000000000000e+0+0.000000000000000000000000000000e+0i
*string in : "+4 -	5.89i"
 endptr   : " -	5.89i"
 z =       +4.000000000000000000000000000000e+0+0.000000000000000000000000000000e+0i
*string in : "-2.6	+ 3i"
 endptr   : "	+ 3i"
 z =       -2.600000000000000000000000000000e+0+0.000000000000000000000000000000e+0i
*string in : "3.4E2	+9.87i"
 endptr   : ""
 z =       +3.400000000000000000000000000000e+2+9.870000000000000000000000000000e+0i
*string in : "5.66e-20	+	9.89e10i"
 endptr   : "	+	9.89e10i"
 z =       +5.660000000000000000000000000000e-20+0.000000000000000000000000000000e+0i
*string in : "-4.2e4  +  6.54e-6i"
 endptr   : "  +  6.54e-6i"
 z =       -4.200000000000000000000000000000e+4+0.000000000000000000000000000000e+0i
*string in : "-7.55e+5  -8.65e+6i"
 endptr   : ""
 z =       -7.550000000000000000000000000000e+5-8.650000000000000000000000000000e+6i
*string in : "+7.55e-5 -		8.65e6i"
 endptr   : " -		8.65e6i"
 z =       +7.550000000000000000000000000000e-5+0.000000000000000000000000000000e+0i
*string in : "~3.4-5.6i"
 endptr   : "~3.4-5.6i"
 NAN
*string in : ":4-6i"
 endptr   : ":4-6i"
 NAN
*string in : "cane+7i"
 endptr   : "cane+7i"
 NAN
*string in : ":(-6i"
 endptr   : ":(-6i"
 NAN
*string in : "-~7+5i"
 endptr   : "-~7+5i"
 NAN
*string in : "--8+6i"
 endptr   : "--8+6i"
 NAN
*string in : "++9-6.54i"
 endptr   : "++9-6.54i"
 NAN
*string in : "+-87.654+4.2i"
 endptr   : "+-87.654+4.2i"
 NAN
*string in : "-+456.78+9.7i"
 endptr   : "-+456.78+9.7i"
 NAN
*string in : "+ 76.24-9i"
 endptr   : "+ 76.24-9i"
 NAN
*string in : "- 78.4-5.3i"
 endptr   : "- 78.4-5.3i"
 NAN
*string in : "-7..0+4i"
 endptr   : ".0+4i"
 z =       -7.000000000000000000000000000000e+0+0.000000000000000000000000000000e+0i
*string in : "-7..0"
 endptr   : ".0"
 z =       -7.000000000000000000000000000000e+0+0.000000000000000000000000000000e+0i
*string in : "64.cane-5i"
 endptr   : "cane-5i"
 z =       +6.400000000000000000000000000000e+1+0.000000000000000000000000000000e+0i
*string in : "64.cane"
 endptr   : "cane"
 z =       +6.400000000000000000000000000000e+1+0.000000000000000000000000000000e+0i
*string in : "756f12-6.4i"
 endptr   : "f12-6.4i"
 z =       +7.560000000000000000000000000000e+2+0.000000000000000000000000000000e+0i
*string in : "756f12"
 endptr   : "f12"
 z =       +7.560000000000000000000000000000e+2+0.000000000000000000000000000000e+0i
*string in : "756  	34i"
 endptr   : "  	34i"
 z =       +7.560000000000000000000000000000e+2+0.000000000000000000000000000000e+0i
*string in : "-98.	66.76i"
 endptr   : "	66.76i"
 z =       -9.800000000000000000000000000000e+1+0.000000000000000000000000000000e+0i
*string in : "-98."
 endptr   : ""
 z =       -9.800000000000000000000000000000e+1+0.000000000000000000000000000000e+0i
*string in : "-98E4  56.23E-4i"
 endptr   : "  56.23E-4i"
 z =       -9.800000000000000000000000000000e+5+0.000000000000000000000000000000e+0i
*string in : "-98E4"
 endptr   : ""
 z =       -9.800000000000000000000000000000e+5+0.000000000000000000000000000000e+0i
*string in : "754.3 cane"
 endptr   : " cane"
 z =       +7.543000000000000000000000000000e+2+0.000000000000000000000000000000e+0i
*string in : "754.3"
 endptr   : ""
 z =       +7.543000000000000000000000000000e+2+0.000000000000000000000000000000e+0i
*string in : "54.21  +cane"
 endptr   : "  +cane"
 z =       +5.421000000000000000000000000000e+1+0.000000000000000000000000000000e+0i
*string in : "+54.21  -cane"
 endptr   : "  -cane"
 z =       +5.421000000000000000000000000000e+1+0.000000000000000000000000000000e+0i
*string in : "67.32 +~23"
 endptr   : " +~23"
 z =       +6.732000000000000000000000000000e+1+0.000000000000000000000000000000e+0i
*string in : "+67.32 -~46.56"
 endptr   : " -~46.56"
 z =       +6.732000000000000000000000000000e+1+0.000000000000000000000000000000e+0i
*string in : "67.32 	+~23i"
 endptr   : " 	+~23i"
 z =       +6.732000000000000000000000000000e+1+0.000000000000000000000000000000e+0i
*string in : "+67.32 	-~46.56i"
 endptr   : " 	-~46.56i"
 z =       +6.732000000000000000000000000000e+1+0.000000000000000000000000000000e+0i
*string in : "28.56 + 43i"
 endptr   : " + 43i"
 z =       +2.856000000000000000000000000000e+1+0.000000000000000000000000000000e+0i
*string in : "34.7886 +32i"
 endptr   : ""
 z =       +3.478860000000000000000000000000e+1+3.200000000000000000000000000000e+1i
*string in : "+77.665E8  -45i"
 endptr   : ""
 z =       +7.766500000000000000000000000000e+9-4.500000000000000000000000000000e+1i
*string in : "77.665E+8  +4.5i"
 endptr   : ""
 z =       +7.766500000000000000000000000000e+9+4.500000000000000000000000000000e+0i
*string in : "-88.42E-4 +75E2i"
 endptr   : ""
 z =       -8.842000000000000000000000000000e-3+7.500000000000000000000000000000e+3i
*string in : "88.42E-4 -75E-2i"
 endptr   : ""
 z =       +8.842000000000000000000000000000e-3-7.500000000000000000000000000000e-1i
*string in : "-88.42E-4 -75E-2i"
 endptr   : ""
 z =       -8.842000000000000000000000000000e-3-7.500000000000000000000000000000e-1i
*string in : "+9987.65e-4 -88.34E-5i"
 endptr   : ""
 z =       +9.987650000000000000000000000000e-1-8.834000000000000000000000000000e-4i
*string in : "28.56 + 43"
 endptr   : " + 43"
 z =       +2.856000000000000000000000000000e+1+0.000000000000000000000000000000e+0i
*string in : "34.7886 +32"
 endptr   : " +32"
 z =       +3.478860000000000000000000000000e+1+0.000000000000000000000000000000e+0i
*string in : "+77.665E8  -45"
 endptr   : "  -45"
 z =       +7.766500000000000000000000000000e+9+0.000000000000000000000000000000e+0i
*string in : "-88.42E-4 +75E2"
 endptr   : " +75E2"
 z =       -8.842000000000000000000000000000e-3+0.000000000000000000000000000000e+0i
*string in : "-88.42E-4 -75E-2"
 endptr   : " -75E-2"
 z =       -8.842000000000000000000000000000e-3+0.000000000000000000000000000000e+0i
*string in : "+9987.65e-4 -88.34E-5"
 endptr   : " -88.34E-5"
 z =       +9.987650000000000000000000000000e-1+0.000000000000000000000000000000e+0i
*string in : "28.56 + 43 i"
 endptr   : " + 43 i"
 z =       +2.856000000000000000000000000000e+1+0.000000000000000000000000000000e+0i
*string in : "34.7886 +32 i"
 endptr   : " +32 i"
 z =       +3.478860000000000000000000000000e+1+0.000000000000000000000000000000e+0i
*string in : "+77.665E8  -45 i"
 endptr   : "  -45 i"
 z =       +7.766500000000000000000000000000e+9+0.000000000000000000000000000000e+0i
*string in : "88.42E-4 -75E-2 i"
 endptr   : " -75E-2 i"
 z =       +8.842000000000000000000000000000e-3+0.000000000000000000000000000000e+0i
*string in : "-88.42E-4 -75E-2 i"
 endptr   : " -75E-2 i"
 z =       -8.842000000000000000000000000000e-3+0.000000000000000000000000000000e+0i
*string in : "+9987.65e-4 -88.34E-5 i"
 endptr   : " -88.34E-5 i"
 z =       +9.987650000000000000000000000000e-1+0.000000000000000000000000000000e+0i
*string in : "28.56 + 43I"
 endptr   : " + 43I"
 z =       +2.856000000000000000000000000000e+1+0.000000000000000000000000000000e+0i
*string in : "34.7886 +32I"
 endptr   : " +32I"
 z =       +3.478860000000000000000000000000e+1+0.000000000000000000000000000000e+0i
*string in : "+77.665E8  -45I"
 endptr   : "  -45I"
 z =       +7.766500000000000000000000000000e+9+0.000000000000000000000000000000e+0i
*string in : "-88.42E-4 +75E2I"
 endptr   : " +75E2I"
 z =       -8.842000000000000000000000000000e-3+0.000000000000000000000000000000e+0i
*string in : "88.42E-4 -75E-2I"
 endptr   : " -75E-2I"
 z =       +8.842000000000000000000000000000e-3+0.000000000000000000000000000000e+0i
*string in : "+9987.65e-4 -88.34E-5I"
 endptr   : " -88.34E-5I"
 z =       +9.987650000000000000000000000000e-1+0.000000000000000000000000000000e+0i
*string in : "77.665E+8  +4..5i"
 endptr   : "  +4..5i"
 z =       +7.766500000000000000000000000000e+9+0.000000000000000000000000000000e+0i
*string in : "77.665E+8  +4..i"
 endptr   : "  +4..i"
 z =       +7.766500000000000000000000000000e+9+0.000000000000000000000000000000e+0i
*string in : "-88.42E-4 +75EE2i"
 endptr   : " +75EE2i"
 z =       -8.842000000000000000000000000000e-3+0.000000000000000000000000000000e+0i
*string in : "88.42E-4 -75E-+2i"
 endptr   : " -75E-+2i"
 z =       +8.842000000000000000000000000000e-3+0.000000000000000000000000000000e+0i
*string in : "-88.42E-4 -75E+-2i"
 endptr   : " -75E+-2i"
 z =       -8.842000000000000000000000000000e-3+0.000000000000000000000000000000e+0i
*string in : "+88.42E-4 -75Ei"
 endptr   : " -75Ei"
 z =       +8.842000000000000000000000000000e-3+0.000000000000000000000000000000e+0i
*string in : "-88.42E-4 -75ei"
 endptr   : " -75ei"
 z =       -8.842000000000000000000000000000e-3+0.000000000000000000000000000000e+0i
*string in : "+88.42E-4 -75e+i"
 endptr   : " -75e+i"
 z =       +8.842000000000000000000000000000e-3+0.000000000000000000000000000000e+0i
*string in : "77.42E-4 -75E-i"
 endptr   : " -75E-i"
 z =       +7.742000000000000000000000000000e-3+0.000000000000000000000000000000e+0i
*string in : "88.42E-4 -75e++i"
 endptr   : " -75e++i"
 z =       +8.842000000000000000000000000000e-3+0.000000000000000000000000000000e+0i
*string in : "-887.42E-4 -75E--i"
 endptr   : " -75E--i"
 z =       -8.874200000000000000000000000000e-2+0.000000000000000000000000000000e+0i
*string in : "881.42E-4 -75e0i"
 endptr   : ""
 z =       +8.814200000000000000000000000000e-2-7.500000000000000000000000000000e+1i
*string in : "-8856789.42E-4 -75e+0i"
 endptr   : ""
 z =       -8.856789420000000000000000000000e+2-7.500000000000000000000000000000e+1i
*string in : "-88234.42E-4 -75E-0i"
 endptr   : ""
 z =       -8.823442000000000000000000000000e+0-7.500000000000000000000000000000e+1i
*string in : ""
 endptr   : ""
 NAN
*string in : "564-mondoi"
 endptr   : "-mondoi"
 z =       +5.640000000000000000000000000000e+2+0.000000000000000000000000000000e+0i
*string in : "i"
 endptr   : "i"
 NAN
*string in : "+i"
 endptr   : "+i"
 NAN
*string in : "-i"
 endptr   : "-i"
 NAN
*string in : "+.i"
 endptr   : "+.i"
 NAN
*string in : "-.i"
 endptr   : "-.i"
 NAN
*string in : ".i"
 endptr   : ".i"
 NAN
*string in : ".Ei"
 endptr   : ".Ei"
 NAN
*string in : ".ei"
 endptr   : ".ei"
 NAN
*string in : ".E-i"
 endptr   : ".E-i"
 NAN
*string in : ".e+i"
 endptr   : ".e+i"
 NAN
*string in : ".0i"
 endptr   : ""
 z =       +0.000000000000000000000000000000e+0+0.000000000000000000000000000000e+0i
*string in : "-.0i"
 endptr   : ""
 z =       +0.000000000000000000000000000000e+0+0.000000000000000000000000000000e+0i
*string in : ".02i"
 endptr   : ""
 z =       +0.000000000000000000000000000000e+0+2.000000000000000000000000000000e-2i
*string in : "-.02i"
 endptr   : ""
 z =       +0.000000000000000000000000000000e+0-2.000000000000000000000000000000e-2i
*string in : "+.034e12i"
 endptr   : ""
 z =       +0.000000000000000000000000000000e+0+3.400000000000000000000000000000e+10i
*string in : "-.034E-12i"
 endptr   : ""
 z =       +0.000000000000000000000000000000e+0-3.400000000000000000000000000000e-14i
*string in : "Some overflows"
 endptr   : "Some overflows"
 NAN
*string in : "7.55e5000"
 endptr   : ""
 OVERFLOW
*string in : "-8.66E-5000"
 endptr   : ""
 z =       -0.000000000000000000000000000000e+0+0.000000000000000000000000000000e+0i
*string in : "+7.55E+5000 +7i"
 endptr   : ""
 OVERFLOW
*string in : "-8.66e-5000  -65i"
 endptr   : ""
 z =       -0.000000000000000000000000000000e+0-6.500000000000000000000000000000e+1i
*string in : "8.355e5400i"
 endptr   : ""
 OVERFLOW
*string in : "-2.66E-5800i"
 endptr   : ""
 z =       +0.000000000000000000000000000000e+0-0.000000000000000000000000000000e+0i
*string in : "67   +8.355e+5400i"
 endptr   : ""
 OVERFLOW
*string in : "-654 -2.66E-5800i"
 endptr   : ""
 z =       -6.540000000000000000000000000000e+2-0.000000000000000000000000000000e+0i
*string in : "64.32e5400 +45.322e+5100i"
 endptr   : ""
 OVERFLOW
*string in : "64.32E5400 +45.322E+5100i"
 endptr   : ""
 OVERFLOW
*string in : "64.32e-5400 +45.322e+5100i"
 endptr   : ""
 OVERFLOW
*string in : "64.32E-5400 +45.322E+5100i"
 endptr   : ""
 OVERFLOW
*string in : "64.32e5400 -45.322e-5100i"
 endptr   : ""
 OVERFLOW
*string in : "64.32E5400 -45.322E-5100i"
 endptr   : ""
 OVERFLOW
*string in : "-64.32e-5400 -45.322e-5100i"
 endptr   : ""
 z =       -0.000000000000000000000000000000e+0-0.000000000000000000000000000000e+0i
*string in : "+64.32E-5400 -45.322E-5100i"
 endptr   : ""
 z =       +0.000000000000000000000000000000e+0-0.000000000000000000000000000000e+0i
*string in : "!!End!!"
 endptr   : "!!End!!"
 NAN
*/
