/*
   Copyright (C)  2000    Daniel A. Atkinson  <DanAtk@aol.com>
   Copyright (C)  2004    Ivano Primi  <ivprimi@libero.it>    

   This file is part of the HPA Library.

   The HPA Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The HPA Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the HPA Library; if not, write to the Free
   Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
   02110-1301 USA.
*/

/*
    Test:  xfix

    Uses:  atox  xfix  xprxpr
    
    Input file:  data/xfix.dat
*/

/*
    WARNING: This test will surely fail if XDIM is not equal to 7 !!!
*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "xpre.h"

#define BUFF_SIZE 1024		/* 1 Kb */
int decd = 32;

int xdigit2int (char c)
{
  if (c >= '0' && c <= '9')
    return c - '0';
  else
    {
      int n;

      switch (tolower(c))
	{
	case 'a':
	  n = 10;
	  break;
	case 'b':
	  n = 11;
	  break;
	case 'c':
	  n = 12;
	  break;
	case 'd':
	  n = 13;
	  break;
	case 'e':
	  n = 14;
	  break;
	case 'f':
	  n = 15;
	}
      return n;
    }
}

struct xpr
hexatox (char* s)
{
  char* t;
  int i;
  struct xpr x;

  for (t=s; *t != '\0' && *t != '.'; t++);
  if (*t == '\0' || t - s != 4 )
    return xNaN;
  else
    {
      unsigned short a[4], j;

      for (; *t != '\0'; *t = *(t+1), t++);
      for (t=s; isxdigit(*t); t++);
      if (*t != '\0' || t - s < 4 * XDIM + 4)
	return xNaN;
      else
	{
	  for (i=0; i <= 4 * XDIM; i += 4)
	    {
	      for (j=0; j<4; j++)
		a[j] = xdigit2int (s[i+j]);
	      x.nmm[i/4] = a[0] * 4096 + a[1] * 256 + a[2] * 16 + a[3];
	    }
	  return x;
	}
    }
}

int
main (int na, char **av)
{
  int i;
  struct xpr x;
  char buffer[BUFF_SIZE];
  FILE *fp;

  if (na != 2)
    {
      printf ("para: input_file\n");
      exit (-1);
    }
  fp = fopen (*++av, "r");
  printf ("     Test of the function xfix()\n");
  while (fgets (buffer, BUFF_SIZE, fp) != NULL)
    {
      for (i = 0; buffer[i] != '\0'; i++);
      if (i > 0 && buffer[i - 1] == '\n')
	buffer[i - 1] = '\0';
      if (*buffer == 'x') 
	x = hexatox (buffer+1);
      else
	x = atox (buffer);
      printf ("\nx\t    = ");
      xprxpr (x, decd);
      printf ("\nxfix (x)    = ");
      xprxpr (xfix (x), decd);
      putchar ('\n');
    }
  return 0;
}

/*  Test output

     Test of the function xfix()

x	    = 1.00000000000000000000000000000000e+0
xfix (x)    = 1.00000000000000000000000000000000e+0

x	    = 9.99999999999999999999999999999969e-1
xfix (x)    = 1.00000000000000000000000000000000e+0

x	    = 9.99999999999999999999999999999960e-1
xfix (x)    = 0.00000000000000000000000000000000e+0

x	    = 9.99999999999999999999999999999960e-1
xfix (x)    = 0.00000000000000000000000000000000e+0

x	    = 9.99999999999999999999999999999957e-1
xfix (x)    = 0.00000000000000000000000000000000e+0

x	    = 1.00000000000000000000000000000000e+0
xfix (x)    = 1.00000000000000000000000000000000e+0

x	    = 1.00000000000000000000000000000000e+0
xfix (x)    = 1.00000000000000000000000000000000e+0

x	    = 1.00000000000000000000000000000000e+0
xfix (x)    = 1.00000000000000000000000000000000e+0

x	    = 1.00000000000000000000000000000001e+0
xfix (x)    = 1.00000000000000000000000000000000e+0

x	    = -1.00000000000000000000000000000000e+0
xfix (x)    = -1.00000000000000000000000000000000e+0

x	    = -9.99999999999999999999999999999969e-1
xfix (x)    = -1.00000000000000000000000000000000e+0

x	    = -9.99999999999999999999999999999960e-1
xfix (x)    = 0.00000000000000000000000000000000e+0

x	    = -9.99999999999999999999999999999960e-1
xfix (x)    = 0.00000000000000000000000000000000e+0

x	    = -9.99999999999999999999999999999957e-1
xfix (x)    = 0.00000000000000000000000000000000e+0

x	    = -1.00000000000000000000000000000000e+0
xfix (x)    = -1.00000000000000000000000000000000e+0

x	    = -1.00000000000000000000000000000000e+0
xfix (x)    = -1.00000000000000000000000000000000e+0

x	    = -1.00000000000000000000000000000000e+0
xfix (x)    = -1.00000000000000000000000000000000e+0

x	    = -1.00000000000000000000000000000001e+0
xfix (x)    = -1.00000000000000000000000000000000e+0

x	    = 9.00000000000000000000000000000000e+0
xfix (x)    = 9.00000000000000000000000000000000e+0

x	    = 8.99999999999999999999999999999943e+0
xfix (x)    = 9.00000000000000000000000000000000e+0

x	    = 8.99999999999999999999999999999934e+0
xfix (x)    = 8.00000000000000000000000000000000e+0

x	    = 8.99999999999999999999999999998903e+0
xfix (x)    = 8.00000000000000000000000000000000e+0

x	    = 8.99999999999999999999999999998736e+0
xfix (x)    = 8.00000000000000000000000000000000e+0

x	    = 9.00000000000000000000000000000000e+0
xfix (x)    = 9.00000000000000000000000000000000e+0

x	    = 9.00000000000000000000000000000000e+0
xfix (x)    = 9.00000000000000000000000000000000e+0

x	    = 9.00000000000000000000000000000001e+0
xfix (x)    = 9.00000000000000000000000000000000e+0

x	    = 9.00000000000000000000000000000004e+0
xfix (x)    = 9.00000000000000000000000000000000e+0

x	    = -9.00000000000000000000000000000000e+0
xfix (x)    = -9.00000000000000000000000000000000e+0

x	    = -8.99999999999999999999999999999943e+0
xfix (x)    = -9.00000000000000000000000000000000e+0

x	    = -8.99999999999999999999999999999934e+0
xfix (x)    = -8.00000000000000000000000000000000e+0

x	    = -8.99999999999999999999999999998903e+0
xfix (x)    = -8.00000000000000000000000000000000e+0

x	    = -8.99999999999999999999999999998736e+0
xfix (x)    = -8.00000000000000000000000000000000e+0

x	    = -9.00000000000000000000000000000000e+0
xfix (x)    = -9.00000000000000000000000000000000e+0

x	    = -9.00000000000000000000000000000000e+0
xfix (x)    = -9.00000000000000000000000000000000e+0

x	    = -9.00000000000000000000000000000001e+0
xfix (x)    = -9.00000000000000000000000000000000e+0

x	    = -9.00000000000000000000000000000004e+0
xfix (x)    = -9.00000000000000000000000000000000e+0

x	    = 1.23456789099999999999999999999999e+9
xfix (x)    = 1.23456789099999999999999999999999e+9

x	    = 1.23456789099999999999999999999999e+9
xfix (x)    = 1.23456789099999999999999999999999e+9

x	    = 1.23456789099999999999999999999999e+9
xfix (x)    = 1.23456789099999999999999999999999e+9

x	    = 1.23456789099999999999999999999999e+9
xfix (x)    = 1.23456789099999999999999999999999e+9

x	    = 1.23456789099999999999999999599999e+9
xfix (x)    = 1.23456788999999999999999999999999e+9

x	    = -1.23456789099999999999999999999999e+9
xfix (x)    = -1.23456789099999999999999999999999e+9

x	    = -1.23456789099999999999999999999999e+9
xfix (x)    = -1.23456789099999999999999999999999e+9

x	    = -1.23456789099999999999999999999999e+9
xfix (x)    = -1.23456789099999999999999999999999e+9

x	    = -1.23456789099999999999999999999999e+9
xfix (x)    = -1.23456789099999999999999999999999e+9

x	    = -1.23456789099999999999999999599999e+9
xfix (x)    = -1.23456788999999999999999999999999e+9

x	    = 1.23456789099999999999999999999999e+9
xfix (x)    = 1.23456789099999999999999999999999e+9

x	    = 1.23456789099999999999999999999999e+9
xfix (x)    = 1.23456789099999999999999999999999e+9

x	    = 1.23456789099999999999999999999999e+9
xfix (x)    = 1.23456789099999999999999999999999e+9

x	    = 1.23456789100000000000000000399999e+9
xfix (x)    = 1.23456789099999999999999999999999e+9

x	    = -1.23456789099999999999999999999999e+9
xfix (x)    = -1.23456789099999999999999999999999e+9

x	    = -1.23456789099999999999999999999999e+9
xfix (x)    = -1.23456789099999999999999999999999e+9

x	    = -1.23456789099999999999999999999999e+9
xfix (x)    = -1.23456789099999999999999999999999e+9

x	    = -1.23456789100000000000000000399999e+9
xfix (x)    = -1.23456789099999999999999999999999e+9

x	    = 5.99999999999999999999999999998581e+2000
xfix (x)    = 5.99999999999999999999999999998614e+2000

x	    = 5.99999999999999999999999999998581e+2000
xfix (x)    = 5.99999999999999999999999999998613e+2000

x	    = 5.99999999999999999999999999998579e+2000
xfix (x)    = 5.99999999999999999999999999998612e+2000

x	    = 5.99999999999999999999999999998561e+2000
xfix (x)    = 5.99999999999999999999999999998594e+2000

x	    = 5.99999999999999999999999999998381e+2000
xfix (x)    = 5.99999999999999999999999999998413e+2000

x	    = -5.99999999999999999999999999998581e+2000
xfix (x)    = -5.99999999999999999999999999998614e+2000

x	    = -5.99999999999999999999999999998581e+2000
xfix (x)    = -5.99999999999999999999999999998613e+2000

x	    = -5.99999999999999999999999999998579e+2000
xfix (x)    = -5.99999999999999999999999999998612e+2000

x	    = -5.99999999999999999999999999998561e+2000
xfix (x)    = -5.99999999999999999999999999998594e+2000

x	    = -5.99999999999999999999999999998381e+2000
xfix (x)    = -5.99999999999999999999999999998413e+2000

x	    = 5.99999999999999999999999999998581e+2000
xfix (x)    = 5.99999999999999999999999999998614e+2000

x	    = 5.99999999999999999999999999998583e+2000
xfix (x)    = 5.99999999999999999999999999998615e+2000

x	    = 5.99999999999999999999999999998601e+2000
xfix (x)    = 5.99999999999999999999999999998634e+2000

x	    = 5.99999999999999999999999999998781e+2000
xfix (x)    = 5.99999999999999999999999999998813e+2000

x	    = -5.99999999999999999999999999998581e+2000
xfix (x)    = -5.99999999999999999999999999998614e+2000

x	    = -5.99999999999999999999999999998583e+2000
xfix (x)    = -5.99999999999999999999999999998615e+2000

x	    = -5.99999999999999999999999999998601e+2000
xfix (x)    = -5.99999999999999999999999999998634e+2000

x	    = -5.99999999999999999999999999998781e+2000
xfix (x)    = -5.99999999999999999999999999998813e+2000

x	    = 3.00000000000000000000000000000000e+0
xfix (x)    = 3.00000000000000000000000000000000e+0

x	    = 3.50000000000000000000000000000000e+0
xfix (x)    = 3.00000000000000000000000000000000e+0

x	    = 4.00000000000000000000000000000000e+0
xfix (x)    = 4.00000000000000000000000000000000e+0

x	    = -8.79999999999999999999999999999999e+1
xfix (x)    = -8.79999999999999999999999999999999e+1

x	    = -8.84999999999999999999999999999997e+1
xfix (x)    = -8.79999999999999999999999999999999e+1

x	    = -8.89999999999999999999999999999998e+1
xfix (x)    = -8.89999999999999999999999999999998e+1

x	    = 0.00000000000000000000000000000000e+0
xfix (x)    = 0.00000000000000000000000000000000e+0

x	    = 1.00000000000000000000000000000000e-1
xfix (x)    = 0.00000000000000000000000000000000e+0

x	    = 2.00000000000000000000000000000000e-1
xfix (x)    = 0.00000000000000000000000000000000e+0

x	    = 4.00000000000000000000000000000000e-1
xfix (x)    = 0.00000000000000000000000000000000e+0

x	    = 8.00000000000000000000000000000000e-1
xfix (x)    = 0.00000000000000000000000000000000e+0

x	    = 9.00000000000000000000000000000000e-1
xfix (x)    = 0.00000000000000000000000000000000e+0

x	    = 1.00000000000000000000000000000000e+0
xfix (x)    = 1.00000000000000000000000000000000e+0

x	    = 0.00000000000000000000000000000000e+0
xfix (x)    = 0.00000000000000000000000000000000e+0

x	    = -1.00000000000000000000000000000000e-1
xfix (x)    = 0.00000000000000000000000000000000e+0

x	    = -2.00000000000000000000000000000000e-1
xfix (x)    = 0.00000000000000000000000000000000e+0

x	    = -4.00000000000000000000000000000000e-1
xfix (x)    = 0.00000000000000000000000000000000e+0

x	    = -8.00000000000000000000000000000000e-1
xfix (x)    = 0.00000000000000000000000000000000e+0

x	    = -9.00000000000000000000000000000000e-1
xfix (x)    = 0.00000000000000000000000000000000e+0

x	    = -1.00000000000000000000000000000000e+0
xfix (x)    = -1.00000000000000000000000000000000e+0

x	    = 9.99999999999999999999999999999989e+9
xfix (x)    = 9.99999999999999999999999999999989e+9

x	    = -9.99999999999999999999999999999989e+9
xfix (x)    = -9.99999999999999999999999999999989e+9

x	    = 9.99999999999999999999999999999883e+99
xfix (x)    = 9.99999999999999999999999999999948e+99

x	    = -9.99999999999999999999999999999883e+99
xfix (x)    = -9.99999999999999999999999999999948e+99

x	    = 9.99999999999999999999999999995270e+3999
xfix (x)    = 9.99999999999999999999999999995316e+3999

x	    = -9.99999999999999999999999999995270e+3999
xfix (x)    = -9.99999999999999999999999999995316e+3999
*/
