/* main.c -- main module
   Copyright (C) 2004 Maximiliano Pin

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#define _POSIX_SOURCE

#include <signal.h>		/* SIG* */
#include <locale.h>		/* setlocale */
#include "common.h"
#include "uconfig.h"
#include "contact_list.h"
#include "transport.h"
#include "user_iface.h"
#include "uconfig.h"
#include "misc.h"

static void finish (int sig);

int
main (int argc, char **argv)
{
	signal (SIGPIPE, SIG_IGN);
	dmx_signal (SIGINT, finish);
	dmx_signal (SIGTERM, finish);
	setlocale (LC_ALL, "");

	
	CHECK_OK (ui_init ());

	ui_output_info ("\\b\\3IPChat 0.2");
	ui_output_info ("\\b\\3-----------");
	ui_output_info ("\\b(c) Maximiliano Pin");
	ui_output_info ("\\b(c) Julio A. Becerra");
	ui_output_info ("\\bType \"/help\" to access online help.");
	ui_output_info ("");

	check_dir ();
	cf_load ();
	cl_load ();

	tr_init_resolver ();
	tr_init_server ();
	tr_init_checker ();

	dmx_main_loop ();

	ui_finish ();
	dmx_cleanup ();

	return 0;
error:
	return 1;
}

static void
finish (int sig)
{
	dmx_stop ();
}
