/* uconfig.h -- manages the program configuration
   Copyright (C) 2004 Maximiliano Pin

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef UCONFIG_H
#define UCONFIG_H 1

#include "common.h"

/* Default listen port. We can check /usr/share/nmap/nmap-services
   and http://www.graffiti.com/services for free ports.
   This is ipxat on the phone. */
#define DEFAULT_PORT 47928

#define DEFAULT_NICK "nick"

typedef struct {
	char    nick[MAX_NICK];
	port_t  listen_port;
} config_t;

extern config_t cfg;

extern int cf_load ();
extern int cf_save ();

#endif
