/* contact_list.h -- manages the list of contacts
   Copyright (C) 2004 Maximiliano Pin

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef CONTACT_LIST_H
#define CONTACT_LIST_H 1

#include "common.h"
#include "demux.h"

#define BROADCAST ((contact_t *)~0)	/* send something to all contacts */
#define MAX_HNAME 256			/* RFC 1035, limit is 255 (+ '\0') */

typedef struct ct {
	char    hname[MAX_HNAME]; 	/* IP or hostname of contact */
	port_t  port;			/* port where contact listens */
	char    nick[MAX_NICK];		/* nickname of the contact */
	struct ct *next;
	struct {
		ip_t    ip;		/* current ip address of hname */
		sock_t  socket;		/* connecting/connected socket, or -1 */
		BOOL    connected;	/* connection is established */
		BOOL    hello_pending;	/* the HELLO message is pending */
		BYTE   *in_buffer;	/* input buffer */
		len_t   in_buf_size;	/* allocated mem AND bytes to recv */
		len_t   in_buf_rcvd;	/* received bytes */
		BYTE   *out_buffer;	/* output buffer */
		len_t   out_buf_size;	/* memory allocated AND bytes to send */
		/* TODO out_buf_sent not needed by now, see transport */
		timer_id hello_timeout;	/* timer for hello timeout */
		void   *ui_info;        /* user iface info */
	} state;
} contact_t;

extern contact_t *contacts;

extern int cl_load ();
extern int cl_save ();
extern contact_t* cl_find_by_nick (const char *nick);
extern contact_t* cl_find_by_ip (ip_t ip);
extern void cl_add_contact (contact_t * contact);
extern void cl_remove_contact (const char *nick);

#endif
