/* transport.h -- implements the server, and transports messages
   Copyright (C) 2004 Maximiliano Pin

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef TRANSPORT_H
#define TRANSPORT_H 1

#include "contact_list.h"

extern void tr_init_server ();
extern void tr_connect (contact_t *contact);
extern void tr_disconnect (contact_t *contact);
extern void tr_send_msg (contact_t *contact, const BYTE *header, int hdr_len,
			 const BYTE *payload, int pl_len);
extern void tr_resolv (contact_t *contact);
extern void tr_init_resolver ();
extern void tr_init_checker ();

#endif
